/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsUserSettings;
import org.opencms.db.I_CmsDbContextFactory;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.publish.CmsPublishEngineState;
import org.opencms.publish.CmsPublishException;
import org.opencms.publish.CmsPublishHistory;
import org.opencms.publish.CmsPublishJobBase;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.publish.CmsPublishListenerCollection;
import org.opencms.publish.CmsPublishQueue;
import org.opencms.publish.CmsPublishThread;
import org.opencms.publish.I_CmsPublishEventListener;
import org.opencms.publish.Messages;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAuthentificationException;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;

public final class CmsPublishEngine {
    private static final Log LOG = CmsLog.getLog(CmsPublishEngine.class);
    private CmsUUID m_adminUserId;
    private CmsPublishThread m_currentPublishThread;
    private final I_CmsDbContextFactory m_dbContextFactory;
    private CmsDriverManager m_driverManager;
    private CmsPublishEngineState m_engineState;
    private final CmsPublishListenerCollection m_listeners;
    private final CmsPublishHistory m_publishHistory;
    private final CmsPublishQueue m_publishQueue;
    private int m_publishQueueShutdowntime;
    private boolean m_shuttingDown;

    public CmsPublishEngine(I_CmsDbContextFactory dbContextFactory) throws CmsInitException {
        if (OpenCms.getRunLevel() > 2) {
            throw new CmsInitException(org.opencms.main.Messages.get().container("ERR_ALREADY_INITIALIZED_0"));
        }
        if (dbContextFactory == null) {
            throw new CmsInitException(org.opencms.main.Messages.get().container("ERR_CRITICAL_NO_DB_CONTEXT_0"));
        }
        this.m_dbContextFactory = dbContextFactory;
        this.m_publishQueue = new CmsPublishQueue(this);
        this.m_publishHistory = new CmsPublishHistory(this);
        this.m_listeners = new CmsPublishListenerCollection(this);
        this.m_engineState = CmsPublishEngineState.ENGINE_STARTED;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PUBLISH_ENGINE_READY_0"));
        }
    }

    public void abandonThread() {
        if (!this.m_currentPublishThread.isAlive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_ENGINE_DEAD_JOB_0"));
            }
        } else {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_THREADSTORE_PUBLISH_THREAD_INTERRUPT_2", this.m_currentPublishThread.getName(), this.m_currentPublishThread.getUUID()));
            }
            this.m_currentPublishThread.interrupt();
        }
        this.m_currentPublishThread = null;
        this.checkCurrentPublishJobThread();
    }

    public synchronized void checkCurrentPublishJobThread() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.m_engineState != CmsPublishEngineState.ENGINE_STARTED) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_ENGINE_RUNNING_0"));
        }
        if (this.m_driverManager == null || this.m_dbContextFactory == null) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_ENGINE_NOT_INITIALIZED_0"));
            return;
        }
        if (this.m_currentPublishThread == null) {
            if (!this.m_publishQueue.isEmpty()) {
                CmsPublishJobInfoBean publishJob = this.m_publishQueue.next();
                this.m_currentPublishThread = new CmsPublishThread(this, publishJob);
                this.m_currentPublishThread.start();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_ENGINE_NO_RUNNING_JOB_0"));
            }
            return;
        }
        if (this.m_currentPublishThread.isAlive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_ENGINE_WAITING_0"));
            }
        } else {
            this.abandonThread();
        }
    }

    public void enqueuePublishJob(CmsObject cms, CmsPublishList publishList, I_CmsReport report) throws CmsException {
        if (this.m_driverManager == null || this.m_dbContextFactory == null) {
            throw new CmsPublishException(Messages.get().container("ERR_PUBLISH_ENGINE_NOT_INITIALIZED_0"));
        }
        if (this.m_shuttingDown || !this.isEnabled() && !OpenCms.getRoleManager().hasRole(cms, CmsRole.ROOT_ADMIN)) {
            throw new CmsPublishException(Messages.get().container("ERR_PUBLISH_ENGINE_DISABLED_0"));
        }
        CmsPublishJobInfoBean publishJob = new CmsPublishJobInfoBean(cms, publishList, report);
        try {
            this.m_publishQueue.add(publishJob);
            this.m_listeners.fireEnqueued(new CmsPublishJobBase(publishJob));
        }
        catch (Throwable t) {
            if (this.m_publishQueue.contains(publishJob)) {
                this.m_publishQueue.remove(publishJob);
            }
            throw new CmsException(Messages.get().container("ERR_PUBLISH_ENGINE_QUEUE_1", publishJob.getPublishHistoryId()), t);
        }
        this.checkCurrentPublishJobThread();
    }

    public CmsPublishJobBase getJobByPublishHistoryId(CmsUUID publishHistoryId) {
        if (this.m_currentPublishThread != null && this.m_currentPublishThread.getPublishJob().getPublishHistoryId().equals(publishHistoryId)) {
            return new CmsPublishJobRunning(this.m_currentPublishThread.getPublishJob());
        }
        for (CmsPublishJobEnqueued enqueuedJob : this.getPublishQueue().asList()) {
            if (!enqueuedJob.getPublishList().getPublishHistoryId().equals(publishHistoryId)) continue;
            return enqueuedJob;
        }
        for (CmsPublishJobFinished finishedJob : this.getPublishHistory().asList()) {
            if (!finishedJob.getPublishHistoryId().equals(publishHistoryId)) continue;
            return finishedJob;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDriverManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        try {
            this.m_adminUserId = this.m_driverManager.readUser(dbc, OpenCms.getDefaultUsers().getUserAdmin()).getId();
        }
        catch (CmsException e) {
            dbc.rollback();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        block18: {
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.main.Messages.get().getBundle().key("INIT_SHUTDOWN_START_1", this.getClass().getName()));
            }
            this.m_shuttingDown = true;
            if (this.m_currentPublishThread != null) {
                if (this.m_publishQueueShutdowntime > 0) {
                    CmsPublishEngine cmsPublishEngine = this;
                    synchronized (cmsPublishEngine) {
                        try {
                            Thread.sleep(this.m_publishQueueShutdowntime * 1000);
                        }
                        catch (InterruptedException exc) {
                            // empty catch block
                        }
                    }
                }
                if (this.m_currentPublishThread != null) {
                    CmsPublishJobInfoBean publishJob = this.m_currentPublishThread.getPublishJob();
                    try {
                        this.abortPublishJob(this.m_adminUserId, new CmsPublishJobEnqueued(publishJob), false);
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block18;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        CmsDbContext dbc = this.getDbContext(null);
        try {
            this.m_driverManager.updateLog(dbc);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        finally {
            dbc.clear();
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.staticexport.Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
    }

    protected void abortPublishJob(CmsUUID userId, CmsPublishJobEnqueued publishJob, boolean removeJob) throws CmsException, CmsPublishException {
        this.m_listeners.fireAbort(userId, publishJob);
        if (this.m_currentPublishThread == null || !publishJob.m_publishJob.equals(this.m_currentPublishThread.getPublishJob())) {
            if (!this.m_publishQueue.abortPublishJob(publishJob.m_publishJob)) {
                throw new CmsPublishException(Messages.get().container("ERR_PUBLISH_ENGINE_MISSING_PUBLISH_JOB_0"));
            }
        } else if (!this.m_shuttingDown) {
            this.m_currentPublishThread.abort();
        } else if (this.m_shuttingDown && this.m_currentPublishThread != null) {
            I_CmsReport report = this.m_currentPublishThread.getReport();
            report.println();
            report.println();
            report.println(Messages.get().container("RPT_PUBLISH_JOB_ABORT_SHUTDOWN_0"), 5);
            report.println();
        }
        if (publishJob.getPublishList() != null) {
            this.unlockPublishList(publishJob.m_publishJob);
        }
        if (!removeJob) {
            publishJob.m_publishJob.finish();
            this.getPublishHistory().add(publishJob.m_publishJob);
        } else {
            this.getPublishQueue().remove(publishJob.m_publishJob);
        }
    }

    protected void addPublishListener(I_CmsPublishEventListener listener) {
        this.m_listeners.add(listener);
    }

    protected void disableEngine() {
        this.m_engineState = CmsPublishEngineState.ENGINE_DISABLED;
    }

    protected void enableEngine() {
        this.m_engineState = CmsPublishEngineState.ENGINE_STARTED;
        if (this.m_currentPublishThread == null && !this.m_publishQueue.isEmpty()) {
            this.checkCurrentPublishJobThread();
        }
    }

    protected CmsPublishThread getCurrentPublishJob() {
        return this.m_currentPublishThread;
    }

    protected CmsDbContext getDbContext(CmsRequestContext ctx) {
        return this.m_dbContextFactory.getDbContext(ctx);
    }

    protected CmsDriverManager getDriverManager() {
        return this.m_driverManager;
    }

    protected CmsPublishHistory getPublishHistory() {
        return this.m_publishHistory;
    }

    protected CmsPublishQueue getPublishQueue() {
        return this.m_publishQueue;
    }

    protected byte[] getReportContents(CmsPublishJobFinished publishJob) throws CmsException {
        byte[] result = null;
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        try {
            result = this.m_driverManager.readPublishReportContents(dbc, publishJob.getPublishHistoryId());
        }
        catch (CmsException e) {
            dbc.rollback();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            dbc.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CmsUser getUser(CmsUUID userId) {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        try {
            CmsUser cmsUser = this.m_driverManager.readUser(dbc, userId);
            return cmsUser;
        }
        catch (CmsException e) {
            dbc.rollback();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            dbc.clear();
        }
        return null;
    }

    protected void initialize(CmsObject adminCms, boolean publishQueuePersistance, int publishQueueShutdowntime) throws CmsException {
        if (this.m_driverManager == null || this.m_dbContextFactory == null) {
            throw new CmsPublishException(Messages.get().container("ERR_PUBLISH_ENGINE_NOT_INITIALIZED_0"));
        }
        this.m_publishQueueShutdowntime = publishQueueShutdowntime;
        this.m_engineState = CmsPublishEngineState.ENGINE_STOPPED;
        this.m_publishHistory.initialize();
        this.m_publishQueue.initialize(adminCms, publishQueuePersistance);
    }

    protected boolean isRunning() {
        return this.m_engineState == CmsPublishEngineState.ENGINE_STARTED && !this.m_publishQueue.isEmpty() || this.m_currentPublishThread != null;
    }

    protected void lockPublishList(CmsPublishJobInfoBean publishJob) throws CmsException {
        CmsPublishList publishList = publishJob.getPublishList();
        CmsDbContext dbc = this.getDbContext(publishJob.getCmsObject().getRequestContext());
        try {
            for (CmsResource resource : publishList.getAllResources()) {
                this.m_driverManager.lockResource(dbc, resource, CmsLockType.PUBLISH);
            }
        }
        catch (CmsException e) {
            dbc.rollback();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            dbc.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishJobFinished(CmsPublishJobInfoBean publishJob) {
        try {
            this.unlockPublishList(publishJob);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getLocalizedMessage(), t);
        }
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext(publishJob.getCmsObject().getRequestContext());
        try {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("report", publishJob.getPublishReport());
            eventData.put("publishHistoryId", publishJob.getPublishList().getPublishHistoryId().toString());
            eventData.put("projectId", dbc.currentProject().getUuid());
            eventData.put("dbContext", dbc);
            CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
            OpenCms.fireCmsEvent(afterPublishEvent);
        }
        catch (Throwable t) {
            dbc.rollback();
            LOG.error((Object)t);
            publishJob.getPublishReport().println(t);
        }
        finally {
            try {
                dbc.clear();
            }
            catch (Throwable t) {}
            dbc = null;
        }
        try {
            this.m_listeners.fireFinish(new CmsPublishJobRunning(publishJob));
        }
        catch (Throwable t) {
            LOG.error((Object)t.getLocalizedMessage(), t);
        }
        try {
            publishJob.finish();
        }
        catch (Throwable t) {
            LOG.error((Object)t.getLocalizedMessage(), t);
        }
        try {
            this.m_publishHistory.add(publishJob);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getLocalizedMessage(), t);
        }
        if (Thread.currentThread() == this.m_currentPublishThread) {
            this.m_currentPublishThread = null;
        }
        OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PUBLISHED_RESOURCES);
        this.checkCurrentPublishJobThread();
    }

    protected void publishJobRemoved(CmsPublishJobInfoBean publishJob) {
        this.m_listeners.fireRemove(new CmsPublishJobFinished(publishJob));
    }

    protected void publishJobStarted(CmsPublishJobInfoBean publishJob) {
        this.m_publishQueue.update(publishJob);
        this.m_listeners.fireStart(new CmsPublishJobEnqueued(publishJob));
    }

    protected void removePublishListener(I_CmsPublishEventListener listener) {
        this.m_listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(CmsUUID toUserId, String message, boolean hasErrors) {
        CmsDbContext dbc = this.m_dbContextFactory.getDbContext();
        try {
            CmsUser toUser = this.m_driverManager.readUser(dbc, toUserId);
            CmsUserSettings settings = new CmsUserSettings(toUser);
            if (settings.getShowPublishNotification() || hasErrors) {
                OpenCms.getSessionManager().sendBroadcast(null, message, toUser);
            }
        }
        catch (CmsException e) {
            dbc.rollback();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            dbc.clear();
        }
    }

    protected void startEngine() {
        if (this.m_engineState != CmsPublishEngineState.ENGINE_STARTED) {
            this.m_engineState = CmsPublishEngineState.ENGINE_STARTED;
            if (this.m_currentPublishThread == null && !this.m_publishQueue.isEmpty()) {
                this.checkCurrentPublishJobThread();
            }
        }
    }

    protected void stopEngine() {
        this.m_engineState = CmsPublishEngineState.ENGINE_STOPPED;
    }

    protected void unlockPublishList(CmsPublishJobInfoBean publishJob) throws CmsException {
        CmsPublishList publishList = publishJob.getPublishList();
        List<CmsResource> allResources = publishList.getAllResources();
        CmsDbContext dbc = this.getDbContext(publishJob.getCmsObject().getRequestContext());
        try {
            for (CmsResource resource : allResources) {
                this.m_driverManager.unlockResource(dbc, resource, true, true);
            }
        }
        catch (CmsException e) {
            dbc.rollback();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        finally {
            dbc.clear();
        }
    }

    private boolean isEnabled() {
        try {
            if (this.m_engineState == CmsPublishEngineState.ENGINE_STOPPED || this.m_engineState == CmsPublishEngineState.ENGINE_STARTED) {
                OpenCms.getLoginManager().checkLoginAllowed();
                return true;
            }
            return false;
        }
        catch (CmsAuthentificationException e) {
            return false;
        }
    }
}

