/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.io.Serializable;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.relations.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsCategory
implements Comparable<CmsCategory>,
Serializable {
    private static final long serialVersionUID = -6395887983124249138L;
    private String m_basePath;
    private String m_description;
    private String m_path;
    private String m_rootPath;
    private CmsUUID m_structureId;
    private String m_title;

    public CmsCategory(CmsUUID structureId, String rootPath, String title, String description, String baseFolder) throws CmsException {
        this.m_structureId = structureId;
        this.m_rootPath = rootPath;
        this.m_title = title;
        this.m_description = description;
        this.m_path = CmsCategory.getCategoryPath(this.m_rootPath, baseFolder);
        this.m_basePath = this.m_rootPath.substring(0, this.m_rootPath.length() - this.m_path.length());
    }

    protected CmsCategory() {
    }

    public static String getCategoryPath(String rootPath, String baseFolder) throws CmsException {
        String base;
        if (rootPath.startsWith("/system/categories/")) {
            base = "/system/categories/";
        } else {
            int pos;
            base = baseFolder;
            if (!base.endsWith("/")) {
                base = base + "/";
            }
            if (!base.startsWith("/")) {
                base = "/" + base;
            }
            if ((pos = rootPath.indexOf(base)) < 0) {
                throw new CmsDataAccessException(Messages.get().container("ERR_CATEGORY_INVALID_LOCATION_1", rootPath));
            }
            base = rootPath.substring(0, pos + base.length());
        }
        return rootPath.substring(base.length());
    }

    @Override
    public int compareTo(CmsCategory cat) {
        boolean thisGlobal = this.getBasePath().equals("/system/categories/");
        boolean thatGlobal = cat.getBasePath().equals("/system/categories/");
        if (thisGlobal && thatGlobal || !thisGlobal && !thatGlobal) {
            return this.getPath().compareTo(cat.getPath());
        }
        return thisGlobal ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsCategory)) {
            return false;
        }
        CmsCategory compareCategory = (CmsCategory)obj;
        return compareCategory.getPath().equals(this.getPath());
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public String getDescription() {
        return this.m_description;
    }

    public CmsUUID getId() {
        return this.m_structureId;
    }

    public String getName() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_path)) {
            return "";
        }
        String result = CmsResource.getName(this.m_path);
        if (CmsResource.isFolder(result)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

