/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsInitException;
import org.opencms.main.OpenCms;
import org.opencms.relations.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsRelationType
implements Serializable {
    private static final String PREFIX_JSP = "JSP_";
    private static final String PREFIX_XML = "XML_";
    private static final String VALUE_STRONG = "STRONG";
    private static final String VALUE_WEAK = "WEAK";
    public static final CmsRelationType CATEGORY = new CmsRelationType(9, "CATEGORY", false, false);
    public static final CmsRelationType EMBEDDED_IMAGE = new CmsRelationType(2, "IMG", true, true);
    public static final CmsRelationType EMBEDDED_OBJECT = new CmsRelationType(7, "OBJECT", true, true);
    public static final CmsRelationType HYPERLINK = new CmsRelationType(1, "A", false, true);
    public static final CmsRelationType JSP_STRONG = new CmsRelationType(5, "JSP_STRONG", true, true);
    public static final CmsRelationType JSP_WEAK = new CmsRelationType(6, "JSP_WEAK", false, true);
    public static final CmsRelationType OU_RESOURCE = new CmsRelationType(8, "OU", false, false);
    public static final CmsRelationType XML_STRONG = new CmsRelationType(3, "XML_STRONG", true, true);
    public static final CmsRelationType XML_WEAK = new CmsRelationType(4, "XML_WEAK", false, true);
    public static final CmsRelationType XSD = new CmsRelationType(10, "XSD", true, true);
    private static final long serialVersionUID = -4060567973007877250L;
    private static final int USER_DEFINED_MODE_LIMIT = 100;
    private static final CmsRelationType[] VALUE_ARRAY = new CmsRelationType[]{HYPERLINK, EMBEDDED_IMAGE, XML_STRONG, XML_WEAK, JSP_STRONG, JSP_WEAK, EMBEDDED_OBJECT, OU_RESOURCE, CATEGORY, XSD};
    private final boolean m_defInContent;
    private final int m_id;
    private final String m_name;
    private final boolean m_strong;

    public CmsRelationType(int id, String name, String type) {
        this.m_name = name.toUpperCase();
        if (OpenCms.getRunLevel() > 2) {
            throw new CmsInitException(Messages.get().container("ERR_RELATION_TYPE_INIT_1", this.m_name));
        }
        this.m_strong = type.toUpperCase().equals(VALUE_STRONG);
        this.m_defInContent = false;
        this.m_id = 100 + id;
    }

    private CmsRelationType(int id, String name, boolean strong, boolean defInContent) {
        this.m_id = id;
        this.m_name = name;
        this.m_strong = strong;
        this.m_defInContent = defInContent;
    }

    public static List<CmsRelationType> filterDefinedInContent(Collection<CmsRelationType> relationTypes) {
        ArrayList<CmsRelationType> result = new ArrayList<CmsRelationType>(relationTypes);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CmsRelationType type = (CmsRelationType)it.next();
            if (type.isDefinedInContent()) continue;
            it.remove();
        }
        return result;
    }

    public static List<CmsRelationType> filterInternal(Collection<CmsRelationType> relationTypes) {
        ArrayList<CmsRelationType> result = new ArrayList<CmsRelationType>(relationTypes);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CmsRelationType type = (CmsRelationType)it.next();
            if (type.isInternal()) continue;
            it.remove();
        }
        return result;
    }

    public static List<CmsRelationType> filterNotDefinedInContent(Collection<CmsRelationType> relationTypes) {
        ArrayList<CmsRelationType> result = new ArrayList<CmsRelationType>(relationTypes);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CmsRelationType type = (CmsRelationType)it.next();
            if (!type.isDefinedInContent()) continue;
            it.remove();
        }
        return result;
    }

    public static List<CmsRelationType> filterStrong(Collection<CmsRelationType> relationTypes) {
        ArrayList<CmsRelationType> result = new ArrayList<CmsRelationType>(relationTypes);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CmsRelationType type = (CmsRelationType)it.next();
            if (type.isStrong()) continue;
            it.remove();
        }
        return result;
    }

    public static List<CmsRelationType> filterUserDefined(Collection<CmsRelationType> relationTypes) {
        ArrayList<CmsRelationType> result = new ArrayList<CmsRelationType>(relationTypes);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CmsRelationType type = (CmsRelationType)it.next();
            if (!type.isInternal()) continue;
            it.remove();
        }
        return result;
    }

    public static List<CmsRelationType> filterWeak(Collection<CmsRelationType> relationTypes) {
        ArrayList<CmsRelationType> result = new ArrayList<CmsRelationType>(relationTypes);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CmsRelationType type = (CmsRelationType)it.next();
            if (!type.isStrong()) continue;
            it.remove();
        }
        return result;
    }

    public static List<CmsRelationType> getAll() {
        ArrayList<CmsRelationType> all = new ArrayList<CmsRelationType>(Arrays.asList(VALUE_ARRAY));
        all.addAll(OpenCms.getResourceManager().getRelationTypes());
        return Collections.unmodifiableList(all);
    }

    public static List<CmsRelationType> getAllDefinedInContent() {
        return CmsRelationType.filterDefinedInContent(CmsRelationType.getAll());
    }

    public static List<CmsRelationType> getAllInternal() {
        return Collections.unmodifiableList(Arrays.asList(VALUE_ARRAY));
    }

    public static List<CmsRelationType> getAllNotDefinedInContent() {
        return CmsRelationType.filterNotDefinedInContent(CmsRelationType.getAll());
    }

    public static List<CmsRelationType> getAllStrong() {
        return CmsRelationType.filterStrong(CmsRelationType.getAll());
    }

    public static List<CmsRelationType> getAllUserDefined() {
        return OpenCms.getResourceManager().getRelationTypes();
    }

    public static List<CmsRelationType> getAllWeak() {
        return CmsRelationType.filterWeak(CmsRelationType.getAll());
    }

    public static CmsRelationType valueOf(int id) throws CmsIllegalArgumentException {
        if (id > 0 && id <= VALUE_ARRAY.length) {
            return VALUE_ARRAY[id - 1];
        }
        if ((id -= 100) >= 0 && id < CmsRelationType.getAllUserDefined().size()) {
            return CmsRelationType.getAllUserDefined().get(id);
        }
        throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_MODE_ENUM_PARSE_2", new Integer(id), CmsRelationType.class.getName()));
    }

    public static CmsRelationType valueOf(String name) throws CmsIllegalArgumentException {
        CmsRelationType result = CmsRelationType.valueOfInternal(name);
        if (result == null) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_MODE_ENUM_PARSE_2", name, CmsRelationType.class.getName()));
        }
        return result;
    }

    public static CmsRelationType valueOfJsp(String name) {
        CmsRelationType result = CmsRelationType.valueOfInternal(name);
        if (result == null) {
            result = CmsRelationType.valueOf(PREFIX_JSP + name);
        }
        return result;
    }

    public static CmsRelationType valueOfXml(String name) {
        CmsRelationType result = CmsRelationType.valueOfInternal(name);
        if (result == null) {
            result = CmsRelationType.valueOf(PREFIX_XML + name);
        }
        return result;
    }

    private static CmsRelationType valueOfInternal(String name) {
        if (name != null) {
            int i;
            String valueUp = name.toUpperCase();
            for (i = 0; i < VALUE_ARRAY.length; ++i) {
                if (!valueUp.equals(CmsRelationType.VALUE_ARRAY[i].m_name)) continue;
                return VALUE_ARRAY[i];
            }
            if (valueUp.equals("REFERENCE") || valueUp.equals("XML_REFERENCE")) {
                return XML_WEAK;
            }
            if (valueUp.equals("ATTACHMENT") || valueUp.equals("XML_ATTACHMENT")) {
                return XML_STRONG;
            }
            for (i = 0; i < CmsRelationType.getAllUserDefined().size(); ++i) {
                CmsRelationType type = CmsRelationType.getAllUserDefined().get(i);
                if (!valueUp.equals(type.m_name)) continue;
                return type;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CmsRelationType) {
            return this.m_id == ((CmsRelationType)obj).m_id;
        }
        return false;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLocalizedName(CmsMessages messages) {
        String nameKey = "GUI_RELATION_TYPE_" + this.getName() + "_0";
        return messages.key(nameKey);
    }

    public String getLocalizedName(Locale locale) {
        return this.getLocalizedName(Messages.get().getBundle(locale));
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameForXml() {
        String result;
        switch (this.getId()) {
            case 3: {
                result = VALUE_STRONG;
                break;
            }
            case 4: {
                result = VALUE_WEAK;
                break;
            }
            case 5: {
                result = VALUE_STRONG;
                break;
            }
            case 6: {
                result = VALUE_WEAK;
                break;
            }
            default: {
                result = this.getName();
            }
        }
        return result;
    }

    public String getType() {
        return this.isStrong() ? VALUE_STRONG : VALUE_WEAK;
    }

    public int hashCode() {
        return this.m_id;
    }

    public boolean isDefinedInContent() {
        return this.m_defInContent;
    }

    public boolean isInternal() {
        return this.getId() < 100;
    }

    public boolean isStrong() {
        return this.m_strong;
    }

    public String toString() {
        return this.m_name;
    }
}

