/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsHtmlReport;
import org.opencms.report.I_CmsReport;
import org.opencms.report.I_CmsReportThread;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsReportThread
extends Thread
implements I_CmsReportThread {
    private CmsObject m_cms;
    private boolean m_doomed;
    private CmsUUID m_id;
    private I_CmsReport m_report;
    private long m_starttime;

    protected A_CmsReportThread(CmsObject cms, String name) {
        super(OpenCms.getThreadStore().getThreadGroup(), name);
        this.setDaemon(false);
        this.m_cms = cms;
        this.m_cms.getRequestContext().setUpdateSessionEnabled(false);
        this.m_id = new CmsUUID();
        this.setName(name + " [" + this.m_id + "]");
        this.m_doomed = false;
        this.m_starttime = System.currentTimeMillis();
        OpenCms.getThreadStore().addThread(this);
    }

    public void addError(Object obj) {
        if (this.getReport() != null) {
            this.getReport().addError(obj);
        }
    }

    public long getLastEntryTime() {
        if (this.getReport() == null) {
            return 0L;
        }
        return this.getReport().getLastEntryTime();
    }

    public Throwable getError() {
        return null;
    }

    public List<Object> getErrors() {
        if (this.getReport() != null) {
            return this.getReport().getErrors();
        }
        return null;
    }

    public abstract String getReportUpdate();

    public synchronized long getRuntime() {
        if (this.m_doomed) {
            return this.m_starttime;
        }
        return System.currentTimeMillis() - this.m_starttime;
    }

    @Override
    public CmsUUID getUUID() {
        return this.m_id;
    }

    public boolean hasError() {
        if (this.getReport() != null) {
            return this.getReport().getErrors().size() > 0;
        }
        return false;
    }

    public synchronized boolean isDoomed() {
        if (this.isAlive()) {
            return false;
        }
        if (this.m_doomed) {
            return true;
        }
        this.m_starttime = this.getRuntime();
        this.m_doomed = true;
        return false;
    }

    protected CmsObject getCms() {
        return this.m_cms;
    }

    protected I_CmsReport getReport() {
        return this.m_report;
    }

    protected void initHtmlReport(Locale locale) {
        this.m_report = new CmsHtmlReport(locale, this.m_cms.getRequestContext().getSiteRoot());
    }

    protected void initOldHtmlReport(Locale locale) {
        this.m_report = new CmsHtmlReport(locale, this.m_cms.getRequestContext().getSiteRoot(), true, false);
    }
}

