/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.main.CmsLog;
import org.opencms.repository.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsRepositoryFilter {
    private static final String TYPE_EXCLUDE = "exclude";
    private static final String TYPE_INCLUDE = "include";
    private List<Pattern> m_filterRules = new ArrayList<Pattern>();
    private String m_type;

    public void addFilterRule(String rule) {
        this.m_filterRules.add(Pattern.compile(rule));
    }

    public List<Pattern> getFilterRules() {
        return this.m_filterRules;
    }

    public String getType() {
        return this.m_type;
    }

    public void initConfiguration() throws CmsConfigurationException {
        if (!TYPE_INCLUDE.equals(this.m_type) && !TYPE_EXCLUDE.equals(this.m_type)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_FILTER_TYPE_1", this.m_type));
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            for (Pattern rule : this.m_filterRules) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_FILTER_RULE_2", this.m_type, rule.pattern()));
            }
        }
        this.m_filterRules = Collections.unmodifiableList(this.m_filterRules);
    }

    public boolean isFiltered(String path) {
        for (int j = 0; j < this.m_filterRules.size(); ++j) {
            Pattern pattern = this.m_filterRules.get(j);
            if (!this.isPartialMatch(pattern, path)) continue;
            return this.m_type.equals(TYPE_EXCLUDE);
        }
        return this.m_type.equals(TYPE_INCLUDE);
    }

    public void setFilterRules(List<Pattern> filterRules) {
        this.m_filterRules = filterRules;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    private boolean isPartialMatch(Pattern pattern, String path) {
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            return true;
        }
        if (!path.endsWith("/")) {
            matcher = pattern.matcher(path + "/");
            return matcher.matches();
        }
        return false;
    }
}

