/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanFilter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermsFilter;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsLuceneIndexWriter;
import org.opencms.search.CmsSearchCategoryCollector;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResult;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSearchIndex
implements I_CmsConfigurationParameterHandler {
    public static final String BACKUP_REINDEXING = CmsSearchIndex.class.getName() + ".useBackupReindexing";
    public static final String[] DATES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    public static final String[] DOC_META_FIELDS = new String[]{"meta", "content"};
    public static final String EXCERPT = CmsSearchIndex.class.getName() + ".createExcerpt";
    public static final String EXTRACT_CONTENT = CmsSearchIndex.class.getName() + ".extractContent";
    public static final String LUCENE_AUTO_COMMIT = "lucene.AutoCommit";
    public static final String LUCENE_MAX_MERGE_DOCS = "lucene.MaxMergeDocs";
    public static final String LUCENE_MERGE_FACTOR = "lucene.MergeFactor";
    public static final String LUCENE_RAM_BUFFER_SIZE_MB = "lucene.RAMBufferSizeMB";
    public static final String LUCENE_USE_COMPOUND_FILE = "lucene.UseCompoundFile";
    public static final Version LUCENE_VERSION = Version.LUCENE_34;
    public static final String MAX_HITS = CmsSearchIndex.class.getName() + ".maxHits";
    public static final int MAX_HITS_DEFAULT = 5000;
    public static final int MAX_YEAR_RANGE = 12;
    public static final String PERMISSIONS = CmsSearchIndex.class.getName() + ".checkPermissions";
    public static final String PRIORITY = CmsSearchIndex.class.getName() + ".priority";
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_ALL = "all";
    public static final String PROPERTY_SEARCH_EXCLUDE_VALUE_GALLERY = "gallery";
    public static final String REBUILD_MODE_AUTO = "auto";
    public static final String REBUILD_MODE_MANUAL = "manual";
    public static final String REBUILD_MODE_OFFLINE = "offline";
    public static final String TIME_RANGE = CmsSearchIndex.class.getName() + ".checkTimeRange";
    public static final String USE_ALL_LOCALE = "all";
    protected static final FieldSelector CONTENT_SELECTOR = new FieldSelector(){
        private static final long serialVersionUID = 2785064181424297998L;

        public FieldSelectorResult accept(String fieldName) {
            if ("content".equals(fieldName) || "contentblob".equals(fieldName)) {
                return FieldSelectorResult.LAZY_LOAD;
            }
            return FieldSelectorResult.LOAD;
        }
    };
    private static final Log LOG = CmsLog.getLog(CmsSearchIndex.class);
    protected boolean m_requireViewPermission;
    protected List<CmsSearchIndexSource> m_sources;
    private Analyzer m_analyzer;
    private boolean m_backupReindexing;
    private boolean m_checkPermissions = true;
    private boolean m_checkTimeRange = false;
    private boolean m_createExcerpt = true;
    private Map<String, Filter> m_displayFilters;
    private Map<String, List<String>> m_documenttypes;
    private boolean m_enabled = true;
    private boolean m_extractContent = true;
    private CmsSearchFieldConfiguration m_fieldConfiguration;
    private String m_fieldConfigurationName;
    private IndexSearcher m_indexSearcher;
    private I_CmsIndexWriter m_indexWriter;
    private Locale m_locale;
    private Integer m_luceneMaxMergeDocs;
    private Integer m_luceneMergeFactor;
    private Double m_luceneRAMBufferSizeMB;
    private Boolean m_luceneUseCompoundFile;
    private int m_maxHits = 5000;
    private String m_name;
    private String m_path;
    private int m_priority = -1;
    private String m_project;
    private String m_rebuild;
    private List<String> m_sourceNames = new ArrayList<String>();

    public CmsSearchIndex() {
        this.m_documenttypes = new HashMap<String, List<String>>();
    }

    public CmsSearchIndex(String name) throws CmsIllegalArgumentException {
        this();
        this.setName(name);
    }

    public static List<String> getDateRangeSpan(long startDate, long endDate) {
        if (startDate > endDate) {
            long temp = endDate;
            endDate = startDate;
            startDate = temp;
        }
        ArrayList<String> result = new ArrayList<String>(100);
        Calendar calStart = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
        Calendar calEnd = Calendar.getInstance(calStart.getTimeZone());
        calStart.setTimeInMillis(startDate);
        calEnd.setTimeInMillis(endDate);
        int startDay = calStart.get(5);
        int endDay = calEnd.get(5);
        int maxDayInStartMonth = calStart.getActualMaximum(5);
        int startMonth = calStart.get(2) + 1;
        int endMonth = calEnd.get(2) + 1;
        int startYear = calStart.get(1);
        int endYear = calEnd.get(1);
        result.addAll(CmsSearchIndex.getYearSpan(startYear + 1, endYear - 1));
        if (startYear != endYear) {
            result.addAll(CmsSearchIndex.getMonthSpan(startMonth + 1, 12, startYear));
            result.addAll(CmsSearchIndex.getMonthSpan(1, endMonth - 1, endYear));
            result.addAll(CmsSearchIndex.getDaySpan(startDay, maxDayInStartMonth, startMonth, startYear));
            result.addAll(CmsSearchIndex.getDaySpan(1, endDay, endMonth, endYear));
        } else if (startMonth != endMonth) {
            result.addAll(CmsSearchIndex.getMonthSpan(startMonth + 1, endMonth - 1, startYear));
            result.addAll(CmsSearchIndex.getDaySpan(startDay, maxDayInStartMonth, startMonth, startYear));
            result.addAll(CmsSearchIndex.getDaySpan(1, endDay, endMonth, endYear));
        } else {
            result.addAll(CmsSearchIndex.getDaySpan(startDay, endDay, endMonth, endYear));
        }
        Collections.sort(result);
        return result;
    }

    private static List<String> getDaySpan(int startDay, int endDay, int month, int year) {
        ArrayList<String> result = new ArrayList<String>();
        String yearMonthStr = String.valueOf(year) + DATES[month];
        for (int i = startDay; i <= endDay; ++i) {
            String dateStr = yearMonthStr + DATES[i];
            result.add(dateStr);
        }
        return result;
    }

    private static List<String> getMonthSpan(int startMonth, int endMonth, int year) {
        ArrayList<String> result = new ArrayList<String>();
        String yearStr = String.valueOf(year);
        for (int i = startMonth; i <= endMonth; ++i) {
            String dateStr = yearStr + DATES[i];
            result.add(dateStr);
        }
        return result;
    }

    private static List<String> getYearSpan(int startYear, int endYear) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = startYear; i <= endYear; ++i) {
            String dateStr = String.valueOf(i);
            result.add(dateStr);
        }
        return result;
    }

    @Override
    public void addConfigurationParameter(String key, String value) {
        if (PERMISSIONS.equals(key)) {
            this.m_checkPermissions = Boolean.valueOf(value);
        } else if (TIME_RANGE.equals(key)) {
            this.m_checkTimeRange = Boolean.valueOf(value);
        } else if (EXCERPT.equals(key)) {
            this.m_createExcerpt = Boolean.valueOf(value);
        } else if (EXTRACT_CONTENT.equals(key)) {
            this.m_extractContent = Boolean.valueOf(value);
        } else if (BACKUP_REINDEXING.equals(key)) {
            this.m_backupReindexing = Boolean.valueOf(value);
        } else if (MAX_HITS.equals(key)) {
            try {
                this.m_maxHits = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
            if (this.m_maxHits < 50) {
                this.m_maxHits = 5000;
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
        } else if (PRIORITY.equals(key)) {
            this.m_priority = Integer.parseInt(value);
            if (this.m_priority < 1) {
                this.m_priority = 1;
                LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_LOW_2", value, new Integer(1)));
            } else if (this.m_priority > 10) {
                this.m_priority = 10;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCH_PRIORITY_TOO_HIGH_2", value, new Integer(10)));
            }
        } else if (LUCENE_MAX_MERGE_DOCS.equals(key)) {
            try {
                this.m_luceneMaxMergeDocs = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
        } else if (LUCENE_MERGE_FACTOR.equals(key)) {
            try {
                this.m_luceneMergeFactor = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
        } else if (LUCENE_RAM_BUFFER_SIZE_MB.equals(key)) {
            try {
                this.m_luceneRAMBufferSizeMB = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PARAM_3", value, key, this.getName()));
            }
        } else if (LUCENE_USE_COMPOUND_FILE.equals(key)) {
            this.m_luceneUseCompoundFile = Boolean.valueOf(value);
        }
    }

    public void addSourceName(String sourceName) {
        this.m_sourceNames.add(sourceName);
    }

    public boolean checkConfiguration(CmsObject cms) {
        if (this.isEnabled()) {
            try {
                cms.readProject(this.getProject());
                this.setEnabled(true);
            }
            catch (CmsException e) {
                this.setEnabled(false);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_CREATE_BAD_PROJECT_2", this.getProject(), this.getName()));
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_SEARCHINDEX_DISABLED_1", this.getName()));
        }
        return this.isEnabled();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSearchIndex) {
            return ((CmsSearchIndex)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public Analyzer getAnalyzer() {
        return this.m_analyzer;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        if (this.getPriority() > 0) {
            result.put(PRIORITY, String.valueOf(this.m_priority));
        }
        if (!this.isCreatingExcerpt()) {
            result.put(EXCERPT, String.valueOf(this.m_createExcerpt));
        }
        if (!this.isExtractingContent()) {
            result.put(EXTRACT_CONTENT, String.valueOf(this.m_extractContent));
        }
        if (!this.isCheckingPermissions()) {
            result.put(PERMISSIONS, String.valueOf(this.m_checkPermissions));
        }
        result.put(TIME_RANGE, String.valueOf(this.m_checkTimeRange));
        if (this.isBackupReindexing()) {
            result.put(BACKUP_REINDEXING, String.valueOf(this.m_backupReindexing));
        }
        if (this.getMaxHits() != 5000) {
            result.put(MAX_HITS, String.valueOf(this.getMaxHits()));
        }
        if (this.m_luceneMaxMergeDocs != null) {
            result.put(LUCENE_MAX_MERGE_DOCS, String.valueOf(this.m_luceneMaxMergeDocs));
        }
        if (this.m_luceneMergeFactor != null) {
            result.put(LUCENE_MERGE_FACTOR, String.valueOf(this.m_luceneMergeFactor));
        }
        if (this.m_luceneRAMBufferSizeMB != null) {
            result.put(LUCENE_RAM_BUFFER_SIZE_MB, String.valueOf(this.m_luceneRAMBufferSizeMB));
        }
        if (this.m_luceneUseCompoundFile != null) {
            result.put(LUCENE_USE_COMPOUND_FILE, String.valueOf(this.m_luceneUseCompoundFile));
        }
        return result;
    }

    public Document getDocument(String rootPath) {
        Document result = null;
        IndexSearcher searcher = this.getSearcher();
        if (searcher != null) {
            Term pathTerm = new Term("path", rootPath);
            try {
                TopDocs hits = searcher.search((Query)new TermQuery(pathTerm), 1);
                if (hits.scoreDocs.length > 0) {
                    result = searcher.doc(hits.scoreDocs[0].doc);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return result;
    }

    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        I_CmsDocumentFactory result;
        if (res != null && this.m_sources != null && (result = OpenCms.getSearchManager().getDocumentFactory(res)) != null) {
            for (CmsSearchIndexSource source : this.m_sources) {
                if (!source.isIndexing(res.getRootPath(), result.getName())) continue;
                return result;
            }
        }
        return null;
    }

    public CmsSearchFieldConfiguration getFieldConfiguration() {
        return this.m_fieldConfiguration;
    }

    public String getFieldConfigurationName() {
        return this.m_fieldConfigurationName;
    }

    public I_CmsIndexWriter getIndexWriter(I_CmsReport report, boolean create) throws CmsIndexException {
        if (this.m_indexWriter != null) {
            if (!create) {
                return this.m_indexWriter;
            }
            try {
                this.m_indexWriter.close();
                this.m_indexWriter = null;
            }
            catch (IOException e) {
                throw new CmsIndexException(Messages.get().container("LOG_IO_INDEX_WRITER_CLOSE_2", this.getPath(), this.getName()), (Throwable)e);
            }
        }
        this.indexWriterUnlock(report);
        I_CmsIndexWriter indexWriter = this.indexWriterCreate(create);
        if (!create) {
            this.m_indexWriter = indexWriter;
        }
        return indexWriter;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        List<Locale> locales = availableLocales;
        if (locales == null || locales.size() == 0) {
            locales = defaultLocales;
        }
        Locale result = OpenCms.getLocaleManager().getBestMatchingLocale(this.getLocale(), defaultLocales, locales);
        return result;
    }

    public String getLocaleString() {
        return this.getLocale().toString();
    }

    public int getMaxHits() {
        return this.m_maxHits;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_path;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public String getProject() {
        return this.m_project;
    }

    public String getRebuildMode() {
        return this.m_rebuild;
    }

    public IndexSearcher getSearcher() {
        return this.m_indexSearcher;
    }

    public List<String> getSourceNames() {
        return this.m_sourceNames;
    }

    public List<CmsSearchIndexSource> getSources() {
        return this.m_sources;
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : 0;
    }

    @Override
    public void initConfiguration() {
    }

    public void initialize() throws CmsSearchException {
        if (!this.isEnabled()) {
            return;
        }
        String sourceName = null;
        CmsSearchIndexSource indexSource = null;
        List<String> searchIndexSourceDocumentTypes = null;
        List<String> resourceNames = null;
        String resourceName = null;
        this.m_sources = new ArrayList<CmsSearchIndexSource>();
        this.m_path = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSearchManager().getDirectory() + "/" + this.m_name);
        int n = this.m_sourceNames.size();
        for (int i = 0; i < n; ++i) {
            try {
                sourceName = this.m_sourceNames.get(i);
                indexSource = OpenCms.getSearchManager().getIndexSource(sourceName);
                this.m_sources.add(indexSource);
                resourceNames = indexSource.getResourcesNames();
                searchIndexSourceDocumentTypes = indexSource.getDocumentTypes();
                int m = resourceNames.size();
                for (int j = 0; j < m; ++j) {
                    resourceName = resourceNames.get(j);
                    this.m_documenttypes.put(resourceName, searchIndexSourceDocumentTypes);
                }
                continue;
            }
            catch (Exception e) {
                this.setEnabled(false);
                throw new CmsSearchException(Messages.get().container("ERR_INDEX_SOURCE_ASSOCIATION_1", sourceName), (Throwable)e);
            }
        }
        if (this.m_fieldConfigurationName == null) {
            this.m_fieldConfigurationName = "standard";
        }
        this.m_fieldConfiguration = OpenCms.getSearchManager().getFieldConfiguration(this.m_fieldConfigurationName);
        if (this.m_fieldConfiguration == null) {
            throw new CmsSearchException(Messages.get().container("ERR_FIELD_CONFIGURATION_UNKNOWN_2", this.m_name, this.m_fieldConfigurationName));
        }
        Analyzer baseAnalyzer = OpenCms.getSearchManager().getAnalyzer(this.getLocale());
        this.setAnalyzer(this.m_fieldConfiguration.getAnalyzer(baseAnalyzer));
        this.indexSearcherOpen(this.m_path);
    }

    public boolean isBackupReindexing() {
        return this.m_backupReindexing;
    }

    public boolean isCheckingPermissions() {
        return this.m_checkPermissions;
    }

    public boolean isCheckingTimeRange() {
        return this.m_checkTimeRange;
    }

    public boolean isCreatingExcerpt() {
        return this.m_createExcerpt;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isExtractingContent() {
        return this.m_extractContent;
    }

    public boolean isRequireViewPermission() {
        return this.m_requireViewPermission;
    }

    public void removeSourceName(String sourceName) {
        this.m_sourceNames.remove(sourceName);
    }

    public synchronized CmsSearchResultList search(CmsObject cms, CmsSearchParameters params) throws CmsSearchException {
        long timeResultProcessing;
        TopDocs hits;
        long timeLucene;
        long timeTotal = -System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCH_PARAMS_2", params, this.getName()));
        }
        CmsSearchResultList searchResults = new CmsSearchResultList();
        int previousPriority = Thread.currentThread().getPriority();
        try {
            CmsObject searchCms = OpenCms.initCmsObject(cms);
            if (this.getPriority() > 0) {
                Thread.currentThread().setPriority(this.getPriority());
            }
            searchCms.getRequestContext().setCurrentProject(searchCms.readProject(this.getProject()));
            timeLucene = -System.currentTimeMillis();
            BooleanFilter filter = new BooleanFilter();
            filter = this.appendPathFilter(searchCms, filter, params.getRoots());
            filter = this.appendCategoryFilter(searchCms, filter, params.getCategories());
            filter = this.appendResourceTypeFilter(searchCms, filter, params.getResourceTypes());
            filter = this.appendDateLastModifiedFilter(filter, params.getMinDateLastModified(), params.getMaxDateLastModified());
            filter = this.appendDateCreatedFilter(filter, params.getMinDateCreated(), params.getMaxDateCreated());
            MatchAllDocsQuery query = null;
            Query fieldsQuery = null;
            if (!params.isIgnoreQuery()) {
                QueryParser p;
                if (params.getParsedQuery() != null) {
                    p = new QueryParser(LUCENE_VERSION, "content", this.getAnalyzer());
                    fieldsQuery = p.parse(params.getParsedQuery());
                } else if (params.getFieldQueries() != null) {
                    BooleanQuery mustOccur = null;
                    BooleanQuery shouldOccur = null;
                    for (CmsSearchParameters.CmsSearchFieldQuery fq : params.getFieldQueries()) {
                        QueryParser p2 = new QueryParser(LUCENE_VERSION, fq.getFieldName(), this.getAnalyzer());
                        Query keywordQuery = null;
                        if (fq.getSearchTerms().size() == 1) {
                            keywordQuery = p2.parse(fq.getSearchTerms().get(0));
                        } else {
                            BooleanQuery keywordListQuery = new BooleanQuery();
                            for (String keyword : fq.getSearchTerms()) {
                                keywordListQuery.add(p2.parse(keyword), fq.getTermOccur());
                            }
                            keywordQuery = keywordListQuery;
                        }
                        if (BooleanClause.Occur.SHOULD.equals((Object)fq.getOccur())) {
                            if (shouldOccur == null) {
                                shouldOccur = new BooleanQuery();
                            }
                            shouldOccur.add(keywordQuery, fq.getOccur());
                            continue;
                        }
                        if (mustOccur == null) {
                            mustOccur = new BooleanQuery();
                        }
                        mustOccur.add(keywordQuery, fq.getOccur());
                    }
                    BooleanQuery booleanFieldsQuery = new BooleanQuery();
                    if (mustOccur != null) {
                        booleanFieldsQuery.add(mustOccur, BooleanClause.Occur.MUST);
                    }
                    if (shouldOccur != null) {
                        booleanFieldsQuery.add(shouldOccur, BooleanClause.Occur.MUST);
                    }
                    fieldsQuery = this.getSearcher().rewrite((Query)booleanFieldsQuery);
                } else if (params.getFields() != null && params.getFields().size() > 0) {
                    BooleanQuery booleanFieldsQuery = new BooleanQuery();
                    for (int i = 0; i < params.getFields().size(); ++i) {
                        QueryParser p3 = new QueryParser(LUCENE_VERSION, params.getFields().get(i), this.getAnalyzer());
                        booleanFieldsQuery.add(p3.parse(params.getQuery()), BooleanClause.Occur.SHOULD);
                    }
                    fieldsQuery = this.getSearcher().rewrite((Query)booleanFieldsQuery);
                } else {
                    p = new QueryParser(LUCENE_VERSION, "content", this.getAnalyzer());
                    fieldsQuery = this.getSearcher().rewrite(p.parse(params.getQuery()));
                }
                query = fieldsQuery;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_BASE_QUERY_1", query));
            }
            if (query == null) {
                query = new MatchAllDocsQuery();
            } else {
                params.setParsedQuery(query.toString("content"));
            }
            if (params.isCalculateCategories()) {
                CmsSearchCategoryCollector categoryCollector = new CmsSearchCategoryCollector(this.getSearcher());
                this.getSearcher().search((Query)query, (Filter)filter, (Collector)categoryCollector);
                searchResults.setCategories(categoryCollector.getCategoryCountResult());
            }
            if (params.getSort() == null || params.getSort() == CmsSearchParameters.SORT_DEFAULT) {
                hits = this.getSearcher().search((Query)query, (Filter)filter, this.m_maxHits);
            } else {
                this.prepareSortScoring(this.m_indexSearcher, params.getSort());
                hits = this.getSearcher().search((Query)query, (Filter)filter, this.m_maxHits, params.getSort());
            }
            timeLucene += System.currentTimeMillis();
            timeResultProcessing = -System.currentTimeMillis();
            if (hits != null) {
                int hitCount = hits.totalHits > hits.scoreDocs.length ? hits.scoreDocs.length : hits.totalHits;
                int page = params.getSearchPage();
                int start = -1;
                int end = -1;
                if (params.getMatchesPerPage() > 0 && page > 0 && hitCount > 0) {
                    start = params.getMatchesPerPage() * (page - 1);
                    end = start + params.getMatchesPerPage();
                    start = start > hitCount ? hitCount : start;
                    end = end > hitCount ? hitCount : end;
                } else {
                    start = 0;
                    end = hitCount;
                }
                int visibleHitCount = hitCount;
                int cnt = 0;
                for (int i = 0; i < hitCount && cnt < end; ++i) {
                    try {
                        Document doc = this.getSearcher().doc(hits.scoreDocs[i].doc);
                        if (this.isInTimeRange(doc, params) && this.hasReadPermission(searchCms, doc)) {
                            if (cnt >= start) {
                                String excerpt = null;
                                if (this.isCreatingExcerpt() && fieldsQuery != null) {
                                    I_CmsTermHighlighter highlighter = OpenCms.getSearchManager().getHighlighter();
                                    excerpt = highlighter.getExcerpt(doc, this, params, fieldsQuery, this.getAnalyzer());
                                }
                                CmsSearchResult searchResult = new CmsSearchResult(Math.round(hits.scoreDocs[i].score / hits.getMaxScore() * 100.0f), doc, excerpt);
                                searchResults.add(searchResult);
                            }
                            ++cnt;
                            continue;
                        }
                        --visibleHitCount;
                        continue;
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                    }
                }
                searchResults.setHitCount(visibleHitCount);
            } else {
                searchResults.setHitCount(0);
            }
            timeResultProcessing += System.currentTimeMillis();
        }
        catch (RuntimeException e) {
            throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
        }
        finally {
            Thread.currentThread().setPriority(previousPriority);
        }
        if (LOG.isDebugEnabled()) {
            Object[] logParams = new Object[]{new Integer(hits == null ? 0 : hits.totalHits), new Long(timeTotal += System.currentTimeMillis()), new Long(timeLucene), new Long(timeResultProcessing)};
            LOG.debug((Object)Messages.get().getBundle().key("LOG_STAT_RESULTS_TIME_4", logParams));
        }
        return searchResults;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.m_analyzer = analyzer;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setFieldConfiguration(CmsSearchFieldConfiguration fieldConfiguration) {
        this.m_fieldConfiguration = fieldConfiguration;
    }

    public void setFieldConfigurationName(String fieldConfigurationName) {
        this.m_fieldConfigurationName = fieldConfigurationName;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setLocaleString(String locale) {
        this.setLocale(CmsLocaleManager.getLocale(locale));
    }

    public void setMaxHits(int maxHits) {
        if (this.m_maxHits >= 50) {
            this.m_maxHits = maxHits;
        }
    }

    public void setName(String name) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_MISSING_NAME_0"));
        }
        if (!name.equals(this.m_name) && OpenCms.getRunLevel() > 2) {
            Iterator<String> itIdxNames = OpenCms.getSearchManager().getIndexNames().iterator();
            while (itIdxNames.hasNext()) {
                if (!itIdxNames.next().equals(name)) continue;
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_INVALID_NAME_1", name));
            }
        }
        this.m_name = name;
    }

    public void setProject(String projectName) {
        this.setProjectName(projectName);
    }

    public void setProjectName(String projectName) {
        this.m_project = projectName;
    }

    public void setRebuildMode(String rebuildMode) {
        this.m_rebuild = rebuildMode;
    }

    public void setRequireViewPermission(boolean requireViewPermission) {
        this.m_requireViewPermission = requireViewPermission;
    }

    public void shutDown() {
        if (this.m_indexWriter != null) {
            try {
                this.m_indexWriter.commit();
                this.m_indexWriter.close();
            }
            catch (IOException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", this.getPath(), this.getName()), (Throwable)e);
            }
        }
        this.indexSearcherClose();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_INDEX_1", this.getName()));
        }
    }

    public String toString() {
        return this.getName();
    }

    protected BooleanFilter appendCategoryFilter(CmsObject cms, BooleanFilter filter, List<String> categories) {
        if (categories != null && categories.size() > 0) {
            ArrayList<String> lowerCaseCategories = new ArrayList<String>();
            for (String category : categories) {
                lowerCaseCategories.add(category.toLowerCase());
            }
            filter.add(new FilterClause(this.getMultiTermQueryFilter("category", lowerCaseCategories), BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected BooleanFilter appendDateCreatedFilter(BooleanFilter filter, long startTime, long endTime) {
        Filter dateFilter = this.createDateRangeFilter("created_lookup", startTime, endTime);
        if (dateFilter != null) {
            filter.add(new FilterClause(dateFilter, BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected BooleanFilter appendDateLastModifiedFilter(BooleanFilter filter, long startTime, long endTime) {
        Filter dateFilter = this.createDateRangeFilter("lastmodified_lookup", startTime, endTime);
        if (dateFilter != null) {
            filter.add(new FilterClause(dateFilter, BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected BooleanFilter appendPathFilter(CmsObject cms, BooleanFilter filter, List<String> roots) {
        TermsFilter pathFilter = new TermsFilter();
        if (roots != null && roots.size() > 0) {
            for (int i = 0; i < roots.size(); ++i) {
                String searchRoot = cms.getRequestContext().addSiteRoot(roots.get(i));
                this.extendPathFilter(pathFilter, searchRoot);
            }
        } else {
            this.extendPathFilter(pathFilter, cms.getRequestContext().getSiteRoot());
            this.extendPathFilter(pathFilter, OpenCms.getSiteManager().getSharedFolder());
        }
        filter.add(new FilterClause((Filter)pathFilter, BooleanClause.Occur.MUST));
        return filter;
    }

    protected BooleanFilter appendResourceTypeFilter(CmsObject cms, BooleanFilter filter, List<String> resourceTypes) {
        if (resourceTypes != null && resourceTypes.size() > 0) {
            filter.add(new FilterClause(this.getMultiTermQueryFilter("type", resourceTypes), BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected Filter createDateRangeFilter(String fieldName, long startTime, long endTime) {
        TermsFilter filter = null;
        if (startTime != Long.MIN_VALUE || endTime != Long.MAX_VALUE) {
            Calendar cal;
            if (startTime == Long.MIN_VALUE) {
                cal = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
                cal.setTimeInMillis(endTime);
                cal.set(cal.get(1) - 12, 11, 31, 0, 0, 0);
                startTime = cal.getTimeInMillis();
            } else if (endTime == Long.MAX_VALUE) {
                cal = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
                cal.setTimeInMillis(startTime);
                cal.set(cal.get(1) + 12, 0, 1, 0, 0, 0);
                endTime = cal.getTimeInMillis();
            }
            filter = new TermsFilter();
            List<String> dateRage = CmsSearchIndex.getDateRangeSpan(startTime, endTime);
            Iterator<String> i = dateRage.iterator();
            while (i.hasNext()) {
                filter.addTerm(new Term(fieldName, i.next()));
            }
        }
        return filter;
    }

    protected String createIndexBackup() {
        if (!this.isBackupReindexing()) {
            return null;
        }
        File file = new File(this.getPath());
        if (!file.exists()) {
            return null;
        }
        String backupPath = this.getPath() + "_backup";
        try {
            FSDirectory oldDir = FSDirectory.open((File)file);
            FSDirectory newDir = FSDirectory.open((File)new File(backupPath));
            for (String fileName : oldDir.listAll()) {
                oldDir.copy((Directory)newDir, fileName, fileName);
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_BACKUP_CREATE_3", this.getName(), this.getPath(), backupPath), (Throwable)e);
            backupPath = null;
        }
        return backupPath;
    }

    protected boolean excludeFromIndex(CmsObject cms, CmsResource resource) {
        boolean excludeFromIndex;
        block5: {
            excludeFromIndex = false;
            if (resource.isInternal() || resource.isFolder() || resource.isTemporaryFile() || resource.getDateExpired() <= System.currentTimeMillis()) {
                return true;
            }
            try {
                String propValue = cms.readPropertyObject(resource, "search.exclude", true).getValue();
                excludeFromIndex = Boolean.valueOf(propValue);
                if (!excludeFromIndex && propValue != null) {
                    excludeFromIndex = "all".equalsIgnoreCase(propValue.trim());
                }
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_PROPERTY_1", resource.getRootPath()));
            }
        }
        if (!excludeFromIndex && !"all".equalsIgnoreCase(this.getLocale().getLanguage())) {
            List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
            Locale match = OpenCms.getLocaleManager().getFirstMatchingLocale(Collections.singletonList(this.getLocale()), locales);
            excludeFromIndex = match == null;
        }
        return excludeFromIndex;
    }

    protected void extendPathFilter(TermsFilter pathFilter, String searchRoot) {
        if (!CmsResource.isFolder(searchRoot)) {
            searchRoot = searchRoot + "/";
        }
        pathFilter.addTerm(new Term("parent-folders", searchRoot));
    }

    protected Filter getMultiTermQueryFilter(String field, List<String> terms) {
        return this.getMultiTermQueryFilter(field, null, terms);
    }

    protected Filter getMultiTermQueryFilter(String field, String terms) {
        return this.getMultiTermQueryFilter(field, terms, null);
    }

    protected Filter getMultiTermQueryFilter(String field, String termsStr, List<String> termsList) {
        Filter result;
        if (termsStr == null) {
            StringBuffer buf = new StringBuffer(64);
            for (int i = 0; i < termsList.size(); ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(termsList.get(i));
            }
            termsStr = buf.toString();
        }
        if ((result = this.m_displayFilters.get(new StringBuffer(64).append(field).append('|').append(termsStr).toString())) == null) {
            TermsFilter filter = new TermsFilter();
            if (termsList == null) {
                termsList = CmsStringUtil.splitAsList(termsStr, ' ');
            }
            for (int i = 0; i < termsList.size(); ++i) {
                filter.addTerm(new Term(field, termsList.get(i)));
            }
            result = new CachingWrapperFilter((Filter)filter);
            this.m_displayFilters.put(field + termsStr, result);
        }
        return result;
    }

    protected Filter getTermQueryFilter(String field, String term) {
        return this.getMultiTermQueryFilter(field, term, Collections.singletonList(term));
    }

    protected boolean hasReadPermission(CmsObject cms, Document doc) {
        if (!this.isCheckingPermissions()) {
            return true;
        }
        Fieldable typeField = doc.getFieldable("type");
        Fieldable pathField = doc.getFieldable("path");
        if (typeField == null || pathField == null) {
            return true;
        }
        String type = typeField.stringValue();
        if (!"VFS".equals(type) && !OpenCms.getResourceManager().hasResourceType(type)) {
            return true;
        }
        String contextPath = cms.getRequestContext().removeSiteRoot(pathField.stringValue());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT;
        if (this.isRequireViewPermission()) {
            filter = CmsResourceFilter.DEFAULT_ONLY_VISIBLE;
        }
        return cms.existsResource(contextPath, filter);
    }

    protected synchronized void indexSearcherClose() {
        this.indexSearcherClose(this.m_indexSearcher);
    }

    protected void indexSearcherClose(IndexSearcher searcher) {
        if (searcher != null && searcher.getIndexReader() != null) {
            try {
                searcher.getIndexReader().close();
                searcher.close();
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_SEARCHER_CLOSE_1", this.getName()), (Throwable)e);
            }
        }
    }

    protected synchronized void indexSearcherOpen(String path) {
        IndexSearcher oldSearcher = null;
        try {
            FSDirectory indexDirectory = FSDirectory.open((File)new File(path));
            if (IndexReader.indexExists((Directory)indexDirectory)) {
                LazyContentReader reader = new LazyContentReader(IndexReader.open((Directory)indexDirectory));
                if (this.m_indexSearcher != null) {
                    oldSearcher = this.m_indexSearcher;
                }
                this.m_indexSearcher = new IndexSearcher((IndexReader)reader);
                this.m_displayFilters = new HashMap<String, Filter>();
            }
        }
        catch (IOException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_SEARCHER_1", this.getName()), (Throwable)e);
        }
        if (oldSearcher != null) {
            this.indexSearcherClose(oldSearcher);
        }
    }

    protected synchronized void indexSearcherUpdate() {
        if (this.m_indexSearcher != null && this.m_indexSearcher.getIndexReader() != null) {
            try {
                IndexReader newReader = this.m_indexSearcher.getIndexReader().reopen();
                this.m_indexSearcher = new IndexSearcher(newReader);
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_SEARCHER_REOPEN_1", this.getName()), (Throwable)e);
            }
        }
    }

    protected I_CmsIndexWriter indexWriterCreate(boolean create) throws CmsIndexException {
        IndexWriter indexWriter;
        try {
            File f = new File(this.m_path);
            if (!f.exists()) {
                if ((f = f.getParentFile()) != null && !f.exists()) {
                    f.mkdirs();
                }
                create = true;
            }
            FSDirectory dir = FSDirectory.open((File)new File(this.m_path));
            LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
            if (this.m_luceneMaxMergeDocs != null) {
                mergePolicy.setMaxMergeDocs(this.m_luceneMaxMergeDocs.intValue());
            }
            if (this.m_luceneMergeFactor != null) {
                mergePolicy.setMergeFactor(this.m_luceneMergeFactor.intValue());
            }
            if (this.m_luceneUseCompoundFile != null) {
                mergePolicy.setUseCompoundFile(this.m_luceneUseCompoundFile.booleanValue());
            }
            IndexWriterConfig indexConfig = new IndexWriterConfig(LUCENE_VERSION, this.getAnalyzer());
            if (this.m_luceneRAMBufferSizeMB != null) {
                indexConfig.setRAMBufferSizeMB(this.m_luceneRAMBufferSizeMB.doubleValue());
            }
            if (create) {
                indexConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            } else {
                indexConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            }
            indexWriter = new IndexWriter((Directory)dir, indexConfig);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_IO_INDEX_WRITER_OPEN_2", this.m_path, this.m_name), (Throwable)e);
        }
        return new CmsLuceneIndexWriter(indexWriter, this);
    }

    protected void indexWriterUnlock(I_CmsReport report) throws CmsIndexException {
        File indexPath = new File(this.getPath());
        boolean indexLocked = true;
        if (indexPath.exists()) {
            FSDirectory indexDirectory = null;
            try {
                indexDirectory = FSDirectory.open((File)indexPath);
                indexLocked = IndexWriter.isLocked((Directory)indexDirectory);
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_READER_OPEN_2", this.getPath(), this.getName()), (Throwable)e);
            }
            if (indexLocked) {
                try {
                    IndexWriter.unlock((Directory)indexDirectory);
                }
                catch (Exception e) {
                    CmsMessageContainer msg = Messages.get().container("ERR_INDEX_LOCK_FAILED_1", this.getName());
                    report.println(msg, 5);
                    throw new CmsIndexException(msg, (Throwable)e);
                }
            }
        }
    }

    protected boolean isInTimeRange(Document doc, CmsSearchParameters params) {
        if (!this.isCheckingTimeRange()) {
            return true;
        }
        try {
            Date dateCreated = DateTools.stringToDate((String)doc.getFieldable("created").stringValue());
            if (dateCreated.getTime() < params.getMinDateCreated()) {
                return false;
            }
            if (dateCreated.getTime() > params.getMaxDateCreated()) {
                return false;
            }
            Date dateLastModified = DateTools.stringToDate((String)doc.getFieldable("lastmodified").stringValue());
            if (dateLastModified.getTime() < params.getMinDateLastModified()) {
                return false;
            }
            if (dateLastModified.getTime() > params.getMaxDateLastModified()) {
                return false;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    protected void prepareSortScoring(IndexSearcher searcher, Sort sort) {
        boolean doScoring = false;
        if (sort != null) {
            if (sort == CmsSearchParameters.SORT_DEFAULT || sort == CmsSearchParameters.SORT_TITLE) {
                doScoring = true;
            } else if (sort == CmsSearchParameters.SORT_DATE_CREATED || sort == CmsSearchParameters.SORT_DATE_LASTMODIFIED) {
                doScoring = false;
            } else {
                SortField[] fields;
                for (SortField field : fields = sort.getSort()) {
                    if (field != SortField.FIELD_SCORE) continue;
                    doScoring = true;
                    break;
                }
            }
        }
        searcher.setDefaultFieldSortScoring(doScoring, doScoring);
    }

    protected void removeIndexBackup(String path) {
        if (!this.isBackupReindexing()) {
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try {
            FSDirectory dir = FSDirectory.open((File)file);
            dir.close();
            CmsFileUtil.purgeDirectory(file);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_BACKUP_REMOVE_2", this.getName(), path), (Throwable)e);
        }
    }

    protected class LazyContentReader
    extends FilterIndexReader {
        private IndexReader m_reader;

        public LazyContentReader(IndexReader indexReader) {
            super(indexReader);
            this.m_reader = indexReader;
        }

        public Document document(int n) throws CorruptIndexException, IOException {
            return super.document(n, CONTENT_SELECTOR);
        }

        public synchronized IndexReader reopen() throws CorruptIndexException, IOException {
            return this.m_reader.reopen();
        }
    }
}

