/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSearchFieldConfiguration
implements Comparable<CmsSearchFieldConfiguration> {
    public static final CmsSearchFieldConfiguration DEFAULT_STANDARD = CmsSearchFieldConfiguration.createStandardConfiguration();
    public static final String SEARCH_PRIORITY_HIGH_VALUE = "high";
    public static final String SEARCH_PRIORITY_LOW_VALUE = "low";
    public static final String SEARCH_PRIORITY_MAX_VALUE = "max";
    public static final String SEARCH_PRIORITY_NORMAL_VALUE = "normal";
    public static final String STR_STANDARD = "standard";
    public static final String STR_STANDARD_DESCRIPTION = "The standard OpenCms 8.0 search index field configuration.";
    public static final String VFS_DOCUMENT_KEY_PREFIX = "VFS";
    private String m_description;
    private List<String> m_excerptFieldNames;
    private Map<String, CmsSearchField> m_fieldLookup;
    private List<String> m_fieldNames;
    private List<CmsSearchField> m_fields = new ArrayList<CmsSearchField>();
    private String m_name;

    public static String getDateTerms(long date) {
        Calendar cal = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
        cal.setTimeInMillis(date);
        String day = CmsSearchIndex.DATES[cal.get(5)];
        String month = CmsSearchIndex.DATES[cal.get(2) + 1];
        String year = String.valueOf(cal.get(1));
        StringBuffer result = new StringBuffer();
        result.append(year);
        result.append(month);
        result.append(day);
        result.append(' ');
        result.append(year);
        result.append(month);
        result.append(' ');
        result.append(year);
        return result.toString();
    }

    public static String getParentFolderTokens(String rootPath) {
        if (CmsStringUtil.isEmpty(rootPath)) {
            return "/";
        }
        StringBuffer result = new StringBuffer(128);
        String folderName = CmsResource.getFolderPath(rootPath);
        for (int i = 0; i < folderName.length(); ++i) {
            char c = folderName.charAt(i);
            if (c != '/') continue;
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(folderName.substring(0, i + 1));
        }
        return result.toString();
    }

    private static CmsSearchFieldConfiguration createStandardConfiguration() {
        CmsSearchFieldConfiguration result = new CmsSearchFieldConfiguration();
        result.setName(STR_STANDARD);
        result.setDescription(STR_STANDARD_DESCRIPTION);
        CmsSearchField field = new CmsSearchField("content", "%(key.field.content)", true, true, true, true, true, null, 1.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, null));
        result.addField(field);
        field = new CmsSearchField("title-key", "-", true, true, false, false, 0.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsSearchField("title", "%(key.field.title)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsSearchField("keywords", "%(key.field.keywords)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        result.addField(field);
        field = new CmsSearchField("description", "%(key.field.description)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        field = new CmsSearchField("meta", "%(key.field.meta)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        return result;
    }

    public void addField(CmsSearchField field) {
        if (field != null) {
            this.m_fields.add(field);
        }
    }

    @Override
    public int compareTo(CmsSearchFieldConfiguration obj) {
        return this.m_name.compareTo(obj.m_name);
    }

    public Document createDocument(CmsObject cms, CmsResource resource, CmsSearchIndex index, I_CmsExtractionResult content) throws CmsException {
        Document document = new Document();
        List<CmsProperty> propertiesSearched = cms.readPropertyObjects(resource, true);
        List<CmsProperty> properties = cms.readPropertyObjects(resource, false);
        document = this.appendContentBlob(document, cms, resource, content, properties, propertiesSearched);
        document = this.appendFieldMappings(document, cms, resource, content, properties, propertiesSearched);
        document = this.appendPath(document, cms, resource, content, properties, propertiesSearched);
        document = this.appendCategories(document, cms, resource, content, properties, propertiesSearched);
        document = this.appendDates(document, cms, resource, content, properties, propertiesSearched);
        document = this.appendType(document, cms, resource, content, properties, propertiesSearched);
        document = this.setBoost(document, cms, resource, content, properties, propertiesSearched);
        return document;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSearchFieldConfiguration) {
            return ((CmsSearchFieldConfiguration)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public Analyzer getAnalyzer(Analyzer analyzer) {
        PerFieldAnalyzerWrapper result = (analyzer = this.getAnalyzerForDefaultFields(analyzer)) instanceof PerFieldAnalyzerWrapper ? (PerFieldAnalyzerWrapper)analyzer : null;
        for (CmsSearchField field : this.m_fields) {
            Analyzer fieldAnalyzer = field.getAnalyzer();
            if (fieldAnalyzer == null) continue;
            if (result == null) {
                result = new PerFieldAnalyzerWrapper(analyzer);
            }
            result.addAnalyzer(field.getName(), fieldAnalyzer);
        }
        if (result == null) {
            return analyzer;
        }
        return result;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<String> getExcerptFieldNames() {
        if (this.m_excerptFieldNames == null) {
            this.m_excerptFieldNames = new ArrayList<String>();
            for (CmsSearchField field : this.m_fields) {
                if (!field.isInExcerptAndStored()) continue;
                this.m_excerptFieldNames.add(field.getName());
            }
        }
        return new ArrayList<String>(this.m_excerptFieldNames);
    }

    public CmsSearchField getField(String name) {
        if (this.m_fieldLookup == null) {
            this.m_fieldLookup = new HashMap<String, CmsSearchField>();
            for (CmsSearchField field : this.m_fields) {
                this.m_fieldLookup.put(field.getName(), field);
            }
        }
        return this.m_fieldLookup.get(name);
    }

    public List<String> getFieldNames() {
        if (this.m_fieldNames == null) {
            this.m_fieldNames = new ArrayList<String>();
            Iterator<CmsSearchField> i = this.m_fields.iterator();
            while (i.hasNext()) {
                this.m_fieldNames.add(i.next().getName());
            }
        }
        return new ArrayList<String>(this.m_fieldNames);
    }

    public List<CmsSearchField> getFields() {
        return this.m_fields;
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    protected Document appendCategories(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) throws CmsException {
        CmsCategoryService categoryService = CmsCategoryService.getInstance();
        List<CmsCategory> categories = categoryService.readResourceCategories(cms, resource);
        if (categories != null && categories.size() > 0) {
            StringBuffer categoryBuffer = new StringBuffer(128);
            for (CmsCategory category : categories) {
                categoryBuffer.append(category.getPath());
                categoryBuffer.append(' ');
            }
            if (categoryBuffer.length() > 0) {
                Field field = new Field("category", categoryBuffer.toString().toLowerCase(), Field.Store.YES, Field.Index.ANALYZED);
                field.setBoost(0.0f);
                document.add((Fieldable)field);
            }
        } else {
            Field field = new Field("category", "unknown", Field.Store.YES, Field.Index.ANALYZED);
            document.add((Fieldable)field);
        }
        return document;
    }

    protected Document appendContentBlob(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        byte[] data;
        if (extractionResult != null && (data = extractionResult.getBytes()) != null) {
            Field field = new Field("contentblob", data);
            document.add((Fieldable)field);
        }
        return document;
    }

    protected Document appendDates(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        Field field = new Field("created", DateTools.dateToString((Date)new Date(resource.getDateCreated()), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED);
        field.setBoost(0.0f);
        document.add((Fieldable)field);
        field = new Field("created_lookup", CmsSearchFieldConfiguration.getDateTerms(resource.getDateCreated()), Field.Store.NO, Field.Index.ANALYZED);
        document.add((Fieldable)field);
        field = new Field("lastmodified", DateTools.dateToString((Date)new Date(resource.getDateLastModified()), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED);
        field.setBoost(0.0f);
        document.add((Fieldable)field);
        field = new Field("lastmodified_lookup", CmsSearchFieldConfiguration.getDateTerms(resource.getDateLastModified()), Field.Store.NO, Field.Index.ANALYZED);
        document.add((Fieldable)field);
        field = new Field("contentdate", DateTools.dateToString((Date)new Date(resource.getDateContent()), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED);
        field.setBoost(0.0f);
        document.add((Fieldable)field);
        return document;
    }

    protected Document appendFieldMapping(Document document, CmsSearchField fieldConfig, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        StringBuffer text = new StringBuffer();
        for (CmsSearchFieldMapping mapping : fieldConfig.getMappings()) {
            String mapResult = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched);
            if (mapResult == null) continue;
            if (text.length() > 0) {
                text.append('\n');
            }
            text.append(mapResult);
        }
        if (text.length() > 0) {
            Field field = fieldConfig.createField(text.toString());
            document.add((Fieldable)field);
        }
        return document;
    }

    protected Document appendFieldMappings(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (CmsSearchField fieldConfig : this.getFields()) {
            document = this.appendFieldMapping(document, fieldConfig, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    protected Document appendPath(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String parentFolders = CmsSearchFieldConfiguration.getParentFolderTokens(resource.getRootPath());
        Field field = new Field("parent-folders", parentFolders, Field.Store.NO, Field.Index.ANALYZED);
        field.setBoost(0.0f);
        document.add((Fieldable)field);
        document.add((Fieldable)new Field("path", resource.getRootPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        return document;
    }

    protected Document appendType(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) throws CmsLoaderException {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        String typeName = VFS_DOCUMENT_KEY_PREFIX;
        if (type != null) {
            typeName = type.getTypeName();
        }
        document.add((Fieldable)new Field("type", typeName, Field.Store.YES, Field.Index.NOT_ANALYZED));
        return document;
    }

    protected Analyzer getAnalyzerForDefaultFields(Analyzer analyzer) {
        PerFieldAnalyzerWrapper result = analyzer instanceof PerFieldAnalyzerWrapper ? (PerFieldAnalyzerWrapper)analyzer : new PerFieldAnalyzerWrapper(analyzer);
        WhitespaceAnalyzer ws = new WhitespaceAnalyzer(CmsSearchIndex.LUCENE_VERSION);
        result.addAnalyzer("parent-folders", (Analyzer)ws);
        result.addAnalyzer("category", (Analyzer)ws);
        result.addAnalyzer("lastmodified_lookup", (Analyzer)ws);
        result.addAnalyzer("created_lookup", (Analyzer)ws);
        return result;
    }

    protected Document setBoost(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        float boost = 1.0f;
        String value = CmsProperty.get("search.priority", propertiesSearched).getValue();
        if (value != null) {
            if ((value = value.trim().toLowerCase()).equals(SEARCH_PRIORITY_MAX_VALUE)) {
                boost = 2.0f;
            } else if (value.equals(SEARCH_PRIORITY_HIGH_VALUE)) {
                boost = 1.5f;
            } else if (value.equals(SEARCH_PRIORITY_LOW_VALUE)) {
                boost = 0.5f;
            }
        }
        if (boost != 1.0f) {
            document.setBoost(boost);
        }
        return document;
    }
}

