/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.main.OpenCms;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.util.CmsStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsGallerySearchFieldConfiguration
extends CmsSearchFieldConfiguration {
    public static final String getLocaleExtendedName(String lookup, Locale locale) {
        return CmsGallerySearchFieldConfiguration.getLocaleExtendedName(lookup, locale.toString());
    }

    public static final String getLocaleExtendedName(String lookup, String locale) {
        StringBuffer result = new StringBuffer(32);
        result.append(lookup);
        result.append('_');
        result.append(locale);
        return result.toString();
    }

    @Override
    protected Document appendFieldMappings(Document document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (CmsSearchField fieldConfig : this.getFields()) {
            if ("title-key".equals(fieldConfig.getName()) || CmsResourceTypeXmlContent.isXmlContent(resource) && ("content".equals(fieldConfig.getName()) || "title".equals(fieldConfig.getName()) || "description".equals(fieldConfig.getName()) || "meta".equals(fieldConfig.getName()))) {
                this.appendMultipleFieldMapping(document, fieldConfig, cms, resource, extractionResult, properties, propertiesSearched);
                continue;
            }
            this.appendFieldMapping(document, fieldConfig, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    protected Document appendMultipleFieldMapping(Document document, CmsSearchField fieldConfig, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String mappingName = null;
        String fieldName = fieldConfig.getName();
        String value = null;
        if ("content".equals(fieldName)) {
            mappingName = "content";
        } else if ("title".equals(fieldName)) {
            mappingName = "title";
        } else if ("title-key".equals(fieldName)) {
            if (!CmsResourceTypeXmlContent.isXmlContent(resource)) {
                value = CmsProperty.get("Title", properties).getValue();
            } else {
                mappingName = "title";
            }
        } else if ("description".equals(fieldName)) {
            mappingName = "description";
        } else if ("meta".equals(fieldName)) {
            mappingName = "meta";
        }
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            if (mappingName != null) {
                if (mappingName == "meta") {
                    String title = extractionResult.getContentItems().get(CmsGallerySearchFieldConfiguration.getLocaleExtendedName("title", locale));
                    String description = extractionResult.getContentItems().get(CmsGallerySearchFieldConfiguration.getLocaleExtendedName("description", locale));
                    StringBuffer v = new StringBuffer();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
                        v.append(title);
                        v.append('\n');
                    }
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(description)) {
                        v.append(description);
                    }
                    if (v.length() > 0) {
                        value = v.toString();
                    }
                } else {
                    String localeMapping = CmsGallerySearchFieldConfiguration.getLocaleExtendedName(mappingName, locale);
                    value = extractionResult.getContentItems().get(localeMapping);
                }
            }
            if (value == null) continue;
            Field field = fieldConfig.createField(CmsGallerySearchFieldConfiguration.getLocaleExtendedName(fieldName, locale), value);
            document.add((Fieldable)field);
        }
        return document;
    }
}

