/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsUUID;

public class CmsAccessControlEntry {
    public static final int ACCESS_FLAGS_ALLOTHERS = 128;
    public static final int ACCESS_FLAGS_GROUP = 32;
    public static final int ACCESS_FLAGS_ROLE = 512;
    public static final int ACCESS_FLAGS_INHERIT = 2;
    public static final int ACCESS_FLAGS_INHERITED = 8;
    public static final int ACCESS_FLAGS_OVERWRITE = 4;
    public static final int ACCESS_FLAGS_OVERWRITE_ALL = 256;
    public static final int ACCESS_FLAGS_RESPONSIBLE = 64;
    public static final int ACCESS_FLAGS_USER = 16;
    public static final Comparator<CmsAccessControlEntry> COMPARATOR_ACE = new Comparator<CmsAccessControlEntry>(){

        @Override
        public int compare(CmsAccessControlEntry ace1, CmsAccessControlEntry ace2) {
            if (ace1 == ace2) {
                return 0;
            }
            CmsUUID id1 = ace1.getPrincipal();
            CmsUUID id2 = ace2.getPrincipal();
            return COMPARATOR_PRINCIPALS.compare(id1, id2);
        }
    };
    public static final Comparator<CmsUUID> COMPARATOR_PRINCIPALS = new Comparator<CmsUUID>(){

        @Override
        public int compare(CmsUUID id1, CmsUUID id2) {
            if (id1 == id2) {
                return 0;
            }
            if (id1.equals(id2)) {
                return 0;
            }
            if (id1.equals(PRINCIPAL_OVERWRITE_ALL_ID)) {
                return -1;
            }
            if (id1.equals(PRINCIPAL_ALL_OTHERS_ID)) {
                if (id2.equals(PRINCIPAL_OVERWRITE_ALL_ID)) {
                    return 1;
                }
                return -1;
            }
            if (id2.equals(PRINCIPAL_ALL_OTHERS_ID)) {
                if (id1.equals(PRINCIPAL_OVERWRITE_ALL_ID)) {
                    return -1;
                }
                return 1;
            }
            if (id2.equals(PRINCIPAL_OVERWRITE_ALL_ID)) {
                return 1;
            }
            return id1.compareTo(id2);
        }
    };
    public static final String PRINCIPAL_ALL_OTHERS_NAME = "ALL_OTHERS";
    public static final CmsUUID PRINCIPAL_ALL_OTHERS_ID = CmsUUID.getConstantUUID("ALL_OTHERS".toLowerCase());
    public static final String PRINCIPAL_OVERWRITE_ALL_NAME = "OVERWRITE_ALL";
    public static final CmsUUID PRINCIPAL_OVERWRITE_ALL_ID = CmsUUID.getConstantUUID("OVERWRITE_ALL".toLowerCase());
    private int m_flags;
    private CmsPermissionSetCustom m_permissions;
    private CmsUUID m_principal;
    private CmsUUID m_resource;

    public CmsAccessControlEntry(CmsUUID resource, CmsAccessControlEntry base) {
        this.m_resource = resource;
        this.m_principal = base.m_principal;
        this.m_permissions = base.m_permissions;
        this.m_flags = base.m_flags;
    }

    public CmsAccessControlEntry(CmsUUID resource, CmsUUID principal, CmsPermissionSet permissions, int flags) {
        this.m_resource = resource;
        this.m_principal = principal;
        this.m_permissions = new CmsPermissionSetCustom(permissions);
        this.m_flags = flags;
    }

    public CmsAccessControlEntry(CmsUUID resource, CmsUUID principal, int allowed, int denied, int flags) {
        this.m_resource = resource;
        this.m_principal = principal;
        this.m_permissions = new CmsPermissionSetCustom(allowed, denied);
        this.m_flags = flags;
    }

    public CmsAccessControlEntry(CmsUUID resource, CmsUUID principal, String acPermissionString) {
        this.m_resource = resource;
        this.m_principal = principal;
        this.m_flags = 0;
        StringTokenizer tok = new StringTokenizer(acPermissionString, "+-", true);
        StringBuffer permissionString = new StringBuffer();
        block5: while (tok.hasMoreElements()) {
            String prefix = tok.nextToken();
            String suffix = tok.nextToken();
            switch (suffix.charAt(0)) {
                case 'I': 
                case 'i': {
                    if (prefix.charAt(0) == '+') {
                        this.m_flags |= 2;
                    }
                    if (prefix.charAt(0) != '-') continue block5;
                    this.m_flags &= 0xFFFFFFFD;
                    continue block5;
                }
                case 'O': 
                case 'o': {
                    if (prefix.charAt(0) == '+') {
                        this.m_flags |= 4;
                    }
                    if (prefix.charAt(0) != '-') continue block5;
                    this.m_flags &= 0xFFFFFFFB;
                    continue block5;
                }
                case 'L': 
                case 'l': {
                    if (prefix.charAt(0) == '+') {
                        this.m_flags |= 0x40;
                    }
                    if (prefix.charAt(0) != '-') continue block5;
                    this.m_flags &= 0xFFFFFFBF;
                    continue block5;
                }
            }
            permissionString.append(prefix);
            permissionString.append(suffix);
        }
        this.m_permissions = new CmsPermissionSetCustom(permissionString.toString());
    }

    public void denyPermissions(int denied) {
        this.m_permissions.denyPermissions(denied);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsAccessControlEntry) {
            CmsAccessControlEntry other = (CmsAccessControlEntry)obj;
            if (other.m_flags != this.m_flags) {
                return false;
            }
            if (other.getPermissions().getAllowedPermissions() != this.getPermissions().getAllowedPermissions()) {
                return false;
            }
            if (other.getPermissions().getDeniedPermissions() != this.getPermissions().getDeniedPermissions()) {
                return false;
            }
            if (!other.m_resource.equals(this.m_resource)) {
                return false;
            }
            return other.m_principal.equals(this.m_principal);
        }
        return false;
    }

    public int getAllowedPermissions() {
        return this.m_permissions.getAllowedPermissions();
    }

    public int getDeniedPermissions() {
        return this.m_permissions.getDeniedPermissions();
    }

    public int getFlags() {
        return this.m_flags;
    }

    public String getInheritingString() {
        if (this.isInheriting()) {
            return "+i";
        }
        return "-i";
    }

    public CmsPermissionSet getPermissions() {
        return this.m_permissions;
    }

    public CmsUUID getPrincipal() {
        return this.m_principal;
    }

    public CmsUUID getResource() {
        return this.m_resource;
    }

    public String getResponsibleString() {
        if (this.isResponsible()) {
            return "+l";
        }
        return "-l";
    }

    public void grantPermissions(int allowed) {
        this.m_permissions.grantPermissions(allowed);
    }

    public int hashCode() {
        if (this.m_permissions != null) {
            return this.m_permissions.hashCode() * this.m_flags;
        }
        return CmsUUID.getNullUUID().hashCode();
    }

    public boolean isAllOthers() {
        return (this.m_flags & 0x80) == 128;
    }

    public boolean isInherited() {
        return (this.m_flags & 8) > 0;
    }

    public boolean isInheriting() {
        return (this.m_flags & 2) > 0;
    }

    public boolean isOverwriteAll() {
        return (this.m_flags & 0x100) == 256;
    }

    public boolean isResponsible() {
        return (this.m_flags & 0x40) > 0;
    }

    public void resetFlags(int flags) {
        this.m_flags &= ~flags;
    }

    public void setFlags(int flags) {
        this.m_flags |= flags;
    }

    public void setFlagsForPrincipal(I_CmsPrincipal principal) {
        this.setFlags(principal.isGroup() ? 32 : 16);
    }

    public void setPermissions(CmsPermissionSet permissions) {
        this.m_permissions.setPermissions(permissions);
    }

    public String toString() {
        return "[Ace:] ResourceId=" + this.m_resource + ", PrincipalId=" + this.m_principal + ", Permissions=" + this.m_permissions.toString() + ", Flags=" + this.m_flags;
    }
}

