/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsAdvancedLinkSubstitutionHandler
extends CmsDefaultLinkSubstitutionHandler {
    private static final String LINK_EXCLUDE_DEFINIFITON_FILE = "/system/shared/linkexcludes";
    private static final Log LOG = CmsLog.getLog(CmsAdvancedLinkSubstitutionHandler.class);
    private static final String XPATH_LINK = "link";

    @Override
    public String getRootPath(CmsObject cms, String targetUri, String basePath) {
        String query;
        String fragment;
        String path;
        URI uri;
        if (cms == null) {
            return targetUri;
        }
        try {
            uri = new URI(targetUri);
            path = uri.getPath();
            fragment = uri.getFragment();
            fragment = fragment != null ? "#" + fragment : "";
            query = uri.getQuery();
            query = query != null ? "?" + query : "";
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_MALFORMED_URI_1", targetUri), (Throwable)e);
            }
            return null;
        }
        String suffix = fragment.concat(query);
        if (uri.isOpaque()) {
            return null;
        }
        CmsVfsMemoryObjectCache cache = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache();
        List<String> excludes = (List<String>)cache.getCachedObject(cms, LINK_EXCLUDE_DEFINIFITON_FILE);
        if (excludes == null) {
            excludes = this.readLinkExcludes(cms);
            cache.putCachedObject(cms, LINK_EXCLUDE_DEFINIFITON_FILE, excludes);
        }
        for (int i = 0; i < excludes.size(); ++i) {
            if (!path.startsWith(excludes.get(i))) continue;
            return null;
        }
        if (uri.isAbsolute()) {
            CmsSiteMatcher matcher = new CmsSiteMatcher(targetUri);
            if (OpenCms.getSiteManager().isMatching(matcher)) {
                if (path.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                    path = path.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                }
                if (OpenCms.getSiteManager().isWorkplaceRequest(matcher)) {
                    return cms.getRequestContext().addSiteRoot(path + suffix);
                }
                return cms.getRequestContext().addSiteRoot(OpenCms.getSiteManager().matchSite(matcher).getSiteRoot(), path + suffix);
            }
            return null;
        }
        String context = OpenCms.getSystemInfo().getOpenCmsContext();
        if (context != null && path.startsWith(context)) {
            String siteRoot = null;
            if (basePath != null) {
                siteRoot = OpenCms.getSiteManager().getSiteRoot(basePath);
            }
            path = path.substring(context.length());
            if (siteRoot != null) {
                if (!path.startsWith(siteRoot)) {
                    return cms.getRequestContext().addSiteRoot(siteRoot, path + suffix);
                }
                return path + suffix;
            }
            return cms.getRequestContext().addSiteRoot(path + suffix);
        }
        if (CmsStringUtil.isNotEmpty(path) && path.charAt(0) != '/') {
            if (basePath != null) {
                int pos = path.indexOf("../../galleries/pics/");
                if (pos >= 0) {
                    return "/system/" + path.substring(pos + 6) + suffix;
                }
                String absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().addSiteRoot(basePath));
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/" + "xmlcontent/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
            }
            return null;
        }
        if (CmsStringUtil.isNotEmpty(path)) {
            return cms.getRequestContext().addSiteRoot(path) + suffix;
        }
        return suffix;
    }

    private List<String> readLinkExcludes(CmsObject cms) {
        ArrayList<String> linkExcludes = new ArrayList<String>();
        try {
            CmsResource res = cms.readResource(LINK_EXCLUDE_DEFINIFITON_FILE);
            CmsFile file = cms.readFile(res);
            CmsXmlContent linkExcludeDefinitions = CmsXmlContentFactory.unmarshal(cms, file);
            int count = linkExcludeDefinitions.getIndexCount(XPATH_LINK, Locale.ENGLISH);
            for (int i = 1; i <= count; ++i) {
                String exclude = linkExcludeDefinitions.getStringValue(cms, "link[" + i + "]", Locale.ENGLISH);
                linkExcludes.add(exclude);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e);
        }
        return linkExcludes;
    }
}

