/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.detailpage.I_CmsDetailPageFinder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.I_CmsLinkSubstitutionHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultLinkSubstitutionHandler
implements I_CmsLinkSubstitutionHandler {
    public static final String DONT_USE_CURRENT_SITE_FOR_WORKPLACE_REQUESTS = "DONT_USE_CURRENT_SITE_FOR_WORKPLACE_REQUESTS";
    private static final Log LOG = CmsLog.getLog(CmsDefaultLinkSubstitutionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLink(CmsObject cms, String link, String siteRoot, boolean forceSecure) {
        String parameters;
        String vfsName;
        if (CmsStringUtil.isEmpty(link)) {
            return "";
        }
        String absoluteLink = CmsLinkManager.getAbsoluteUri(link, cms.getRequestContext().getUri());
        int pos = absoluteLink.indexOf(63);
        if (pos >= 0) {
            vfsName = absoluteLink.substring(0, pos);
            parameters = absoluteLink.substring(pos);
        } else {
            vfsName = absoluteLink;
            parameters = null;
        }
        String anchor = null;
        pos = vfsName.indexOf(35);
        if (pos >= 0) {
            anchor = vfsName.substring(pos);
            vfsName = vfsName.substring(0, pos);
        }
        String resultLink = null;
        String uriBaseName = null;
        boolean useRelativeLinks = false;
        CmsSite currentSite = OpenCms.getSiteManager().getCurrentSite(cms);
        CmsSite targetSite = null;
        if (CmsStringUtil.isNotEmpty(siteRoot)) {
            targetSite = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        }
        if (targetSite == null) {
            targetSite = currentSite;
        }
        String targetSiteRoot = targetSite.getSiteRoot();
        String originalVfsName = vfsName;
        String detailPage = null;
        try {
            String rootVfsName = !vfsName.startsWith(targetSiteRoot) && !vfsName.startsWith("/system/") && !OpenCms.getSiteManager().startsWithShared(vfsName) ? CmsStringUtil.joinPaths(targetSiteRoot, vfsName) : vfsName;
            I_CmsDetailPageFinder finder = OpenCms.getADEManager().getDetailPageFinder();
            detailPage = finder.getDetailPage(cms, rootVfsName, cms.getRequestContext().getUri());
            if (detailPage != null) {
                if (detailPage.startsWith(targetSiteRoot) && !(detailPage = detailPage.substring(targetSiteRoot.length())).startsWith("/")) {
                    detailPage = "/" + detailPage;
                }
                try {
                    CmsResource element = cms.readResource(vfsName);
                    Locale locale = cms.getRequestContext().getLocale();
                    List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales();
                    vfsName = CmsStringUtil.joinPaths(detailPage, cms.getDetailName(element, locale, defaultLocales), "/");
                }
                catch (CmsVfsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        catch (CmsVfsResourceNotFoundException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String serverPrefix = targetSite != currentSite ? targetSite.getUrl() : "";
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            CmsStaticExportManager exportManager = OpenCms.getStaticExportManager();
            String oriUri = cms.getRequestContext().getUri();
            if (exportManager.relativeLinksInExport(cms.getRequestContext().getSiteRoot() + oriUri)) {
                String cacheKey = exportManager.getCacheKey(targetSiteRoot, oriUri);
                uriBaseName = exportManager.getCachedOnlineLink(cacheKey);
                if (uriBaseName == null) {
                    uriBaseName = exportManager.isExportLink(cms, oriUri) ? exportManager.getRfsName(cms, oriUri) : exportManager.getVfsPrefix() + oriUri;
                    exportManager.cacheOnlineLink(cacheKey, uriBaseName);
                }
                useRelativeLinks = uriBaseName.startsWith(OpenCms.getStaticExportManager().getRfsPrefix(cms.getRequestContext().getSiteRoot() + oriUri));
            }
            String detailPagePart = detailPage == null ? "" : detailPage + ":";
            String cacheKey = cms.getRequestContext().getSiteRoot() + ":" + targetSiteRoot + ":" + detailPagePart + absoluteLink;
            resultLink = exportManager.getCachedOnlineLink(cacheKey);
            if (resultLink == null) {
                String storedSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    cms.getRequestContext().setSiteRoot(targetSite.getSiteRoot());
                    if (exportManager.isExportLink(cms, vfsName)) {
                        resultLink = exportManager.getRfsName(cms, vfsName, parameters);
                        parameters = null;
                    } else {
                        resultLink = exportManager.getVfsPrefix().concat(vfsName);
                        if (parameters != null) {
                            resultLink = resultLink.concat(parameters);
                        }
                    }
                    Object var25_28 = null;
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                }
                catch (Throwable throwable) {
                    Object var25_29 = null;
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                    throw throwable;
                }
                exportManager.cacheOnlineLink(cacheKey, resultLink);
            }
            if ((targetSite.hasSecureServer() || currentSite.hasSecureServer()) && !vfsName.startsWith("/system/")) {
                int imageId;
                int linkType;
                block37: {
                    linkType = -1;
                    try {
                        linkType = cms.readResource(originalVfsName).getTypeId();
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block37;
                        String message = Messages.get().getBundle().key("LOG_RESOURCE_ACESS_ERROR_3", vfsName, cms.getRequestContext().getCurrentUser().getName(), cms.getRequestContext().getSiteRoot());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)message, (Throwable)e);
                        }
                        LOG.info((Object)message);
                    }
                }
                try {
                    imageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()).getTypeId();
                }
                catch (CmsLoaderException e1) {
                    LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
                    imageId = CmsResourceTypeImage.getStaticTypeId();
                }
                if (linkType != imageId) {
                    boolean secureLink = exportManager.isSecureLink(cms, vfsName, targetSite.getSiteRoot());
                    boolean secureRequest = exportManager.isSecureLink(cms, oriUri);
                    if (secureLink && (forceSecure || !secureRequest)) {
                        serverPrefix = targetSite.getSecureUrl();
                    } else if (!secureLink && secureRequest) {
                        serverPrefix = targetSite.getUrl();
                    }
                }
            }
            if (useRelativeLinks && CmsStringUtil.isEmpty(serverPrefix)) {
                resultLink = CmsLinkManager.getRelativeUri(uriBaseName, resultLink);
            }
        } else {
            if (OpenCms.getRunLevel() >= 3) {
                resultLink = OpenCms.getStaticExportManager().getVfsPrefix().concat(vfsName);
            }
            if (parameters != null && resultLink != null) {
                resultLink = resultLink.concat(parameters);
            }
        }
        if (anchor != null && resultLink != null) {
            resultLink = resultLink.concat(anchor);
        }
        return serverPrefix.concat(resultLink);
    }

    public String getRootPath(CmsObject cms, String targetUri, String basePath) {
        String query;
        String fragment;
        String path;
        URI uri;
        if (cms == null) {
            return targetUri;
        }
        try {
            uri = new URI(targetUri);
            path = uri.getPath();
            fragment = uri.getFragment();
            fragment = fragment != null ? "#" + fragment : "";
            query = uri.getQuery();
            query = query != null ? "?" + query : "";
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_MALFORMED_URI_1", targetUri), (Throwable)e);
            }
            return null;
        }
        String suffix = fragment.concat(query);
        if (uri.isOpaque()) {
            return null;
        }
        if (uri.isAbsolute()) {
            CmsSiteMatcher matcher = new CmsSiteMatcher(targetUri);
            if (OpenCms.getSiteManager().isMatching(matcher)) {
                if (path.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                    path = path.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                }
                String ignoreWorkplaceStr = (String)cms.getRequestContext().getAttribute(DONT_USE_CURRENT_SITE_FOR_WORKPLACE_REQUESTS);
                boolean ignoreWorkplace = Boolean.parseBoolean(ignoreWorkplaceStr);
                cms.getRequestContext().setAttribute(DONT_USE_CURRENT_SITE_FOR_WORKPLACE_REQUESTS, "false");
                if (OpenCms.getSiteManager().isWorkplaceRequest(matcher) && !ignoreWorkplace) {
                    return cms.getRequestContext().addSiteRoot(path + suffix);
                }
                return cms.getRequestContext().addSiteRoot(OpenCms.getSiteManager().matchSite(matcher).getSiteRoot(), path + suffix);
            }
            return null;
        }
        String context = OpenCms.getSystemInfo().getOpenCmsContext();
        if (context != null && path.startsWith(context)) {
            String siteRoot = null;
            if (basePath != null) {
                siteRoot = OpenCms.getSiteManager().getSiteRoot(basePath);
            }
            path = path.substring(context.length());
            if (siteRoot != null) {
                if (!path.startsWith(siteRoot)) {
                    return cms.getRequestContext().addSiteRoot(siteRoot, path + suffix);
                }
                return path + suffix;
            }
            return cms.getRequestContext().addSiteRoot(path + suffix);
        }
        if (CmsStringUtil.isNotEmpty(path) && path.charAt(0) != '/') {
            if (basePath != null) {
                int pos = path.indexOf("../../galleries/pics/");
                if (pos >= 0) {
                    return "/system/" + path.substring(pos + 6) + suffix;
                }
                String absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().addSiteRoot(basePath));
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/" + "xmlcontent/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
            }
            return null;
        }
        if (CmsStringUtil.isNotEmpty(path)) {
            return cms.getRequestContext().addSiteRoot(path) + suffix;
        }
        return suffix;
    }
}

