/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.detailpage.CmsDetailPageUtil;
import org.opencms.ade.detailpage.I_CmsDetailPageFinder;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.i18n.CmsAcceptLanguageHeaderParser;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsSecurityException;
import org.opencms.site.CmsSite;
import org.opencms.staticexport.CmsAfterPublishStaticExportHandler;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.staticexport.CmsExportFolderMatcher;
import org.opencms.staticexport.CmsOnDemandStaticExportHandler;
import org.opencms.staticexport.CmsPrefixFileFilter;
import org.opencms.staticexport.CmsStaticExportData;
import org.opencms.staticexport.CmsStaticExportException;
import org.opencms.staticexport.CmsStaticExportExportRule;
import org.opencms.staticexport.CmsStaticExportResponseWrapper;
import org.opencms.staticexport.CmsStaticExportRfsRule;
import org.opencms.staticexport.I_CmsLinkSubstitutionHandler;
import org.opencms.staticexport.I_CmsStaticExportHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsStaticExportManager
implements I_CmsEventListener {
    public static final String DEFAULT_FILE = "index.html";
    public static final String EXPORT_ATTRIBUTE_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String EXPORT_ATTRIBUTE_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String EXPORT_ATTRIBUTE_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String EXPORT_ATTRIBUTE_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String EXPORT_BACKUP_FOLDER_NAME = "backup";
    public static final Integer EXPORT_DEFAULT_BACKUPS = new Integer(0);
    public static final String EXPORT_DEFAULT_FILE = "index_export.html";
    public static final String EXPORT_DEFAULT_WORKPATH = CmsSystemInfo.FOLDER_WEBINF + "temp";
    public static final int EXPORT_LINK_WITH_PARAMETER = 2;
    public static final int EXPORT_LINK_WITHOUT_PARAMETER = 1;
    public static final String EXPORT_MARKER = "exporturi";
    public static final int HANDLER_FINISH_TIME = 60;
    private static final String CACHEVALUE_404 = "?404";
    private static final Log LOG = CmsLog.getLog(CmsStaticExportManager.class);
    private String m_acceptCharsetHeader;
    private String m_acceptLanguageHeader;
    private Map<String, Boolean> m_cacheExportLinks;
    private Map<String, CmsStaticExportData> m_cacheExportUris;
    private Map<String, String> m_cacheOnlineLinks;
    private Map<String, Boolean> m_cacheSecureLinks;
    private String m_defaultAcceptCharsetHeader;
    private String m_defaultAcceptLanguageHeader;
    private CmsExportFolderMatcher m_exportFolderMatcher;
    private List<String> m_exportFolders;
    private List<String> m_exportHeaders;
    private Map<String, String> m_exportnameResources;
    private boolean m_exportPropertyDefault;
    private boolean m_exportRelativeLinks;
    private List<CmsStaticExportExportRule> m_exportRules;
    private List<String> m_exportSuffixes;
    private CmsStaticExportExportRule m_exportTmpRule;
    private String m_exportUrl;
    private String m_exportUrlConfigured;
    private String m_exportUrlPrefix;
    private boolean m_fullStaticExport = false;
    private I_CmsStaticExportHandler m_handler;
    private I_CmsLinkSubstitutionHandler m_linkSubstitutionHandler;
    private Object m_lockCmsEvent = new Object();
    private Object m_lockScrubExportFolders = new Object();
    private Object m_lockSetExportnames = new Object();
    private boolean m_quickPlainExport;
    private String m_remoteAddr;
    private String m_rfsPrefix;
    private String m_rfsPrefixConfigured;
    private List<CmsStaticExportRfsRule> m_rfsRules;
    private CmsStaticExportRfsRule m_rfsTmpRule;
    private Integer m_staticExportBackups;
    private boolean m_staticExportEnabled;
    private String m_staticExportPath;
    private String m_staticExportPathConfigured;
    private String m_staticExportWorkPath;
    private String m_staticExportWorkPathConfigured;
    private String m_testResource;
    private boolean m_useTempDirs = true;
    private String m_vfsPrefix;
    private String m_vfsPrefixConfigured;

    public CmsStaticExportManager() {
        this.m_exportSuffixes = new ArrayList<String>();
        this.m_exportFolders = new ArrayList<String>();
        this.m_exportHeaders = new ArrayList<String>();
        this.m_rfsRules = new ArrayList<CmsStaticExportRfsRule>();
        this.m_exportRules = new ArrayList<CmsStaticExportExportRule>();
        this.m_exportTmpRule = new CmsStaticExportExportRule("", "");
        this.m_rfsTmpRule = new CmsStaticExportRfsRule("", "", "", "", "", "", null, null);
    }

    public String addDefaultFileNameToFolder(String rfsName, boolean isFolder) {
        StringBuffer name = new StringBuffer(rfsName);
        if (isFolder) {
            name.append(EXPORT_DEFAULT_FILE);
        } else if (CmsResource.isFolder(rfsName)) {
            LOG.info((Object)"addDefaultFileNameToFolder: sitemap case");
            name.append(DEFAULT_FILE);
        }
        return name.toString();
    }

    public void addExportRule(String name, String description) {
        this.m_exportRules.add(new CmsStaticExportExportRule(name, description, this.m_exportTmpRule.getModifiedResources(), this.m_exportTmpRule.getExportResourcePatterns()));
        this.m_exportTmpRule = new CmsStaticExportExportRule("", "");
    }

    public void addExportRuleRegex(String regex) {
        this.m_exportTmpRule.addModifiedResource(regex);
    }

    public void addExportRuleUri(String exportUri) {
        this.m_exportTmpRule.addExportResourcePattern(exportUri);
    }

    public void addRfsRule(String name, String description, String source, String rfsPrefix, String exportPath, String exportWorkPath, String exportBackups, String useRelativeLinks) {
        if (this.m_staticExportPathConfigured != null && exportPath.equals(this.m_staticExportPathConfigured)) {
            this.m_useTempDirs = false;
        }
        Iterator<CmsStaticExportRfsRule> itRules = this.m_rfsRules.iterator();
        while (this.m_useTempDirs && itRules.hasNext()) {
            CmsStaticExportRfsRule rule = itRules.next();
            if (!exportPath.equals(rule.getExportPathConfigured())) continue;
            this.m_useTempDirs = false;
        }
        Boolean relativeLinks = useRelativeLinks == null ? null : Boolean.valueOf(useRelativeLinks);
        Integer backups = exportBackups == null ? null : Integer.valueOf(exportBackups);
        this.m_rfsRules.add(new CmsStaticExportRfsRule(name, description, source, rfsPrefix, exportPath, exportWorkPath, backups, relativeLinks, this.m_rfsTmpRule.getRelatedSystemResources()));
        this.m_rfsTmpRule = new CmsStaticExportRfsRule("", "", "", "", "", "", null, null);
    }

    public void addRfsRuleSystemRes(String regex) {
        this.m_rfsTmpRule.addRelatedSystemRes(regex);
    }

    public void cacheOnlineLink(String linkName, String vfsName) {
        this.m_cacheOnlineLinks.put(linkName, vfsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmsEvent(CmsEvent event) {
        if (!this.isStaticExportEnabled()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_STATIC_EXPORT_DISABLED_0"));
            }
            return;
        }
        I_CmsReport report = null;
        Map<String, Object> data = event.getData();
        if (data != null) {
            report = (I_CmsReport)data.get("report");
        }
        if (report == null) {
            report = new CmsLogReport(CmsLocaleManager.getDefaultLocale(), this.getClass());
        }
        switch (event.getType()) {
            case 19: {
                this.scrubExportFolders(report);
                this.clearCaches(event);
                break;
            }
            case 2: {
                if (data == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_EMPTY_EVENT_DATA_0"));
                    }
                    return;
                }
                CmsUUID publishHistoryId = new CmsUUID((String)data.get("publishHistoryId"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_1", publishHistoryId));
                }
                Object object = this.m_lockCmsEvent;
                synchronized (object) {
                    this.getHandler().performEventPublishProject(publishHistoryId, report);
                }
                this.clearCaches(event);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_FINISHED_1", publishHistoryId));
                break;
            }
            case 5: {
                this.clearCaches(event);
                break;
            }
        }
    }

    public int export(HttpServletRequest req, HttpServletResponse res, CmsObject cms, CmsStaticExportData data) throws CmsException, IOException, ServletException, CmsStaticExportException {
        CmsContextInfo contextInfo;
        CmsObject exportCms;
        CmsResource resource = data.getResource();
        String vfsName = data.getVfsName();
        String rfsName = data.getParameters() != null ? data.getRfsName() : this.addDefaultFileNameToFolder(data.getRfsName(), resource.isFolder());
        String siteRoot = OpenCms.getSiteManager().getSiteRoot(vfsName);
        CmsI18nInfo i18nInfo = OpenCms.getLocaleManager().getI18nInfo(req, cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject(), vfsName);
        String remoteAddr = this.m_remoteAddr;
        if (remoteAddr == null) {
            remoteAddr = "127.0.0.1";
        }
        if (siteRoot != null) {
            vfsName = vfsName.substring(siteRoot.length());
        } else {
            siteRoot = "/";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_STATIC_EXPORT_SITE_ROOT_2", siteRoot, vfsName));
        }
        if (!this.isExportLink(exportCms = OpenCms.initCmsObject(null, contextInfo = new CmsContextInfo(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject(), vfsName, siteRoot, i18nInfo.getLocale(), i18nInfo.getEncoding(), remoteAddr, -1L, cms.getRequestContext().getOuFqn())), exportCms.getRequestContext().removeSiteRoot(data.getVfsName()))) {
            return 303;
        }
        boolean exportOnDemand = req != null && res != null;
        CmsStaticExportResponseWrapper wrapRes = null;
        if (res != null) {
            wrapRes = new CmsStaticExportResponseWrapper(res);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SE_RESOURCE_START_1", data));
        }
        CmsFile file = exportCms.readFile(OpenCms.initResource(exportCms, vfsName, req, (HttpServletResponse)wrapRes));
        vfsName = exportCms.getSitePath(file);
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(file);
        if (loader == null || !loader.isStaticExportEnabled()) {
            Object[] arguments = new Object[]{vfsName, new Integer(file.getTypeId())};
            throw new CmsStaticExportException(Messages.get().container("ERR_EXPORT_NOT_SUPPORTED_2", arguments));
        }
        if (exportOnDemand) {
            String mimetype = OpenCms.getResourceManager().getMimeType(file.getName(), exportCms.getRequestContext().getEncoding());
            if (wrapRes != null) {
                wrapRes.setContentType(mimetype);
            }
            exportCms.getRequestContext().setUri(vfsName);
        }
        int status = -1;
        List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(exportCms, vfsName);
        boolean exported = false;
        boolean matched = false;
        for (CmsStaticExportRfsRule rule : this.getRfsRules()) {
            byte[] content;
            boolean export = rule.getSource().matcher(siteRoot + vfsName).matches();
            matched |= export;
            if (!(export |= vfsName.startsWith("/system/") && rule.match(vfsName))) continue;
            CmsObject locCms = exportCms;
            Locale locale = CmsLocaleManager.getLocale(rule.getName());
            if (locales.contains(locale)) {
                CmsContextInfo ctxInfo = new CmsContextInfo(exportCms.getRequestContext());
                ctxInfo.setLocale(locale);
                locCms = OpenCms.initCmsObject(exportCms, ctxInfo);
            }
            if ((content = loader.export(locCms, file, req, (HttpServletResponse)wrapRes)) == null) continue;
            exported = true;
            String locRfsName = rfsName;
            if (locales.contains(locale)) {
                locRfsName = rule.getLocalizedRfsName(rfsName, "/");
            }
            this.writeResource(req, rule.getExportPath(), locRfsName, resource, content);
        }
        if (!matched) {
            String exportPath = this.getExportPath(siteRoot + vfsName);
            byte[] content = loader.export(exportCms, file, req, (HttpServletResponse)wrapRes);
            if (content != null) {
                exported = true;
                this.writeResource(req, exportPath, rfsName, resource, content);
            }
        }
        if (exported) {
            int n = status = wrapRes != null ? wrapRes.getStatus() : -1;
            if (status < 0) {
                status = 200;
            }
        } else {
            status = 304;
        }
        return status;
    }

    public synchronized void exportFullStaticRender(boolean purgeFirst, I_CmsReport report) throws CmsException, IOException, ServletException {
        this.m_fullStaticExport = true;
        String staticExportPathStore = this.m_staticExportPath;
        if (this.m_useTempDirs) {
            this.m_staticExportPath = this.m_staticExportWorkPath;
        }
        if (purgeFirst) {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("report", report);
            CmsEvent clearCacheEvent = new CmsEvent(5, eventData);
            OpenCms.fireCmsEvent(clearCacheEvent);
            this.scrubExportFolders(report);
            CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
            cms.deleteAllStaticExportPublishedResources(1);
            cms.deleteAllStaticExportPublishedResources(2);
        }
        CmsAfterPublishStaticExportHandler handler = new CmsAfterPublishStaticExportHandler();
        handler.doExportAfterPublish(null, report);
        this.m_staticExportPath = staticExportPathStore;
        this.m_fullStaticExport = false;
        if (this.m_useTempDirs && !report.hasError()) {
            File staticExport = new File(this.m_staticExportPath);
            this.createExportBackupFolders(staticExport, this.m_staticExportPath, this.getExportBackups(), null);
            File staticExportWork = new File(this.m_staticExportWorkPath);
            staticExportWork.renameTo(new File(this.m_staticExportPath));
            for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
                File staticExportRule = new File(rule.getExportPath());
                File staticExportWorkRule = new File(rule.getExportWorkPath());
                if (!staticExportWorkRule.exists()) continue;
                this.createExportBackupFolders(staticExportRule, rule.getExportPath(), rule.getExportBackups(), OpenCms.getResourceManager().getFileTranslator().translateResource(rule.getName()));
                staticExportWorkRule.renameTo(new File(rule.getExportPath()));
            }
        } else if (report.hasError()) {
            report.println(Messages.get().container("ERR_EXPORT_NOT_SUCCESSFUL_0"), 1);
        }
    }

    public String getAcceptCharsetHeader() {
        return this.m_acceptCharsetHeader;
    }

    public String getAcceptLanguageHeader() {
        return this.m_acceptLanguageHeader;
    }

    public String getCachedOnlineLink(String vfsName) {
        return this.m_cacheOnlineLinks.get(vfsName);
    }

    public String getCacheKey(String siteRoot, String uri) {
        return new StringBuffer(siteRoot).append(uri).toString();
    }

    public String getDefault() {
        return String.valueOf(this.m_exportPropertyDefault);
    }

    public String getDefaultAcceptCharsetHeader() {
        return this.m_defaultAcceptCharsetHeader;
    }

    public String getDefaultAcceptLanguageHeader() {
        return this.m_defaultAcceptLanguageHeader;
    }

    public String getDefaultRfsPrefix() {
        return this.m_rfsPrefix;
    }

    public Integer getExportBackups() {
        if (this.m_staticExportBackups != null) {
            return this.m_staticExportBackups;
        }
        return EXPORT_DEFAULT_BACKUPS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsStaticExportData getExportData(HttpServletRequest request, CmsObject cms) {
        if (!this.isStaticExportEnabled()) {
            return null;
        }
        String rfsName = request.getParameter(EXPORT_MARKER);
        if (rfsName == null) {
            rfsName = (String)request.getAttribute(EXPORT_ATTRIBUTE_ERROR_REQUEST_URI);
        }
        if (request.getHeader("OpenCms-Export") != null) {
            int prefix;
            int n = prefix = rfsName.startsWith(this.getExportUrlPrefix()) ? this.getExportUrlPrefix().length() : 0;
            if (prefix > 0) {
                rfsName = rfsName.substring(prefix);
            } else {
                return null;
            }
        }
        if (!this.isValidRfsName(rfsName)) {
            return null;
        }
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            CmsSite site = OpenCms.getSiteManager().matchRequest(request);
            cms.getRequestContext().setSiteRoot(site.getSiteRoot());
            CmsStaticExportData data = this.getRfsExportData(cms, rfsName);
            if (data != null && this.isExportLink(cms, cms.getRequestContext().removeSiteRoot(data.getVfsName()))) {
                CmsStaticExportData cmsStaticExportData = data;
                return cmsStaticExportData;
            }
            CmsStaticExportData cmsStaticExportData = null;
            return cmsStaticExportData;
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    public String getExportEnabled() {
        return String.valueOf(this.m_staticExportEnabled);
    }

    public CmsExportFolderMatcher getExportFolderMatcher() {
        return this.m_exportFolderMatcher;
    }

    public List<String> getExportFolderPatterns() {
        return Collections.unmodifiableList(this.m_exportFolders);
    }

    public List<String> getExportHeaders() {
        return Collections.unmodifiableList(this.m_exportHeaders);
    }

    public Map<String, String> getExportnames() {
        HashMap<String, String> exportnames = new HashMap<String, String>();
        if (this.m_exportnameResources == null) {
            this.m_exportnameResources = Collections.unmodifiableMap(this.computeVfsExportnames());
            exportnames.putAll(this.m_exportnameResources);
        } else {
            exportnames.putAll(this.m_exportnameResources);
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(new CmsStringUtil.CmsSlashComparator());
        sortedMap.putAll(exportnames);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_EXPORTNAME_PROP_FINISHED_0"));
        }
        return Collections.unmodifiableMap(sortedMap);
    }

    public String getExportPath(String vfsName) {
        if (vfsName != null) {
            for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
                if (!rule.getSource().matcher(vfsName).matches()) continue;
                return rule.getExportPath();
            }
        }
        if (this.m_useTempDirs && this.isFullStaticExport()) {
            return this.getExportWorkPath();
        }
        return this.m_staticExportPath;
    }

    public String getExportPathForConfiguration() {
        return this.m_staticExportPathConfigured;
    }

    public boolean getExportPropertyDefault() {
        return this.m_exportPropertyDefault;
    }

    public List<CmsStaticExportExportRule> getExportRules() {
        return Collections.unmodifiableList(this.m_exportRules);
    }

    public List<String> getExportSuffixes() {
        return this.m_exportSuffixes;
    }

    public String getExportUrl() {
        return this.m_exportUrl;
    }

    public String getExportUrlForConfiguration() {
        return this.m_exportUrlConfigured;
    }

    public String getExportUrlPrefix() {
        return this.m_exportUrlPrefix;
    }

    public String getExportWorkPath() {
        return this.m_staticExportWorkPath;
    }

    public String getExportWorkPathForConfiguration() {
        if (this.m_staticExportWorkPathConfigured != null) {
            return this.m_staticExportWorkPathConfigured;
        }
        return EXPORT_DEFAULT_WORKPATH;
    }

    public I_CmsStaticExportHandler getHandler() {
        if (this.m_handler == null) {
            this.setHandler(CmsOnDemandStaticExportHandler.class.getName());
        }
        return this.m_handler;
    }

    public I_CmsLinkSubstitutionHandler getLinkSubstitutionHandler() {
        if (this.m_linkSubstitutionHandler == null) {
            this.setLinkSubstitutionHandler(CmsDefaultLinkSubstitutionHandler.class.getName());
        }
        return this.m_linkSubstitutionHandler;
    }

    public String getPlainExportOptimization() {
        return String.valueOf(this.m_quickPlainExport);
    }

    public boolean getQuickPlainExport() {
        return this.m_quickPlainExport;
    }

    public String getRelativeLinks() {
        return String.valueOf(this.m_exportRelativeLinks);
    }

    public String getRemoteAddr() {
        return this.m_remoteAddr;
    }

    public String getRemoteAddress() {
        return this.m_remoteAddr;
    }

    public String getRfsName(CmsObject cms, String vfsName) {
        return this.getRfsName(cms, vfsName, null);
    }

    public String getRfsName(CmsObject cms, String vfsName, String parameters) {
        String rfsName;
        try {
            CmsResource vfsRes = null;
            try {
                vfsRes = cms.readResource(vfsName);
                I_CmsDetailPageFinder finder = OpenCms.getADEManager().getDetailPageFinder();
                String detailPage = finder.getDetailPage(cms, vfsRes.getRootPath(), cms.getRequestContext().getUri());
                if (detailPage != null) {
                    vfsName = CmsStringUtil.joinPaths(detailPage, CmsDetailPageUtil.getBestUrlName(cms, vfsRes.getStructureId()), "/");
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                // empty catch block
            }
            rfsName = this.getRfsNameWithExportName(cms, vfsName);
            String extension = CmsFileUtil.getExtension(rfsName);
            boolean isJsp = extension.equals(".jsp");
            if (isJsp) {
                String suffix = null;
                try {
                    CmsResource res = cms.readResource(vfsName);
                    isJsp = CmsResourceTypeJsp.isJsp(res);
                    if (isJsp) {
                        suffix = cms.readPropertyObject(vfsName, "exportsuffix", true).getValue(".html");
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    File rfsFile = new File(CmsFileUtil.normalizePath(this.getExportPath(cms.getRequestContext().addSiteRoot(vfsName)) + rfsName));
                    File parent = rfsFile.getParentFile();
                    if (parent != null) {
                        File[] paramVariants = parent.listFiles(new CmsPrefixFileFilter(rfsFile.getName()));
                        if (paramVariants != null && paramVariants.length > 0) {
                            suffix = paramVariants[0].getAbsolutePath().substring(rfsFile.getAbsolutePath().length());
                        }
                    }
                    suffix = ".html";
                }
                if (suffix != null && !extension.equals(suffix.toLowerCase())) {
                    rfsName = rfsName + suffix;
                    extension = suffix;
                }
            }
            if (parameters != null) {
                rfsName = CmsFileUtil.getRfsPath(rfsName, extension, parameters);
                try {
                    cms.writeStaticExportPublishedResource(rfsName, 2, parameters, System.currentTimeMillis());
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_WRITE_FAILED_1", rfsName), (Throwable)e);
                }
            }
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            rfsName = vfsName;
        }
        if (!vfsName.startsWith("/system/")) {
            return this.getRfsPrefix(cms.getRequestContext().addSiteRoot(vfsName)).concat(rfsName);
        }
        String source = cms.getRequestContext().addSiteRoot(cms.getRequestContext().getUri());
        for (CmsStaticExportRfsRule rule : this.getRfsRules()) {
            if (!rule.getSource().matcher(source).matches() || !rule.match(vfsName)) continue;
            return rule.getRfsPrefix().concat(rfsName);
        }
        return this.getRfsPrefix(cms.getRequestContext().getSiteRoot() + "/").concat(rfsName);
    }

    public String getRfsPrefix(String vfsName) {
        if (vfsName != null) {
            for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
                if (!rule.getSource().matcher(vfsName).matches()) continue;
                return rule.getRfsPrefix();
            }
        }
        return this.m_rfsPrefix;
    }

    public String getRfsPrefixForConfiguration() {
        return this.m_rfsPrefixConfigured;
    }

    public List<CmsStaticExportRfsRule> getRfsRules() {
        return Collections.unmodifiableList(this.m_rfsRules);
    }

    public String getTestResource() {
        return this.m_testResource;
    }

    public CmsStaticExportData getVfsExportData(CmsObject cms, String vfsName) {
        return this.getRfsExportData(cms, this.getRfsName(cms, vfsName));
    }

    public String getVfsName(CmsObject cms, String rfsName) {
        CmsStaticExportData data = this.getRfsExportData(cms, rfsName);
        if (data != null) {
            String result = data.getVfsName();
            if (result != null && result.startsWith(cms.getRequestContext().getSiteRoot())) {
                result = result.substring(cms.getRequestContext().getSiteRoot().length());
            }
            return result;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public CmsStaticExportData getVfsNameInternal(CmsObject cms, String rfsName) throws CmsVfsResourceNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getVfsPrefix() {
        return this.m_vfsPrefix;
    }

    public String getVfsPrefixForConfiguration() {
        return this.m_vfsPrefixConfigured;
    }

    public void initialize(CmsObject cms) {
        int pos2;
        this.m_staticExportPath = this.normalizeExportPath(this.m_staticExportPathConfigured);
        this.m_staticExportWorkPath = this.normalizeExportPath(this.getExportWorkPathForConfiguration());
        if (this.m_staticExportPath.equals(OpenCms.getSystemInfo().getWebApplicationRfsPath())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_EXPORT_PATH_0"));
        }
        this.m_rfsPrefix = this.normalizeRfsPrefix(this.m_rfsPrefixConfigured);
        for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
            try {
                rule.setExportPath(this.normalizeExportPath(rule.getExportPathConfigured()));
            }
            catch (CmsIllegalArgumentException e) {
                CmsLog.INIT.warn((Object)e.getMessageContainer());
                rule.setExportPath(this.m_staticExportPath);
            }
            try {
                rule.setExportWorkPath(this.normalizeExportPath(rule.getExportWorkPathConfigured()));
            }
            catch (CmsIllegalArgumentException e) {
                CmsLog.INIT.warn((Object)e.getMessageContainer());
                rule.setExportWorkPath(this.m_staticExportWorkPath);
            }
            rule.setRfsPrefix(this.normalizeRfsPrefix(rule.getRfsPrefixConfigured()));
        }
        this.m_vfsPrefix = this.insertContextStrings(this.m_vfsPrefixConfigured);
        this.m_vfsPrefix = CmsFileUtil.normalizePath(this.m_vfsPrefix, '/');
        if (CmsResource.isFolder(this.m_vfsPrefix)) {
            this.m_vfsPrefix = this.m_vfsPrefix.substring(0, this.m_vfsPrefix.length() - 1);
        }
        if (CmsLog.INIT.isDebugEnabled()) {
            if (cms != null) {
                CmsLog.INIT.debug((Object)Messages.get().getBundle().key("INIT_SE_MANAGER_CREATED_1", cms));
            } else {
                CmsLog.INIT.debug((Object)Messages.get().getBundle().key("INIT_SE_MANAGER_CREATED_0"));
            }
        }
        Map lruMap1 = CmsCollectionsGenericWrapper.createLRUMap(2048);
        this.m_cacheOnlineLinks = Collections.synchronizedMap(lruMap1);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheOnlineLinks", lruMap1);
        Map lruMap2 = CmsCollectionsGenericWrapper.createLRUMap(2048);
        this.m_cacheExportUris = Collections.synchronizedMap(lruMap2);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheExportUris", lruMap2);
        Map lruMap3 = CmsCollectionsGenericWrapper.createLRUMap(2048);
        this.m_cacheSecureLinks = Collections.synchronizedMap(lruMap3);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheSecureLinks", lruMap3);
        Map lruMap4 = CmsCollectionsGenericWrapper.createLRUMap(2048);
        this.m_cacheExportLinks = Collections.synchronizedMap(lruMap4);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheExportLinks", lruMap4);
        OpenCms.addCmsEventListener(this, new int[]{2, 5, 19});
        this.m_exportFolderMatcher = new CmsExportFolderMatcher(this.m_exportFolders, this.m_testResource);
        this.m_defaultAcceptLanguageHeader = CmsAcceptLanguageHeaderParser.createLanguageHeader();
        this.m_defaultAcceptCharsetHeader = OpenCms.getSystemInfo().getDefaultEncoding();
        int pos = this.m_exportUrl.indexOf("://");
        this.m_exportUrlPrefix = pos > 0 ? ((pos2 = this.m_exportUrl.indexOf(47, pos + 3)) > 0 ? this.m_exportUrl.substring(pos2) : "") : this.m_exportUrl;
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.isStaticExportEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STATIC_EXPORT_ENABLED_0"));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_DEFAULT_1", (Object)this.getExportPropertyDefault()));
                for (CmsStaticExportRfsRule rfsRule : this.m_rfsRules) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_EXPORT_PATH_2", rfsRule.getSource(), rfsRule.getExportPath()));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RFS_PREFIX_2", rfsRule.getSource(), rfsRule.getRfsPrefix()));
                    if (rfsRule.getUseRelativeLinks() == null) continue;
                    if (rfsRule.getUseRelativeLinks().booleanValue()) {
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RELATIVE_LINKS_1", rfsRule.getSource()));
                        continue;
                    }
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_ABSOLUTE_LINKS_1", rfsRule.getSource()));
                }
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_EXPORT_PATH_2", "/", this.m_staticExportPath));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RFS_PREFIX_2", "/", this.m_rfsPrefix));
                if (this.m_exportRelativeLinks) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RELATIVE_LINKS_1", "/"));
                } else {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_ABSOLUTE_LINKS_1", "/"));
                }
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_VFS_PREFIX_1", this.getVfsPrefix()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_EXPORT_HANDLER_1", this.getHandler().getClass().getName()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_URL_1", this.getExportUrl()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_OPTIMIZATION_1", this.getPlainExportOptimization()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_TESTRESOURCE_1", this.getTestResource()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINKSUBSTITUTION_HANDLER_1", this.getLinkSubstitutionHandler().getClass().getName()));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STATIC_EXPORT_DISABLED_0"));
            }
        }
    }

    public boolean isExportLink(CmsObject cms, String vfsName) {
        LOG.info((Object)("isExportLink? " + vfsName));
        String cacheKey = this.getCacheKey(cms.getRequestContext().getSiteRoot(), vfsName);
        Boolean exportResource = this.getCacheExportLinks().get(cacheKey);
        if (exportResource != null) {
            return exportResource;
        }
        boolean result = false;
        try {
            CmsObject exportCms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
            exportCms.getRequestContext().setSiteRoot(cms.getRequestContext().getSiteRoot());
            CmsResource exportRes = CmsDetailPageUtil.lookupPage(exportCms, vfsName);
            String exportValue = exportCms.readPropertyObject(exportCms.getSitePath(exportRes), "export", true).getValue();
            result = exportValue == null ? (this.getExportPropertyDefault() ? true : this.isSuffixExportable(vfsName)) : Boolean.valueOf(exportValue);
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.getCacheExportLinks().put(cacheKey, result);
        return result;
    }

    public boolean isFullStaticExport() {
        return this.m_fullStaticExport;
    }

    public boolean isSecureLink(CmsObject cms, String vfsName) {
        if (!cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return false;
        }
        String cacheKey = OpenCms.getStaticExportManager().getCacheKey(cms.getRequestContext().getSiteRoot(), vfsName);
        Boolean secureResource = OpenCms.getStaticExportManager().getCacheSecureLinks().get(cacheKey);
        if (secureResource == null) {
            try {
                String secureProp = cms.readPropertyObject(vfsName, "secure", true).getValue();
                secureResource = Boolean.valueOf(secureProp);
                OpenCms.getStaticExportManager().getCacheSecureLinks().put(cacheKey, secureResource);
            }
            catch (CmsVfsResourceNotFoundException e) {
                secureResource = Boolean.FALSE;
                OpenCms.getStaticExportManager().getCacheSecureLinks().put(cacheKey, secureResource);
            }
            catch (Exception e) {
                secureResource = Boolean.FALSE;
            }
        }
        return secureResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecureLink(CmsObject cms, String vfsName, String siteRoot) {
        if (siteRoot == null) {
            return this.isSecureLink(cms, vfsName);
        }
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot(siteRoot);
            boolean bl = this.isSecureLink(cms, vfsName);
            return bl;
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    public boolean isStaticExportEnabled() {
        return this.m_staticExportEnabled;
    }

    public boolean isSuffixExportable(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        int pos = resourceName.lastIndexOf(46);
        if (pos >= 0) {
            String suffix = resourceName.substring(pos).toLowerCase();
            return this.m_exportSuffixes.contains(suffix);
        }
        return false;
    }

    public boolean isUseTempDir() {
        return this.m_useTempDirs;
    }

    public boolean relativeLinksInExport(String vfsName) {
        if (vfsName != null) {
            for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
                if (!rule.getSource().matcher(vfsName).matches()) continue;
                return rule.getUseRelativeLinks() != null ? rule.getUseRelativeLinks() : this.m_exportRelativeLinks;
            }
        }
        return this.m_exportRelativeLinks;
    }

    public void setAcceptCharsetHeader(String value) {
        this.m_acceptCharsetHeader = value;
    }

    public void setAcceptLanguageHeader(String value) {
        this.m_acceptLanguageHeader = value;
    }

    public void setDefault(String value) {
        this.m_exportPropertyDefault = Boolean.valueOf(value);
    }

    public void setExportBackups(String backup) {
        this.m_staticExportBackups = new Integer(backup);
    }

    public void setExportEnabled(String value) {
        this.m_staticExportEnabled = Boolean.valueOf(value);
    }

    public void setExportFolderPattern(String folder) {
        this.m_exportFolders.add(folder);
    }

    public void setExportHeader(String exportHeader) {
        if (CmsStringUtil.splitAsArray(exportHeader, ':').length == 2) {
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_HEADERS_1", exportHeader));
            }
            this.m_exportHeaders.add(exportHeader);
        } else if (CmsLog.INIT.isWarnEnabled()) {
            CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_INVALID_HEADER_1", exportHeader));
        }
    }

    public void setExportPath(String path) {
        this.m_staticExportPathConfigured = path;
    }

    public void setExportSuffix(String suffix) {
        this.m_exportSuffixes.add(suffix.toLowerCase());
    }

    public void setExportUrl(String url) {
        this.m_exportUrl = this.insertContextStrings(url);
        this.m_exportUrlConfigured = url;
    }

    public void setExportWorkPath(String path) {
        this.m_staticExportWorkPathConfigured = path;
    }

    public void setHandler(String handlerClassName) {
        try {
            this.m_handler = (I_CmsStaticExportHandler)Class.forName(handlerClassName).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setLinkSubstitutionHandler(String handlerClassName) {
        try {
            this.m_linkSubstitutionHandler = (I_CmsLinkSubstitutionHandler)Class.forName(handlerClassName).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setPlainExportOptimization(String value) {
        this.m_quickPlainExport = Boolean.valueOf(value);
    }

    public void setRelativeLinks(String value) {
        this.m_exportRelativeLinks = Boolean.valueOf(value);
    }

    public void setRemoteAddr(String addr) {
        this.m_remoteAddr = addr;
    }

    public void setRfsPrefix(String rfsPrefix) {
        this.m_rfsPrefixConfigured = rfsPrefix;
    }

    public void setTestResource(String testResource) {
        this.m_testResource = testResource;
    }

    public void setVfsPrefix(String vfsPrefix) {
        this.m_vfsPrefixConfigured = vfsPrefix;
    }

    public synchronized void shutDown() {
        int count = 0;
        while (count < 60 && this.m_handler.isBusy()) {
            ++count;
            try {
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STATIC_EXPORT_SHUTDOWN_3", this.m_handler.getClass().getName(), String.valueOf(count), String.valueOf(60)));
                }
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                count = 60;
            }
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
    }

    protected void clearCaches(CmsEvent event) {
        this.m_cacheOnlineLinks.clear();
        this.m_cacheExportUris.clear();
        this.m_cacheSecureLinks.clear();
        this.m_cacheExportLinks.clear();
        this.m_exportnameResources = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLUSHED_CACHES_1", new Integer(event.getType())));
        }
    }

    protected void createExportBackupFolders(File staticExport, String exportPath, int exportBackups, String ruleBackupExtension) {
        if (staticExport.exists()) {
            String backupFolderName = exportPath.substring(0, exportPath.lastIndexOf(File.separator) + 1);
            backupFolderName = ruleBackupExtension != null ? backupFolderName + EXPORT_BACKUP_FOLDER_NAME + ruleBackupExtension : backupFolderName + EXPORT_BACKUP_FOLDER_NAME;
            for (int i = exportBackups; i > 0; --i) {
                File staticExportBackupOld = new File(backupFolderName + new Integer(i).toString());
                if (staticExportBackupOld.exists()) {
                    if (i + 1 > exportBackups) {
                        CmsFileUtil.purgeDirectory(staticExportBackupOld);
                    } else {
                        staticExportBackupOld.renameTo(new File(backupFolderName + new Integer(i + 1).toString()));
                    }
                }
                if (i != 1) continue;
                staticExport.renameTo(staticExportBackupOld);
            }
            if (exportBackups == 0) {
                CmsFileUtil.purgeDirectory(staticExport);
            }
        }
    }

    protected void createExportFolder(String exportPath, String rfsName) throws CmsException {
        String exportFolderName = CmsFileUtil.normalizePath(exportPath + CmsResource.getFolderPath(rfsName));
        File exportFolder = new File(exportFolderName);
        if (!(exportFolder.exists() || exportFolder.mkdirs() || exportFolder.exists())) {
            throw new CmsStaticExportException(Messages.get().container("ERR_CREATE_FOLDER_1", rfsName));
        }
    }

    protected Map<String, Boolean> getCacheExportLinks() {
        return this.m_cacheExportLinks;
    }

    protected Map<String, Boolean> getCacheSecureLinks() {
        return this.m_cacheSecureLinks;
    }

    protected CmsStaticExportData getRfsExportData(CmsObject cms, String uri) {
        CmsStaticExportData data;
        String rfsName;
        block16: {
            rfsName = uri.substring(this.getRfsPrefixForRfsName(uri).length());
            data = this.m_cacheExportUris.get(rfsName);
            if (data == null) {
                try {
                    data = this.getVfsNameInternal(cms, rfsName);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
            }
            if (data == null) {
                try {
                    String parameters = cms.readStaticExportPublishedResourceParameters(rfsName);
                    if (CmsStringUtil.isNotEmpty(parameters)) {
                        String rfsBaseName = rfsName.substring(0, rfsName.lastIndexOf(95));
                        if (rfsBaseName.endsWith(DEFAULT_FILE)) {
                            rfsBaseName = rfsBaseName.substring(0, rfsBaseName.length() - DEFAULT_FILE.length());
                        } else if (rfsBaseName.endsWith(EXPORT_DEFAULT_FILE)) {
                            rfsBaseName = rfsBaseName.substring(0, rfsBaseName.length() - EXPORT_DEFAULT_FILE.length());
                        }
                        data = this.getVfsNameInternal(cms, rfsBaseName);
                        if (data != null) {
                            data.setParameters(parameters);
                        }
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_INTERNAL_VFS_RESOURCE_FOUND_1", new String[]{rfsName}));
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) break block16;
                    LOG.warn((Object)Messages.get().getBundle().key("ERR_EXPORT_FILE_FAILED_1", new String[]{rfsName}), (Throwable)e);
                }
            }
        }
        if (data == null) {
            data = new CmsStaticExportData(CACHEVALUE_404, rfsName, null, null);
        }
        this.m_cacheExportUris.put(rfsName, data);
        if (data.getVfsName() != CACHEVALUE_404) {
            if (data.getResource().isFolder() && !CmsResource.isFolder(rfsName)) {
                rfsName = rfsName + "/";
            }
            data.setRfsName(rfsName);
            return data;
        }
        return null;
    }

    protected String getRfsNameWithExportName(CmsObject cms, String vfsName) {
        String rfsName;
        block11: {
            rfsName = vfsName;
            try {
                boolean cont;
                String name = CmsResource.getName(vfsName).replaceAll("/$", "");
                CmsUUID detailId = cms.readIdForUrlName(name);
                String propertyReadPath = detailId == null ? CmsResource.getFolderPath(rfsName) : CmsResource.getFolderPath(rfsName.replaceAll("/$", ""));
                CmsProperty exportNameProperty = cms.readPropertyObject(propertyReadPath, "exportname", true);
                if (exportNameProperty.isNullProperty()) {
                    rfsName = cms.getRequestContext().addSiteRoot(rfsName);
                    break block11;
                }
                String exportname = exportNameProperty.getValue();
                if (exportname.charAt(0) != '/') {
                    exportname = '/' + exportname;
                }
                if (exportname.charAt(exportname.length() - 1) != '/') {
                    exportname = exportname + '/';
                }
                String value = null;
                String resourceName = rfsName;
                do {
                    try {
                        CmsProperty prop = cms.readPropertyObject(resourceName, "exportname", false);
                        if (prop.isIdentical(exportNameProperty)) {
                            value = prop.getValue();
                        }
                        cont = value == null && resourceName.length() > 1;
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        cont = resourceName.length() > 1;
                    }
                    catch (CmsSecurityException se) {
                        cont = false;
                    }
                    if (!cont) continue;
                    resourceName = CmsResource.getParentFolder(resourceName);
                } while (cont);
                rfsName = exportname + rfsName.substring(resourceName.length());
            }
            catch (CmsException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                rfsName = vfsName;
            }
        }
        return rfsName;
    }

    protected String getRfsPrefixForRfsName(String rfsName) {
        String retVal = "";
        if (rfsName.startsWith(this.m_rfsPrefix + "/")) {
            retVal = this.m_rfsPrefix;
        }
        for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
            String rfsPrefix = rule.getRfsPrefix();
            if (!rfsName.startsWith(rfsPrefix + "/") || retVal.length() >= rfsPrefix.length()) continue;
            retVal = rfsPrefix;
        }
        return retVal;
    }

    protected String insertContextStrings(String path) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        resolver.addMacro("CONTEXT_NAME", OpenCms.getSystemInfo().getContextPath());
        resolver.addMacro("SERVLET_NAME", OpenCms.getSystemInfo().getServletPath());
        return resolver.resolveMacros(path);
    }

    protected boolean isValidRfsName(String rfsName) {
        if (rfsName != null) {
            if (rfsName.startsWith(this.m_rfsPrefix + "/")) {
                return true;
            }
            for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
                String rfsPrefix = rule.getRfsPrefix() + "/";
                if (!rfsName.startsWith(rfsPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isValidURL(String inputString) {
        boolean isValid = false;
        try {
            if (inputString != null) {
                URL tempURL = new URL(inputString);
                isValid = tempURL.getProtocol() != null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isValid;
    }

    protected String normalizeExportPath(String exportPath) {
        String result = this.insertContextStrings(exportPath);
        result = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebApplication(result);
        if (result.endsWith(File.separator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected String normalizeRfsPrefix(String rfsPrefix) {
        String result = this.insertContextStrings(rfsPrefix);
        if (!this.isValidURL(result)) {
            result = CmsFileUtil.normalizePath(result, '/');
        }
        if (CmsResource.isFolder(result = CmsFileUtil.normalizePath(result, '/'))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected CmsStaticExportData readResource(CmsObject cms, String uri) throws CmsException {
        CmsResource resource = null;
        try {
            resource = cms.readResource(uri);
        }
        catch (CmsVfsResourceNotFoundException e) {
            String urlName = CmsResource.getName(uri).replaceAll("/$", "");
            CmsUUID id = cms.readIdForUrlName(urlName);
            if (id == null) {
                throw e;
            }
            resource = cms.readResource(id);
        }
        return new CmsStaticExportData(uri, null, resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrubExportFolders(I_CmsReport report) {
        if (report != null) {
            report.println(Messages.get().container("RPT_DELETING_EXPORT_FOLDERS_BEGIN_0"), 2);
        }
        Object object = this.m_lockScrubExportFolders;
        synchronized (object) {
            String exportFolderName;
            Integer size;
            int count;
            block16: {
                count = 0;
                size = new Integer(this.m_rfsRules.size() + 1);
                exportFolderName = CmsFileUtil.normalizePath(this.m_staticExportPath + '/');
                try {
                    File exportFolder = new File(exportFolderName);
                    if (exportFolder.exists() && exportFolder.canWrite()) {
                        CmsFileUtil.purgeDirectory(exportFolder);
                    }
                    ++count;
                    if (report != null) {
                        report.println(Messages.get().container("RPT_DELETE_EXPORT_FOLDER_3", new Integer(count), size, exportFolderName), 3);
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_DEL_MAIN_SE_FOLDER_1", exportFolderName));
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) break block16;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETION_FAILED_1", exportFolderName), t);
                }
            }
            for (CmsStaticExportRfsRule rule : this.m_rfsRules) {
                exportFolderName = CmsFileUtil.normalizePath(rule.getExportPath() + '/');
                try {
                    File exportFolder = new File(exportFolderName);
                    if (exportFolder.exists() && exportFolder.canWrite()) {
                        CmsFileUtil.purgeDirectory(exportFolder);
                    }
                    ++count;
                    if (report != null) {
                        report.println(Messages.get().container("RPT_DELETE_EXPORT_FOLDER_3", new Integer(count), size, exportFolderName), 3);
                        continue;
                    }
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)Messages.get().getBundle().key("LOG_DEL_MAIN_SE_FOLDER_1", exportFolderName));
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETION_FAILED_1", exportFolderName), t);
                }
            }
        }
        if (report != null) {
            report.println(Messages.get().container("RPT_DELETING_EXPORT_FOLDERS_END_0"), 2);
        }
    }

    protected void writeResource(HttpServletRequest req, String exportPath, String rfsName, CmsResource resource, byte[] content) throws CmsException {
        String exportFileName = CmsFileUtil.normalizePath(exportPath + rfsName);
        this.createExportFolder(exportPath, rfsName);
        File exportFile = new File(exportFileName);
        try {
            FileOutputStream exportStream = new FileOutputStream(exportFile);
            exportStream.write(content);
            exportStream.close();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_STATIC_EXPORTED_2", resource.getRootPath(), exportFileName));
            }
        }
        catch (Throwable t) {
            throw new CmsStaticExportException(Messages.get().container("ERR_OUTPUT_STREAM_1", exportFileName), t);
        }
        if (req != null) {
            Long dateLastModified = (Long)req.getAttribute("OpenCms-Export");
            if (dateLastModified != null && dateLastModified != -1L) {
                exportFile.setLastModified(dateLastModified / 1000L * 1000L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_LAST_MODIFIED_2", exportFile.getName(), new Long(dateLastModified / 1000L * 1000L)));
                }
            }
        } else {
            exportFile.setLastModified(resource.getDateLastModified() / 1000L * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> computeVfsExportnames() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_EXPORTNAME_PROP_START_0"));
        }
        CmsObject cms = null;
        try {
            cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
            List<CmsResource> resources = cms.readResourcesWithProperty("exportname");
            Object object = this.m_lockSetExportnames;
            synchronized (object) {
                HashMap<String, String> exportnameResources = new HashMap<String, String>();
                int n = resources.size();
                for (int i = 0; i < n; ++i) {
                    CmsResource res = resources.get(i);
                    try {
                        String foldername = res.getRootPath();
                        String exportname = cms.readPropertyObject(foldername, "exportname", false).getValue();
                        if (exportname == null) continue;
                        if (exportname.charAt(exportname.length() - 1) != '/') {
                            exportname = exportname + "/";
                        }
                        if (exportname.charAt(0) != '/') {
                            exportname = "/" + exportname;
                        }
                        exportnameResources.put(exportname, foldername);
                        continue;
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                return Collections.unmodifiableMap(exportnameResources);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

