/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.util.Translate;
import org.opencms.util.CmsHtmlParser;
import org.opencms.util.CmsStringUtil;

public class CmsHtml2TextConverter
extends CmsHtmlParser {
    private boolean m_appendBr;
    private Map<Tag, String> m_attributeMap;
    private int m_brCount;
    private int m_indent;
    private int m_lineLength;
    private String m_marker;
    private int m_maxLineLength;
    private int m_storedBrCount;

    public CmsHtml2TextConverter() {
        this.m_result = new StringBuffer(512);
        this.m_maxLineLength = 100;
        this.m_attributeMap = new HashMap<Tag, String>(16);
    }

    public static String html2text(String html, String encoding) throws Exception {
        CmsHtml2TextConverter visitor = new CmsHtml2TextConverter();
        return visitor.process(html, encoding);
    }

    public void visitEndTag(Tag tag) {
        this.m_appendBr = false;
        this.appendLinebreaks(tag, false);
        String attribute = this.m_attributeMap.remove(tag.getParent());
        if (attribute != null) {
            this.appendText(attribute);
        }
    }

    public void visitStringNode(Text text) {
        this.appendText(text.toPlainTextString());
    }

    public void visitTag(Tag tag) {
        String alt;
        String title;
        String src;
        String href;
        this.m_appendBr = true;
        this.appendLinebreaks(tag, true);
        if (tag.getTagName().equals("IMG")) {
            this.appendText("##IMG##");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(href = tag.getAttribute("href"))) {
            this.appendAttribute(tag, " [" + href.trim() + "]");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(src = tag.getAttribute("src"))) {
            this.appendAttribute(tag, " [" + src.trim() + "]");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title = tag.getAttribute("title"))) {
            this.appendAttribute(tag, " {" + title.trim() + "}");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(alt = tag.getAttribute("alt"))) {
            this.appendAttribute(tag, " {" + alt.trim() + "}");
        }
    }

    private void appendAttribute(Tag tag, String text) {
        if (tag.getTagName().equals("IMG")) {
            this.appendText(text);
        } else {
            String current = this.m_attributeMap.get(tag);
            if (current != null) {
                text = current + text;
            }
            this.m_attributeMap.put(tag, text);
        }
    }

    private void appendIndentation() {
        if (this.m_lineLength <= this.m_indent) {
            int len = this.m_marker != null ? this.m_indent - (this.m_marker.length() + 1) : this.m_indent;
            for (int i = 0; i < len; ++i) {
                this.m_result.append(' ');
            }
            if (this.m_marker != null) {
                this.m_result.append(this.m_marker);
                this.m_result.append(' ');
                this.m_marker = null;
            }
        }
    }

    private void appendLinebreak(int count) {
        this.appendLinebreak(count, false);
    }

    private void appendLinebreak(int count, boolean force) {
        if (this.m_appendBr) {
            if (this.m_storedBrCount > count) {
                count = this.m_storedBrCount;
            }
            this.m_storedBrCount = 0;
            if (force) {
                this.m_brCount = 0;
            }
            while (this.m_brCount < count) {
                this.m_result.append("\r\n");
                ++this.m_brCount;
            }
            this.m_lineLength = this.m_indent;
        } else {
            while (this.m_storedBrCount < count) {
                ++this.m_storedBrCount;
            }
        }
    }

    private void appendLinebreaks(Tag tag, boolean open) {
        String name = tag.getTagName();
        int pos = TAG_LIST.indexOf(name);
        switch (pos) {
            case 0: {
                this.setMarker("=", open);
                this.setIndentation(2, open);
                this.appendLinebreak(2);
                break;
            }
            case 1: {
                this.setMarker("==", open);
                this.setIndentation(3, open);
                this.appendLinebreak(2);
                break;
            }
            case 2: {
                this.setMarker("===", open);
                this.setIndentation(4, open);
                this.appendLinebreak(2);
                break;
            }
            case 3: {
                this.setMarker("====", open);
                this.setIndentation(5, open);
                this.appendLinebreak(2);
                break;
            }
            case 4: {
                this.setMarker("=====", open);
                this.setIndentation(6, open);
                this.appendLinebreak(2);
                break;
            }
            case 5: {
                this.setMarker("=======", open);
                this.setIndentation(7, open);
                this.appendLinebreak(2);
                break;
            }
            case 6: 
            case 7: {
                this.appendLinebreak(2);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.appendLinebreak(1, true);
                break;
            }
            case 10: 
            case 11: {
                this.appendLinebreak(2);
                break;
            }
            case 12: {
                this.setMarker("*", open);
                this.setIndentation(5, open);
                this.appendLinebreak(1);
                break;
            }
            case 13: {
                this.setIndentation(5, open);
                this.appendLinebreak(2);
                if (!open) break;
                this.appendLinebreak(1);
                this.appendText("-----");
                this.appendLinebreak(1);
                break;
            }
            case 14: {
                this.setMarker("--", open);
                this.appendLinebreak(2);
                break;
            }
            case 15: {
                if (open) break;
                this.appendLinebreak(1);
                this.appendText("-----");
                this.appendLinebreak(1);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.appendLinebreak(1);
                break;
            }
        }
    }

    private void appendText(String text) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(text)) {
            text = Translate.decode((String)text);
            text = this.collapse(text);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(text)) {
            if (this.m_storedBrCount > 0) {
                this.m_appendBr = true;
                this.appendLinebreak(this.m_storedBrCount);
            }
            this.appendIndentation();
            this.m_brCount = 0;
            List<String> wordList = CmsStringUtil.splitAsList(text, ' ');
            for (String word : wordList) {
                boolean hasNbsp;
                boolean bl = hasNbsp = word.charAt(0) == '\u00a0' || word.charAt(word.length() - 1) == '\u00a0';
                if (word.length() + 1 + this.m_lineLength > this.m_maxLineLength) {
                    this.m_appendBr = true;
                    this.appendLinebreak(1);
                    this.appendIndentation();
                    this.m_brCount = 0;
                } else if (!hasNbsp && this.m_lineLength > this.m_indent && this.m_result.charAt(this.m_result.length() - 1) != '\u00a0' && this.m_result.charAt(this.m_result.length() - 1) != ' ') {
                    this.m_result.append(' ');
                    ++this.m_lineLength;
                }
                this.m_result.append(word);
                this.m_lineLength += word.length();
            }
        }
    }

    private void setIndentation(int length, boolean open) {
        if (open) {
            this.m_indent += length;
        } else {
            this.m_indent -= length;
            if (this.m_indent < 0) {
                this.m_indent = 0;
            }
        }
    }

    private void setMarker(String marker, boolean open) {
        if (open) {
            this.m_marker = marker;
        }
    }
}

