/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.opencms.util.CmsNoAutoCloseTag;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsHtmlNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsHtmlParser
extends NodeVisitor
implements I_CmsHtmlNodeVisitor {
    protected List<String> m_noAutoCloseTags;
    protected static final String[] TAG_ARRAY = new String[]{"H1", "H2", "H3", "H4", "H5", "H6", "P", "DIV", "SPAN", "BR", "OL", "UL", "LI", "TABLE", "TD", "TR", "TH", "THEAD", "TBODY", "TFOOT"};
    protected static final List<String> TAG_LIST = Arrays.asList(TAG_ARRAY);
    protected boolean m_echo;
    protected StringBuffer m_result = new StringBuffer(1024);
    private String m_configuration = "";

    public CmsHtmlParser() {
        this(false);
    }

    public CmsHtmlParser(boolean echo) {
        this.m_echo = echo;
        this.m_noAutoCloseTags = new ArrayList<String>(32);
    }

    protected PrototypicalNodeFactory configureNoAutoCorrectionTags() {
        PrototypicalNodeFactory factory = new PrototypicalNodeFactory();
        for (String tagName : this.m_noAutoCloseTags) {
            CmsNoAutoCloseTag noAutoCloseTag = new CmsNoAutoCloseTag(new String[]{tagName});
            factory.unregisterTag((Tag)noAutoCloseTag);
            factory.registerTag((Tag)noAutoCloseTag);
        }
        return factory;
    }

    @Override
    public String getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public String getResult() {
        return this.m_result.toString();
    }

    public String getTagHtml(Tag tag) {
        StringBuffer result = new StringBuffer(32);
        result.append('<');
        result.append(tag.getText());
        result.append('>');
        return result.toString();
    }

    @Override
    public String process(String html, String encoding) throws ParserException {
        this.m_result = new StringBuffer();
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Page page = new Page(html, encoding);
        lexer.setPage(page);
        parser.setLexer(lexer);
        if (this.m_noAutoCloseTags != null && this.m_noAutoCloseTags.size() > 0) {
            PrototypicalNodeFactory factory = this.configureNoAutoCorrectionTags();
            lexer.setNodeFactory((NodeFactory)factory);
        }
        parser.visitAllNodesWith((NodeVisitor)this);
        return this.getResult();
    }

    @Override
    public void setConfiguration(String configuration) {
        if (CmsStringUtil.isNotEmpty(configuration)) {
            this.m_configuration = configuration;
        }
    }

    @Override
    public void visitEndTag(Tag tag) {
        if (this.m_echo) {
            this.m_result.append(this.getTagHtml(tag));
        }
    }

    @Override
    public void visitRemarkNode(Remark remark) {
        if (this.m_echo) {
            this.m_result.append(remark.toHtml(true));
        }
    }

    @Override
    public void visitStringNode(Text text) {
        if (this.m_echo) {
            this.m_result.append(text.getText());
        }
    }

    @Override
    public void visitTag(Tag tag) {
        if (this.m_echo) {
            this.m_result.append(this.getTagHtml(tag));
        }
    }

    protected String collapse(String string) {
        int len = string.length();
        StringBuffer result = new StringBuffer(len);
        int state = 0;
        block3: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u200b': {
                    if (false == state) continue block3;
                    state = 1;
                    continue block3;
                }
                default: {
                    if (1 == state) {
                        result.append(' ');
                    }
                    state = 2;
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public List<String> getNoAutoCloseTags() {
        return this.m_noAutoCloseTags;
    }

    @Override
    public void setNoAutoCloseTags(List<String> noAutoCloseTagList) {
        this.m_noAutoCloseTags.clear();
        if (noAutoCloseTagList != null) {
            Iterator<String> it = noAutoCloseTagList.iterator();
            while (it.hasNext()) {
                this.m_noAutoCloseTags.add(it.next().toUpperCase());
            }
        }
    }
}

