/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.htmlparser.Attribute;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsHtmlParser;
import org.opencms.util.CmsHtmlTagRemoveFactory;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.Messages;

public final class CmsHtmlStripper {
    private static final Log LOG = CmsLog.getLog(CmsHtmlStripper.class);
    private CmsHtmlTagRemoveFactory m_nodeFactory;
    private boolean m_useTidy;

    public CmsHtmlStripper() {
        this.reset();
    }

    public CmsHtmlStripper(boolean useTidy) {
        this();
        this.m_useTidy = useTidy;
    }

    public boolean addPreserveTag(String tagName) {
        Vector<Attribute> attributeList = new Vector<Attribute>(1);
        Attribute tagNameAttribute = new Attribute();
        tagNameAttribute.setName(tagName.toLowerCase());
        attributeList.add(tagNameAttribute);
        Tag keepTag = this.m_nodeFactory.createTagNode(null, 0, 0, attributeList);
        boolean result = this.m_nodeFactory.addTagPreserve(keepTag);
        return result;
    }

    public void addPreserveTagList(List preserveTags) {
        Iterator it = preserveTags.iterator();
        while (it.hasNext()) {
            this.addPreserveTag((String)it.next());
        }
    }

    public void addPreserveTags(String tagList, char separator) {
        List<String> tags = CmsStringUtil.splitAsList(tagList, separator, true);
        this.addPreserveTagList(tags);
    }

    public void reset() {
        this.m_nodeFactory = new CmsHtmlTagRemoveFactory();
    }

    public String stripHtml(String html) throws ParserException {
        String content = html;
        if (this.m_useTidy) {
            content = this.tidy(content);
        }
        Parser parser = new Parser();
        parser.setNodeFactory((NodeFactory)this.m_nodeFactory);
        Lexer lexer = new Lexer();
        Page page = new Page(content);
        lexer.setPage(page);
        parser.setLexer(lexer);
        CmsHtmlParser visitor = new CmsHtmlParser(true);
        parser.visitAllNodesWith((NodeVisitor)visitor);
        return visitor.getResult();
    }

    private String tidy(String content) {
        String result;
        block2: {
            CmsHtmlConverter converter = new CmsHtmlConverter("UTF-8", new StringBuffer("cleanup").append(";").append("xhtml").toString());
            result = content;
            try {
                result = converter.convertToString(content);
            }
            catch (UnsupportedEncodingException e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_TIDY_FAILURE_0"), (Throwable)e);
            }
        }
        return result;
    }
}

