/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.webdav;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.repository.CmsRepositoryLockInfo;
import org.opencms.repository.I_CmsRepository;
import org.opencms.repository.I_CmsRepositoryItem;
import org.opencms.repository.I_CmsRepositorySession;
import org.opencms.security.CmsSecurityException;
import org.opencms.webdav.CmsMD5Encoder;
import org.opencms.webdav.CmsWebdavRange;
import org.opencms.webdav.CmsWebdavStatus;
import org.opencms.webdav.Messages;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsWebdavServlet
extends HttpServlet {
    public static final String AUTHORIZATION_BASIC_PREFIX = "BASIC ";
    public static final int BUFFER_SIZE = 4096;
    public static final String SEPARATOR_CREDENTIALS = ":";
    protected static final DateFormat HTTP_DATE_FORMAT;
    protected static final DateFormat ISO8601_FORMAT;
    protected static MessageDigest m_md5Helper;
    protected static final CmsMD5Encoder MD5_ENCODER;
    protected static final String METHOD_COPY = "COPY";
    protected static final String METHOD_DELETE = "DELETE";
    protected static final String METHOD_GET = "GET";
    protected static final String METHOD_HEAD = "HEAD";
    protected static final String METHOD_LOCK = "LOCK";
    protected static final String METHOD_MKCOL = "MKCOL";
    protected static final String METHOD_MOVE = "MOVE";
    protected static final String METHOD_OPTIONS = "OPTIONS";
    protected static final String METHOD_POST = "POST";
    protected static final String METHOD_PROPFIND = "PROPFIND";
    protected static final String METHOD_PROPPATCH = "PROPPATCH";
    protected static final String METHOD_PUT = "PUT";
    protected static final String METHOD_TRACE = "TRACE";
    protected static final String METHOD_UNLOCK = "UNLOCK";
    protected static final String MIME_SEPARATION = "CATALINA_MIME_BOUNDARY";
    protected static final BitSet URL_SAFE_CHARS;
    private static final String ATT_SERVLET_TEMPDIR = "javax.servlet.context.tempdir";
    private static final String BASIC_REALM = "OpenCms WebDAV Servlet";
    private static final String DEFAULT_NAMESPACE = "DAV:";
    private static final String DEPTH_INFINITY = "Infinity";
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static ArrayList<CmsWebdavRange> FULL_RANGE;
    private static final String HEADER_ALLOW = "Allow";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_CONTENTLENGTH = "content-length";
    private static final String HEADER_CONTENTRANGE = "Content-Range";
    private static final String HEADER_DEPTH = "Depth";
    private static final String HEADER_DESTINATION = "Destination";
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_IFRANGE = "If-Range";
    private static final String HEADER_LASTMODIFIED = "Last-Modified";
    private static final String HEADER_LOCKTOKEN = "Lock-Token";
    private static final String HEADER_OVERWRITE = "Overwrite";
    private static final String HEADER_RANGE = "Range";
    private static final String INIT_PARAM_LIST = "listings";
    private static final String INIT_PARAM_READONLY = "readonly";
    private static final String INIT_PARAM_REPOSITORY = "repository";
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final Log LOG;
    private static I_CmsRepository m_repository;
    private static final long serialVersionUID = -122598983283724306L;
    private static final String TAG_ACTIVELOCK = "activelock";
    private static final String TAG_COLLECTION = "collection";
    private static final String TAG_CONTENTLANGUAGE = "getcontentlanguage";
    private static final String TAG_CONTENTLENGTH = "getcontentlength";
    private static final String TAG_CONTENTTYPE = "getcontenttype";
    private static final String TAG_CREATIONDATE = "creationdate";
    private static final String TAG_DEPTH = "depth";
    private static final String TAG_DISPLAYNAME = "displayname";
    private static final String TAG_ETAG = "getetag";
    private static final String TAG_HREF = "href";
    private static final String TAG_LASTMODIFIED = "getlastmodified";
    private static final String TAG_LOCKDISCOVERY = "lockdiscovery";
    private static final String TAG_LOCKENTRY = "lockentry";
    private static final String TAG_LOCKSCOPE = "lockscope";
    private static final String TAG_LOCKTOKEN = "locktoken";
    private static final String TAG_LOCKTYPE = "locktype";
    private static final String TAG_MULTISTATUS = "multistatus";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_PROP = "prop";
    private static final String TAG_PROPSTAT = "propstat";
    private static final String TAG_RESOURCETYPE = "resourcetype";
    private static final String TAG_RESPONSE = "response";
    private static final String TAG_SOURCE = "source";
    private static final String TAG_STATUS = "status";
    private static final String TAG_SUPPORTEDLOCK = "supportedlock";
    private static final String TAG_TIMEOUT = "timeout";
    private static final String TIMEOUT_INFINITE = "Infinite";
    protected int m_input = 2048;
    protected int m_output = 2048;
    private boolean m_listings;
    private boolean m_readOnly = true;
    private String m_secret = "catalina";
    private I_CmsRepositorySession m_session;
    private String m_username;

    public static Element addElement(Element parent, String name) {
        return parent.addElement(new QName(name, Namespace.get((String)"D", (String)DEFAULT_NAMESPACE)));
    }

    public void init() throws ServletException {
        block18: {
            String value;
            block17: {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_INIT_WEBDAV_SERVLET_0"));
                }
                value = null;
                try {
                    value = this.getServletConfig().getInitParameter(INIT_PARAM_LIST);
                    if (value != null) {
                        this.m_listings = Boolean.valueOf(value);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block17;
                    LOG.error((Object)Messages.get().getBundle().key("LOG_READ_INIT_PARAM_ERROR_2", INIT_PARAM_LIST, value), (Throwable)e);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_READ_INIT_PARAM_2", INIT_PARAM_LIST, this.m_listings));
            }
            try {
                value = this.getServletConfig().getInitParameter(INIT_PARAM_READONLY);
                if (value != null) {
                    this.m_readOnly = Boolean.valueOf(value);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block18;
                LOG.error((Object)Messages.get().getBundle().key("LOG_READ_INIT_PARAM_ERROR_2", INIT_PARAM_READONLY, value), (Throwable)e);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_READ_INIT_PARAM_2", INIT_PARAM_READONLY, this.m_readOnly));
        }
        try {
            m_md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_MD5_NOT_AVAILABLE_0"), (Throwable)e);
            }
            throw new UnavailableException(Messages.get().getBundle().key("ERR_MD5_NOT_AVAILABLE_0"));
        }
        String repositoryName = this.getInitParameter(INIT_PARAM_REPOSITORY);
        if (repositoryName == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_INIT_PARAM_MISSING_1", INIT_PARAM_REPOSITORY));
            }
            throw new ServletException(Messages.get().getBundle().key("ERR_INIT_PARAM_MISSING_1", INIT_PARAM_REPOSITORY));
        }
        m_repository = OpenCms.getRepositoryManager().getRepository(repositoryName);
        if (m_repository == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_REPOSITORY_NOT_FOUND_1", repositoryName));
            }
            throw new ServletException(Messages.get().getBundle().key("ERR_REPOSITORY_NOT_FOUND_1", repositoryName));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_USE_REPOSITORY_1", repositoryName));
        }
    }

    protected void copy(I_CmsRepositoryItem item, InputStream is, PrintWriter writer) throws IOException {
        IOException exception;
        block3: {
            exception = null;
            InputStream resourceInputStream = null;
            resourceInputStream = !item.isCollection() ? new ByteArrayInputStream(item.getContent()) : is;
            InputStreamReader reader = new InputStreamReader(resourceInputStream);
            exception = this.copyRange(reader, writer);
            try {
                ((Reader)reader).close();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)Messages.get().getBundle().key("ERR_CLOSE_READER_0"), (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(I_CmsRepositoryItem item, InputStream is, ServletOutputStream ostream) throws IOException {
        IOException exception;
        block6: {
            exception = null;
            InputStream resourceInputStream = null;
            if (!item.isCollection()) {
                byte[] buffer = item.getContent();
                if (buffer != null) {
                    ostream.write(buffer, 0, buffer.length);
                    return;
                }
                resourceInputStream = new ByteArrayInputStream(item.getContent());
            } else {
                resourceInputStream = is;
            }
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.m_input);
            exception = this.copyRange(istream, ostream);
            try {
                ((InputStream)istream).close();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)Messages.get().getBundle().key("ERR_CLOSE_INPUT_STREAM_0"), (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(I_CmsRepositoryItem item, PrintWriter writer, CmsWebdavRange range) throws IOException {
        IOException exception;
        block3: {
            exception = null;
            ByteArrayInputStream resourceInputStream = new ByteArrayInputStream(item.getContent());
            InputStreamReader reader = new InputStreamReader(resourceInputStream);
            exception = this.copyRange(reader, writer, range.getStart(), range.getEnd());
            try {
                ((Reader)reader).close();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)Messages.get().getBundle().key("ERR_CLOSE_READER_0"), (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(I_CmsRepositoryItem item, PrintWriter writer, Iterator<CmsWebdavRange> ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            ByteArrayInputStream resourceInputStream = new ByteArrayInputStream(item.getContent());
            InputStreamReader reader = new InputStreamReader(resourceInputStream);
            CmsWebdavRange currentRange = ranges.next();
            writer.println();
            writer.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                writer.println("Content-Type: " + contentType);
            }
            writer.println("Content-Range: bytes " + currentRange.getStart() + "-" + currentRange.getEnd() + "/" + currentRange.getLength());
            writer.println();
            exception = this.copyRange(reader, writer, currentRange.getStart(), currentRange.getEnd());
            try {
                ((Reader)reader).close();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)Messages.get().getBundle().key("ERR_CLOSE_READER_0"), (Throwable)e);
            }
        }
        writer.println();
        writer.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(I_CmsRepositoryItem item, ServletOutputStream ostream, CmsWebdavRange range) throws IOException {
        IOException exception;
        block3: {
            exception = null;
            ByteArrayInputStream resourceInputStream = new ByteArrayInputStream(item.getContent());
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.m_input);
            exception = this.copyRange(istream, ostream, range.getStart(), range.getEnd());
            try {
                ((InputStream)istream).close();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)Messages.get().getBundle().key("ERR_CLOSE_INPUT_STREAM_0"), (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void copy(I_CmsRepositoryItem item, ServletOutputStream ostream, Iterator<CmsWebdavRange> ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            ByteArrayInputStream resourceInputStream = new ByteArrayInputStream(item.getContent());
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, this.m_input);
            CmsWebdavRange currentRange = ranges.next();
            ostream.println();
            ostream.println("--CATALINA_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.getStart() + "-" + currentRange.getEnd() + "/" + currentRange.getLength());
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.getStart(), currentRange.getEnd());
            try {
                ((InputStream)istream).close();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)Messages.get().getBundle().key("ERR_CLOSE_INPUT_STREAM_0"), (Throwable)e);
            }
        }
        ostream.println();
        ostream.print("--CATALINA_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream) {
        IOException exception = null;
        byte[] buffer = new byte[this.m_input];
        int len = buffer.length;
        try {
            while ((len = istream.read(buffer)) != -1) {
                ostream.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SERVE_BYTES_2", new Long(start), new Long(end)));
        }
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[this.m_input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    protected IOException copyRange(Reader reader, PrintWriter writer) {
        IOException exception = null;
        char[] buffer = new char[this.m_input];
        int len = buffer.length;
        try {
            while ((len = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            exception = e;
            len = -1;
        }
        return exception;
    }

    protected IOException copyRange(Reader reader, PrintWriter writer, long start, long end) {
        try {
            reader.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        char[] buffer = new char[this.m_input];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = reader.read(buffer);
                if (bytesToRead >= (long)len) {
                    writer.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    writer.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) {
        if (this.m_readOnly) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
            }
            return;
        }
        String src = this.getRelativePath(req);
        if (!this.m_session.exists(src)) {
            resp.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", src));
            }
            return;
        }
        String dest = this.parseDestinationHeader(req);
        if (dest == null) {
            resp.setStatus(400);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PARSE_DEST_HEADER_0"));
            }
            return;
        }
        if (dest.equals(src)) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SRC_DEST_EQUALS_0"));
            }
            return;
        }
        boolean overwrite = this.parseOverwriteHeader(req);
        if (this.m_session.exists(dest) && !overwrite) {
            resp.setStatus(412);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEST_PATH_EXISTS_1", dest));
            }
            return;
        }
        if (!this.m_session.exists(dest) && overwrite) {
            resp.setStatus(201);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_COPY_ITEM_2", src, dest));
            }
            this.m_session.copy(src, dest, overwrite);
        }
        catch (CmsSecurityException sex) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_PERMISSION_0"));
            }
            return;
        }
        catch (CmsVfsResourceAlreadyExistsException raeex) {
            resp.setStatus(412);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_EXISTS_1", dest));
            }
            return;
        }
        catch (CmsVfsResourceNotFoundException rnfex) {
            resp.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", src));
            }
            return;
        }
        catch (CmsException ex) {
            resp.setStatus(500);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REPOSITORY_ERROR_2", METHOD_COPY, src), (Throwable)ex);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_COPY_SUCCESS_0"));
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = this.getRelativePath(req);
        if (this.m_readOnly) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
            }
            return;
        }
        boolean exists = this.m_session.exists(path);
        if (!exists) {
            resp.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", path));
            }
            return;
        }
        if (this.isLocked(req)) {
            resp.setStatus(423);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_LOCKED_1", path));
            }
            return;
        }
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        this.checkChildLocks(req, path, errorList);
        if (!errorList.isEmpty()) {
            this.sendReport(req, resp, errorList);
            if (LOG.isDebugEnabled()) {
                for (String errorPath : errorList.keySet()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_CHILD_LOCKED_1", errorPath));
                }
            }
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_ITEM_0"));
            }
            this.m_session.delete(path);
        }
        catch (CmsVfsResourceNotFoundException rnfex) {
            resp.setStatus(404);
            return;
        }
        catch (CmsSecurityException sex) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_PERMISSION_0"));
            }
            return;
        }
        catch (CmsException ex) {
            resp.setStatus(500);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REPOSITORY_ERROR_2", METHOD_DELETE, path), (Throwable)ex);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_SUCCESS_0"));
        }
        resp.setStatus(204);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.serveResource(request, response, true);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.serveResource(request, response, false);
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        CmsRepositoryLockInfo lock;
        block57: {
            CmsRepositoryLockInfo currentLock;
            String path = this.getRelativePath(req);
            if (this.m_readOnly) {
                resp.setStatus(403);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
                }
                return;
            }
            if (this.isLocked(req)) {
                resp.setStatus(423);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_LOCKED_1", path));
                }
                return;
            }
            lock = new CmsRepositoryLockInfo();
            String depthStr = req.getHeader(HEADER_DEPTH);
            if (depthStr == null) {
                lock.setDepth(3);
            } else if (depthStr.equals("0")) {
                lock.setDepth(0);
            } else {
                lock.setDepth(3);
            }
            int lockDuration = -1;
            lock.setExpiresAt(System.currentTimeMillis() + (long)(lockDuration * 1000));
            boolean lockRequestType = false;
            Element lockInfoNode = null;
            try {
                Element rootElement;
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(new InputSource((InputStream)req.getInputStream()));
                lockInfoNode = rootElement = document.getRootElement();
            }
            catch (Exception e) {
                lockRequestType = true;
            }
            if (lockInfoNode != null) {
                Element currentElem;
                Iterator iter = lockInfoNode.elementIterator();
                Element lockScopeNode = null;
                Element lockTypeNode = null;
                Element lockOwnerNode = null;
                while (iter.hasNext()) {
                    currentElem = (Element)iter.next();
                    switch (currentElem.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            String nodeName = currentElem.getName();
                            if (nodeName.endsWith(TAG_LOCKSCOPE)) {
                                lockScopeNode = currentElem;
                            }
                            if (nodeName.endsWith(TAG_LOCKTYPE)) {
                                lockTypeNode = currentElem;
                            }
                            if (!nodeName.endsWith(TAG_OWNER)) break;
                            lockOwnerNode = currentElem;
                            break;
                        }
                    }
                }
                if (lockScopeNode != null) {
                    iter = lockScopeNode.elementIterator();
                    while (iter.hasNext()) {
                        currentElem = (Element)iter.next();
                        switch (currentElem.getNodeType()) {
                            case 3: {
                                break;
                            }
                            case 1: {
                                String tempScope = currentElem.getName();
                                if (tempScope.indexOf(58) != -1) {
                                    lock.setScope(tempScope.substring(tempScope.indexOf(58) + 1));
                                    break;
                                }
                                lock.setScope(tempScope);
                                break;
                            }
                        }
                    }
                    if (lock.getScope() == null) {
                        resp.setStatus(400);
                    }
                } else {
                    resp.setStatus(400);
                }
                if (lockTypeNode != null) {
                    iter = lockTypeNode.elementIterator();
                    while (iter.hasNext()) {
                        currentElem = (Element)iter.next();
                        switch (currentElem.getNodeType()) {
                            case 3: {
                                break;
                            }
                            case 1: {
                                String tempType = currentElem.getName();
                                if (tempType.indexOf(58) != -1) {
                                    lock.setType(tempType.substring(tempType.indexOf(58) + 1));
                                    break;
                                }
                                lock.setType(tempType);
                                break;
                            }
                        }
                    }
                    if (lock.getType() == null) {
                        resp.setStatus(400);
                    }
                } else {
                    resp.setStatus(400);
                }
                if (lockOwnerNode != null) {
                    iter = lockOwnerNode.elementIterator();
                    while (iter.hasNext()) {
                        currentElem = (Element)iter.next();
                        switch (currentElem.getNodeType()) {
                            case 3: {
                                lock.setOwner(lock.getOwner() + currentElem.getStringValue());
                                break;
                            }
                            case 1: {
                                lock.setOwner(lock.getOwner() + currentElem.getStringValue());
                                break;
                            }
                        }
                    }
                    if (lock.getOwner() == null) {
                        resp.setStatus(400);
                    }
                } else {
                    lock.setOwner("");
                }
            }
            lock.setPath(path);
            lock.setUsername(this.m_username);
            if (lockRequestType && (currentLock = this.m_session.getLock(path)) == null) {
                lockRequestType = false;
            }
            if (!lockRequestType) {
                try {
                    boolean result;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_LOCK_ITEM_1", lock.getOwner()));
                    }
                    if (result = this.m_session.lock(path, lock)) {
                        resp.addHeader(HEADER_LOCKTOKEN, "<opaquelocktoken:" + this.generateLockToken(req, lock) + ">");
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_LOCK_ITEM_FAILED_0"));
                        }
                        break block57;
                    }
                    resp.setStatus(423);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_LOCK_ITEM_SUCCESS_0"));
                    }
                    return;
                }
                catch (CmsVfsResourceNotFoundException rnfex) {
                    resp.setStatus(404);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", path));
                    }
                    return;
                }
                catch (CmsSecurityException sex) {
                    resp.setStatus(403);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_PERMISSION_0"));
                    }
                    return;
                }
                catch (CmsException ex) {
                    resp.setStatus(500);
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_REPOSITORY_ERROR_2", METHOD_LOCK, path), (Throwable)ex);
                    }
                    return;
                }
            }
        }
        Document doc = DocumentHelper.createDocument();
        Element propElem = doc.addElement(new QName(TAG_PROP, Namespace.get((String)DEFAULT_NAMESPACE)));
        Element lockElem = CmsWebdavServlet.addElement(propElem, TAG_LOCKDISCOVERY);
        this.addLockElement(lock, lockElem, this.generateLockToken(req, lock));
        resp.setStatus(200);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        doc.write((Writer)writer);
        ((Writer)writer).close();
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = this.getRelativePath(req);
        if (this.m_readOnly) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
            }
            resp.setStatus(403);
            return;
        }
        if (this.isLocked(req)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_LOCKED_1", path));
            }
            resp.setStatus(423);
            return;
        }
        boolean exists = this.m_session.exists(path);
        if (exists) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_EXISTS_1", path));
            }
            StringBuffer methodsAllowed = this.determineMethodsAllowed(this.getRelativePath(req));
            resp.addHeader(HEADER_ALLOW, methodsAllowed.toString());
            resp.setStatus(405);
            return;
        }
        if (req.getInputStream().available() > 0) {
            try {
                new SAXReader().read((InputStream)req.getInputStream());
                resp.setStatus(501);
                return;
            }
            catch (DocumentException de) {
                resp.setStatus(400);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_INVALID_CONTENT_0"));
                }
                return;
            }
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_COLLECTION_0"));
            }
            this.m_session.create(path);
        }
        catch (CmsVfsResourceAlreadyExistsException raeex) {
            resp.setStatus(412);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_EXISTS_1", path));
            }
            return;
        }
        catch (CmsSecurityException sex) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_PERMISSION_0"));
            }
            return;
        }
        catch (CmsException ex) {
            resp.setStatus(500);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REPOSITORY_ERROR_2", METHOD_MKCOL, path), (Throwable)ex);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_SUCCESS_0"));
        }
        resp.setStatus(201);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) {
        String src = this.getRelativePath(req);
        if (this.m_readOnly) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
            }
            return;
        }
        if (this.isLocked(req)) {
            resp.setStatus(423);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_LOCKED_1", src));
            }
            return;
        }
        String dest = this.parseDestinationHeader(req);
        if (dest == null) {
            resp.setStatus(400);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PARSE_DEST_HEADER_0"));
            }
            return;
        }
        if (dest.equals(src)) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SRC_DEST_EQUALS_0"));
            }
            return;
        }
        boolean overwrite = this.parseOverwriteHeader(req);
        if (!this.m_session.exists(src)) {
            resp.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", src));
            }
            return;
        }
        if (this.m_session.exists(dest) && !overwrite) {
            resp.setStatus(412);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEST_PATH_EXISTS_1", dest));
            }
            return;
        }
        if (!this.m_session.exists(dest) && overwrite) {
            resp.setStatus(201);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MOVE_ITEM_2", src, dest));
            }
            this.m_session.move(src, dest, overwrite);
        }
        catch (CmsVfsResourceNotFoundException rnfex) {
            resp.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", src));
            }
            return;
        }
        catch (CmsSecurityException sex) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_PERMISSION_0"));
            }
            return;
        }
        catch (CmsVfsResourceAlreadyExistsException raeex) {
            resp.setStatus(412);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_EXISTS_1", dest));
            }
            return;
        }
        catch (CmsException ex) {
            resp.setStatus(500);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REPOSITORY_ERROR_2", METHOD_MOVE, src), (Throwable)ex);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MOVE_ITEM_SUCCESS_0"));
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) {
        resp.addHeader("DAV", "1,2");
        StringBuffer methodsAllowed = this.determineMethodsAllowed(this.getRelativePath(req));
        resp.addHeader(HEADER_ALLOW, methodsAllowed.toString());
        resp.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean exists;
        String path = this.getRelativePath(req);
        if (!this.m_listings) {
            StringBuffer methodsAllowed = this.determineMethodsAllowed(this.getRelativePath(req));
            resp.addHeader(HEADER_ALLOW, methodsAllowed.toString());
            resp.setStatus(405);
            return;
        }
        Vector<String> properties = new Vector<String>();
        int depth = 3;
        int type = 1;
        String depthStr = req.getHeader(HEADER_DEPTH);
        if (depthStr == null) {
            depth = 3;
        } else if (depthStr.equals("0")) {
            depth = 0;
        } else if (depthStr.equals("1")) {
            depth = 1;
        } else if (depthStr.equalsIgnoreCase(DEPTH_INFINITY)) {
            depth = 3;
        }
        Element propNode = null;
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((InputStream)req.getInputStream());
            Element rootElement = document.getRootElement();
            Iterator iter = rootElement.elementIterator();
            while (iter.hasNext()) {
                Element currentElem = (Element)iter.next();
                switch (currentElem.getNodeType()) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        if (currentElem.getName().endsWith(TAG_PROP)) {
                            type = 0;
                            propNode = currentElem;
                        }
                        if (currentElem.getName().endsWith("propname")) {
                            type = 2;
                        }
                        if (!currentElem.getName().endsWith("allprop")) break;
                        type = 1;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (propNode != null && type == 0) {
            Iterator iter = propNode.elementIterator();
            while (iter.hasNext()) {
                Element currentElem = (Element)iter.next();
                switch (currentElem.getNodeType()) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        String nodeName = currentElem.getName();
                        String propertyName = null;
                        propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                        properties.add(propertyName);
                        break;
                    }
                }
            }
        }
        if (!(exists = this.m_session.exists(path))) {
            resp.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", path));
            }
            return;
        }
        I_CmsRepositoryItem item = null;
        try {
            item = this.m_session.getItem(path);
        }
        catch (CmsException e) {
            resp.setStatus(404);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        Document doc = DocumentHelper.createDocument();
        Element multiStatusElem = doc.addElement(new QName(TAG_MULTISTATUS, Namespace.get((String)"D", (String)DEFAULT_NAMESPACE)));
        if (depth == 0) {
            this.parseProperties(req, multiStatusElem, item, type, properties);
        } else {
            Stack<I_CmsRepositoryItem> stack = new Stack<I_CmsRepositoryItem>();
            stack.push(item);
            Stack<I_CmsRepositoryItem> stackBelow = new Stack<I_CmsRepositoryItem>();
            while (!stack.isEmpty() && depth >= 0) {
                I_CmsRepositoryItem currentItem = (I_CmsRepositoryItem)stack.pop();
                this.parseProperties(req, multiStatusElem, currentItem, type, properties);
                if (currentItem.isCollection() && depth > 0) {
                    try {
                        List<I_CmsRepositoryItem> list = this.m_session.list(currentItem.getName());
                        for (I_CmsRepositoryItem element : list) {
                            stackBelow.push(element);
                        }
                    }
                    catch (CmsException e) {
                        resp.setStatus(500);
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_LIST_ITEMS_ERROR_1", currentItem.getName()), (Throwable)e);
                        }
                        return;
                    }
                }
                if (!stack.isEmpty()) continue;
                --depth;
                stack = stackBelow;
                stackBelow = new Stack();
            }
        }
        PrintWriter writer = resp.getWriter();
        doc.write((Writer)writer);
        ((Writer)writer).close();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) {
        if (this.m_readOnly) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
            }
            return;
        }
        if (this.isLocked(req)) {
            resp.setStatus(423);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_LOCKED_1", this.getRelativePath(req)));
            }
            return;
        }
        resp.setStatus(501);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean result;
        boolean exists;
        block17: {
            String path = this.getRelativePath(req);
            if (this.m_readOnly) {
                resp.setStatus(403);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
                }
                return;
            }
            if (this.isLocked(req)) {
                resp.setStatus(423);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_LOCKED_1", path));
                }
                return;
            }
            exists = this.m_session.exists(path);
            result = true;
            File contentFile = null;
            CmsWebdavRange range = this.parseContentRange(req, resp);
            Object resourceInputStream = null;
            if (range != null) {
                contentFile = this.executePartialPut(req, range, path);
                resourceInputStream = new FileInputStream(contentFile);
            } else {
                resourceInputStream = req.getInputStream();
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SAVE_ITEM_0"));
                }
                this.m_session.save(path, (InputStream)resourceInputStream, exists);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REPOSITORY_ERROR_2", METHOD_PUT, path), (Throwable)e);
                }
                result = false;
                resp.setStatus(409);
            }
            if (contentFile != null) {
                try {
                    contentFile.delete();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block17;
                    LOG.error((Object)Messages.get().getBundle().key("LOG_DELETE_TEMP_FILE_0"), (Throwable)e);
                }
            }
        }
        if (result) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SAVE_SUCCESS_0"));
            }
            if (exists) {
                resp.setStatus(204);
            } else {
                resp.setStatus(201);
            }
        }
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) {
        String path = this.getRelativePath(req);
        if (this.m_readOnly) {
            resp.setStatus(403);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_WEBDAV_READ_ONLY_0"));
            }
            return;
        }
        if (this.isLocked(req)) {
            resp.setStatus(423);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_LOCKED_1", path));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_UNLOCK_ITEM_0"));
        }
        this.m_session.unlock(path);
        resp.setStatus(204);
    }

    protected File executePartialPut(HttpServletRequest req, CmsWebdavRange range, String path) throws IOException {
        int numBytesRead;
        ByteArrayInputStream oldResourceStream;
        RandomAccessFile randAccessContentFile;
        File contentFile;
        block5: {
            File tempDir = (File)this.getServletContext().getAttribute(ATT_SERVLET_TEMPDIR);
            String convertedResourcePath = path.replace('/', '.');
            contentFile = new File(tempDir, convertedResourcePath);
            contentFile.createNewFile();
            randAccessContentFile = new RandomAccessFile(contentFile, "rw");
            oldResourceStream = null;
            try {
                I_CmsRepositoryItem item = this.m_session.getItem(path);
                oldResourceStream = new ByteArrayInputStream(item.getContent());
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", path), (Throwable)e);
            }
        }
        if (oldResourceStream != null) {
            int numBytesRead2;
            byte[] copyBuffer = new byte[4096];
            while ((numBytesRead2 = oldResourceStream.read(copyBuffer)) != -1) {
                randAccessContentFile.write(copyBuffer, 0, numBytesRead2);
            }
            ((InputStream)oldResourceStream).close();
        }
        randAccessContentFile.setLength(range.getLength());
        randAccessContentFile.seek(range.getStart());
        byte[] transferBuffer = new byte[4096];
        BufferedInputStream requestBufInStream = new BufferedInputStream((InputStream)req.getInputStream(), 4096);
        while ((numBytesRead = requestBufInStream.read(transferBuffer)) != -1) {
            randAccessContentFile.write(transferBuffer, 0, numBytesRead);
        }
        randAccessContentFile.close();
        requestBufInStream.close();
        return contentFile;
    }

    protected String getETag(I_CmsRepositoryItem item) {
        return "\"" + item.getContentLength() + "-" + item.getLastModifiedDate() + "\"";
    }

    protected ArrayList<CmsWebdavRange> parseRange(HttpServletRequest request, HttpServletResponse response, I_CmsRepositoryItem item) {
        long fileLength;
        String headerValue = request.getHeader(HEADER_IFRANGE);
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader(HEADER_IFRANGE);
            }
            catch (Exception e) {
                // empty catch block
            }
            String eTag = this.getETag(item);
            long lastModified = item.getLastModifiedDate();
            if (headerValueTime == -1L ? !eTag.equals(headerValue.trim()) : lastModified > headerValueTime + 1000L) {
                return FULL_RANGE;
            }
        }
        if ((fileLength = item.getContentLength()) == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader(HEADER_RANGE);
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader(HEADER_CONTENTRANGE, "bytes */" + fileLength);
            response.setStatus(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<CmsWebdavRange> result = new ArrayList<CmsWebdavRange>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            CmsWebdavRange currentRange = new CmsWebdavRange();
            currentRange.setLength(fileLength);
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader(HEADER_CONTENTRANGE, "bytes */" + fileLength);
                response.setStatus(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.setStart(fileLength + offset);
                    currentRange.setEnd(fileLength - 1L);
                }
                catch (NumberFormatException e) {
                    response.addHeader(HEADER_CONTENTRANGE, "bytes */" + fileLength);
                    response.setStatus(416);
                    return null;
                }
            }
            try {
                currentRange.setStart(Long.parseLong(rangeDefinition.substring(0, dashPos)));
                if (dashPos < rangeDefinition.length() - 1) {
                    currentRange.setEnd(Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())));
                } else {
                    currentRange.setEnd(fileLength - 1L);
                }
            }
            catch (NumberFormatException e) {
                response.addHeader(HEADER_CONTENTRANGE, "bytes */" + fileLength);
                response.setStatus(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader(HEADER_CONTENTRANGE, "bytes */" + fileLength);
                response.setStatus(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    protected InputStream renderHtml(String contextPath, String path) throws IOException {
        int slash;
        String name = path;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osWriter = null;
        try {
            osWriter = new OutputStreamWriter((OutputStream)stream, "UTF8");
        }
        catch (Exception e) {
            osWriter = new OutputStreamWriter(stream);
        }
        PrintWriter writer = new PrintWriter(osWriter);
        StringBuffer sb = new StringBuffer();
        String rewrittenContextPath = this.rewriteUrl(contextPath);
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>");
        sb.append(Messages.get().getBundle().key("GUI_DIRECTORY_TITLE_1", name));
        sb.append("</title>\r\n");
        sb.append("<STYLE><!--");
        sb.append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}");
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append(Messages.get().getBundle().key("GUI_DIRECTORY_TITLE_1", name));
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append(Messages.get().getBundle().key("GUI_DIRECTORY_FILENAME_0"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
        sb.append(Messages.get().getBundle().key("GUI_DIRECTORY_SIZE_0"));
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
        sb.append(Messages.get().getBundle().key("GUI_DIRECTORY_LASTMODIFIED_0"));
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        boolean shade = false;
        String parentDirectory = name;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0) {
            String parent = parentDirectory.substring(0, slash);
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor=\"#eeeeee\"");
            }
            sb.append(">\r\n");
            shade = !shade;
            sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
            sb.append("<a href=\"");
            sb.append(rewrittenContextPath);
            if (parent.equals("")) {
                parent = "/";
            }
            sb.append(this.rewriteUrl(parent));
            if (!parent.endsWith("/")) {
                sb.append("/");
            }
            sb.append("\"><tt>");
            sb.append("..");
            sb.append("</tt></a></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            sb.append("&nbsp;");
            sb.append("</tt></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            sb.append("&nbsp;");
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
        }
        try {
            List<I_CmsRepositoryItem> list = this.m_session.list(path);
            for (I_CmsRepositoryItem childItem : list) {
                String resourceName = childItem.getName();
                if (resourceName.endsWith("/")) {
                    resourceName = resourceName.substring(0, resourceName.length() - 1);
                }
                if ((slash = resourceName.lastIndexOf(47)) > -1) {
                    resourceName = resourceName.substring(slash + 1, resourceName.length());
                }
                sb.append("<tr");
                if (shade) {
                    sb.append(" bgcolor=\"#eeeeee\"");
                }
                sb.append(">\r\n");
                shade = !shade;
                sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
                sb.append("<a href=\"");
                sb.append(rewrittenContextPath);
                sb.append(this.rewriteUrl(name + resourceName));
                if (childItem.isCollection()) {
                    sb.append("/");
                }
                sb.append("\"><tt>");
                sb.append(CmsEncoder.escapeXml(resourceName));
                if (childItem.isCollection()) {
                    sb.append("/");
                }
                sb.append("</tt></a></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                if (childItem.isCollection()) {
                    sb.append("&nbsp;");
                } else {
                    sb.append(this.renderSize(childItem.getContentLength()));
                }
                sb.append("</tt></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                sb.append(HTTP_DATE_FORMAT.format(new Date(childItem.getLastModifiedDate())));
                sb.append("</tt></td>\r\n");
                sb.append("</tr>\r\n");
            }
        }
        catch (CmsException e) {
            e.printStackTrace();
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        writer.write(sb.toString());
        writer.flush();
        return new ByteArrayInputStream(stream.toByteArray());
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return "" + leftSide + "." + rightSide + " kb";
    }

    protected String rewriteUrl(String path) throws UnsupportedEncodingException {
        return new String(URLCodec.encodeUrl((BitSet)URL_SAFE_CHARS, (byte[])path.getBytes("ISO-8859-1")));
    }

    protected void serveResource(HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException {
        String path = this.getRelativePath(request);
        if (LOG.isDebugEnabled()) {
            if (content) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SERVE_ITEM_1", path));
            } else {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SERVE_ITEM_HEADER_1", path));
            }
        }
        I_CmsRepositoryItem item = null;
        try {
            item = this.m_session.getItem(path);
        }
        catch (CmsException ex) {
            response.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", path));
            }
            return;
        }
        if (!item.isCollection() && (path.endsWith("/") || path.endsWith("\\"))) {
            response.setStatus(404);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ITEM_NOT_FOUND_1", path));
            }
            return;
        }
        String contentType = item.getMimeType();
        if (contentType == null) {
            contentType = this.getServletContext().getMimeType(item.getName());
        }
        ArrayList<CmsWebdavRange> ranges = null;
        long contentLength = -1L;
        if (item.isCollection()) {
            if (!this.m_listings) {
                response.setStatus(404);
                return;
            }
            contentType = "text/html;charset=UTF-8";
        } else {
            ranges = this.parseRange(request, response, item);
            response.setHeader(HEADER_ETAG, this.getETag(item));
            response.setHeader(HEADER_LASTMODIFIED, HTTP_DATE_FORMAT.format(new Date(item.getLastModifiedDate())));
            contentLength = item.getContentLength();
            if (contentLength == 0L) {
                content = false;
            }
        }
        ServletOutputStream ostream = null;
        PrintWriter writer = null;
        if (content) {
            try {
                ostream = response.getOutputStream();
            }
            catch (IllegalStateException e) {
                if (contentType == null || contentType.startsWith("text") || contentType.endsWith("xml")) {
                    writer = response.getWriter();
                }
                throw e;
            }
        }
        if (item.isCollection() || (ranges == null || ranges.isEmpty()) && request.getHeader(HEADER_RANGE) == null || ranges == FULL_RANGE) {
            if (contentType != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SERVE_ITEM_CONTENT_TYPE_1", contentType));
                }
                response.setContentType(contentType);
            }
            if (!item.isCollection() && contentLength >= 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SERVE_ITEM_CONTENT_LENGTH_1", new Long(contentLength)));
                }
                if (contentLength < Integer.MAX_VALUE) {
                    response.setContentLength((int)contentLength);
                } else {
                    response.setHeader(HEADER_CONTENTLENGTH, "" + contentLength);
                }
            }
            InputStream renderResult = null;
            if (item.isCollection() && content) {
                renderResult = this.renderHtml(request.getContextPath() + request.getServletPath(), item.getName());
            }
            if (content) {
                try {
                    response.setBufferSize(this.m_output);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                if (ostream != null) {
                    this.copy(item, renderResult, ostream);
                } else {
                    this.copy(item, renderResult, writer);
                }
            }
        } else {
            if (ranges == null || ranges.isEmpty()) {
                return;
            }
            response.setStatus(206);
            if (ranges.size() == 1) {
                CmsWebdavRange range = ranges.get(0);
                response.addHeader(HEADER_CONTENTRANGE, "bytes " + range.getStart() + "-" + range.getEnd() + "/" + range.getLength());
                long length = range.getEnd() - range.getStart() + 1L;
                if (length < Integer.MAX_VALUE) {
                    response.setContentLength((int)length);
                } else {
                    response.setHeader(HEADER_CONTENTLENGTH, "" + length);
                }
                if (contentType != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_SERVE_ITEM_CONTENT_TYPE_1", contentType));
                    }
                    response.setContentType(contentType);
                }
                if (content) {
                    try {
                        response.setBufferSize(this.m_output);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        this.copy(item, ostream, range);
                    } else {
                        this.copy(item, writer, range);
                    }
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                if (content) {
                    try {
                        response.setBufferSize(this.m_output);
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    if (ostream != null) {
                        this.copy(item, ostream, ranges.iterator(), contentType);
                    } else {
                        this.copy(item, writer, ranges.iterator(), contentType);
                    }
                }
            }
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String auth;
        String method = req.getMethod();
        if (LOG.isDebugEnabled()) {
            String path = this.getRelativePath(req);
            LOG.debug((Object)("[" + method + "] " + path));
        }
        if ((auth = req.getHeader(HEADER_AUTHORIZATION)) == null || !auth.toUpperCase().startsWith(AUTHORIZATION_BASIC_PREFIX)) {
            this.requestAuthorization(resp);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_NO_AUTHORIZATION_0"));
            }
            return;
        }
        String base64Token = auth.substring(6);
        String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
        String password = null;
        int pos = token.indexOf(SEPARATOR_CREDENTIALS);
        if (pos != -1) {
            this.m_username = token.substring(0, pos);
            password = token.substring(pos + 1);
        }
        try {
            this.m_session = m_repository.login(this.m_username, password);
        }
        catch (CmsException ex) {
            this.m_session = null;
        }
        if (this.m_session == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_LOGIN_FAILED_1", this.m_username));
            }
            resp.setStatus(403);
            return;
        }
        if (method.equals(METHOD_PROPFIND)) {
            this.doPropfind(req, resp);
        } else if (method.equals(METHOD_PROPPATCH)) {
            this.doProppatch(req, resp);
        } else if (method.equals(METHOD_MKCOL)) {
            this.doMkcol(req, resp);
        } else if (method.equals(METHOD_COPY)) {
            this.doCopy(req, resp);
        } else if (method.equals(METHOD_MOVE)) {
            this.doMove(req, resp);
        } else if (method.equals(METHOD_LOCK)) {
            this.doLock(req, resp);
        } else if (method.equals(METHOD_UNLOCK)) {
            this.doUnlock(req, resp);
        } else {
            super.service(req, resp);
        }
    }

    private void addLockElement(CmsRepositoryLockInfo lock, Element parent, String lockToken) {
        Element activeLockElem = CmsWebdavServlet.addElement(parent, TAG_ACTIVELOCK);
        CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(activeLockElem, TAG_LOCKTYPE), lock.getType());
        CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(activeLockElem, TAG_LOCKSCOPE), lock.getScope());
        if (lock.getDepth() == 3) {
            CmsWebdavServlet.addElement(activeLockElem, TAG_DEPTH).addText(DEPTH_INFINITY);
        } else {
            CmsWebdavServlet.addElement(activeLockElem, TAG_DEPTH).addText("0");
        }
        Element ownerElem = CmsWebdavServlet.addElement(activeLockElem, TAG_OWNER);
        CmsWebdavServlet.addElement(ownerElem, TAG_HREF).addText(lock.getOwner());
        if (lock.getExpiresAt() == -1L) {
            CmsWebdavServlet.addElement(activeLockElem, TAG_TIMEOUT).addText(TIMEOUT_INFINITE);
        } else {
            long timeout = (lock.getExpiresAt() - System.currentTimeMillis()) / 1000L;
            CmsWebdavServlet.addElement(activeLockElem, TAG_TIMEOUT).addText("Second-" + timeout);
        }
        Element lockTokenElem = CmsWebdavServlet.addElement(activeLockElem, TAG_LOCKTOKEN);
        CmsWebdavServlet.addElement(lockTokenElem, TAG_HREF).addText("opaquelocktoken:" + lockToken);
    }

    private void checkChildLocks(HttpServletRequest req, String path, Hashtable<String, Integer> errorList) {
        List<I_CmsRepositoryItem> list = null;
        try {
            list = this.m_session.list(path);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_LIST_ITEMS_ERROR_1", path), (Throwable)e);
            }
            errorList.put(path, new Integer(500));
            return;
        }
        for (I_CmsRepositoryItem element : list) {
            if (this.isLocked(element.getName())) {
                errorList.put(element.getName(), new Integer(423));
                continue;
            }
            if (!element.isCollection()) continue;
            this.checkChildLocks(req, element.getName(), errorList);
        }
    }

    private StringBuffer determineMethodsAllowed(String path) {
        StringBuffer methodsAllowed = new StringBuffer();
        boolean exists = true;
        I_CmsRepositoryItem item = null;
        try {
            item = this.m_session.getItem(path);
        }
        catch (CmsException e) {
            exists = false;
        }
        if (!exists) {
            methodsAllowed.append(METHOD_OPTIONS);
            methodsAllowed.append(", ").append(METHOD_PUT);
            methodsAllowed.append(", ").append(METHOD_MKCOL);
            methodsAllowed.append(", ").append(METHOD_LOCK);
            return methodsAllowed;
        }
        methodsAllowed.append(METHOD_OPTIONS);
        methodsAllowed.append(", ").append(METHOD_GET);
        methodsAllowed.append(", ").append(METHOD_HEAD);
        methodsAllowed.append(", ").append(METHOD_POST);
        methodsAllowed.append(", ").append(METHOD_DELETE);
        methodsAllowed.append(", ").append(METHOD_TRACE);
        methodsAllowed.append(", ").append(METHOD_LOCK);
        methodsAllowed.append(", ").append(METHOD_UNLOCK);
        methodsAllowed.append(", ").append(METHOD_MOVE);
        methodsAllowed.append(", ").append(METHOD_COPY);
        methodsAllowed.append(", ").append(METHOD_PROPPATCH);
        if (this.m_listings) {
            methodsAllowed.append(", ").append(METHOD_PROPFIND);
        }
        if (item != null && !item.isCollection()) {
            methodsAllowed.append(", ").append(METHOD_PUT);
        }
        return methodsAllowed;
    }

    private boolean generateLockDiscovery(String path, Element elem, HttpServletRequest req) {
        CmsRepositoryLockInfo lock = this.m_session.getLock(path);
        if (lock != null) {
            Element lockElem = CmsWebdavServlet.addElement(elem, TAG_LOCKDISCOVERY);
            this.addLockElement(lock, lockElem, this.generateLockToken(req, lock));
            return true;
        }
        return false;
    }

    private String generateLockToken(HttpServletRequest req, CmsRepositoryLockInfo lock) {
        String lockTokenStr = req.getServletPath() + "-" + req.getUserPrincipal() + "-" + lock.getOwner() + "-" + lock.getPath() + "-" + this.m_secret;
        return MD5_ENCODER.encode(m_md5Helper.digest(lockTokenStr.getBytes()));
    }

    private String getRelativePath(HttpServletRequest request) {
        String result = request.getPathInfo();
        if (result == null) {
            // empty if block
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    private boolean isLocked(HttpServletRequest req) {
        return this.isLocked(this.getRelativePath(req));
    }

    private boolean isLocked(String path) {
        CmsRepositoryLockInfo lock = this.m_session.getLock(path);
        if (lock == null) {
            return false;
        }
        return !lock.getUsername().equals(this.m_username);
    }

    private String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    private CmsWebdavRange parseContentRange(HttpServletRequest request, HttpServletResponse response) {
        String rangeHeader = request.getHeader(HEADER_CONTENTRANGE);
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.setStatus(400);
            return null;
        }
        rangeHeader = rangeHeader.substring(6).trim();
        int dashPos = rangeHeader.indexOf(45);
        int slashPos = rangeHeader.indexOf(47);
        if (dashPos == -1) {
            response.setStatus(400);
            return null;
        }
        if (slashPos == -1) {
            response.setStatus(400);
            return null;
        }
        CmsWebdavRange range = new CmsWebdavRange();
        try {
            range.setStart(Long.parseLong(rangeHeader.substring(0, dashPos)));
            range.setEnd(Long.parseLong(rangeHeader.substring(dashPos + 1, slashPos)));
            range.setLength(Long.parseLong(rangeHeader.substring(slashPos + 1, rangeHeader.length())));
        }
        catch (NumberFormatException e) {
            response.setStatus(400);
            return null;
        }
        if (!range.validate()) {
            response.setStatus(400);
            return null;
        }
        return range;
    }

    private String parseDestinationHeader(HttpServletRequest req) {
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader(HEADER_DESTINATION);
        if (destinationPath == null) {
            return null;
        }
        int protocolIndex = (destinationPath = CmsEncoder.decode(destinationPath, "UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(SEPARATOR_CREDENTIALS)) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(SEPARATOR_CREDENTIALS)) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = this.normalize(destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        return destinationPath;
    }

    private boolean parseOverwriteHeader(HttpServletRequest req) {
        boolean overwrite = true;
        String overwriteHeader = req.getHeader(HEADER_OVERWRITE);
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        return overwrite;
    }

    private void parseProperties(HttpServletRequest req, Element elem, I_CmsRepositoryItem item, int type, List<String> propertiesVector) {
        String path = item.getName();
        Element responseElem = CmsWebdavServlet.addElement(elem, TAG_RESPONSE);
        String status = "HTTP/1.1 200 " + CmsWebdavStatus.getStatusText(200);
        Element hrefElem = CmsWebdavServlet.addElement(responseElem, TAG_HREF);
        String href = req.getContextPath() + req.getServletPath();
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        try {
            hrefElem.addText(this.rewriteUrl(href));
        }
        catch (UnsupportedEncodingException ex) {
            return;
        }
        String resourceName = path;
        Element propstatElem = CmsWebdavServlet.addElement(responseElem, TAG_PROPSTAT);
        Element propElem = CmsWebdavServlet.addElement(propstatElem, TAG_PROP);
        switch (type) {
            case 1: {
                CmsWebdavServlet.addElement(propElem, TAG_CREATIONDATE).addText(ISO8601_FORMAT.format(new Date(item.getCreationDate())));
                CmsWebdavServlet.addElement(propElem, TAG_DISPLAYNAME).addCDATA(resourceName);
                if (!item.isCollection()) {
                    CmsWebdavServlet.addElement(propElem, TAG_LASTMODIFIED).addText(HTTP_DATE_FORMAT.format(new Date(item.getLastModifiedDate())));
                    CmsWebdavServlet.addElement(propElem, TAG_CONTENTLENGTH).addText(String.valueOf(item.getContentLength()));
                    String contentType = this.getServletContext().getMimeType(item.getName());
                    if (contentType != null) {
                        CmsWebdavServlet.addElement(propElem, TAG_CONTENTTYPE).addText(contentType);
                    }
                    CmsWebdavServlet.addElement(propElem, TAG_ETAG).addText(this.getETag(item));
                    CmsWebdavServlet.addElement(propElem, TAG_RESOURCETYPE);
                } else {
                    CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(propElem, TAG_RESOURCETYPE), TAG_COLLECTION);
                }
                CmsWebdavServlet.addElement(propElem, TAG_SOURCE).addText("");
                Element suppLockElem = CmsWebdavServlet.addElement(propElem, TAG_SUPPORTEDLOCK);
                Element lockEntryElem = CmsWebdavServlet.addElement(suppLockElem, TAG_LOCKENTRY);
                CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKSCOPE), "exclusive");
                CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKTYPE), "write");
                lockEntryElem = CmsWebdavServlet.addElement(suppLockElem, TAG_LOCKENTRY);
                CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKSCOPE), "shared");
                CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKTYPE), "write");
                this.generateLockDiscovery(path, propElem, req);
                CmsWebdavServlet.addElement(propstatElem, TAG_STATUS).addText(status);
                break;
            }
            case 2: {
                CmsWebdavServlet.addElement(propElem, TAG_CREATIONDATE);
                CmsWebdavServlet.addElement(propElem, TAG_DISPLAYNAME);
                if (!item.isCollection()) {
                    CmsWebdavServlet.addElement(propElem, TAG_CONTENTLANGUAGE);
                    CmsWebdavServlet.addElement(propElem, TAG_CONTENTLENGTH);
                    CmsWebdavServlet.addElement(propElem, TAG_CONTENTTYPE);
                    CmsWebdavServlet.addElement(propElem, TAG_ETAG);
                }
                CmsWebdavServlet.addElement(propElem, TAG_LASTMODIFIED);
                CmsWebdavServlet.addElement(propElem, TAG_RESOURCETYPE);
                CmsWebdavServlet.addElement(propElem, TAG_SOURCE);
                CmsWebdavServlet.addElement(propElem, TAG_LOCKDISCOVERY);
                CmsWebdavServlet.addElement(propstatElem, TAG_STATUS).addText(status);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                for (String property : propertiesVector) {
                    if (property.equals(TAG_CREATIONDATE)) {
                        CmsWebdavServlet.addElement(propElem, TAG_CREATIONDATE).addText(ISO8601_FORMAT.format(new Date(item.getCreationDate())));
                        continue;
                    }
                    if (property.equals(TAG_DISPLAYNAME)) {
                        CmsWebdavServlet.addElement(propElem, TAG_DISPLAYNAME).addCDATA(resourceName);
                        continue;
                    }
                    if (property.equals(TAG_CONTENTLANGUAGE)) {
                        if (item.isCollection()) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        CmsWebdavServlet.addElement(propElem, TAG_CONTENTLANGUAGE);
                        continue;
                    }
                    if (property.equals(TAG_CONTENTLENGTH)) {
                        if (item.isCollection()) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        CmsWebdavServlet.addElement(propElem, TAG_CONTENTLENGTH).addText(String.valueOf(item.getContentLength()));
                        continue;
                    }
                    if (property.equals(TAG_CONTENTTYPE)) {
                        if (item.isCollection()) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        String contentType = item.getMimeType();
                        if (contentType == null) {
                            contentType = this.getServletContext().getMimeType(item.getName());
                        }
                        if (contentType == null) continue;
                        CmsWebdavServlet.addElement(propElem, TAG_CONTENTTYPE).addText(contentType);
                        continue;
                    }
                    if (property.equals(TAG_ETAG)) {
                        if (item.isCollection()) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        CmsWebdavServlet.addElement(propElem, TAG_ETAG).addText(this.getETag(item));
                        continue;
                    }
                    if (property.equals(TAG_LASTMODIFIED)) {
                        CmsWebdavServlet.addElement(propElem, TAG_LASTMODIFIED).addText(HTTP_DATE_FORMAT.format(new Date(item.getLastModifiedDate())));
                        continue;
                    }
                    if (property.equals(TAG_RESOURCETYPE)) {
                        if (item.isCollection()) {
                            CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(propElem, TAG_RESOURCETYPE), TAG_COLLECTION);
                            continue;
                        }
                        CmsWebdavServlet.addElement(propElem, TAG_RESOURCETYPE);
                        continue;
                    }
                    if (property.equals(TAG_SOURCE)) {
                        CmsWebdavServlet.addElement(propElem, TAG_SOURCE).addText("");
                        continue;
                    }
                    if (property.equals(TAG_SUPPORTEDLOCK)) {
                        Element suppLockElem = CmsWebdavServlet.addElement(propElem, TAG_SUPPORTEDLOCK);
                        Element lockEntryElem = CmsWebdavServlet.addElement(suppLockElem, TAG_LOCKENTRY);
                        CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKSCOPE), "exclusive");
                        CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKTYPE), "write");
                        lockEntryElem = CmsWebdavServlet.addElement(suppLockElem, TAG_LOCKENTRY);
                        CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKSCOPE), "shared");
                        CmsWebdavServlet.addElement(CmsWebdavServlet.addElement(lockEntryElem, TAG_LOCKTYPE), "write");
                        continue;
                    }
                    if (property.equals(TAG_LOCKDISCOVERY)) {
                        if (this.generateLockDiscovery(path, propElem, req)) continue;
                        CmsWebdavServlet.addElement(propElem, TAG_LOCKDISCOVERY);
                        continue;
                    }
                    propertiesNotFound.add(property);
                }
                CmsWebdavServlet.addElement(propstatElem, TAG_STATUS).addText(status);
                if (propertiesNotFound.size() <= 0) break;
                status = "HTTP/1.1 404 " + CmsWebdavStatus.getStatusText(404);
                propstatElem = CmsWebdavServlet.addElement(responseElem, TAG_PROPSTAT);
                propElem = CmsWebdavServlet.addElement(propstatElem, TAG_PROP);
                Iterator notFoundIter = propertiesNotFound.iterator();
                while (notFoundIter.hasNext()) {
                    CmsWebdavServlet.addElement(propElem, (String)notFoundIter.next());
                }
                CmsWebdavServlet.addElement(propstatElem, TAG_STATUS).addText(status);
                break;
            }
            default: {
                if (!LOG.isErrorEnabled()) break;
                LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_PROPFIND_TYPE_0"));
            }
        }
    }

    private void requestAuthorization(HttpServletResponse resp) throws IOException {
        resp.setHeader("WWW-Authenticate", "Basic realm=\"OpenCms WebDAV Servlet\"");
        resp.sendError(401);
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Map<String, Integer> errors) throws IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        Document doc = DocumentHelper.createDocument();
        Element multiStatusElem = doc.addElement(new QName(TAG_MULTISTATUS, Namespace.get((String)DEFAULT_NAMESPACE)));
        for (Map.Entry<String, Integer> e : errors.entrySet()) {
            String errorPath = e.getKey();
            int errorCode = e.getValue();
            Element responseElem = CmsWebdavServlet.addElement(multiStatusElem, TAG_RESPONSE);
            String toAppend = errorPath.substring(relativePath.length());
            if (!toAppend.startsWith("/")) {
                toAppend = "/" + toAppend;
            }
            CmsWebdavServlet.addElement(responseElem, TAG_HREF).addText(absoluteUri + toAppend);
            CmsWebdavServlet.addElement(responseElem, TAG_STATUS).addText("HTTP/1.1 " + errorCode + " " + CmsWebdavStatus.getStatusText(errorCode));
        }
        PrintWriter writer = resp.getWriter();
        doc.write((Writer)writer);
        ((Writer)writer).close();
    }

    static {
        MD5_ENCODER = new CmsMD5Encoder();
        FULL_RANGE = new ArrayList();
        LOG = CmsLog.getLog(CmsWebdavServlet.class);
        URL_SAFE_CHARS = new BitSet();
        URL_SAFE_CHARS.set(97, 123);
        URL_SAFE_CHARS.set(65, 91);
        URL_SAFE_CHARS.set(48, 58);
        URL_SAFE_CHARS.set(45);
        URL_SAFE_CHARS.set(95);
        URL_SAFE_CHARS.set(46);
        URL_SAFE_CHARS.set(42);
        URL_SAFE_CHARS.set(47);
        URL_SAFE_CHARS.set(58);
        ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        ISO8601_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        HTTP_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        HTTP_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

