/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsGalleryWidgetConfiguration;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsDialog;
import org.opencms.xml.types.I_CmsXmlContentValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class A_CmsAdeGalleryWidget
extends A_CmsWidget {
    private CmsGalleryWidgetConfiguration m_widgetConfiguration;
    protected static final String PATH_GALLERY_JSP = "/system/modules/org.opencms.ade.galleries/gallery.jsp";
    private static final Log LOG = CmsLog.getLog(A_CmsAdeGalleryWidget.class);

    public A_CmsAdeGalleryWidget() {
        this("");
    }

    protected A_CmsAdeGalleryWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        long idHash = id.hashCode();
        if (idHash < 0L) {
            idHash = -idHash;
            idHash += 0x100000000L;
        }
        StringBuffer result = new StringBuffer(512);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"xmlTd\">");
        result.append("<input class=\"xmlInput textInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        String value = param.getStringValue(cms);
        result.append(value);
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" onkeyup=\"checkPreview('");
        result.append(id);
        result.append("');\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button(this.getOpenGalleryCall(cms, widgetDialog, param, idHash), null, this.getGalleryName() + "gallery", Messages.getButtonName(this.getGalleryName()), widgetDialog.getButtonStyle()));
        String previewClass = "hide";
        if (CmsStringUtil.isNotEmpty(value) && value.startsWith("/")) {
            previewClass = "show";
        }
        result.append("<td class=\"");
        result.append(previewClass);
        result.append("\" id=\"preview");
        result.append(id);
        result.append("\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button(this.getOpenPreviewCall(widgetDialog, param.getId()), null, "preview.png", "GUI_BUTTON_PREVIEW_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        result.append("</tr></table>");
        result.append("</td>");
        JSONObject additional = null;
        try {
            additional = this.getAdditionalGalleryInfo(cms, widgetDialog, param);
        }
        catch (JSONException e) {
            LOG.error((Object)"Error parsing widget configuration", (Throwable)e);
        }
        if (additional != null) {
            result.append("\n<script type=\"text/javascript\">\n");
            result.append("var cms_additional_").append(idHash).append("=");
            result.append(additional.toString()).append(";\n");
            result.append("</script>");
        }
        return result.toString();
    }

    public abstract String getGalleryName();

    protected abstract JSONObject getAdditionalGalleryInfo(CmsObject var1, I_CmsWidgetDialog var2, I_CmsWidgetParameter var3) throws JSONException;

    protected Map<String, String> getGalleryOpenParams(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param, long hashId) {
        CmsGalleryWidgetConfiguration configuration;
        String paramResource;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(GALLERY_PARAM.dialogmode.name(), "widget");
        result.put(GALLERY_PARAM.types.name(), this.getGalleryTypes());
        result.put(GALLERY_PARAM.fieldid.name(), param.getId());
        result.put(GALLERY_PARAM.hashid.name(), "" + hashId);
        result.put(GALLERY_PARAM.currentelement.name(), "'+document.getElementById('" + param.getId() + "').getAttribute('value')+'");
        if (widgetDialog instanceof CmsDialog && CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramResource = ((CmsDialog)((Object)widgetDialog)).getParamResource())) {
            result.put(GALLERY_PARAM.resource.name(), paramResource);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((configuration = this.getWidgetConfiguration(cms, widgetDialog, param)).getStartup())) {
            result.put(GALLERY_PARAM.gallerypath.name(), configuration.getStartup());
        }
        return result;
    }

    protected abstract String getGalleryTypes();

    protected String getOpenGalleryCall(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param, long hashId) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("javascript:cmsOpenDialog('");
        sb.append(widgetDialog.getMessages().key(Messages.getButtonName(this.getGalleryName()))).append("', '");
        sb.append(OpenCms.getSystemInfo().getOpenCmsContext()).append(PATH_GALLERY_JSP);
        Locale contentLocale = widgetDialog.getLocale();
        try {
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)((Object)param);
            contentLocale = value.getLocale();
        }
        catch (Exception e) {
            // empty catch block
        }
        sb.append("?__locale=").append(contentLocale.toString());
        for (Map.Entry<String, String> paramEntry : this.getGalleryOpenParams(cms, widgetDialog, param, hashId).entrySet()) {
            sb.append("&").append(paramEntry.getKey()).append("=").append(paramEntry.getValue());
        }
        sb.append("', '").append(param.getId()).append("', 488, 650); return false;");
        return sb.toString();
    }

    protected String getOpenPreviewCall(I_CmsWidgetDialog widgetDialog, String id) {
        StringBuffer sb = new StringBuffer(64);
        sb.append("javascript:cmsOpenPreview('").append(widgetDialog.getMessages().key("GUI_BUTTON_PREVIEW_0"));
        sb.append("', '").append(OpenCms.getSystemInfo().getOpenCmsContext());
        sb.append("', '").append(id);
        sb.append("'); return false;");
        return sb.toString();
    }

    protected CmsGalleryWidgetConfiguration getWidgetConfiguration(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        if (this.m_widgetConfiguration == null) {
            this.m_widgetConfiguration = new CmsGalleryWidgetConfiguration(cms, widgetDialog, param, this.getConfiguration());
        }
        return this.m_widgetConfiguration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GALLERY_PARAM {
        currentelement,
        dialogmode,
        fieldid,
        gallerypath,
        hashid,
        resource,
        types;

    }
}

