/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.widgets.A_CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsMultiSelectWidget
extends A_CmsSelectWidget {
    private boolean m_asCheckBoxes;

    public CmsMultiSelectWidget() {
    }

    public CmsMultiSelectWidget(List<CmsSelectWidgetOption> configuration) {
        this(configuration, false);
    }

    public CmsMultiSelectWidget(List<CmsSelectWidgetOption> configuration, boolean asCheckboxes) {
        super(configuration);
        this.m_asCheckBoxes = asCheckboxes;
    }

    public CmsMultiSelectWidget(String configuration) {
        super(configuration);
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            StringBuffer value = new StringBuffer(128);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    value.append(',');
                }
                value.append(values[i]);
            }
            param.setStringValue(cms, value.toString());
        } else {
            param.setStringValue(cms, "");
        }
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        List<CmsSelectWidgetOption> options = this.parseSelectOptions(cms, widgetDialog, param);
        result.append("<td class=\"xmlTd\">");
        if (!this.m_asCheckBoxes) {
            result.append("<select multiple size='");
            result.append(options.size());
            result.append("' class=\"xmlInput");
            if (param.hasError()) {
                result.append(" xmlInputError");
            }
            result.append("\" name=\"");
            result.append(id);
            result.append("\" id=\"");
            result.append(id);
            result.append("\">");
        }
        List<String> selected = this.getSelectedValues(cms, param);
        for (CmsSelectWidgetOption option : options) {
            if (!this.m_asCheckBoxes) {
                result.append("<option value=\"");
                result.append(option.getValue());
                result.append("\"");
                if (selected.contains(option.getValue())) {
                    result.append(" selected=\"selected\"");
                }
                result.append(">");
                result.append(option.getOption());
                result.append("</option>");
                continue;
            }
            result.append("<input type='checkbox' name='");
            result.append(id);
            result.append("' value='");
            result.append(option.getValue());
            result.append("'");
            if (selected.contains(option.getValue())) {
                result.append(" checked");
            }
            result.append(">");
            result.append(option.getOption());
            result.append("<br>");
        }
        if (!this.m_asCheckBoxes) {
            result.append("</select>");
        }
        result.append("</td>");
        return result.toString();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsMultiSelectWidget(this.getConfiguration());
    }
}

