/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsWidgetException;
import org.opencms.widgets.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSelectWidgetOption {
    private static final char DEFAULT_MARKER = '*';
    private static final char INPUT_DELIMITER = '|';
    private static final String KEY_DEFAULT = "default='";
    private static final String KEY_HELP = "help='";
    private static final String KEY_OPTION = "option='";
    private static final String KEY_VALUE = "value='";
    private static final Log LOG = CmsLog.getLog(CmsSelectWidgetOption.class);
    private static final char OPTION_DELIMITER = ':';
    private boolean m_default;
    private int m_hashcode;
    private String m_help;
    private String m_option;
    private String m_value;

    public CmsSelectWidgetOption(String value) {
        this(value, false, null, null);
    }

    public CmsSelectWidgetOption(String value, boolean isDefault) {
        this(value, isDefault, null, null);
    }

    public CmsSelectWidgetOption(String value, boolean isDefault, String optionText) {
        this(value, isDefault, optionText, null);
    }

    public CmsSelectWidgetOption(String value, boolean isDefault, String optionText, String helpText) {
        this.m_default = isDefault;
        this.m_value = value;
        this.m_option = optionText;
        this.m_help = helpText;
    }

    public static String createConfigurationString(List<CmsSelectWidgetOption> options) {
        if (options == null || options.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(256);
        boolean first = true;
        for (int i = 0; i < options.size(); ++i) {
            CmsSelectWidgetOption o = options.get(i);
            if (!first) {
                result.append('|');
            } else {
                first = false;
            }
            result.append(o.toString());
        }
        return result.toString();
    }

    public static CmsSelectWidgetOption getDefaultOption(List<CmsSelectWidgetOption> options) {
        if (options == null || options.size() == 0) {
            return null;
        }
        for (int i = 0; i < options.size(); ++i) {
            CmsSelectWidgetOption option;
            CmsSelectWidgetOption o = options.get(i);
            if (!(o instanceof CmsSelectWidgetOption) || !(option = o).isDefault()) continue;
            return option;
        }
        return null;
    }

    public static List<CmsSelectWidgetOption> getDefaultOptions(List<CmsSelectWidgetOption> options) {
        ArrayList<CmsSelectWidgetOption> defaults = new ArrayList<CmsSelectWidgetOption>();
        if (options == null || options.size() == 0) {
            return defaults;
        }
        for (int i = 0; i < options.size(); ++i) {
            CmsSelectWidgetOption option;
            CmsSelectWidgetOption o = options.get(i);
            if (!(o instanceof CmsSelectWidgetOption) || !(option = o).isDefault()) continue;
            defaults.add(option);
        }
        return defaults;
    }

    public static List<CmsSelectWidgetOption> parseOptions(String input) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(input)) {
            return Collections.emptyList();
        }
        String[] parts = CmsStringUtil.splitAsArray(input, '|');
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        boolean foundDefault = false;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            if (part.length() == 0) continue;
            try {
                int pos;
                String value = null;
                String option = null;
                String help = null;
                boolean isDefault = false;
                int posValue = part.indexOf(KEY_VALUE);
                int posDefault = part.indexOf(KEY_DEFAULT);
                int posOption = part.indexOf(KEY_OPTION);
                int posHelp = part.indexOf(KEY_HELP);
                boolean shortValue = false;
                if (posValue < 0) {
                    if (posDefault == 0 || posOption == 0 || posHelp == 0) {
                        throw new CmsWidgetException(Messages.get().container("ERR_MALFORMED_SELECT_OPTIONS_1", input));
                    }
                    posValue = 0;
                    shortValue = true;
                }
                int end = part.length();
                if (posHelp > posValue) {
                    end = posHelp;
                }
                if (posDefault > posValue && posDefault < end) {
                    end = posDefault;
                }
                if (posOption > posValue && posOption < end) {
                    end = posOption;
                }
                if (shortValue) {
                    value = part.substring(0, end).trim();
                } else {
                    value = part.substring(posValue + KEY_VALUE.length(), end).trim();
                    value = value.substring(0, value.length() - 1);
                }
                boolean shortOption = false;
                if (shortValue && posOption < 0 && (pos = value.indexOf(58)) >= 0) {
                    posOption = pos;
                    shortOption = true;
                    value = value.substring(0, pos);
                }
                if (posDefault >= 0) {
                    end = part.length();
                    if (posHelp > posDefault) {
                        end = posHelp;
                    }
                    if (posOption > posDefault && posOption < end) {
                        end = posOption;
                    }
                    if (posValue > posDefault && posValue < end) {
                        end = posValue;
                    }
                    String sub = part.substring(posDefault + KEY_DEFAULT.length(), end).trim();
                    sub = sub.substring(0, sub.length() - 1);
                    isDefault = Boolean.valueOf(sub);
                } else if (value.charAt(value.length() - 1) == '*') {
                    isDefault = true;
                    value = value.substring(0, value.length() - 1);
                }
                if (posOption >= 0) {
                    end = part.length();
                    if (posHelp > posOption) {
                        end = posHelp;
                    }
                    if (posDefault > posOption && posDefault < end) {
                        end = posDefault;
                    }
                    if (posValue > posOption && posValue < end) {
                        end = posValue;
                    }
                    if (shortOption) {
                        option = part.substring(posOption + 1, end).trim();
                    } else {
                        option = part.substring(posOption + KEY_OPTION.length(), end).trim();
                        option = option.substring(0, option.length() - 1);
                    }
                }
                if (posHelp >= 0) {
                    end = part.length();
                    if (posOption > posHelp) {
                        end = posOption;
                    }
                    if (posDefault > posHelp && posDefault < end) {
                        end = posDefault;
                    }
                    if (posValue > posHelp && posValue < end) {
                        end = posValue;
                    }
                    help = part.substring(posHelp + KEY_HELP.length(), end).trim();
                    help = help.substring(0, help.length() - 1);
                }
                if (foundDefault) {
                    isDefault = false;
                } else if (isDefault) {
                    foundDefault = true;
                }
                result.add(new CmsSelectWidgetOption(value, isDefault, option, help));
                continue;
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)Messages.get().getBundle().key("ERR_MALFORMED_SELECT_OPTIONS_1", input));
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsSelectWidgetOption)) {
            return false;
        }
        CmsSelectWidgetOption other = (CmsSelectWidgetOption)obj;
        if (this.m_default != other.m_default) {
            return false;
        }
        if (this.m_value == null ? other.m_value != null : !this.m_value.equals(other.m_value)) {
            return false;
        }
        if (this.m_option == null ? other.m_option != null : !this.m_option.equals(other.m_option)) {
            return false;
        }
        return !(this.m_help == null ? other.m_help != null : !this.m_help.equals(other.m_help));
    }

    public String getHelp() {
        return this.m_help;
    }

    public String getOption() {
        if (this.m_option == null) {
            return this.getValue();
        }
        return this.m_option;
    }

    public String getValue() {
        return this.m_value;
    }

    public int hashCode() {
        if (this.m_hashcode == 0) {
            StringBuffer hash = new StringBuffer(128);
            hash.append(this.m_value);
            hash.append('|');
            hash.append(this.m_default);
            hash.append('|');
            hash.append(this.m_option);
            hash.append('|');
            hash.append(this.m_help);
            this.m_hashcode = hash.toString().hashCode();
        }
        return this.m_hashcode;
    }

    public boolean isDefault() {
        return this.m_default;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append(KEY_VALUE);
        result.append(this.m_value);
        result.append('\'');
        if (this.m_default) {
            result.append(' ');
            result.append(KEY_DEFAULT);
            result.append(this.m_default);
            result.append('\'');
        }
        if (this.m_option != null) {
            result.append(' ');
            result.append(KEY_OPTION);
            result.append(this.m_option);
            result.append('\'');
        }
        if (this.m_help != null) {
            result.append(' ');
            result.append(KEY_HELP);
            result.append(this.m_help);
            result.append('\'');
        }
        return result.toString();
    }
}

