/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

public class CmsTextareaWidget
extends A_CmsWidget {
    private static final int DEFAULT_ROWS_NUMBER = 4;

    public CmsTextareaWidget() {
        this(4);
    }

    public CmsTextareaWidget(int rows) {
        super("" + rows);
    }

    public CmsTextareaWidget(String configuration) {
        super(configuration);
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        int rows = 4;
        try {
            rows = new Integer(this.getConfiguration());
        }
        catch (Exception e) {
            // empty catch block
        }
        result.append("<td class=\"xmlTd\">");
        result.append("<textarea class=\"xmlInput maxwidth");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" name=\"");
        result.append(id);
        result.append("\" rows=\"");
        result.append(rows);
        result.append("\" cols=\"60\" style=\"overflow:auto;\">");
        result.append(CmsEncoder.escapeXml(param.getStringValue(cms)));
        result.append("</textarea>");
        result.append("</td>");
        return result.toString();
    }

    public I_CmsWidget newInstance() {
        return new CmsTextareaWidget(this.getConfiguration());
    }
}

