/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.I_CmsMessageBundle;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsMultiException;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CmsMultiDialog
extends CmsDialog {
    public static final String DELIMITER_RESOURCES = "|";
    public static final String PARAM_RESOURCELIST = "resourcelist";
    private static final Log LOG = CmsLog.getLog(CmsMultiDialog.class);
    private CmsMultiException m_multiOperationException = new CmsMultiException();
    private String m_paramResourcelist;
    private List<String> m_resourceList;

    public CmsMultiDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsMultiDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void addMultiOperationException(CmsException exc) {
        this.m_multiOperationException.addException(exc);
    }

    public String buildResourceList() {
        boolean scroll = this.getResourceList().size() > 6;
        StringBuffer result = new StringBuffer(1024);
        result.append(this.dialogWhiteBoxStart());
        if (scroll) {
            result.append("<div style='width: 100%; height:100px; overflow: auto;'>\n");
        }
        result.append("<table border=\"0\">\n");
        for (String resName : this.getResourceList()) {
            result.append("\t<tr>\n");
            result.append("\t\t<td class='textbold' style=\"vertical-align:top;\">");
            result.append(CmsResource.getName(resName));
            result.append("&nbsp;</td>\n\t\t<td style=\"vertical-align:top;\">");
            String title = null;
            try {
                title = this.getCms().readPropertyObject(resName, "Title", false).getValue(null);
            }
            catch (CmsException e) {
                // empty catch block
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
                result.append(title);
            }
            result.append("</td>\n\t</tr>\n");
        }
        result.append("</table>");
        if (scroll) {
            result.append("</div>\n");
        }
        result.append(this.dialogWhiteBoxEnd());
        return result.toString();
    }

    @Override
    public String buildLockHeaderBox() throws CmsException {
        if (!this.isMultiOperation()) {
            return super.buildLockHeaderBox();
        }
        StringBuffer html = new StringBuffer(1024);
        html.append(this.dialogBlockStart(this.key("GUI_MULTI_RESOURCELIST_TITLE_0")));
        html.append(this.buildResourceList());
        html.append(this.dialogBlockEnd());
        return html.toString();
    }

    public void checkMultiOperationException(I_CmsMessageBundle messages, String key) throws CmsException {
        if (this.m_multiOperationException.hasExceptions()) {
            this.m_multiOperationException.setMessage(new CmsMessageContainer(messages, key, this.m_multiOperationException));
            throw this.m_multiOperationException;
        }
    }

    public String getParamResourcelist() {
        if (CmsStringUtil.isNotEmpty(this.m_paramResourcelist) && !"null".equals(this.m_paramResourcelist)) {
            return this.m_paramResourcelist;
        }
        return null;
    }

    public List<String> getResourceList() {
        if (this.m_resourceList == null) {
            if (this.getParamResourcelist() != null) {
                this.m_resourceList = CmsStringUtil.splitAsList(this.getParamResourcelist(), DELIMITER_RESOURCES, true);
                Collections.sort(this.m_resourceList);
            } else {
                this.m_resourceList = new ArrayList<String>(1);
                this.m_resourceList.add(this.getParamResource());
            }
        }
        return this.m_resourceList;
    }

    public String getResourceListAsParam() {
        String result = this.getParamResourcelist();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = this.getParamResource();
        }
        return result;
    }

    public boolean isMultiOperation() {
        return this.getResourceList().size() > 1;
    }

    public void setDialogTitle(String singleKey, String multiKey) {
        if (this.isMultiOperation()) {
            String resCount = String.valueOf(this.getResourceList().size());
            String currentFolder = CmsResource.getFolderPath(this.getSettings().getExplorerResource());
            currentFolder = CmsStringUtil.formatResourceName(currentFolder, 40);
            Object[] params = new Object[]{resCount, currentFolder};
            this.setParamTitle(this.key(multiKey, params));
        } else {
            String resourceName = CmsStringUtil.formatResourceName(this.getParamResource(), 50);
            this.setParamTitle(this.key(singleKey, new Object[]{resourceName}));
        }
    }

    public void setParamResourcelist(String paramResourcelist) {
        this.m_paramResourcelist = paramResourcelist;
        this.m_resourceList = null;
    }

    @Override
    public void setParamResource(String value) {
        super.setParamResource(value);
        this.m_resourceList = null;
    }

    @Override
    protected boolean checkResourcePermissions(CmsPermissionSet required, boolean neededForFolder) {
        if (this.isMultiOperation()) {
            return true;
        }
        return super.checkResourcePermissions(required, neededForFolder);
    }

    protected boolean isOperationOnFolder() {
        for (String resName : this.getResourceList()) {
            try {
                CmsResource curRes = this.getCms().readResource(resName, CmsResourceFilter.ALL);
                if (!curRes.isFolder()) continue;
                return true;
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        return false;
    }

    protected abstract boolean performDialogOperation() throws CmsException;
}

