/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.CmsListResourceLinkRelationCollector;
import org.opencms.workplace.commons.CmsListResourceLinkRelationExplorerColumn;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListExplorerColumn;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListResourceProjStateAction;
import org.opencms.workplace.list.I_CmsListResourceCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsResourceLinkRelationList
extends A_CmsListExplorerDialog {
    protected static final String LIST_COLUMN_RELATION_TYPE = "crt";
    protected static final Log LOG = CmsLog.getLog(CmsResourceLinkRelationList.class);
    private static final String LIST_ID = "lrlr";
    private List<String> m_brokenLinks;
    private I_CmsListResourceCollector m_collector;
    private boolean m_isSource;
    private Map<CmsResource, List<CmsRelationType>> m_relationTypes;

    public CmsResourceLinkRelationList(CmsJspActionElement jsp, boolean isSource) {
        super(jsp, LIST_ID, Messages.get().container("GUI_LINK_RELATION_LIST_NAME_0"));
        this.m_isSource = isSource;
        I_CmsListResourceCollector collector = this.getCollector();
        if (collector != null && collector instanceof CmsListResourceLinkRelationCollector) {
            ((CmsListResourceLinkRelationCollector)collector).setSource(isSource);
        }
        CmsResourceUtil resUtil = this.getResourceUtil();
        resUtil.setAbbrevLength(50);
        resUtil.setRelativeTo(CmsResource.getParentFolder(this.getParamResource()));
        resUtil.setSiteMode(CmsResourceUtil.SITE_MODE_MATCHING);
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    public List<String> getBrokenLinks() {
        return this.m_brokenLinks;
    }

    @Override
    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            this.m_collector = new CmsListResourceLinkRelationCollector(this, this.getParamResource(), this.isSource());
        }
        return this.m_collector;
    }

    public Map<CmsResource, List<CmsRelationType>> getRelationTypes() {
        return this.m_relationTypes;
    }

    public boolean isSource() {
        return this.m_isSource;
    }

    public void setBrokenLinks(List<String> brokenLinks) {
        this.m_brokenLinks = brokenLinks;
    }

    public void setRelationTypes(Map<CmsResource, List<CmsRelationType>> relationTypes) {
        this.m_relationTypes = relationTypes;
    }

    public void setSource(boolean isSource) {
        this.m_isSource = isSource;
    }

    @Override
    protected String defaultActionHtmlStart() {
        return this.getList().listJs() + CmsListExplorerColumn.getExplorerStyleDef() + this.dialogContentStart(this.getParamTitle());
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        ArrayList<CmsListItem> newItems = new ArrayList<CmsListItem>();
        List<CmsListItem> items = super.getListItems();
        for (CmsListItem item : items) {
            CmsResource resource = this.getResourceUtil(item).getResource();
            CmsRelationType relationType = this.getRelationTypes().get(resource).remove(0);
            String localizedRelationType = relationType.getLocalizedName(this.getMessages());
            Map<String, Object> itemValues = item.getValues();
            CmsListItem newItem = this.getList().newItem(localizedRelationType + "_" + resource.getStructureId().toString());
            for (Map.Entry<String, Object> e : itemValues.entrySet()) {
                String currentKey = e.getKey();
                newItem.set(currentKey, e.getValue());
            }
            newItem.set(LIST_COLUMN_RELATION_TYPE, localizedRelationType);
            newItems.add(newItem);
        }
        return newItems;
    }

    @Override
    protected boolean isColumnVisible(int colFlag) {
        boolean isVisible = colFlag == 1;
        isVisible = isVisible || colFlag == "ecti".hashCode();
        isVisible = isVisible || colFlag == "ecli".hashCode();
        isVisible = isVisible || colFlag == "ecpi".hashCode();
        isVisible = isVisible || colFlag == "ecn".hashCode();
        isVisible = isVisible || colFlag == 2;
        isVisible = isVisible || colFlag == 8;
        isVisible = isVisible || colFlag == "ecsi".hashCode() && OpenCms.getSiteManager().getSites().size() > 1;
        return isVisible;
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListColumnDefinition projStateIconCol = metadata.getColumnDefinition("ecpi");
        projStateIconCol.removeDirectAction("eaps");
        CmsListResourceProjStateAction resourceProjStateAction = new CmsListResourceProjStateAction("eaps"){

            public String getIconPath() {
                if (((CmsResourceLinkRelationList)this.getWp()).getBrokenLinks() != null && ((CmsResourceLinkRelationList)this.getWp()).getBrokenLinks().contains(this.getItem().getId())) {
                    return "buttons/deletecontent.png";
                }
                return super.getIconPath();
            }

            public CmsMessageContainer getName() {
                if (((CmsResourceLinkRelationList)this.getWp()).getBrokenLinks() != null && ((CmsResourceLinkRelationList)this.getWp()).getBrokenLinks().contains(this.getItem().getId())) {
                    return Messages.get().container("GUI_RELATION_LIST_BROKEN_HELP_0");
                }
                return super.getName();
            }
        };
        resourceProjStateAction.setEnabled(false);
        projStateIconCol.addDirectAction(resourceProjStateAction);
        CmsListResourceLinkRelationExplorerColumn relationTypeCol = new CmsListResourceLinkRelationExplorerColumn(LIST_COLUMN_RELATION_TYPE);
        relationTypeCol.setName(Messages.get().container("GUI_RELATION_LIST_TYPE_NAME_0"));
        metadata.addColumn(relationTypeCol, 4);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    @Override
    protected void validateParamaters() throws Exception {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.getParamResource())) {
            throw new Exception();
        }
    }
}

