/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsTouch
extends CmsMultiDialog {
    public static final int ACTION_TOUCH = 100;
    public static final String DEFAULT_DATE_STRING = "-";
    public static final String DIALOG_TYPE = "touch";
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_NEWTIMESTAMP = "newtimestamp";
    public static final String PARAM_RECURSIVE = "recursive";
    private String m_paramContent;
    private String m_paramNewtimestamp;
    private String m_paramRecursive;

    public CmsTouch(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsTouch(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionTouch() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            if (this.performDialogOperation()) {
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    public String buildCheckContent() {
        StringBuffer retValue = new StringBuffer(256);
        retValue.append("<tr>\n\t<td colspan=\"3\" style=\"white-space: nowrap;\" unselectable=\"on\">");
        retValue.append("<input type=\"checkbox\" name=\"");
        retValue.append(PARAM_CONTENT);
        retValue.append("\" value=\"true\">&nbsp;");
        retValue.append(this.key("GUI_TOUCH_MODIFY_CONTENT_0"));
        retValue.append("</td>\n</tr>\n");
        return retValue.toString();
    }

    public String buildCheckRecursive() {
        StringBuffer retValue = new StringBuffer(256);
        if (this.isOperationOnFolder()) {
            retValue.append("<tr>\n\t<td colspan=\"3\" style=\"white-space: nowrap;\" unselectable=\"on\">");
            retValue.append("<input type=\"checkbox\" name=\"");
            retValue.append(PARAM_RECURSIVE);
            retValue.append("\" value=\"true\">&nbsp;");
            retValue.append(this.key("GUI_TOUCH_MODIFY_SUBRESOURCES_0"));
            retValue.append("</td>\n</tr>\n");
        }
        return retValue.toString();
    }

    public String calendarIncludes() {
        return CmsCalendarWidget.calendarIncludes(this.getLocale());
    }

    public String calendarInit(String inputFieldId, String triggerButtonId, String align, boolean singleClick, boolean weekNumbers, boolean mondayFirst, String dateStatusFunc, boolean showTime) {
        return CmsCalendarWidget.calendarInit(this.getMessages(), inputFieldId, triggerButtonId, align, singleClick, weekNumbers, mondayFirst, dateStatusFunc, showTime);
    }

    public String getCurrentDateTime() {
        return CmsCalendarWidget.getCalendarLocalizedTime(this.getLocale(), this.getMessages(), System.currentTimeMillis());
    }

    public String getParamContent() {
        return this.m_paramContent;
    }

    public String getParamNewtimestamp() {
        return this.m_paramNewtimestamp;
    }

    public String getParamRecursive() {
        return this.m_paramRecursive;
    }

    public void setParamContent(String value) {
        this.m_paramContent = value;
    }

    public void setParamNewtimestamp(String value) {
        this.m_paramNewtimestamp = value;
    }

    public void setParamRecursive(String value) {
        this.m_paramRecursive = value;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if ("locksconfirmed".equals(this.getParamAction())) {
            this.setAction(99);
        } else {
            this.setAction(0);
            this.setDialogTitle("GUI_TOUCH_RESOURCE_1", "GUI_TOUCH_MULTI_2");
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        if (!"wait".equals(this.getParamAction())) {
            if (this.isMultiOperation()) {
                return false;
            }
            CmsResource sourceRes = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
            if (sourceRes.isFolder()) {
                return false;
            }
        }
        long timeStamp = 0L;
        boolean correctDate = false;
        try {
            if (CmsStringUtil.isNotEmpty(this.getParamNewtimestamp())) {
                timeStamp = CmsCalendarWidget.getCalendarDate(this.getMessages(), this.getParamNewtimestamp(), true);
                correctDate = true;
            }
        }
        catch (ParseException e) {
            throw new CmsException(Messages.get().container("ERR_PARSE_TIMESTAMP_1", this.getParamNewtimestamp()), (Throwable)e);
        }
        boolean touchRecursive = Boolean.valueOf(this.getParamRecursive());
        boolean touchContent = Boolean.valueOf(this.getParamContent());
        for (String resName : this.getResourceList()) {
            try {
                this.touchSingleResource(resName, timeStamp, touchRecursive, correctDate, touchContent);
            }
            catch (CmsException e) {
                this.addMultiOperationException(e);
            }
        }
        this.checkMultiOperationException(Messages.get(), "ERR_TOUCH_MULTI_0");
        return true;
    }

    protected void touchSingleResource(String resourceName, long timeStamp, boolean recursive, boolean correctDate, boolean touchContent) throws CmsException {
        this.checkLock(resourceName);
        CmsResource sourceRes = this.getCms().readResource(resourceName, CmsResourceFilter.ALL);
        if (!correctDate) {
            timeStamp = sourceRes.getDateLastModified();
        }
        this.getCms().setDateLastModified(resourceName, timeStamp, recursive);
        if (touchContent) {
            if (sourceRes.isFile()) {
                this.hardTouch(sourceRes);
            } else if (recursive) {
                for (CmsResource subRes : this.getCms().readResources(resourceName, CmsResourceFilter.ALL, true)) {
                    if (!subRes.isFile()) continue;
                    this.hardTouch(subRes);
                }
            }
        }
    }

    private void hardTouch(CmsResource resource) throws CmsException {
        CmsFile file = this.getCms().readFile(resource);
        file.setContents(file.getContents());
        this.getCms().writeFile(file);
    }
}

