/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.extractors.CmsExtractorMsOfficeOLE2;
import org.opencms.search.extractors.CmsExtractorPdf;
import org.opencms.search.extractors.CmsExtractorRtf;
import org.opencms.search.extractors.I_CmsTextExtractor;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.CmsResourceInfoDialog;
import org.opencms.workplace.comparison.CmsAttributeComparison;
import org.opencms.workplace.comparison.CmsAttributeComparisonList;
import org.opencms.workplace.comparison.CmsDifferenceDialog;
import org.opencms.workplace.comparison.CmsElementComparisonList;
import org.opencms.workplace.comparison.CmsHtmlDifferenceDialog;
import org.opencms.workplace.comparison.CmsImageComparisonDialog;
import org.opencms.workplace.comparison.CmsPointerComparisonDialog;
import org.opencms.workplace.comparison.CmsPropertyComparisonList;
import org.opencms.workplace.comparison.CmsResourceComparison;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsMultiListDialog;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.I_CmsXmlContentValueVisitor;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsResourceComparisonDialog
extends CmsDialog {
    public static final String COMPARE_ALL_ELEMENTS = "allelements";
    public static final String COMPARE_ATTRIBUTES = "attributes";
    public static final String COMPARE_PROPERTIES = "properties";
    static final Log LOG = CmsLog.getLog(CmsResourceComparisonDialog.class);
    private CmsDifferenceDialog m_differenceDialog;
    private String m_paramCompare;
    private String m_paramElement;
    private String m_paramId1;
    private String m_paramId2;
    private String m_paramLocale;
    private String m_paramTextmode;
    private String m_paramVersion1;
    private String m_paramVersion2;

    public CmsResourceComparisonDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsResourceComparisonDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CmsFile readFile(CmsObject cms, CmsUUID structureId, String version) throws CmsException {
        if (Integer.parseInt(version) == Integer.MAX_VALUE) {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return cms.readFile(resource);
        }
        int ver = Integer.parseInt(version);
        if (ver < 0) {
            CmsFile cmsFile;
            CmsProject project = cms.getRequestContext().getCurrentProject();
            try {
                cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                cmsFile = cms.readFile(resource);
                Object var8_8 = null;
                cms.getRequestContext().setCurrentProject(project);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                cms.getRequestContext().setCurrentProject(project);
                throw throwable;
            }
            return cmsFile;
        }
        return cms.readFile((CmsHistoryFile)cms.readResource(structureId, ver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CmsResource readResource(CmsObject cms, CmsUUID id, String version) throws CmsException {
        if (Integer.parseInt(version) == Integer.MAX_VALUE) {
            return cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        int ver = Integer.parseInt(version);
        if (ver < 0) {
            CmsResource cmsResource;
            CmsProject project = cms.getRequestContext().getCurrentProject();
            try {
                cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                cmsResource = cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
                Object var7_6 = null;
                cms.getRequestContext().setCurrentProject(project);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                cms.getRequestContext().setCurrentProject(project);
                throw throwable;
            }
            return cmsResource;
        }
        return (CmsResource)((Object)cms.readResource(id, ver));
    }

    public void displayDialog() throws Exception {
        CmsResourceInfoDialog fileInfo = new CmsResourceInfoDialog(this.getJsp()){

            protected String defaultActionHtmlEnd() {
                return "";
            }
        };
        fileInfo.displayDialog(true);
        if (fileInfo.isForwarded()) {
            return;
        }
        CmsPropertyComparisonList propertyDiff = new CmsPropertyComparisonList(this.getJsp());
        CmsAttributeComparisonList attributeDiff = new CmsAttributeComparisonList(this.getJsp());
        ArrayList<A_CmsListDialog> lists = new ArrayList<A_CmsListDialog>();
        lists.add(attributeDiff);
        I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(propertyDiff.getResourceType());
        if (resourceType instanceof CmsResourceTypeXmlContent || resourceType instanceof CmsResourceTypeXmlPage) {
            CmsElementComparisonList contentDiff = new CmsElementComparisonList(this.getJsp());
            lists.add(contentDiff);
            lists.add(propertyDiff);
            CmsMultiListDialog threeLists = new CmsMultiListDialog(lists);
            threeLists.displayDialog(true);
            if (threeLists.isForwarded()) {
                return;
            }
            fileInfo.writeDialog();
            threeLists.writeDialog();
        } else if (resourceType instanceof CmsResourceTypeImage) {
            lists.add(propertyDiff);
            CmsMultiListDialog twoLists = new CmsMultiListDialog(lists){

                public String defaultActionHtmlEnd() {
                    return "";
                }
            };
            twoLists.displayDialog(true);
            if (twoLists.isForwarded()) {
                return;
            }
            CmsImageComparisonDialog images = new CmsImageComparisonDialog(this.getJsp());
            fileInfo.writeDialog();
            twoLists.writeDialog();
            images.displayDialog();
        } else if (resourceType instanceof CmsResourceTypePointer) {
            lists.add(propertyDiff);
            CmsMultiListDialog twoLists = new CmsMultiListDialog(lists){

                public String defaultActionHtmlEnd() {
                    return "";
                }
            };
            twoLists.displayDialog(true);
            if (twoLists.isForwarded()) {
                return;
            }
            CmsPointerComparisonDialog pointers = new CmsPointerComparisonDialog(this.getJsp());
            fileInfo.writeDialog();
            twoLists.writeDialog();
            pointers.displayDialog();
        } else if (propertyDiff.getResource1().isFile()) {
            lists.add(propertyDiff);
            CmsMultiListDialog twoLists = new CmsMultiListDialog(lists);
            twoLists.displayDialog(true);
            if (twoLists.isForwarded()) {
                return;
            }
            String path1 = propertyDiff.getResource1().getRootPath();
            String path2 = propertyDiff.getResource2().getRootPath();
            byte[] content1 = CmsResourceComparisonDialog.readFile(this.getCms(), propertyDiff.getResource1().getStructureId(), this.getParamVersion1()).getContents();
            byte[] content2 = CmsResourceComparisonDialog.readFile(this.getCms(), propertyDiff.getResource2().getStructureId(), this.getParamVersion2()).getContents();
            String originalSource = null;
            String copySource = null;
            I_CmsTextExtractor textExtractor = null;
            if (path1.endsWith(".pdf") && path2.endsWith(".pdf")) {
                textExtractor = CmsExtractorPdf.getExtractor();
            } else if (path1.endsWith(".doc") && path2.endsWith(".doc")) {
                textExtractor = CmsExtractorMsOfficeOLE2.getExtractor();
            } else if (path1.endsWith(".xls") && path2.endsWith(".xls")) {
                textExtractor = CmsExtractorMsOfficeOLE2.getExtractor();
            } else if (path1.endsWith(".rtf") && path2.endsWith(".rtf")) {
                textExtractor = CmsExtractorRtf.getExtractor();
            } else if (path1.endsWith(".ppt") && path2.endsWith(".ppt")) {
                textExtractor = CmsExtractorMsOfficeOLE2.getExtractor();
            }
            if (textExtractor != null) {
                try {
                    originalSource = textExtractor.extractText(content1).getContent();
                    copySource = textExtractor.extractText(content2).getContent();
                }
                catch (Exception e) {
                    originalSource = null;
                    copySource = null;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if (resourceType instanceof CmsResourceTypePlain || resourceType instanceof CmsResourceTypeJsp) {
                originalSource = new String(content1);
                copySource = new String(content2);
            }
            fileInfo.writeDialog();
            twoLists.writeDialog();
            if (CmsStringUtil.isNotEmpty(originalSource) && CmsStringUtil.isNotEmpty(copySource)) {
                this.m_differenceDialog.setCopySource(copySource);
                this.m_differenceDialog.setOriginalSource(originalSource);
                this.m_differenceDialog.displayDialog();
            }
        } else {
            lists.add(propertyDiff);
            CmsMultiListDialog twoLists = new CmsMultiListDialog(lists);
            twoLists.displayDialog(true);
            if (twoLists.isForwarded()) {
                return;
            }
            fileInfo.writeDialog();
            twoLists.writeDialog();
        }
    }

    public void displayDifferenceDialog() throws Exception {
        this.m_differenceDialog.displayDialog();
    }

    public String[] getAttributesAsString(List attributes) {
        Iterator i = attributes.iterator();
        StringBuffer res1 = new StringBuffer(512);
        StringBuffer res2 = new StringBuffer(512);
        while (i.hasNext()) {
            CmsAttributeComparison compare = (CmsAttributeComparison)i.next();
            res1.append(this.key(compare.getName())).append(": ").append(compare.getVersion1()).append("\n");
            res2.append(this.key(compare.getName())).append(": ").append(compare.getVersion2()).append("\n");
        }
        return new String[]{res1.toString(), res2.toString()};
    }

    public String getParamCompare() {
        return this.m_paramCompare;
    }

    public String getParamElement() {
        return this.m_paramElement;
    }

    public String getParamId1() {
        return this.m_paramId1;
    }

    public String getParamId2() {
        return this.m_paramId2;
    }

    public String getParamLocale() {
        return this.m_paramLocale;
    }

    public String getParamTextmode() {
        return this.m_paramTextmode;
    }

    public String getParamVersion1() {
        return this.m_paramVersion1;
    }

    public String getParamVersion2() {
        return this.m_paramVersion2;
    }

    public String[] getPropertiesAsString(List properties) {
        Iterator i = properties.iterator();
        StringBuffer res1 = new StringBuffer(512);
        StringBuffer res2 = new StringBuffer(512);
        while (i.hasNext()) {
            CmsAttributeComparison compare = (CmsAttributeComparison)i.next();
            res1.append(compare.getName()).append(": ").append(compare.getVersion1()).append("\n");
            res2.append(compare.getName()).append(": ").append(compare.getVersion2()).append("\n");
        }
        return new String[]{res1.toString(), res2.toString()};
    }

    public void setParamCompare(String paramCompare) {
        this.m_paramCompare = paramCompare;
    }

    public void setParamElement(String paramElement) {
        this.m_paramElement = paramElement;
    }

    public void setParamId1(String paramId1) {
        this.m_paramId1 = paramId1;
    }

    public void setParamId2(String paramId2) {
        this.m_paramId2 = paramId2;
    }

    public void setParamLocale(String paramLocale) {
        this.m_paramLocale = paramLocale;
    }

    public void setParamTextmode(String paramTextmode) {
        this.m_paramTextmode = paramTextmode;
    }

    public void setParamVersion1(String paramVersion1) {
        this.m_paramVersion1 = paramVersion1;
    }

    public void setParamVersion2(String paramVersion2) {
        this.m_paramVersion2 = paramVersion2;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        try {
            CmsResource resource1 = CmsResourceComparisonDialog.readResource(this.getCms(), new CmsUUID(this.getParamId1()), this.getParamVersion1());
            CmsResource resource2 = CmsResourceComparisonDialog.readResource(this.getCms(), new CmsUUID(this.getParamId2()), this.getParamVersion2());
            this.m_differenceDialog = CmsStringUtil.isNotEmpty(this.getParamElement()) ? new CmsHtmlDifferenceDialog(this.getJsp()) : new CmsDifferenceDialog(this.getJsp());
            if (COMPARE_ATTRIBUTES.equals(this.getParamCompare())) {
                List comparedAttributes = CmsResourceComparison.compareAttributes(this.getCms(), resource1, resource2);
                String[] attributeStrings = this.getAttributesAsString(comparedAttributes);
                this.m_differenceDialog.setOriginalSource(attributeStrings[0]);
                this.m_differenceDialog.setCopySource(attributeStrings[1]);
            } else if (COMPARE_PROPERTIES.equals(this.getParamCompare())) {
                List comparedProperties = CmsResourceComparison.compareProperties(this.getCms(), resource1, this.getParamVersion1(), resource2, this.getParamVersion2());
                String[] propertyStrings = this.getPropertiesAsString(comparedProperties);
                this.m_differenceDialog.setOriginalSource(propertyStrings[0]);
                this.m_differenceDialog.setCopySource(propertyStrings[1]);
            } else if (resource1.isFile()) {
                CmsFile file1 = CmsResourceComparisonDialog.readFile(this.getCms(), new CmsUUID(this.getParamId1()), this.getParamVersion1());
                CmsFile file2 = CmsResourceComparisonDialog.readFile(this.getCms(), new CmsUUID(this.getParamId2()), this.getParamVersion2());
                this.setContentAsSource(file1, file2);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String extractElements(I_CmsXmlDocument xmlDoc) {
        StringBuffer result = new StringBuffer();
        if (xmlDoc instanceof CmsXmlPage) {
            List<Locale> locales = xmlDoc.getLocales();
            Iterator<Locale> i = locales.iterator();
            boolean firstIter = true;
            while (i.hasNext()) {
                if (!firstIter) {
                    result.append("\n\n-----");
                }
                Locale locale = i.next();
                result.append("\n\n[").append(locale.toString()).append(']');
                List<I_CmsXmlContentValue> elements = xmlDoc.getValues(locale);
                for (I_CmsXmlContentValue value : elements) {
                    result.append("\n\n[");
                    result.append(value.getElement().attribute(0).getValue());
                    result.append("]\n\n");
                    try {
                        I_CmsWidget widget = value.getDocument().getHandler().getWidget(value);
                        result.append(widget.getWidgetStringValue(this.getCms(), new CmsResourceInfoDialog(this.getJsp()), (I_CmsWidgetParameter)((Object)value)));
                    }
                    catch (CmsXmlException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                firstIter = false;
            }
        } else if (xmlDoc instanceof CmsXmlContent) {
            CmsXmlContentTextExtractor visitor = new CmsXmlContentTextExtractor(result);
            ((CmsXmlContent)xmlDoc).visitAllValuesWith(visitor);
        }
        return result.toString();
    }

    private void setContentAsSource(CmsFile file1, CmsFile file2) throws CmsException, UnsupportedEncodingException {
        CmsObject cms = this.getCms();
        if (CmsStringUtil.isNotEmpty(this.getParamElement())) {
            A_CmsXmlDocument resource1 = CmsResourceTypeXmlPage.isXmlPage(file1) ? CmsXmlPageFactory.unmarshal(cms, file1) : CmsXmlContentFactory.unmarshal(cms, file1);
            A_CmsXmlDocument resource2 = CmsResourceTypeXmlPage.isXmlPage(file2) ? CmsXmlPageFactory.unmarshal(cms, file2) : CmsXmlContentFactory.unmarshal(cms, file2);
            I_CmsXmlContentValue value1 = resource1.getValue(this.getParamElement(), new Locale(this.getParamLocale()));
            I_CmsXmlContentValue value2 = resource2.getValue(this.getParamElement(), new Locale(this.getParamLocale()));
            if (value1 == null) {
                this.m_differenceDialog.setOriginalSource("");
            } else {
                this.m_differenceDialog.setOriginalSource(value1.getStringValue(cms));
            }
            if (value2 == null) {
                this.m_differenceDialog.setCopySource("");
            } else {
                this.m_differenceDialog.setCopySource(value2.getStringValue(cms));
            }
        } else if (COMPARE_ALL_ELEMENTS.equals(this.getParamCompare())) {
            A_CmsXmlDocument resource1 = CmsResourceTypeXmlPage.isXmlPage(file1) ? CmsXmlPageFactory.unmarshal(cms, file1) : CmsXmlContentFactory.unmarshal(cms, file1);
            A_CmsXmlDocument resource2 = CmsResourceTypeXmlPage.isXmlPage(file2) ? CmsXmlPageFactory.unmarshal(cms, file2) : CmsXmlContentFactory.unmarshal(cms, file2);
            this.m_differenceDialog.setOriginalSource(this.extractElements(resource1));
            this.m_differenceDialog.setCopySource(this.extractElements(resource2));
        } else {
            this.m_differenceDialog.setOriginalSource(new String(file1.getContents(), cms.getRequestContext().getEncoding()));
            this.m_differenceDialog.setCopySource(new String(file2.getContents(), cms.getRequestContext().getEncoding()));
        }
    }

    class CmsXmlContentTextExtractor
    implements I_CmsXmlContentValueVisitor {
        private StringBuffer m_buffer;
        private List m_locales;

        CmsXmlContentTextExtractor(StringBuffer stringBuffer) {
            this.m_buffer = stringBuffer;
            this.m_locales = new ArrayList();
        }

        public void visit(I_CmsXmlContentValue value) {
            if (value.isSimpleType()) {
                String locale = value.getLocale().toString();
                if (!this.m_locales.contains(locale)) {
                    this.m_buffer.append("\n\n[").append(locale).append(']');
                    this.m_locales.add(locale);
                }
                this.m_buffer.append("\n\n[").append(value.getPath()).append("]\n\n");
                try {
                    I_CmsWidget widget = value.getDocument().getContentDefinition().getContentHandler().getWidget(value);
                    this.m_buffer.append(widget.getWidgetStringValue(CmsResourceComparisonDialog.this.getCms(), new CmsResourceInfoDialog(CmsResourceComparisonDialog.this.getJsp()), (I_CmsWidgetParameter)((Object)value)));
                }
                catch (CmsXmlException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

