/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsExplorerTypeAccess {
    public static final String PRINCIPAL_DEFAULT = "DEFAULT";
    private static final Log LOG = CmsLog.getLog(CmsExplorerTypeAccess.class);
    private Map<String, String> m_accessControl = new HashMap<String, String>();
    private CmsAccessControlList m_accessControlList;
    private Map<String, CmsPermissionSetCustom> m_permissionsCache;

    public void addAccessEntry(String key, String value) {
        this.m_accessControl.put(key, value);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_ACCESS_ENTRY_2", key, value));
        }
    }

    public void createAccessControlList(String resourceType) throws CmsException {
        if (OpenCms.getRunLevel() < 2) {
            return;
        }
        if (this.m_permissionsCache == null) {
            Map lruMap = CmsCollectionsGenericWrapper.createLRUMap(2048);
            this.m_permissionsCache = Collections.synchronizedMap(lruMap);
            OpenCms.getMemoryMonitor().register(this.getClass().getName() + "." + resourceType, lruMap);
        } else {
            this.m_permissionsCache.clear();
        }
        this.m_accessControlList = new CmsAccessControlList();
        for (String key : this.m_accessControl.keySet()) {
            if (PRINCIPAL_DEFAULT.equals(key)) continue;
            String value = this.m_accessControl.get(key);
            String principal = key.substring(key.indexOf(46) + 1, key.length());
            CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            CmsUUID principalId = null;
            if (key.startsWith("GROUP")) {
                principal = OpenCms.getImportExportManager().translateGroup(principal);
                try {
                    principalId = cms.readGroup(principal).getId();
                }
                catch (CmsException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            } else if (key.startsWith("USER")) {
                principal = OpenCms.getImportExportManager().translateUser(principal);
                try {
                    principalId = cms.readUser(principal).getId();
                }
                catch (CmsException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            } else {
                CmsRole role = CmsRole.valueOfRoleName(principal);
                if (role == null) {
                    role = CmsRole.valueOfGroupName(principal);
                }
                principalId = role.getId();
            }
            if (principalId == null) continue;
            CmsAccessControlEntry entry = new CmsAccessControlEntry(null, principalId, value);
            this.m_accessControlList.add(entry);
        }
    }

    public CmsAccessControlList getAccessControlList() {
        return this.m_accessControlList;
    }

    public Map<String, String> getAccessEntries() {
        return this.m_accessControl;
    }

    public CmsPermissionSet getPermissions(CmsObject cms, CmsResource resource) {
        CmsPermissionSetCustom permissions;
        String cacheKey = this.getPermissionsCacheKey(cms, resource);
        if (cacheKey != null && (permissions = this.m_permissionsCache.get(cacheKey)) != null) {
            return permissions;
        }
        CmsAccessControlList acl = (CmsAccessControlList)this.m_accessControlList.clone();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        List<CmsGroup> groups = null;
        try {
            groups = cms.getGroupsOfUser(user.getName(), false);
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READ_GROUPS_OF_USER_FAILED_1", user.getName()), (Throwable)e);
        }
        List<CmsRole> roles = null;
        try {
            roles = OpenCms.getRoleManager().getRolesForResource(cms, user.getName(), cms.getSitePath(resource));
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READ_GROUPS_OF_USER_FAILED_1", user.getName()), (Throwable)e);
        }
        String defaultPermissions = this.m_accessControl.get(PRINCIPAL_DEFAULT);
        if (defaultPermissions != null && !user.isGuestUser()) {
            boolean found = false;
            if (acl.getPermissions(user.getId()) != null) {
                found = true;
            }
            if (!found && groups != null) {
                for (CmsGroup group : groups) {
                    if (acl.getPermissions(group.getId()) == null) continue;
                    found = true;
                    break;
                }
            }
            if (!found && roles != null) {
                for (CmsRole role : roles) {
                    if (acl.getPermissions(role.getId()) == null) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                CmsAccessControlEntry entry = new CmsAccessControlEntry(null, user.getId(), defaultPermissions);
                acl.add(entry);
            }
        }
        permissions = acl.getPermissions(user, groups, roles);
        if (cacheKey != null) {
            this.m_permissionsCache.put(cacheKey, permissions);
        }
        return permissions;
    }

    public boolean isEmpty() {
        return this.m_accessControl.isEmpty();
    }

    private String getPermissionsCacheKey(CmsObject cms, CmsResource resource) {
        try {
            String userName = cms.getRequestContext().getCurrentUser().getName();
            StringBuffer key = new StringBuffer(256);
            key.append(resource.getRootPath()).append("_");
            for (CmsGroup group : cms.getGroupsOfUser(userName, true)) {
                key.append(group.getName()).append("_");
            }
            for (CmsRole role : OpenCms.getRoleManager().getRolesOfUser(cms, userName, "", true, true, false)) {
                key.append(role.getGroupName()).append("_");
            }
            return key.toString();
        }
        catch (CmsException e) {
            return null;
        }
    }
}

