/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsNewResourcePointer;
import org.opencms.workplace.explorer.Messages;

public class CmsNewResourceSibling
extends CmsNewResourcePointer {
    public static final String PARAM_KEEPPROPERTIES = "keepproperties";
    private static final Log LOG = CmsLog.getLog(CmsNewResourceSibling.class);
    private String m_paramKeepProperties;

    public CmsNewResourceSibling(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsNewResourceSibling(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCreateResource() throws JspException {
        try {
            String fullResourceName;
            String newResourceParam = fullResourceName = this.computeFullResourceName();
            String targetName = this.getParamLinkTarget();
            if (targetName == null) {
                targetName = "";
            }
            String storedSiteRoot = null;
            try {
                if (OpenCms.getSiteManager().getSiteRoot(targetName) != null) {
                    String siteRootFolder = this.getCms().getRequestContext().getSiteRoot();
                    if (siteRootFolder.endsWith("/")) {
                        siteRootFolder = siteRootFolder.substring(0, siteRootFolder.length() - 1);
                    }
                    fullResourceName = siteRootFolder + fullResourceName;
                    storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                    this.getCms().getRequestContext().setSiteRoot("/");
                }
                boolean isFolder = false;
                CmsResource targetRes = this.getCms().readResource(targetName);
                isFolder = targetRes.isFolder();
                if (isFolder) {
                    if (targetName.endsWith("/")) {
                        targetName = targetName.substring(0, targetName.length() - 1);
                    }
                    this.getCms().copyResource(targetName, fullResourceName, CmsResource.COPY_AS_SIBLING);
                } else {
                    List<CmsProperty> targetProperties = null;
                    boolean keepProperties = Boolean.valueOf(this.getParamKeepProperties());
                    if (keepProperties) {
                        try {
                            targetProperties = this.getCms().readPropertyObjects(targetName, false);
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    this.getCms().createSibling(targetName, fullResourceName, targetProperties);
                }
                Object var11_12 = null;
                if (storedSiteRoot != null) {
                    this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (storedSiteRoot != null) {
                    this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                }
                throw throwable;
            }
            this.setParamResource(newResourceParam);
            this.setResourceCreated(true);
        }
        catch (Throwable e) {
            this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_CREATE_LINK_0"));
            this.includeErrorpage(this, e);
        }
    }

    public void actionEditProperties() throws IOException, JspException, ServletException {
        boolean editProps = Boolean.valueOf(this.getParamNewResourceEditProps());
        String newRes = this.getParamResource();
        try {
            CmsLock lock = this.getCms().getLock(newRes);
            if (!lock.isDirectlyOwnedInProjectBy(this.getCms())) {
                editProps = false;
            }
        }
        catch (CmsException e) {
            throw new JspException((Throwable)e);
        }
        if (editProps) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("resource", this.getParamResource());
            params.put("dialogmode", "wizard");
            this.sendForward("/system/workplace/commons/property.jsp", params);
        } else {
            this.actionCloseDialog();
        }
    }

    public String getCurrentPath() {
        String path = this.getSettings().getExplorerResource();
        if (path == null) {
            path = "/";
        }
        return CmsResource.getFolderPath(path);
    }

    public String getParamKeepProperties() {
        return this.m_paramKeepProperties;
    }

    public void setParamKeepProperties(String keepProperties) {
        this.m_paramKeepProperties = keepProperties;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype("newresource");
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_NEWRESOURCE_SIBLING_0"));
        }
    }
}

