/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.CmsPreEditorAction;
import org.opencms.workplace.explorer.CmsNewResourceXmlContent;
import org.opencms.workplace.explorer.CmsNewResourceXmlContentModelCollector;
import org.opencms.workplace.explorer.Messages;
import org.opencms.workplace.list.A_CmsSelectResourceList;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListResourceCollector;

public class CmsNewResourceXmlContentModel
extends A_CmsSelectResourceList {
    public static final String LIST_DETAIL_DESCRIPTION = "dd";
    public static final String LIST_ID = "nrxm";
    public static final String VFS_PATH_MODELDIALOG = "/system/workplace/commons/newresource_xmlcontent_modelfile.jsp";
    public static final String VFS_PATH_NEWRESOURCEDIALOG = "/system/workplace/commons/newresource_xmlcontent.jsp";
    private I_CmsListResourceCollector m_collector;
    private String m_paramAppendSuffixHtml;
    private String m_paramBackLink;
    private String m_paramModelFile;
    private String m_paramNewResourceEditProps;
    private String m_paramNewResourceType;

    public CmsNewResourceXmlContentModel(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_NEWRESOURCE_XMLCONTENT_CHOOSEMODEL_0"), "ect", CmsListOrderEnum.ORDER_ASCENDING, null);
        this.setParamStyle("");
        this.getList().setMaxItemsPerPage(Integer.MAX_VALUE);
    }

    public CmsNewResourceXmlContentModel(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionDialog() throws JspException, ServletException, IOException {
        if (this.getAction() == 8) {
            String resource = this.getSelectedResourceName();
            if (CmsStringUtil.isNotEmpty(resource) && !this.key("GUI_NEWRESOURCE_XMLCONTENT_NO_MODEL_0").equals(resource)) {
                this.setParamModelFile(resource);
            }
            if (CmsPreEditorAction.isPreEditorMode(this)) {
                HashMap<String, String> params = new HashMap<String, String>(1);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamModelFile())) {
                    params.put("modelfile", this.getParamModelFile());
                }
                CmsPreEditorAction.sendForwardToEditor(this, params);
            } else {
                this.setParamAction("submitform");
                this.sendForward(this.nextUrl(), this.paramsAsParameterMap());
            }
            return;
        }
        if (this.getAction() == 4) {
            if (this.isPreEditor()) {
                this.actionClose();
            } else {
                HashMap<String, String> params = new HashMap<String, String>(3);
                params.put("action", "cancel");
                if (CmsStringUtil.isNotEmpty(this.getParamFramename())) {
                    params.put("framename", this.getParamFramename());
                }
                if (CmsStringUtil.isNotEmpty(this.getParamCloseLink())) {
                    params.put("closelink", this.getParamCloseLink());
                }
                this.sendForward(VFS_PATH_NEWRESOURCEDIALOG, params);
            }
            return;
        }
        super.actionDialog();
    }

    public String dialogButtons() {
        if (Boolean.valueOf(this.getParamNewResourceEditProps()).booleanValue() || CmsPreEditorAction.isPreEditorMode(this)) {
            return this.dialogButtons(new int[]{20, 1}, new String[]{"", ""});
        }
        return this.dialogButtons(new int[]{30, 1}, new String[]{"", ""});
    }

    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            ArrayList<CmsResource> modelFiles = new ArrayList<CmsResource>();
            String folderPath = this.getSettings().getExplorerResource();
            if (this.isPreEditor() && CmsStringUtil.isNotEmpty(this.getParamResource())) {
                folderPath = CmsResource.getFolderPath(this.getParamResource());
            }
            List<CmsResource> realModelFiles = CmsNewResourceXmlContent.getModelFiles(this.getCms(), folderPath, this.getParamNewResourceType());
            int dummyType = realModelFiles.get(0).getTypeId();
            String resPath = this.key("GUI_NEWRESOURCE_XMLCONTENT_NO_MODEL_0");
            CmsResource dummy = new CmsResource(CmsUUID.getConstantUUID("nones"), CmsUUID.getConstantUUID("noner"), resPath, dummyType, false, 0, null, CmsResourceState.STATE_UNCHANGED, 0L, this.getCms().getRequestContext().getCurrentUser().getId(), 0L, this.getCms().getRequestContext().getCurrentUser().getId(), 0L, Long.MAX_VALUE, 0, 0, 0L, 0);
            modelFiles.add(dummy);
            modelFiles.addAll(realModelFiles);
            this.m_collector = new CmsNewResourceXmlContentModelCollector(this, modelFiles);
        }
        return this.m_collector;
    }

    public String getListTitle() {
        return this.key("GUI_NEWRESOURCE_XMLCONTENT_CHOOSEMODEL_0");
    }

    public String getParamAppendSuffixHtml() {
        return this.m_paramAppendSuffixHtml;
    }

    public String getParamBackLink() {
        return this.m_paramBackLink;
    }

    public String getParamModelFile() {
        return this.m_paramModelFile;
    }

    public String getParamNewResourceEditProps() {
        return this.m_paramNewResourceEditProps;
    }

    public String getParamNewResourceType() {
        return this.m_paramNewResourceType;
    }

    public String nextUrl() {
        return VFS_PATH_NEWRESOURCEDIALOG;
    }

    public void setParamAppendSuffixHtml(String paramAppendSuffixHtml) {
        this.m_paramAppendSuffixHtml = paramAppendSuffixHtml;
    }

    public void setParamBackLink(String paramBackLink) {
        this.m_paramBackLink = paramBackLink;
    }

    public void setParamModelFile(String paramMasterFile) {
        this.m_paramModelFile = paramMasterFile;
    }

    public void setParamNewResourceEditProps(String newResourceEditProps) {
        this.m_paramNewResourceEditProps = newResourceEditProps;
    }

    public void setParamNewResourceType(String newResourceType) {
        this.m_paramNewResourceType = newResourceType;
    }

    protected void actionClose() throws IOException, ServletException {
        if (CmsStringUtil.isNotEmpty(this.getParamBackLink())) {
            this.setParamCloseLink(this.getJsp().link(this.getParamBackLink()));
        } else {
            this.setParamCloseLink(this.getJsp().link(this.getParamResource()));
        }
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        this.sendForward("/system/workplace/commons/includes/closedialog.jsp", new HashMap());
    }

    protected void fillDetails(String detailId) {
        List<CmsListItem> modelFiles = this.getList().getAllContent();
        for (CmsListItem item : modelFiles) {
            String resName = (String)item.get("ecn");
            String description = "";
            if (!detailId.equals(LIST_DETAIL_DESCRIPTION)) continue;
            try {
                description = this.getJsp().property("Description", resName, "");
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, description);
        }
    }

    protected boolean isColumnVisible(int colFlag) {
        if (colFlag == "ecti".hashCode()) {
            return true;
        }
        if (colFlag == "ecn".hashCode()) {
            return true;
        }
        if (colFlag == 1) {
            return true;
        }
        return colFlag == 4;
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        for (CmsListColumnDefinition colDefinition : metadata.getColumnDefinitions()) {
            if (colDefinition.getId().equals("ecn")) {
                colDefinition.removeDefaultAction("edo");
                continue;
            }
            if (!colDefinition.getId().equals("ecti")) continue;
            colDefinition.setSorteable(false);
            colDefinition.setName(org.opencms.workplace.list.Messages.get().container("GUI_EXPLORER_LIST_COLS_EMPTY_0"));
        }
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails modelFileDescription = new CmsListItemDetails(LIST_DETAIL_DESCRIPTION);
        modelFileDescription.setAtColumn("ecn");
        modelFileDescription.setVisible(false);
        modelFileDescription.setFormatter(new CmsListItemDetailsFormatter(Messages.get().container("GUI_MODELFILES_LABEL_DESCRIPTION_0")));
        modelFileDescription.setShowActionName(Messages.get().container("GUI_MODELFILES_DETAIL_SHOW_DESCRIPTION_NAME_0"));
        modelFileDescription.setShowActionHelpText(Messages.get().container("GUI_MODELFILES_DETAIL_SHOW_DESCRIPTION_HELP_0"));
        modelFileDescription.setHideActionName(Messages.get().container("GUI_MODELFILES_DETAIL_HIDE_DESCRIPTION_NAME_0"));
        modelFileDescription.setHideActionHelpText(Messages.get().container("GUI_MODELFILES_DETAIL_HIDE_DESCRIPTION_HELP_0"));
        metadata.addItemDetails(modelFileDescription);
    }
}

