/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.Messages;

public class CmsTree
extends CmsWorkplace {
    public static final String PARAM_INCLUDEFILES = "includefiles";
    public static final String PARAM_LASTKNOWN = "lastknown";
    public static final String PARAM_PROJECTAWARE = "projectaware";
    public static final String PARAM_RESOURCE = "resource";
    public static final String PARAM_ROOTLOADED = "rootloaded";
    public static final String PARAM_SHOWSITESELECTOR = "showsiteselector";
    public static final String PARAM_TREESITE = "treesite";
    public static final String PARAM_TYPE = "type";
    private static final Log LOG = CmsLog.getLog(CmsTree.class);
    private static final String TYPE_COPY = "copy";
    private static final String TYPE_PAGELINK = "pagelink";
    private static final String TYPE_PREFERENCES = "preferences";
    private static final String TYPE_SIBLING = "sibling";
    private static final String TYPE_VFSWIDGET = "vfswidget";
    private boolean m_includeFiles;
    private boolean m_newTree;
    private boolean m_projectAware = true;
    private String m_rootFolder;
    private boolean m_showSiteSelector;
    private String m_startFolder;
    private String m_targetFolder;
    private String m_treeType;

    public CmsTree(CmsJspActionElement jsp) {
        super(jsp);
    }

    public static String initTree(CmsObject cms, String encoding, String skinUri) {
        StringBuffer retValue = new StringBuffer(512);
        String servletUrl = OpenCms.getSystemInfo().getOpenCmsContext();
        Locale locale = cms.getRequestContext().getLocale();
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(locale);
        retValue.append("function initTreeResources() {\n");
        retValue.append("\tinitResources(\"");
        retValue.append(encoding);
        retValue.append("\", \"");
        retValue.append("/system/workplace/");
        retValue.append("\", \"");
        retValue.append(skinUri);
        retValue.append("\", \"");
        retValue.append(servletUrl);
        retValue.append("\");\n");
        List<I_CmsResourceType> allResTypes = OpenCms.getResourceManager().getResourceTypes();
        for (int i = 0; i < allResTypes.size(); ++i) {
            I_CmsResourceType type = allResTypes.get(i);
            int curTypeId = type.getTypeId();
            String curTypeName = type.getTypeName();
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(curTypeName);
            if (settings == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_MISSING_SETTINGS_ENTRY_1", curTypeName));
                }
                settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypePlain.getStaticTypeName());
            }
            retValue.append("\taddResourceType(");
            retValue.append(curTypeId);
            retValue.append(", \"");
            retValue.append(curTypeName);
            retValue.append("\",\t\"");
            retValue.append(messages.key(settings.getKey()));
            retValue.append("\",\t\"filetypes/");
            retValue.append(settings.getIcon());
            retValue.append("\");\n");
        }
        retValue.append("}\n\n");
        retValue.append("initTreeResources();\n");
        String sharedFolder = OpenCms.getSiteManager().getSharedFolder();
        if (sharedFolder != null) {
            retValue.append("sharedFolderName = '" + sharedFolder + "';");
        }
        return retValue.toString();
    }

    public String getRootFolder() {
        if (this.m_rootFolder == null) {
            String folder = "/";
            if (this.getTreeType() == null && this.getSettings().getUserSettings().getRestrictExplorerView()) {
                folder = this.getSettings().getUserSettings().getStartFolder();
            }
            try {
                this.getCms().readFolder(folder, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e);
                }
                folder = "/";
            }
            this.m_rootFolder = folder;
        }
        return this.m_rootFolder;
    }

    public String getSiteSelector(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        String preSelection = this.getSettings().getTreeSite(this.getTreeType());
        if (preSelection == null) {
            preSelection = "".equals(this.getCms().getRequestContext().getSiteRoot()) ? "" : OpenCms.getSiteManager().getCurrentSite(this.getCms()).getSiteRoot();
            this.getSettings().setTreeSite(this.getTreeType(), preSelection);
        }
        boolean includeRootSite = true;
        boolean showSiteUrls = false;
        if (TYPE_PAGELINK.equals(this.getTreeType())) {
            includeRootSite = false;
            showSiteUrls = true;
        }
        List<CmsSite> sites = OpenCms.getSiteManager().getAvailableSites(this.getCms(), includeRootSite, true, this.getCms().getRequestContext().getOuFqn());
        Iterator<CmsSite> i = sites.iterator();
        int pos = 0;
        while (i.hasNext()) {
            CmsSite site = i.next();
            values.add(site.getSiteRoot());
            String curOption = this.substituteSiteTitle(site.getTitle());
            if (showSiteUrls && site.getSiteMatcher() != null) {
                curOption = site.getUrl() + " (" + curOption + ")";
                if (this.getCms().getRequestContext().getSiteRoot().equals(site.getSiteRoot())) {
                    curOption = "*" + curOption;
                }
            }
            if (site.getSiteRoot().equals(preSelection)) {
                selectedIndex = pos;
            }
            options.add(curOption);
            ++pos;
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTree() {
        StringBuffer result = new StringBuffer(2048);
        ArrayList<String> targetFolderList = new ArrayList<String>();
        if (this.getTargetFolder() != null) {
            StringTokenizer T = new StringTokenizer(this.getTargetFolder(), "|");
            while (T.hasMoreTokens()) {
                String currentFolder = T.nextToken().trim();
                targetFolderList.add(currentFolder);
            }
        } else {
            targetFolderList.add(null);
        }
        String storedSiteRoot = null;
        try {
            ArrayList<String> projectResources;
            String oldSiteRoot;
            ArrayList<CmsResource> resources;
            CmsFolder folder;
            block40: {
                folder = null;
                resources = new ArrayList<CmsResource>();
                oldSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                for (String currentTargetFolder : targetFolderList) {
                    if (this.getSettings().getTreeSite(this.getTreeType()) != null) {
                        storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                        if (this.newTree() && currentTargetFolder == null) {
                            currentTargetFolder = "/";
                        }
                        this.getCms().getRequestContext().setSiteRoot(this.getSettings().getTreeSite(this.getTreeType()));
                        try {
                            this.getCms().readFolder(currentTargetFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                        }
                        catch (CmsException e) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)e);
                            }
                            currentTargetFolder = "/";
                        }
                    }
                    try {
                        folder = this.getCms().readFolder(currentTargetFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                    }
                    catch (CmsException e) {
                        String string = this.printError(e);
                        Object var14_18 = null;
                        if (storedSiteRoot == null) return string;
                        this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                        return string;
                    }
                    String startFolder = this.getStartFolder();
                    String rcSite = this.getCms().getRequestContext().getSiteRoot();
                    if (OpenCms.getSiteManager().startsWithShared(currentTargetFolder) && OpenCms.getSiteManager().startsWithShared(rcSite)) {
                        currentTargetFolder = currentTargetFolder.substring(OpenCms.getSiteManager().getSharedFolder().length() - 1);
                    }
                    if (startFolder == null || !currentTargetFolder.startsWith(startFolder)) {
                        try {
                            if (this.includeFiles()) {
                                resources.addAll(this.getCms().getResourcesInFolder(currentTargetFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                                continue;
                            }
                            resources.addAll(this.getCms().getSubFolders(currentTargetFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                            continue;
                        }
                        catch (CmsException e) {
                            String string = this.printError(e);
                            Object var14_19 = null;
                            if (storedSiteRoot == null) return string;
                            this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                            return string;
                        }
                    }
                    try {
                        if (this.includeFiles()) {
                            resources.addAll(this.getCms().getResourcesInFolder(startFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                        } else {
                            resources.addAll(this.getCms().getSubFolders(startFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                        }
                        StringTokenizer tok = new StringTokenizer(currentTargetFolder.substring(startFolder.length()), "/");
                        while (tok.hasMoreTokens()) {
                            startFolder = startFolder + tok.nextToken() + "/";
                            if (this.includeFiles()) {
                                resources.addAll(this.getCms().getResourcesInFolder(startFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                                continue;
                            }
                            resources.addAll(this.getCms().getSubFolders(startFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                        }
                    }
                    catch (CmsException e) {
                        String string = this.printError(e);
                        Object var14_20 = null;
                        if (storedSiteRoot == null) return string;
                        this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                        return string;
                    }
                }
                result.append("function init() {\n");
                if (this.newTree()) {
                    result.append("parent.initTree();\n");
                    result.append(this.getRootNode());
                }
                projectResources = new ArrayList();
                if (this.isProjectAware()) {
                    try {
                        projectResources = this.getCms().readProjectResources(this.getCms().getRequestContext().getCurrentProject());
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block40;
                        LOG.info((Object)e);
                    }
                }
            }
            for (CmsResource resource : resources) {
                boolean grey = false;
                if (this.isProjectAware()) {
                    boolean bl = grey = !CmsProject.isInsideProject(projectResources, resource);
                }
                if (!grey) {
                    try {
                        OpenCms.getResourceManager().getResourceType(resource.getTypeId());
                    }
                    catch (CmsLoaderException e) {
                        grey = true;
                    }
                }
                result.append(this.getNode(resource.getRootPath(), resource.getName(), resource.getTypeId(), resource.isFolder(), resource.getState(), grey));
            }
            if (this.includeFiles()) {
                result.append("parent.setIncludeFiles(true);\n");
            }
            result.append("parent.setProjectAware(").append(this.isProjectAware()).append(");\n");
            if (this.getTreeType() != null) {
                result.append("parent.setTreeType(\"");
                result.append(this.getTreeType());
                result.append("\");\n");
                String curSite = this.getSettings().getTreeSite(this.getTreeType());
                if (curSite != null) {
                    result.append("parent.setSitePrefix(\"");
                    result.append(this.getSitePrefix(curSite, oldSiteRoot));
                    result.append("\");\n");
                }
            }
            result.append("parent.setRootFolder(\"");
            result.append(this.getRootFolder());
            result.append("\");\n");
            if (folder != null) {
                if (this.newTree()) {
                    result.append("parent.showTree(parent.tree_display.document, \"");
                    result.append(folder.getRootPath().hashCode());
                    result.append("\");\n");
                } else {
                    if (resources.size() == 0) {
                        result.append("parent.setNoChilds(\"");
                        result.append(folder.getRootPath().hashCode());
                        result.append("\");\n");
                    }
                    result.append("parent.showLoadedNodes(parent.tree_display.document,\"");
                    result.append(folder.getRootPath().hashCode());
                    result.append("\");\n");
                }
            }
            result.append("}\n");
            Object var14_21 = null;
            if (storedSiteRoot == null) return result.toString();
            this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
            return result.toString();
        }
        catch (Throwable throwable) {
            Object var14_22 = null;
            if (storedSiteRoot == null) throw throwable;
            this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
            throw throwable;
        }
    }

    public String getTreeType() {
        return this.m_treeType;
    }

    public boolean includeFiles() {
        return this.m_includeFiles;
    }

    public String initTree() {
        return CmsTree.initTree(this.getCms(), this.getEncoding(), CmsTree.getSkinUri());
    }

    public boolean isProjectAware() {
        return this.m_projectAware;
    }

    public void setProjectAware(boolean projectAware) {
        this.m_projectAware = projectAware;
    }

    public boolean showSiteSelector() {
        return this.m_showSiteSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        String rootFolder;
        this.setIncludeFiles(Boolean.valueOf(request.getParameter(PARAM_INCLUDEFILES)));
        this.setProjectAware(Boolean.valueOf(request.getParameter(PARAM_PROJECTAWARE)));
        boolean rootloaded = Boolean.valueOf(request.getParameter(PARAM_ROOTLOADED));
        String resource = request.getParameter(PARAM_RESOURCE);
        this.setTreeType(request.getParameter(PARAM_TYPE));
        String treeSite = request.getParameter(PARAM_TREESITE);
        if (this.getTreeType() != null && treeSite != null) {
            this.getSettings().setTreeSite(this.getTreeType(), treeSite);
        }
        if (this.getSettings().getTreeSite(this.getTreeType()) != null) {
            String site = this.getCms().getRequestContext().getSiteRoot();
            try {
                this.getCms().getRequestContext().setSiteRoot(this.getSettings().getTreeSite(this.getTreeType()));
                if (!this.getCms().existsResource(resource)) {
                    resource = null;
                }
                Object var8_7 = null;
                this.getCms().getRequestContext().setSiteRoot(site);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.getCms().getRequestContext().setSiteRoot(site);
                throw throwable;
            }
        } else if (!this.getCms().existsResource(resource)) {
            resource = null;
        }
        this.computeSiteSelector(request);
        String currentResource = this.getTreeType() == null ? this.getSettings().getExplorerResource() : this.getSettings().getTreeResource(this.getTreeType());
        String lastknown = request.getParameter(PARAM_LASTKNOWN);
        if (resource != null) {
            resource = CmsResource.getFolderPath(resource);
        }
        if (lastknown != null && !lastknown.endsWith("/")) {
            lastknown = lastknown + "/";
        }
        if ((rootFolder = this.getRootFolder()).equals(resource) && !rootFolder.equals(currentResource) && lastknown == null && !rootloaded) {
            lastknown = this.getRootFolder();
            resource = CmsResource.getFolderPath(currentResource);
            this.setNewTree(true);
        } else if (rootFolder.equals(resource)) {
            this.setNewTree(!rootloaded);
        } else {
            this.setNewTree(false);
        }
        if (this.getTreeType() != null) {
            this.getSettings().setTreeResource(this.getTreeType(), resource);
        }
        this.setTargetFolder(resource);
        this.setStartFolder(lastknown);
    }

    private void computeSiteSelector(HttpServletRequest request) {
        boolean selectorForType = TYPE_SIBLING.equals(this.getTreeType()) || TYPE_COPY.equals(this.getTreeType()) || TYPE_PAGELINK.equals(this.getTreeType()) || TYPE_PREFERENCES.equals(this.getTreeType());
        boolean showFromRequest = Boolean.valueOf(request.getParameter(PARAM_SHOWSITESELECTOR));
        if (selectorForType || showFromRequest) {
            int siteCount = OpenCms.getSiteManager().getAvailableSites(this.getCms(), true).size();
            this.setShowSiteSelector(siteCount > 1);
            return;
        }
        this.setShowSiteSelector(false);
    }

    private String getNode(String path, String title, int type, boolean folder, CmsResourceState state, boolean grey) {
        StringBuffer result = new StringBuffer(64);
        String parent = CmsResource.getParentFolder(path);
        result.append("parent.aC(\"");
        result.append(title);
        result.append("\",");
        result.append(type);
        result.append(",");
        if (folder) {
            result.append(1);
        } else {
            result.append(0);
        }
        result.append(",");
        result.append(path.hashCode());
        result.append(",");
        result.append(parent != null ? parent.hashCode() : 0);
        result.append(",");
        result.append(state);
        result.append(",");
        if (grey) {
            result.append(1);
        } else {
            result.append(0);
        }
        result.append(");\n");
        return result.toString();
    }

    private String getRootNode() {
        CmsFolder resource = null;
        String title = null;
        String folder = this.getRootFolder();
        try {
            resource = this.getCms().readFolder(folder, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsProperty titleProperty = this.getCms().readPropertyObject(folder, "Title", false);
            if (titleProperty == null || titleProperty.isNullProperty()) {
                this.getCms().getSitePath(resource);
                title = resource.getRootPath();
            } else {
                title = titleProperty.getValue();
            }
            return this.getNode(resource.getRootPath(), title, resource.getTypeId(), true, resource.getState(), false);
        }
        catch (CmsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e);
            }
            return "";
        }
    }

    private String getSitePrefix(String prefix, String storedSiteRoot) {
        if (OpenCms.getSiteManager().isSharedFolder(prefix)) {
            return prefix;
        }
        if (TYPE_PAGELINK.equals(this.getTreeType())) {
            if (!storedSiteRoot.equals(prefix)) {
                CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(prefix);
                prefix = this.getCms().getRequestContext().removeSiteRoot(prefix);
                prefix = site.getUrl() + OpenCms.getSystemInfo().getOpenCmsContext() + prefix;
            } else {
                prefix = "";
            }
        } else if (TYPE_COPY.equals(this.getTreeType()) || TYPE_SIBLING.equals(this.getTreeType()) || TYPE_VFSWIDGET.equals(this.getTreeType())) {
            if (storedSiteRoot.equals(prefix)) {
                prefix = "";
            }
        } else if (TYPE_PREFERENCES.equals(this.getTreeType())) {
            prefix = "";
        }
        return prefix;
    }

    private String getStartFolder() {
        return this.m_startFolder;
    }

    private String getTargetFolder() {
        return this.m_targetFolder;
    }

    private boolean newTree() {
        return this.m_newTree;
    }

    private String printError(Throwable t) {
        StringBuffer result = new StringBuffer(1024);
        result.append("/*\n");
        result.append(CmsStringUtil.escapeHtml(t.getMessage()));
        result.append("\n*/\n");
        result.append("function init() {\n");
        result.append("}\n");
        return result.toString();
    }

    private void setIncludeFiles(boolean includeFiles) {
        this.m_includeFiles = includeFiles;
    }

    private void setNewTree(boolean newTree) {
        this.m_newTree = newTree;
    }

    private void setShowSiteSelector(boolean showSiteSelector) {
        this.m_showSiteSelector = showSiteSelector;
    }

    private void setStartFolder(String startFolder) {
        this.m_startFolder = startFolder;
    }

    private void setTargetFolder(String targetFolder) {
        this.m_targetFolder = targetFolder;
    }

    private void setTreeType(String type) {
        this.m_treeType = type;
    }
}

