/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer.menu;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsPermissionSet;
import org.opencms.workplace.explorer.CmsExplorerContextMenuItem;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.explorer.menu.CmsMenuItemVisibilityMode;
import org.opencms.workplace.explorer.menu.CmsMirContainerPageActive;

public class CmsMirContainerPageActiveAndFileAvailable
extends CmsMirContainerPageActive {
    public static final Log LOG = CmsLog.getLog(CmsMirContainerPageActiveAndFileAvailable.class);

    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, CmsResourceUtil[] resourceUtil, CmsExplorerContextMenuItem menuItem) {
        String origFileName = menuItem.getParamsMap().get("filename");
        if (origFileName == null) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        String fileName = CmsVfsService.prepareFileNameForEditor(cms, resourceUtil[0].getResource(), origFileName);
        try {
            CmsResource res = cms.readResource(fileName);
            if (!cms.hasPermissions(res, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.DEFAULT)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        }
        catch (CmsVfsResourceNotFoundException e) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
    }
}

