/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import java.awt.Color;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeFolderExtended;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsImageLoader;
import org.opencms.loader.CmsImageScaler;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.galleries.A_CmsAjaxGallery;

public class CmsAjaxImageGallery
extends A_CmsAjaxGallery {
    public static final String GALLERYTYPE_NAME = "imagegallery";
    public static final String OPEN_URI_SUFFIX = "imagegallery/index.jsp";
    public static final String PARAM_FORMATNAME = "formatname";
    public static final String PARAM_FORMATVALUE = "formatvalue";
    public static final String PARAM_HASHID = "hashid";
    public static final String PARAM_IMGHEIGHT = "imgheight";
    public static final String PARAM_IMGWIDTH = "imgwidth";
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_USEFORMATS = "useformats";
    public static final String PARAM_WIDGETMODE = "widgetmode";
    public static final String PROPERTY_COPYRIGHT = "Copyright";
    private static final Log LOG = CmsLog.getLog(CmsAjaxImageGallery.class);
    private CmsImageScaler m_defaultScaleParams;
    private int m_galleryTypeId;

    public CmsAjaxImageGallery() {
    }

    public CmsAjaxImageGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsAjaxImageGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public CmsImageScaler getDefaultScaleParams() {
        return this.m_defaultScaleParams;
    }

    public int getGalleryItemsTypeId() {
        int imageId;
        try {
            imageId = OpenCms.getResourceManager().getResourceType(CmsResourceTypeImage.getStaticTypeName()).getTypeId();
        }
        catch (CmsLoaderException e1) {
            LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
            imageId = CmsResourceTypeImage.getStaticTypeId();
        }
        return imageId;
    }

    public int getGalleryTypeId() {
        block2: {
            try {
                this.m_galleryTypeId = OpenCms.getResourceManager().getResourceType(GALLERYTYPE_NAME).getTypeId();
            }
            catch (CmsLoaderException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.m_galleryTypeId;
    }

    public String getGalleryTypeName() {
        return GALLERYTYPE_NAME;
    }

    public void init() {
        if (CmsImageLoader.isEnabled()) {
            block5: {
                try {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(GALLERYTYPE_NAME);
                    this.m_galleryTypeParams = type instanceof CmsResourceTypeFolderExtended ? ((CmsResourceTypeFolderExtended)type).getFolderClassParams() : null;
                }
                catch (CmsLoaderException e) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.m_defaultScaleParams = new CmsImageScaler(this.m_galleryTypeParams);
            if (!this.m_defaultScaleParams.isValid()) {
                this.m_defaultScaleParams.setType(0);
                this.m_defaultScaleParams.setPosition(0);
                this.m_defaultScaleParams.setWidth(120);
                this.m_defaultScaleParams.setHeight(90);
                this.m_defaultScaleParams.setColor(new Color(221, 221, 221));
            }
        } else {
            this.m_defaultScaleParams = null;
        }
    }

    protected void buildJsonItemSpecificPart(JSONObject jsonObj, CmsResource res, String sitePath) {
        block8: {
            CmsImageScaler scaler = new CmsImageScaler(this.getCms(), res);
            try {
                String scaleParams = "";
                if (this.getDefaultScaleParams() != null) {
                    scaleParams = this.getDefaultScaleParams().toRequestParam();
                }
                jsonObj.put("scalepath", this.getJsp().link(sitePath + scaleParams));
                if (scaler.isValid()) {
                    jsonObj.put("width", scaler.getWidth());
                } else {
                    jsonObj.put("width", -1);
                }
                if (scaler.isValid()) {
                    jsonObj.put("height", scaler.getHeight());
                } else {
                    jsonObj.put("height", -1);
                }
                jsonObj.put("id", res.getStructureId());
                String type = "";
                int dotIndex = res.getName().lastIndexOf(46);
                if (dotIndex != -1) {
                    type = res.getName().substring(dotIndex + 1).toLowerCase();
                }
                jsonObj.put("type", type);
                jsonObj.put("hash", res.getStructureId().hashCode());
                String copyright = this.getJsp().property(PROPERTY_COPYRIGHT, sitePath, "");
                jsonObj.put("copyright", CmsStringUtil.escapeJavaScript(copyright));
            }
            catch (JSONException e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

