/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.io.File;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListExplorerDirectAction;
import org.opencms.workplace.list.Messages;

public class CmsListResourceTypeIconAction
extends CmsListExplorerDirectAction {
    public CmsListResourceTypeIconAction(String id) {
        super(id);
    }

    public CmsMessageContainer getHelpText() {
        if (super.getHelpText() == null || super.getHelpText().equals(EMPTY_MESSAGE)) {
            return Messages.get().container("GUI_EXPLORER_LIST_ACTION_RES_HELP_0");
        }
        return super.getHelpText();
    }

    public String getIconPath() {
        return this.getResourceUtil().getIconPathExplorer();
    }

    public CmsMessageContainer getName() {
        if (super.getName() == null) {
            return new CmsMessageContainer(null, this.getResourceUtil().getResourceTypeName());
        }
        return super.getName();
    }

    protected String defButtonHtml(String id, String helpId, String name, String helpText, boolean enabled, String iconPath, String confirmationMessage, String onClick, boolean singleHelp) {
        StringBuffer html = new StringBuffer(1024);
        html.append("\t<span class=\"link");
        if (enabled) {
            html.append("\"");
        } else {
            html.append(" linkdisabled\"");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(helpText)) {
            if (!singleHelp) {
                html.append(" onMouseOver=\"sMH('");
                html.append(id);
                html.append("');\" onMouseOut=\"hMH('");
                html.append(id);
                html.append("');\"");
            } else {
                html.append(" onMouseOver=\"sMHS('");
                html.append(id);
                html.append("', '");
                html.append(helpId);
                html.append("');\" onMouseOut=\"hMH('");
                html.append(id);
                html.append("', '");
                html.append(helpId);
                html.append("');\"");
            }
        }
        if (enabled && CmsStringUtil.isNotEmptyOrWhitespaceOnly(onClick)) {
            html.append(" onClick=\"");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(confirmationMessage)) {
                html.append("if (confirm('" + CmsStringUtil.escapeJavaScript(confirmationMessage) + "')) {");
            }
            html.append(onClick);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(confirmationMessage)) {
                html.append(" }");
            }
            html.append("\"");
        }
        html.append(" title='");
        html.append(name);
        html.append("'");
        html.append(" style='display: block; width: 20px; height: 20px;'>");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(iconPath)) {
            html.append("<img src='");
            html.append(CmsWorkplace.getSkinUri());
            if (!enabled) {
                StringBuffer icon = new StringBuffer(128);
                int pos = iconPath.lastIndexOf(46);
                if (pos < 0) {
                    pos = iconPath.length();
                }
                icon.append(iconPath.substring(0, pos));
                icon.append("_disabled");
                icon.append(iconPath.substring(pos));
                String resourcesRoot = OpenCms.getSystemInfo().getWebApplicationRfsPath() + "resources/";
                File test = new File(resourcesRoot + icon.toString());
                if (test.exists()) {
                    html.append(icon);
                } else {
                    html.append(iconPath);
                }
            } else {
                html.append(iconPath);
            }
            html.append("'");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) {
                html.append(" alt='");
                html.append(name);
                html.append("'");
                html.append(" title='");
                html.append(name);
                html.append("'");
            }
            html.append(" style='width: 16px; height: 16px;");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getResourceUtil().getStyleSiblings())) {
                html.append(this.getResourceUtil().getStyleSiblings());
            }
            html.append("' >");
        }
        html.append("</span>\n");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(helpText) && !singleHelp) {
            html.append("<div class='help' id='help");
            html.append(helpId);
            html.append("' onMouseOver=\"sMH('");
            html.append(id);
            html.append("');\" onMouseOut=\"hMH('");
            html.append(id);
            html.append("');\">");
            html.append(helpText);
            html.append("</div>\n");
        }
        return html.toString();
    }
}

