/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.util.List;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;
import org.opencms.workplace.tools.CmsTool;
import org.opencms.workplace.tools.CmsToolDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsToolGroup {
    private final CmsIdentifiableObjectContainer<CmsTool> m_container = new CmsIdentifiableObjectContainer(true, true);
    private final String m_id;
    private final String m_name;

    public CmsToolGroup(String id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    public void addAdminTool(CmsTool adminTool) {
        this.m_container.addIdentifiableObject(adminTool.getId(), adminTool);
    }

    public void addAdminTool(CmsTool adminTool, float position) {
        this.m_container.addIdentifiableObject(adminTool.getId(), adminTool, position);
    }

    public List<CmsTool> getAdminTools() {
        return this.m_container.elementList();
    }

    public String getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String groupHtml(CmsWorkplace wp) {
        StringBuffer html = new StringBuffer(2048);
        for (CmsTool item : this.m_container.elementList()) {
            html.append(item.buttonHtml(wp));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(html.toString())) {
            html.insert(0, ((CmsToolDialog)wp).iconsBlockAreaStart(this.getName()));
            html.append(((CmsToolDialog)wp).iconsBlockAreaEnd());
        }
        return html.toString();
    }
}

