/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.Messages;

public class CmsConfigurationFileFinder {
    private static final Log LOG = CmsLog.getLog(CmsConfigurationFileFinder.class);
    private String m_propertyName;

    public CmsConfigurationFileFinder(String propertyName) {
        this.m_propertyName = propertyName;
    }

    public CmsResource getConfigurationFile(CmsObject cms, String containerPageUri) {
        String cfgPath = null;
        try {
            cfgPath = cms.readPropertyObject(containerPageUri, this.m_propertyName, true).getValue();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(cfgPath)) {
            try {
                String templateUri = cms.readPropertyObject(containerPageUri, "template", true).getValue();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(templateUri)) {
                    cfgPath = cms.readPropertyObject(templateUri, this.m_propertyName, true).getValue();
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(cfgPath)) {
            LOG.warn((Object)Messages.get().getBundle().key("ERR_CONFIG_NOT_SET_2", containerPageUri, this.m_propertyName));
            return null;
        }
        try {
            return cms.readResource(cfgPath);
        }
        catch (Exception e1) {
            try {
                CmsResource baseResource = cms.readResource(containerPageUri);
                String baseRootPath = baseResource.getRootPath();
                String siteRoot = OpenCms.getSiteManager().getSiteRoot(baseRootPath);
                String rootCfgPath = CmsStringUtil.joinPaths(siteRoot, cfgPath);
                return cms.readResource(rootCfgPath);
            }
            catch (Exception e2) {
                throw new CmsIllegalStateException(Messages.get().container("ERR_CONFIG_NOT_FOUND_3", containerPageUri, this.m_propertyName, cfgPath));
            }
        }
    }
}

