/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsXmlGroupContainerHandler
extends CmsDefaultXmlContentHandler {
    protected static final Log LOG = CmsLog.getLog(CmsXmlGroupContainerHandler.class);

    protected static List<CmsContainerElementBean> loadGroupContainerElements(CmsObject cms, CmsResource resource) throws CmsException {
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, resource);
        CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(cms, cms.getRequestContext().getLocale());
        List<CmsContainerElementBean> elemBeans = groupContainer.getElements();
        ArrayList<CmsContainerElementBean> result = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElementBean elementBean : elemBeans) {
            if (elementBean.isInMemoryOnly()) continue;
            elementBean.initResource(cms);
            result.add(elementBean);
        }
        return result;
    }

    @Override
    public Set<String> getCSSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        HashSet<String> result = new HashSet<String>();
        List<CmsContainerElementBean> containerElements = CmsXmlGroupContainerHandler.loadGroupContainerElements(cms, resource);
        for (CmsContainerElementBean elementBean : containerElements) {
            CmsResource elementResource = elementBean.getResource();
            Set<String> elementIncludes = CmsXmlContentDefinition.getContentHandlerForResource(cms, elementResource).getCSSHeadIncludes(cms, elementResource);
            result.addAll(elementIncludes);
        }
        return result;
    }

    @Override
    public Set<String> getJSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        HashSet<String> result = new HashSet<String>();
        List<CmsContainerElementBean> containerElements = CmsXmlGroupContainerHandler.loadGroupContainerElements(cms, resource);
        for (CmsContainerElementBean elementBean : containerElements) {
            CmsResource elementResource = elementBean.getResource();
            Set<String> elementIncludes = CmsXmlContentDefinition.getContentHandlerForResource(cms, elementResource).getJSHeadIncludes(cms, elementResource);
            result.addAll(elementIncludes);
        }
        return result;
    }
}

