/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsListResourceBundle;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.loader.I_CmsFileNameGenerator;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCategoryWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.editors.CmsXmlContentWidgetVisitor;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlGenericWrapper;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentTab;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsDefaultXmlContentHandler
implements I_CmsXmlContentHandler {
    public static final String APPINFO_APPINFO = "appinfo";
    public static final String APPINFO_ATTR_COLLAPSE = "collapse";
    public static final String APPINFO_ATTR_CONFIGURATION = "configuration";
    public static final String APPINFO_ATTR_DEFAULT = "default";
    public static final String APPINFO_ATTR_DESCRIPTION = "description";
    public static final String APPINFO_ATTR_ELEMENT = "element";
    public static final String APPINFO_ATTR_ERROR = "error";
    public static final String APPINFO_ATTR_INVALIDATE = "invalidate";
    public static final String APPINFO_ATTR_KEY = "key";
    public static final String APPINFO_ATTR_LOCALE = "locale";
    public static final String APPINFO_ATTR_MAPTO = "mapto";
    public static final String APPINFO_ATTR_MAXWIDTH = "maxwidth";
    public static final String APPINFO_ATTR_MESSAGE = "message";
    public static final String APPINFO_ATTR_MINWIDTH = "minwidth";
    public static final String APPINFO_ATTR_NAME = "name";
    public static final String APPINFO_ATTR_NICE_NAME = "nice-name";
    public static final String APPINFO_ATTR_PREVIEW = "preview";
    public static final String APPINFO_ATTR_REGEX = "regex";
    public static final String APPINFO_ATTR_RULE_REGEX = "rule-regex";
    public static final String APPINFO_ATTR_RULE_TYPE = "rule-type";
    public static final String APPINFO_ATTR_SEARCHCONTENT = "searchcontent";
    public static final String APPINFO_ATTR_SELECT_INHERIT = "select-inherit";
    public static final String APPINFO_ATTR_TYPE = "type";
    public static final String APPINFO_ATTR_TYPE_NODE = "node";
    public static final String APPINFO_ATTR_TYPE_PARENT = "parent";
    public static final String APPINFO_ATTR_TYPE_WARNING = "warning";
    public static final String APPINFO_ATTR_URI = "uri";
    public static final String APPINFO_ATTR_USEALL = "useall";
    public static final String APPINFO_ATTR_VALUE = "value";
    public static final String APPINFO_ATTR_WIDGET = "widget";
    public static final String APPINFO_ATTR_WIDGET_CONFIG = "widget-config";
    public static final String APPINFO_ATTRIBUTE_TYPE_CSS = "css";
    public static final String APPINFO_ATTRIBUTE_TYPE_JAVASCRIPT = "javascript";
    public static final String APPINFO_BUNDLE = "bundle";
    public static final String APPINFO_DEFAULT = "default";
    public static final String APPINFO_DEFAULTS = "defaults";
    public static final String APPINFO_FORMATTER = "formatter";
    public static final String APPINFO_FORMATTERS = "formatters";
    public static final String APPINFO_HEAD_INCLUDE = "headinclude";
    public static final String APPINFO_HEAD_INCLUDES = "headincludes";
    public static final String APPINFO_LAYOUT = "layout";
    public static final String APPINFO_LAYOUTS = "layouts";
    public static final String APPINFO_MAPPING = "mapping";
    public static final String APPINFO_MAPPINGS = "mappings";
    public static final String APPINFO_MODELFOLDER = "modelfolder";
    public static final String APPINFO_PREVIEW = "preview";
    public static final String APPINFO_PROPERTYBUNDLE = "propertybundle";
    public static final String APPINFO_RELATION = "relation";
    public static final String APPINFO_RELATIONS = "relations";
    public static final String APPINFO_RESOURCE = "resource";
    public static final String APPINFO_RESOURCEBUNDLE = "resourcebundle";
    public static final String APPINFO_RESOURCEBUNDLES = "resourcebundles";
    public static final String APPINFO_RULE = "rule";
    public static final String APPINFO_SCHEMA_FILE = "org/opencms/xml/content/DefaultAppinfo.xsd";
    public static final String APPINFO_SCHEMA_FILE_TYPES = "org/opencms/xml/content/DefaultAppinfoTypes.xsd";
    public static final String APPINFO_SCHEMA_SYSTEM_ID = "http://www.opencms.org/dtd/6.0/org/opencms/xml/content/DefaultAppinfo.xsd";
    public static final String APPINFO_SCHEMA_TYPES_SYSTEM_ID = "http://www.opencms.org/dtd/6.0/org/opencms/xml/content/DefaultAppinfoTypes.xsd";
    public static final String APPINFO_SEARCHSETTING = "searchsetting";
    public static final String APPINFO_SEARCHSETTINGS = "searchsettings";
    public static final String APPINFO_SETTING = "setting";
    public static final String APPINFO_SETTINGS = "settings";
    public static final String APPINFO_TAB = "tab";
    public static final String APPINFO_TABS = "tabs";
    public static final String APPINFO_VALIDATIONRULE = "validationrule";
    public static final String APPINFO_VALIDATIONRULES = "validationrules";
    public static final String APPINFO_XMLBUNDLE = "xmlbundle";
    public static final String ATTRIBUTE_INCLUDE_TYPE_CSS = "css";
    public static final String ATTRIBUTE_INCLUDE_TYPE_JAVASCRIPT = "javascript";
    public static final String MACRO_PREVIEW_TEMPFILE = "previewtempfile";
    protected static final String MESSAGE_VALIDATION_DEFAULT_ERROR = "${validation.path}: ${key.GUI_EDITOR_XMLCONTENT_VALIDATION_ERROR_2|${validation.value}|[${validation.regex}]}";
    protected static final String MESSAGE_VALIDATION_DEFAULT_WARNING = "${validation.path}: ${key.GUI_EDITOR_XMLCONTENT_VALIDATION_WARNING_2|${validation.value}|[${validation.regex}]}";
    private static final String APPINFO_ATTR_PREFERFOLDER = "PreferFolder";
    private static final Log LOG;
    protected Map<String, String> m_configurationValues;
    protected Set<String> m_cssHeadIncludes;
    protected Map<String, String> m_defaultValues;
    protected Map<String, List<String>> m_elementMappings;
    protected Map<String, I_CmsWidget> m_elementWidgets;
    protected CmsFormatterConfiguration m_formatterConfiguration;
    protected List<CmsFormatterBean> m_formatters;
    protected Set<String> m_jsHeadIncludes;
    protected List<String> m_messageBundleNames;
    protected String m_modelFolder;
    protected String m_previewLocation;
    protected Map<String, Boolean> m_relationChecks;
    protected Map<String, CmsRelationType> m_relations;
    protected Map<String, Boolean> m_searchSettings;
    protected Map<String, CmsXmlContentProperty> m_settings;
    protected List<CmsXmlContentTab> m_tabs;
    protected List<String> m_titleMappings;
    protected Map<String, String> m_validationErrorMessages;
    protected Map<String, String> m_validationErrorRules;
    protected Map<String, String> m_validationWarningMessages;
    protected Map<String, String> m_validationWarningRules;

    public CmsDefaultXmlContentHandler() {
        this.init();
    }

    @Override
    public String getConfiguration(I_CmsXmlSchemaType type) {
        String elementName = type.getName();
        return this.m_configurationValues.get(elementName);
    }

    @Override
    public Set<String> getCSSHeadIncludes() {
        return Collections.unmodifiableSet(this.m_cssHeadIncludes);
    }

    @Override
    public Set<String> getCSSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        return this.getCSSHeadIncludes();
    }

    @Override
    public String getDefault(CmsObject cms, I_CmsXmlContentValue value, Locale locale) {
        String defaultValue;
        if (value.getElement() == null) {
            defaultValue = value.getDefault(locale);
        } else {
            String xpath = value.getPath();
            defaultValue = this.m_defaultValues.get(xpath);
            if (defaultValue == null) {
                xpath = CmsXmlUtils.removeXpath(xpath);
                xpath = CmsXmlUtils.createXpath(xpath, 1);
                defaultValue = this.m_defaultValues.get(xpath);
            }
        }
        if (defaultValue != null) {
            CmsObject newCms = cms;
            try {
                CmsFile file = value.getDocument().getFile();
                CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(file.getRootPath());
                if (site != null) {
                    newCms = OpenCms.initCmsObject(cms);
                    newCms.getRequestContext().setSiteRoot(site.getSiteRoot());
                    newCms.getRequestContext().setUri(newCms.getSitePath(file));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(newCms).setMessages(this.getMessages(locale));
            return resolver.resolveMacros(defaultValue);
        }
        return null;
    }

    @Override
    public CmsFormatterConfiguration getFormatterConfiguration(CmsObject cms, CmsResource resource) {
        if (this.m_formatterConfiguration == null) {
            this.m_formatterConfiguration = CmsFormatterConfiguration.create(cms, this.m_formatters);
        }
        return this.m_formatterConfiguration;
    }

    @Override
    public Set<String> getJSHeadIncludes() {
        return Collections.unmodifiableSet(this.m_jsHeadIncludes);
    }

    @Override
    public Set<String> getJSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsException {
        return this.getJSHeadIncludes();
    }

    @Override
    public List<String> getMappings(String elementName) {
        return this.m_elementMappings.get(elementName);
    }

    @Override
    public CmsMessages getMessages(Locale locale) {
        CmsMessages result = null;
        if (this.m_messageBundleNames != null && !this.m_messageBundleNames.isEmpty()) {
            if (this.m_messageBundleNames.size() == 1) {
                result = new CmsMessages(this.m_messageBundleNames.get(0), locale);
            } else {
                CmsMultiMessages multiMessages = new CmsMultiMessages(locale);
                for (String messageBundleName : this.m_messageBundleNames) {
                    multiMessages.addMessages(new CmsMessages(messageBundleName, locale));
                }
                result = multiMessages;
            }
        }
        return result;
    }

    @Override
    public String getModelFolder() {
        return this.m_modelFolder;
    }

    @Override
    public String getPreview(CmsObject cms, CmsXmlContent content, String resourcename) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        resolver.addMacro(MACRO_PREVIEW_TEMPFILE, resourcename);
        return resolver.resolveMacros(this.m_previewLocation);
    }

    @Override
    @Deprecated
    public CmsRelationType getRelationType(I_CmsXmlContentValue value) {
        if (value == null) {
            return CmsRelationType.XML_WEAK;
        }
        return this.getRelationType(value.getPath());
    }

    @Override
    public CmsRelationType getRelationType(String xpath) {
        String path;
        if (xpath == null) {
            return CmsRelationType.XML_WEAK;
        }
        CmsRelationType relationType = null;
        relationType = this.m_relations.get(xpath);
        if (relationType == null) {
            path = CmsXmlUtils.removeXpathIndex(xpath);
            relationType = this.m_relations.get(path);
        }
        if (relationType == null) {
            path = CmsXmlUtils.getLastXpathElement(xpath);
            relationType = this.m_relations.get(path);
        }
        if (relationType == null) {
            return CmsRelationType.XML_WEAK;
        }
        return relationType;
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings(CmsObject cms, CmsResource resource) {
        return Collections.unmodifiableMap(this.m_settings);
    }

    @Override
    public List<CmsXmlContentTab> getTabs() {
        return Collections.unmodifiableList(this.m_tabs);
    }

    @Override
    public String getTitleMapping(CmsObject cms, CmsXmlContent document, Locale locale) {
        String result = null;
        if (this.m_titleMappings.size() > 0) {
            String xpath = this.m_titleMappings.get(0);
            result = document.getStringValue(cms, xpath, locale);
        }
        return result;
    }

    @Override
    public I_CmsWidget getWidget(I_CmsXmlContentValue value) {
        I_CmsWidget result = this.m_elementWidgets.get(value.getName());
        result = result == null ? OpenCms.getXmlContentTypeManager().getWidgetDefault(value.getTypeName()) : result.newInstance();
        String configuration = this.getConfiguration(value);
        if (configuration == null) {
            configuration = OpenCms.getXmlContentTypeManager().getWidgetDefaultConfiguration(result);
        }
        result.setConfiguration(configuration);
        return result;
    }

    @Override
    public synchronized void initialize(Element appInfoElement, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        if (appInfoElement != null) {
            this.validateAppinfoElement(appInfoElement);
            this.init();
            Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(appInfoElement);
            while (i.hasNext()) {
                Element element = i.next();
                String nodeName = element.getName();
                if (nodeName.equals(APPINFO_MAPPINGS)) {
                    this.initMappings(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_LAYOUTS)) {
                    this.initLayouts(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_VALIDATIONRULES)) {
                    this.initValidationRules(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_RELATIONS)) {
                    this.initRelations(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_DEFAULTS)) {
                    this.initDefaultValues(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_MODELFOLDER)) {
                    this.initModelFolder(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals("preview")) {
                    this.initPreview(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_RESOURCEBUNDLE)) {
                    this.initResourceBundle(element, contentDefinition, true);
                    continue;
                }
                if (nodeName.equals(APPINFO_RESOURCEBUNDLES)) {
                    this.initResourceBundle(element, contentDefinition, false);
                    continue;
                }
                if (nodeName.equals(APPINFO_SEARCHSETTINGS)) {
                    this.initSearchSettings(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_TABS)) {
                    this.initTabs(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_FORMATTERS)) {
                    this.initFormatters(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_HEAD_INCLUDES)) {
                    this.initHeadIncludes(element, contentDefinition);
                    continue;
                }
                if (!nodeName.equals(APPINFO_SETTINGS)) continue;
                this.initSettings(element, contentDefinition);
            }
        }
        this.addDefaultCheckRules(contentDefinition, null, null);
    }

    @Override
    public void invalidateBrokenLinks(CmsObject cms, CmsXmlContent document) {
        if (cms == null || cms.getRequestContext().getRequestTime() == Long.MIN_VALUE) {
            return;
        }
        boolean needReinitialization = false;
        for (Locale locale : document.getLocales()) {
            ArrayList<String> removedNodes = new ArrayList<String>();
            for (I_CmsXmlContentValue value : document.getValues(locale)) {
                String path = value.getPath();
                boolean alreadyRemoved = false;
                for (String remNode : removedNodes) {
                    if (!path.startsWith(remNode)) continue;
                    alreadyRemoved = true;
                    break;
                }
                if (alreadyRemoved || this.m_relationChecks.get(path) == null && this.m_relationChecks.get(CmsXmlUtils.removeXpath(path)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_RULE_MATCH_1", path));
                }
                if (!this.validateLink(cms, value, null)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_WARNING_2", path, value.getStringValue(cms)));
                }
                String parentPath = path;
                while (this.isInvalidateParent(parentPath)) {
                    parentPath = CmsXmlUtils.removeLastXpathElement(parentPath);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_PARENT_2", path, parentPath));
                }
                value = document.getValue(parentPath, locale);
                value.getElement().detach();
                removedNodes.add(parentPath);
            }
            if (removedNodes.isEmpty()) continue;
            needReinitialization = true;
        }
        if (needReinitialization) {
            document.initDocument();
        }
    }

    @Override
    public boolean isSearchable(I_CmsXmlContentValue value) {
        Boolean anno = this.m_searchSettings.get(value.getName());
        return anno == null ? value.isSearchable() : anno.booleanValue();
    }

    @Override
    public CmsXmlContent prepareForUse(CmsObject cms, CmsXmlContent content) {
        return content;
    }

    @Override
    public CmsFile prepareForWrite(CmsObject cms, CmsXmlContent content, CmsFile file) throws CmsException {
        String contentConversion;
        if (!content.isAutoCorrectionEnabled()) {
            Object attribute = cms.getRequestContext().getAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE);
            boolean autoCorrectionEnabled = attribute != null && (Boolean)attribute != false;
            content.setAutoCorrectionEnabled(autoCorrectionEnabled);
        }
        if (!content.isAutoCorrectionEnabled()) {
            content.validateXmlStructure(new CmsXmlEntityResolver(cms));
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(contentConversion = CmsHtmlConverter.getConversionSettings(cms, file))) {
            contentConversion = "xhtml";
        }
        content.setConversion(contentConversion);
        file = content.correctXmlStructure(cms);
        content.setFile(file);
        content.resolveMappings(cms);
        this.removeEmptyMappings(cms, content);
        file = this.writeCategories(cms, file, content);
        return file;
    }

    @Override
    public void resolveMapping(CmsObject cms, CmsXmlContent content, I_CmsXmlContentValue value) throws CmsException {
        CmsLock lock;
        if (!value.isSimpleType()) {
            return;
        }
        CmsFile file = content.getFile();
        if (file == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_RESOLVE_FILE_NOT_FOUND_0"));
        }
        List<String> mappings = this.getMappings(value.getPath());
        if (mappings == null) {
            return;
        }
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        Object logEntry = cms.getRequestContext().getAttribute("ATTR_LOG_ENTRY");
        if (logEntry != null) {
            rootCms.getRequestContext().setAttribute("ATTR_LOG_ENTRY", logEntry);
        }
        rootCms.getRequestContext().setSiteRoot("/");
        List<CmsResource> siblings = rootCms.readSiblings(content.getFile().getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
        HashSet<CmsResource> urlNameMappingResources = new HashSet<CmsResource>();
        boolean mapToUrlName = false;
        urlNameMappingResources.add(content.getFile());
        for (String mapping : mappings) {
            if (!CmsStringUtil.isNotEmpty(mapping)) continue;
            block11: for (int i = siblings.size() - 1; i >= 0; --i) {
                String property;
                String filename = siblings.get(i).getRootPath();
                Locale locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename);
                if (mapping.startsWith("urlName")) {
                    mapToUrlName = true;
                }
                if (!locale.equals(value.getLocale())) continue;
                CmsLock lock2 = rootCms.getLock(filename);
                if (lock2.isUnlocked()) {
                    rootCms.lockResource(filename);
                } else if (!lock2.isDirectlyOwnedInProjectBy(rootCms)) {
                    rootCms.changeLock(filename);
                }
                String stringValue = value.getStringValue(rootCms);
                if (mapping.startsWith("permission:") && value.getIndex() == 0) {
                    String permissionMappings;
                    String mainMapping = permissionMappings = mapping.substring("permission:".length());
                    Map<Object, Object> permissionsToSet = new HashMap();
                    int sepIndex = permissionMappings.indexOf(124);
                    if (sepIndex != -1) {
                        mainMapping = permissionMappings.substring(0, sepIndex);
                        permissionMappings = permissionMappings.substring(sepIndex + 1);
                        permissionsToSet = CmsStringUtil.splitAsMap(permissionMappings, "|", ":");
                    }
                    String principalType = "GROUP";
                    String permissionString = mainMapping;
                    sepIndex = mainMapping.indexOf(58);
                    if (sepIndex != -1) {
                        principalType = mainMapping.substring(0, sepIndex);
                        permissionString = mainMapping.substring(sepIndex + 1);
                    }
                    if (permissionString.toLowerCase().indexOf(111) == -1) {
                        permissionString = permissionString + "+o";
                    }
                    List<CmsAccessControlEntry> aces = rootCms.getAccessControlEntries(filename, false);
                    for (CmsAccessControlEntry cmsAccessControlEntry : aces) {
                        if (cmsAccessControlEntry.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
                            rootCms.rmacc(filename, "ALL_OTHERS", CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString());
                            continue;
                        }
                        I_CmsPrincipal principal = CmsPrincipal.readPrincipal(rootCms, cmsAccessControlEntry.getPrincipal());
                        if (principal.isGroup()) {
                            rootCms.rmacc(filename, "GROUP", principal.getName());
                            continue;
                        }
                        if (!principal.isUser()) continue;
                        rootCms.rmacc(filename, "USER", principal.getName());
                    }
                    for (Map.Entry entry : permissionsToSet.entrySet()) {
                        sepIndex = ((String)entry.getKey()).indexOf(46);
                        if (sepIndex == -1) continue;
                        String type = ((String)entry.getKey()).substring(0, sepIndex);
                        String name = ((String)entry.getKey()).substring(sepIndex + 1);
                        String permissions = (String)entry.getValue();
                        if (permissions.toLowerCase().indexOf(111) == -1) {
                            permissions = permissions + "+o";
                        }
                        try {
                            rootCms.chacc(filename, type, name, permissions);
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e);
                        }
                    }
                    String path = CmsXmlUtils.removeXpathIndex(value.getPath());
                    List<I_CmsXmlContentValue> list = content.getValues(path, locale);
                    for (I_CmsXmlContentValue val : list) {
                        String principalName = val.getStringValue(rootCms);
                        rootCms.chacc(filename, principalType, principalName, permissionString);
                    }
                    i = 0;
                    continue;
                }
                if (mapping.startsWith("propertyList:") && value.getIndex() == 0) {
                    int prefixLength;
                    boolean mapToShared;
                    if (mapping.startsWith("propertyList:shared:")) {
                        mapToShared = true;
                        prefixLength = "propertyList:shared:".length();
                    } else if (mapping.startsWith("propertyList:individual:")) {
                        mapToShared = false;
                        prefixLength = "propertyList:individual:".length();
                    } else {
                        mapToShared = false;
                        prefixLength = "propertyList:".length();
                    }
                    property = mapping.substring(prefixLength);
                    String path = CmsXmlUtils.removeXpathIndex(value.getPath());
                    List<I_CmsXmlContentValue> values = content.getValues(path, locale);
                    Iterator<I_CmsXmlContentValue> j = values.iterator();
                    StringBuffer result = new StringBuffer(values.size() * 64);
                    while (j.hasNext()) {
                        I_CmsXmlContentValue val = j.next();
                        result.append(val.getStringValue(rootCms));
                        if (!j.hasNext()) continue;
                        result.append('|');
                    }
                    CmsProperty p = mapToShared ? new CmsProperty(property, null, result.toString()) : new CmsProperty(property, result.toString(), null);
                    rootCms.writePropertyObject(filename, p);
                    if (!mapToShared) continue;
                    i = 0;
                    continue;
                }
                if (mapping.startsWith("property:")) {
                    int prefixLength;
                    boolean mapToShared;
                    if (mapping.startsWith("property:shared:")) {
                        mapToShared = true;
                        prefixLength = "property:shared:".length();
                    } else if (mapping.startsWith("property:individual:")) {
                        mapToShared = false;
                        prefixLength = "property:individual:".length();
                    } else {
                        mapToShared = false;
                        prefixLength = "property:".length();
                    }
                    property = mapping.substring(prefixLength);
                    CmsProperty p = mapToShared ? new CmsProperty(property, null, stringValue) : new CmsProperty(property, stringValue, null);
                    rootCms.writePropertyObject(filename, p);
                    if (!mapToShared) continue;
                    i = 0;
                    continue;
                }
                if (mapping.startsWith("urlName")) {
                    urlNameMappingResources.add(siblings.get(i));
                    continue;
                }
                if (!mapping.startsWith("attribute:")) continue;
                String attribute = mapping.substring("attribute:".length());
                switch (ATTRIBUTES.indexOf(attribute)) {
                    case 0: {
                        long date = 0L;
                        try {
                            date = Long.valueOf(stringValue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (date == 0L) {
                            date = 0L;
                        }
                        rootCms.setDateReleased(filename, date, false);
                        if (!filename.equals(rootCms.getSitePath(file))) continue block11;
                        file.setDateReleased(date);
                        continue block11;
                    }
                    case 1: {
                        long date = 0L;
                        try {
                            date = Long.valueOf(stringValue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (date == 0L) {
                            date = Long.MAX_VALUE;
                        }
                        rootCms.setDateExpired(filename, date, false);
                        if (!filename.equals(rootCms.getSitePath(file))) continue block11;
                        file.setDateExpired(date);
                        continue block11;
                    }
                }
            }
        }
        if (mapToUrlName) {
            for (CmsResource resourceForUrlNameMapping : urlNameMappingResources) {
                if (CmsResource.isTemporaryFileName(resourceForUrlNameMapping.getRootPath())) continue;
                I_CmsFileNameGenerator nameGen = OpenCms.getResourceManager().getNameGenerator();
                Iterator<String> nameSeq = nameGen.getUrlNameSequence(value.getStringValue(cms));
                cms.writeUrlNameMapping(nameSeq, resourceForUrlNameMapping.getStructureId(), value.getLocale().toString());
            }
        }
        if ((lock = rootCms.getLock(file)).isUnlocked()) {
            rootCms.lockResource(file.getRootPath());
        } else if (!lock.isExclusiveOwnedBy(rootCms.getRequestContext().getCurrentUser())) {
            rootCms.changeLock(file.getRootPath());
        }
    }

    @Override
    public CmsXmlContentErrorHandler resolveValidation(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = new CmsXmlContentErrorHandler();
        }
        if (!value.isSimpleType()) {
            return errorHandler;
        }
        errorHandler = this.validateValue(cms, value, errorHandler, this.m_validationErrorRules, false);
        errorHandler = this.validateValue(cms, value, errorHandler, this.m_validationWarningRules, true);
        errorHandler = this.validateCategories(cms, value, errorHandler);
        return errorHandler;
    }

    protected void addCheckRule(CmsXmlContentDefinition contentDefinition, String elementName, String invalidate, String type) throws CmsXmlException {
        I_CmsXmlSchemaType schemaType = contentDefinition.getSchemaType(elementName);
        if (schemaType == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_INVALID_ELEM_1", elementName));
        }
        if (!"OpenCmsVfsFile".equals(schemaType.getTypeName()) && !"OpenCmsVarLink".equals(schemaType.getTypeName())) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_INVALID_TYPE_1", elementName));
        }
        Boolean invalidateParent = null;
        if (invalidate == null || invalidate.equalsIgnoreCase(Boolean.TRUE.toString()) || invalidate.equalsIgnoreCase(APPINFO_ATTR_TYPE_NODE)) {
            invalidateParent = Boolean.FALSE;
        } else if (invalidate.equalsIgnoreCase(APPINFO_ATTR_TYPE_PARENT)) {
            invalidateParent = Boolean.TRUE;
        }
        if (invalidateParent != null) {
            this.m_relationChecks.put(elementName, invalidateParent);
        }
        CmsRelationType relationType = type == null ? CmsRelationType.XML_WEAK : CmsRelationType.valueOfXml(type);
        this.m_relations.put(elementName, relationType);
        if (invalidateParent != null) {
            String path = elementName;
            while (CmsStringUtil.isNotEmptyOrWhitespaceOnly(path)) {
                if (!this.isInvalidateParent(path)) {
                    if (contentDefinition.getSchemaType(path).getMinOccurs() <= 0) break;
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_NOT_OPTIONAL_1", path));
                }
                if (!CmsXmlUtils.isDeepXpath(path)) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_NOT_EMPTY_DOC_0"));
                }
                path = CmsXmlUtils.removeLastXpathElement(path);
            }
        }
    }

    protected void addConfiguration(CmsXmlContentDefinition contentDefinition, String elementName, String configurationValue) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CONFIG_ELEM_UNKNOWN_1", elementName));
        }
        this.m_configurationValues.put(elementName, configurationValue);
    }

    protected void addDefault(CmsXmlContentDefinition contentDefinition, String elementName, String defaultValue) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(org.opencms.xml.types.Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_DEFAULT_1", elementName));
        }
        String xpath = CmsXmlUtils.createXpath(elementName, 1);
        this.m_defaultValues.put(xpath, defaultValue);
    }

    protected void addDefaultCheckRules(CmsXmlContentDefinition rootContentDefinition, I_CmsXmlSchemaType schemaType, String elementPath) throws CmsXmlException {
        if (schemaType != null && schemaType.isSimpleType()) {
            if (schemaType.getMinOccurs() == 0 && ("OpenCmsVfsFile".equals(schemaType.getTypeName()) || "OpenCmsVarLink".equals(schemaType.getTypeName())) && !this.m_relationChecks.containsKey(elementPath) && !this.m_relations.containsKey(elementPath)) {
                this.addCheckRule(rootContentDefinition, elementPath, null, null);
            }
        } else {
            CmsXmlContentDefinition nestedContentDefinition = rootContentDefinition;
            if (schemaType != null) {
                CmsXmlNestedContentDefinition nestedDefinition = (CmsXmlNestedContentDefinition)schemaType;
                nestedContentDefinition = nestedDefinition.getNestedContentDefinition();
            }
            for (String element : nestedContentDefinition.getSchemaTypes()) {
                String path = schemaType != null ? CmsXmlUtils.concatXpath(elementPath, element) : element;
                I_CmsXmlSchemaType nestedSchema = nestedContentDefinition.getSchemaType(element);
                if (schemaType != null && nestedSchema.equals(schemaType)) continue;
                this.addDefaultCheckRules(rootContentDefinition, nestedSchema, path);
            }
        }
    }

    protected void addMapping(CmsXmlContentDefinition contentDefinition, String elementName, String mapping) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_MAPPING_1", elementName));
        }
        String xpath = CmsXmlUtils.createXpath(elementName, 1);
        List<String> values = this.m_elementMappings.get(xpath);
        if (values == null) {
            values = new ArrayList<String>(4);
            this.m_elementMappings.put(xpath, values);
        }
        values.add(mapping);
        if (mapping.startsWith("property:") && mapping.endsWith(":Title")) {
            this.m_titleMappings.add(xpath);
        }
    }

    protected void addSearchSetting(CmsXmlContentDefinition contentDefinition, String elementName, Boolean value) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(org.opencms.xml.types.Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_SEARCHSETTINGS_1", elementName));
        }
        this.m_searchSettings.put(elementName, value);
    }

    protected void addValidationRule(CmsXmlContentDefinition contentDefinition, String elementName, String regex, String message, boolean isWarning) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_VALIDATION_1", elementName));
        }
        if (isWarning) {
            this.m_validationWarningRules.put(elementName, regex);
            if (message != null) {
                this.m_validationWarningMessages.put(elementName, message);
            }
        } else {
            this.m_validationErrorRules.put(elementName, regex);
            if (message != null) {
                this.m_validationErrorMessages.put(elementName, message);
            }
        }
    }

    protected void addWidget(CmsXmlContentDefinition contentDefinition, String elementName, String widgetClassOrAlias) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_LAYOUTWIDGET_1", elementName));
        }
        I_CmsWidget widget = OpenCms.getXmlContentTypeManager().getWidget(widgetClassOrAlias);
        if (widget == null) {
            if (CmsStringUtil.isValidJavaClassName(widgetClassOrAlias)) {
                try {
                    Class<?> specialWidgetClass = Class.forName(widgetClassOrAlias);
                    widget = (I_CmsWidget)specialWidgetClass.newInstance();
                }
                catch (Exception e) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_CUSTOM_CLASS_3", widgetClassOrAlias, elementName, contentDefinition.getSchemaLocation()), (Throwable)e);
                }
            }
            if (widget == null) {
                throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_WIDGET_3", widgetClassOrAlias, elementName, contentDefinition.getSchemaLocation()));
            }
        }
        this.m_elementWidgets.put(elementName, widget);
    }

    protected Locale getLocaleForResource(CmsObject cms, String resource) {
        Locale locale = OpenCms.getLocaleManager().getDefaultLocale(cms, resource);
        if (locale == null) {
            List<Locale> locales = OpenCms.getLocaleManager().getAvailableLocales();
            locale = locales.size() > 0 ? locales.get(0) : Locale.ENGLISH;
        }
        return locale;
    }

    protected String getReferencePath(CmsObject cms, I_CmsXmlContentValue value) {
        CmsFile file;
        block6: {
            file = value.getDocument().getFile();
            String resourceName = cms.getSitePath(file);
            if (CmsWorkplace.isTemporaryFile(file)) {
                StringBuffer result = new StringBuffer(resourceName.length() + 2);
                result.append(CmsResource.getFolderPath(resourceName));
                result.append(CmsResource.getName(resourceName).substring(1));
                resourceName = result.toString();
            }
            try {
                List<CmsResource> listsib = cms.readSiblings(resourceName, CmsResourceFilter.ALL);
                for (int i = 0; i < listsib.size(); ++i) {
                    CmsResource resource = listsib.get(i);
                    Locale locale = this.getLocaleForResource(cms, cms.getSitePath(resource));
                    if (!value.getLocale().equals(locale)) continue;
                    return cms.getSitePath(resource);
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return cms.getSitePath(file);
    }

    protected String getValidationMessage(CmsObject cms, I_CmsXmlContentValue value, String regex, String valueStr, boolean matchResult, boolean isWarning) {
        String message = null;
        message = isWarning ? this.m_validationWarningMessages.get(value.getName()) : this.m_validationErrorMessages.get(value.getName());
        if (message == null) {
            message = isWarning ? MESSAGE_VALIDATION_DEFAULT_WARNING : MESSAGE_VALIDATION_DEFAULT_ERROR;
        }
        HashMap<String, String> additionalValues = new HashMap<String, String>();
        additionalValues.put("validation.value", valueStr);
        additionalValues.put("validation.regex", (!matchResult ? "!" : "") + regex);
        additionalValues.put("validation.path", value.getPath());
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms).setMessages(this.getMessages(cms.getRequestContext().getLocale())).setAdditionalMacros(additionalValues);
        return resolver.resolveMacros(message);
    }

    protected void init() {
        this.m_elementMappings = new HashMap<String, List<String>>();
        this.m_elementWidgets = new HashMap<String, I_CmsWidget>();
        this.m_validationErrorRules = new HashMap<String, String>();
        this.m_validationErrorMessages = new HashMap<String, String>();
        this.m_validationWarningRules = new HashMap<String, String>();
        this.m_validationWarningMessages = new HashMap<String, String>();
        this.m_defaultValues = new HashMap<String, String>();
        this.m_configurationValues = new HashMap<String, String>();
        this.m_searchSettings = new HashMap<String, Boolean>();
        this.m_relations = new HashMap<String, CmsRelationType>();
        this.m_relationChecks = new HashMap<String, Boolean>();
        this.m_previewLocation = null;
        this.m_modelFolder = null;
        this.m_tabs = new ArrayList<CmsXmlContentTab>();
        this.m_cssHeadIncludes = new LinkedHashSet<String>();
        this.m_jsHeadIncludes = new LinkedHashSet<String>();
        this.m_settings = new LinkedHashMap<String, CmsXmlContentProperty>();
        this.m_titleMappings = new ArrayList<String>(2);
        this.m_formatters = new ArrayList<CmsFormatterBean>();
    }

    protected void initDefaultValues(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, "default");
        while (i.hasNext()) {
            Element element = i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String defaultValue = element.attributeValue(APPINFO_ATTR_VALUE);
            if (elementName == null || defaultValue == null) continue;
            this.addDefault(contentDefinition, elementName, defaultValue);
        }
    }

    protected void initFormatters(Element root, CmsXmlContentDefinition contentDefinition) {
        Iterator<Element> itFormatter = CmsXmlGenericWrapper.elementIterator(root, APPINFO_FORMATTER);
        while (itFormatter.hasNext()) {
            Element element = itFormatter.next();
            String type = element.attributeValue(APPINFO_ATTR_TYPE);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(type)) {
                type = "*";
            }
            String jspRootPath = element.attributeValue(APPINFO_ATTR_URI);
            String minWidthStr = element.attributeValue(APPINFO_ATTR_MINWIDTH);
            String maxWidthStr = element.attributeValue(APPINFO_ATTR_MAXWIDTH);
            String preview = element.attributeValue("preview");
            String searchContent = element.attributeValue(APPINFO_ATTR_SEARCHCONTENT);
            this.m_formatters.add(new CmsFormatterBean(type, jspRootPath, minWidthStr, maxWidthStr, preview, searchContent, contentDefinition.getSchemaLocation()));
        }
    }

    protected void initHeadIncludes(Element root, CmsXmlContentDefinition contentDefinition) {
        Iterator<Element> itInclude = CmsXmlGenericWrapper.elementIterator(root, APPINFO_HEAD_INCLUDE);
        while (itInclude.hasNext()) {
            Element element = itInclude.next();
            String type = element.attributeValue(APPINFO_ATTR_TYPE);
            String uri = element.attributeValue(APPINFO_ATTR_URI);
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(uri)) continue;
            if ("css".equals(type)) {
                this.m_cssHeadIncludes.add(uri);
                continue;
            }
            if (!"javascript".equals(type)) continue;
            this.m_jsHeadIncludes.add(uri);
        }
    }

    protected void initLayouts(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_LAYOUT);
        while (i.hasNext()) {
            Element element = i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String widgetClassOrAlias = element.attributeValue(APPINFO_ATTR_WIDGET);
            String configuration = element.attributeValue(APPINFO_ATTR_CONFIGURATION);
            if (elementName == null || widgetClassOrAlias == null) continue;
            this.addWidget(contentDefinition, elementName, widgetClassOrAlias);
            if (configuration == null) continue;
            this.addConfiguration(contentDefinition, elementName, configuration);
        }
    }

    protected void initMappings(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_MAPPING);
        while (i.hasNext()) {
            Element element = i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String maptoName = element.attributeValue(APPINFO_ATTR_MAPTO);
            if (elementName == null || maptoName == null) continue;
            this.addMapping(contentDefinition, elementName, maptoName);
        }
    }

    protected void initModelFolder(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String master = root.attributeValue(APPINFO_ATTR_URI);
        if (master == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_MODELFOLDER_URI_2", root.getName(), contentDefinition.getSchemaLocation()));
        }
        this.m_modelFolder = master;
    }

    protected void initPreview(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String preview = root.attributeValue(APPINFO_ATTR_URI);
        if (preview == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_PREVIEW_URI_2", root.getName(), contentDefinition.getSchemaLocation()));
        }
        this.m_previewLocation = preview;
    }

    protected void initRelations(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_RELATION);
        while (i.hasNext()) {
            String type;
            Element element = i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String invalidate = element.attributeValue(APPINFO_ATTR_INVALIDATE);
            if (invalidate != null) {
                invalidate = invalidate.toUpperCase();
            }
            if ((type = element.attributeValue(APPINFO_ATTR_TYPE)) != null) {
                type = type.toLowerCase();
            }
            if (elementName == null) continue;
            this.addCheckRule(contentDefinition, elementName, invalidate, type);
        }
    }

    protected void initResourceBundle(Element root, CmsXmlContentDefinition contentDefinition, boolean single) throws CmsXmlException {
        if (this.m_messageBundleNames == null) {
            this.m_messageBundleNames = new ArrayList<String>(2);
        }
        if (single) {
            String messageBundleName = root.attributeValue(APPINFO_ATTR_NAME);
            if (messageBundleName == null) {
                throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_RESOURCE_BUNDLE_NAME_2", root.getName(), contentDefinition.getSchemaLocation()));
            }
            if (!this.m_messageBundleNames.contains(messageBundleName)) {
                this.m_messageBundleNames.add(messageBundleName);
            }
            CmsResourceBundleLoader.flushBundleCache(messageBundleName);
        } else {
            Iterator<Element> propertybundles = CmsXmlGenericWrapper.elementIterator(root, APPINFO_PROPERTYBUNDLE);
            while (propertybundles.hasNext()) {
                Element propBundle = propertybundles.next();
                String propertyBundleName = propBundle.attributeValue(APPINFO_ATTR_NAME);
                if (!this.m_messageBundleNames.contains(propertyBundleName)) {
                    this.m_messageBundleNames.add(propertyBundleName);
                }
                CmsResourceBundleLoader.flushBundleCache(propertyBundleName);
            }
            Iterator<Element> xmlbundles = CmsXmlGenericWrapper.elementIterator(root, APPINFO_XMLBUNDLE);
            while (xmlbundles.hasNext()) {
                Element xmlbundle = xmlbundles.next();
                String xmlBundleName = xmlbundle.attributeValue(APPINFO_ATTR_NAME);
                if (!this.m_messageBundleNames.contains(xmlBundleName)) {
                    this.m_messageBundleNames.add(xmlBundleName);
                }
                CmsResourceBundleLoader.flushBundleCache(xmlBundleName);
                Iterator<Element> bundles = CmsXmlGenericWrapper.elementIterator(xmlbundle, APPINFO_BUNDLE);
                while (bundles.hasNext()) {
                    Element bundle = bundles.next();
                    String localeStr = bundle.attributeValue(APPINFO_ATTR_LOCALE);
                    Locale locale = CmsStringUtil.isEmptyOrWhitespaceOnly(localeStr) ? null : CmsLocaleManager.getLocale(localeStr);
                    if (CmsLocaleManager.getDefaultLocale().equals(locale)) {
                        locale = null;
                    }
                    CmsListResourceBundle xmlBundle = null;
                    Iterator<Element> resources = CmsXmlGenericWrapper.elementIterator(bundle, APPINFO_RESOURCE);
                    while (resources.hasNext()) {
                        Element resource = resources.next();
                        String key = resource.attributeValue(APPINFO_ATTR_KEY);
                        String value = resource.attributeValue(APPINFO_ATTR_VALUE);
                        if (CmsStringUtil.isEmptyOrWhitespaceOnly(value)) {
                            value = resource.getTextTrim();
                        }
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(key) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) continue;
                        if (xmlBundle == null) {
                            xmlBundle = new CmsListResourceBundle();
                        }
                        xmlBundle.addMessage(key.trim(), value.trim());
                    }
                    if (xmlBundle == null) continue;
                    CmsResourceBundleLoader.addBundleToCache(xmlBundleName, locale, xmlBundle);
                }
            }
        }
    }

    protected void initSearchSettings(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_SEARCHSETTING);
        while (i.hasNext()) {
            boolean include;
            Element element = i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String searchContent = element.attributeValue(APPINFO_ATTR_SEARCHCONTENT);
            boolean bl = include = CmsStringUtil.isEmpty(searchContent) || Boolean.valueOf(searchContent) != false;
            if (elementName == null) continue;
            this.addSearchSetting(contentDefinition, elementName, include);
        }
    }

    protected void initSettings(Element root, CmsXmlContentDefinition contentDefinition) {
        Iterator<Element> itProperties = CmsXmlGenericWrapper.elementIterator(root, APPINFO_SETTING);
        while (itProperties.hasNext()) {
            Element element = itProperties.next();
            CmsXmlContentProperty setting = new CmsXmlContentProperty(element.attributeValue(APPINFO_ATTR_NAME), element.attributeValue(APPINFO_ATTR_TYPE), element.attributeValue(APPINFO_ATTR_WIDGET), element.attributeValue(APPINFO_ATTR_WIDGET_CONFIG), element.attributeValue(APPINFO_ATTR_RULE_REGEX), element.attributeValue(APPINFO_ATTR_RULE_TYPE), element.attributeValue("default"), element.attributeValue(APPINFO_ATTR_NICE_NAME), element.attributeValue(APPINFO_ATTR_DESCRIPTION), element.attributeValue(APPINFO_ATTR_ERROR), element.attributeValue(APPINFO_ATTR_PREFERFOLDER));
            String name = setting.getName();
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) continue;
            this.m_settings.put(name, setting);
        }
    }

    protected void initTabs(Element root, CmsXmlContentDefinition contentDefinition) {
        if (Boolean.valueOf(root.attributeValue(APPINFO_ATTR_USEALL, CmsStringUtil.FALSE)).booleanValue()) {
            for (I_CmsXmlSchemaType type : contentDefinition.getTypeSequence()) {
                this.m_tabs.add(new CmsXmlContentTab(type.getName()));
            }
        } else {
            Iterator<Element> i = CmsXmlGenericWrapper.elementIterator(root, APPINFO_TAB);
            while (i.hasNext()) {
                Element element = i.next();
                String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
                String collapseValue = element.attributeValue(APPINFO_ATTR_COLLAPSE, CmsStringUtil.TRUE);
                String tabName = element.attributeValue(APPINFO_ATTR_NAME, elementName);
                if (elementName == null) continue;
                this.m_tabs.add(new CmsXmlContentTab(elementName, Boolean.valueOf(collapseValue), tabName));
            }
            I_CmsXmlSchemaType type = contentDefinition.getTypeSequence().get(0);
            CmsXmlContentTab tab = new CmsXmlContentTab(type.getName());
            if (!this.m_tabs.contains(tab)) {
                this.m_tabs.add(0, tab);
            }
        }
    }

    protected void initValidationRules(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        ArrayList<Element> elements = new ArrayList<Element>(CmsXmlGenericWrapper.elements(root, APPINFO_RULE));
        elements.addAll(CmsXmlGenericWrapper.elements(root, APPINFO_VALIDATIONRULE));
        for (Element element : elements) {
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String regex = element.attributeValue(APPINFO_ATTR_REGEX);
            String type = element.attributeValue(APPINFO_ATTR_TYPE);
            if (type != null) {
                type = type.toLowerCase();
            }
            String message = element.attributeValue(APPINFO_ATTR_MESSAGE);
            if (elementName == null || regex == null) continue;
            this.addValidationRule(contentDefinition, elementName, regex, message, APPINFO_ATTR_TYPE_WARNING.equals(type));
        }
    }

    protected boolean isInvalidateParent(String xpath) {
        if (!CmsXmlUtils.isDeepXpath(xpath)) {
            return false;
        }
        Boolean isInvalidateParent = null;
        isInvalidateParent = this.m_relationChecks.get(xpath);
        if (isInvalidateParent == null) {
            String path = CmsXmlUtils.removeXpath(xpath);
            isInvalidateParent = this.m_relationChecks.get(path);
        }
        if (isInvalidateParent == null) {
            return false;
        }
        return isInvalidateParent;
    }

    protected String key(String keyName, Locale locale) {
        CmsMessages messages = this.getMessages(locale);
        if (messages != null) {
            return messages.key(keyName);
        }
        return CmsMessages.formatUnknownKey(keyName);
    }

    protected void removeEmptyMappings(CmsObject cms, CmsXmlContent content) throws CmsException {
        List<CmsResource> siblings = null;
        CmsObject rootCms = null;
        for (Map.Entry<String, List<String>> e : this.m_elementMappings.entrySet()) {
            String path = e.getKey();
            List<String> mappings = e.getValue();
            if (mappings == null) continue;
            if (siblings == null || rootCms == null) {
                rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("/");
                siblings = rootCms.readSiblings(content.getFile().getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
            }
            for (int v = mappings.size() - 1; v >= 0; --v) {
                Locale locale;
                String filename;
                int i;
                String mapping = mappings.get(v);
                if (mapping.startsWith("propertyList:") || mapping.startsWith("property:")) {
                    for (i = 0; i < siblings.size(); ++i) {
                        filename = siblings.get(i).getRootPath();
                        locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename);
                        if (!content.hasLocale(locale) || content.hasValue(path, locale)) continue;
                        String property = mapping.startsWith("propertyList:") ? mapping.substring("propertyList:".length()) : mapping.substring("property:".length());
                        rootCms.writePropertyObject(filename, new CmsProperty(property, "", null));
                    }
                    continue;
                }
                if (!mapping.startsWith("permission:")) continue;
                for (i = 0; i < siblings.size(); ++i) {
                    filename = siblings.get(i).getRootPath();
                    locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename);
                    if (!content.hasLocale(locale) || content.hasValue(path, locale)) continue;
                    List<CmsAccessControlEntry> aces = rootCms.getAccessControlEntries(filename, false);
                    for (CmsAccessControlEntry ace : aces) {
                        if (ace.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) {
                            rootCms.rmacc(filename, "ALL_OTHERS", CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.toString());
                            continue;
                        }
                        I_CmsPrincipal principal = CmsPrincipal.readPrincipal(rootCms, ace.getPrincipal());
                        if (principal.isGroup()) {
                            rootCms.rmacc(filename, "GROUP", principal.getName());
                            continue;
                        }
                        if (!principal.isUser()) continue;
                        rootCms.rmacc(filename, "USER", principal.getName());
                    }
                }
            }
        }
    }

    protected void validateAppinfoElement(Element appinfoElement) throws CmsXmlException {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement(APPINFO_APPINFO);
        root.add(I_CmsXmlSchemaType.XSI_NAMESPACE);
        root.addAttribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION, APPINFO_SCHEMA_SYSTEM_ID);
        root.appendContent((Branch)appinfoElement);
        CmsXmlUtils.validateXmlStructure(doc, "UTF-8", new CmsXmlEntityResolver(null));
    }

    protected CmsXmlContentErrorHandler validateCategories(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        I_CmsWidget widget;
        block10: {
            if (!value.isSimpleType()) {
                return errorHandler;
            }
            widget = null;
            try {
                widget = value.getContentDefinition().getContentHandler().getWidget(value);
            }
            catch (CmsXmlException e) {
                if (!LOG.isErrorEnabled()) break block10;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!(widget instanceof CmsCategoryWidget)) {
            return errorHandler;
        }
        String stringValue = value.getStringValue(cms);
        try {
            String catPath = CmsCategoryService.getInstance().getCategory(cms, stringValue).getPath();
            String refPath = this.getReferencePath(cms, value);
            CmsCategoryService.getInstance().readCategory(cms, catPath, refPath);
            if (((CmsCategoryWidget)widget).isOnlyLeafs() && !CmsCategoryService.getInstance().readCategories(cms, catPath, false, refPath).isEmpty()) {
                errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_CATEGORY_CHECK_NOLEAF_ERROR_0"));
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_CATEGORY_CHECK_EMPTY_ERROR_0"));
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            errorHandler.addError(value, e.getLocalizedMessage());
        }
        return errorHandler;
    }

    protected boolean validateLink(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (value == null || !(value instanceof CmsXmlVfsFileValue) && !(value instanceof CmsXmlVarLinkValue)) {
            return false;
        }
        CmsLink link = null;
        if (value instanceof CmsXmlVfsFileValue) {
            link = ((CmsXmlVfsFileValue)value).getLink(cms);
        } else if (value instanceof CmsXmlVarLinkValue) {
            link = ((CmsXmlVarLinkValue)value).getLink(cms);
        }
        if (link == null || !link.isInternal()) {
            return false;
        }
        try {
            String sitePath = cms.getRequestContext().removeSiteRoot(link.getTarget());
            CmsResource res = null;
            CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(link.getTarget());
            if (site != null) {
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                res = rootCms.readResource(link.getTarget(), CmsResourceFilter.IGNORE_EXPIRATION);
            } else {
                res = cms.readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            }
            if (res != null) {
                long time = System.currentTimeMillis();
                if (!res.isReleased(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_NOT_RELEASED_0"));
                    }
                    return true;
                }
                if (res.isExpired(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_EXPIRED_0"));
                    }
                    return true;
                }
            }
        }
        catch (CmsException e) {
            if (errorHandler != null) {
                errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_ERROR_0"));
            }
            return true;
        }
        return false;
    }

    protected CmsXmlContentErrorHandler validateValue(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler, Map<String, String> rules, boolean isWarning) {
        String matchValue;
        String valueStr;
        if (this.validateLink(cms, value, errorHandler)) {
            return errorHandler;
        }
        try {
            if (value.getContentDefinition().getContentHandler().getWidget(value) instanceof CmsDisplayWidget) {
                return errorHandler;
            }
        }
        catch (CmsXmlException e) {
            errorHandler.addError(value, e.getMessage());
            return errorHandler;
        }
        try {
            valueStr = value.getStringValue(cms);
        }
        catch (Exception e) {
            errorHandler.addError(value, e.getMessage());
            return errorHandler;
        }
        String regex = rules.get(value.getName());
        if (regex == null) {
            return this.validateValue(cms, value, valueStr, errorHandler, isWarning);
        }
        boolean matchResult = true;
        if (regex.charAt(0) == '!') {
            matchResult = false;
            regex = regex.substring(1);
        }
        if ((matchValue = valueStr) == null) {
            matchValue = "";
        }
        if (matchResult != Pattern.matches(regex, matchValue)) {
            String message = this.getValidationMessage(cms, value, regex, valueStr, matchResult, isWarning);
            if (isWarning) {
                errorHandler.addWarning(value, message);
            } else {
                errorHandler.addError(value, message);
                return errorHandler;
            }
        }
        return this.validateValue(cms, value, valueStr, errorHandler, isWarning);
    }

    protected CmsXmlContentErrorHandler validateValue(CmsObject cms, I_CmsXmlContentValue value, String valueStr, CmsXmlContentErrorHandler errorHandler, boolean isWarning) {
        if (isWarning) {
            return errorHandler;
        }
        if (!value.validateValue(valueStr)) {
            String message = this.getValidationMessage(cms, value, value.getTypeName(), valueStr, true, false);
            errorHandler.addError(value, message);
        }
        return errorHandler;
    }

    protected CmsFile writeCategories(CmsObject cms, CmsFile file, CmsXmlContent content) throws CmsException {
        boolean modified;
        block15: {
            if (CmsWorkplace.isTemporaryFile(file)) {
                if (CmsResource.isTemporaryFileName(file.getRootPath())) {
                    String originalFileName = CmsResource.getFolderPath(file.getRootPath()) + CmsResource.getName(file.getRootPath()).substring("~".length());
                    if (cms.existsResource(cms.getRequestContext().removeSiteRoot(originalFileName))) {
                        return file;
                    }
                } else {
                    return file;
                }
            }
            boolean hasCategoryWidget = false;
            for (I_CmsWidget widget : this.m_elementWidgets.values()) {
                if (!(widget instanceof CmsCategoryWidget)) continue;
                hasCategoryWidget = true;
                break;
            }
            if (!hasCategoryWidget) {
                return file;
            }
            modified = false;
            CmsObject tmpCms = OpenCms.initCmsObject(cms);
            tmpCms.getRequestContext().setSiteRoot("");
            try {
                List<CmsResource> listsib = tmpCms.readSiblings(file.getRootPath(), CmsResourceFilter.ALL);
                for (int i = 0; i < listsib.size(); ++i) {
                    CmsResource resource = listsib.get(i);
                    Locale locale = this.getLocaleForResource(tmpCms, resource.getRootPath());
                    CmsCategoryService.getInstance().clearCategoriesForResource(tmpCms, resource.getRootPath());
                    CmsXmlContentWidgetVisitor widgetCollector = new CmsXmlContentWidgetVisitor(locale);
                    content.visitAllValuesWith(widgetCollector);
                    for (Map.Entry<String, I_CmsXmlContentValue> entry : widgetCollector.getValues().entrySet()) {
                        I_CmsXmlContentValue value;
                        String catRootPath;
                        String xpath = entry.getKey();
                        I_CmsWidget widget = widgetCollector.getWidgets().get(xpath);
                        if (!(widget instanceof CmsCategoryWidget) || CmsStringUtil.isEmptyOrWhitespaceOnly(catRootPath = (value = entry.getValue()).getStringValue(tmpCms))) continue;
                        try {
                            CmsCategory cat = CmsCategoryService.getInstance().getCategory(tmpCms, catRootPath);
                            CmsCategoryService.getInstance().addResourceToCategory(tmpCms, resource.getRootPath(), cat.getPath());
                        }
                        catch (CmsVfsResourceNotFoundException e) {
                            try {
                                content.removeValue(value.getName(), value.getLocale(), value.getIndex());
                                modified = true;
                            }
                            catch (CmsRuntimeException ex) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)ex.getLocalizedMessage(), (Throwable)ex);
                            }
                        }
                    }
                }
            }
            catch (CmsException ex) {
                if (!LOG.isErrorEnabled()) break block15;
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        if (modified) {
            file = content.correctXmlStructure(cms);
            content.setFile(file);
        }
        return file;
    }

    static {
        byte[] appinfoSchema;
        byte[] appinfoSchemaTypes;
        LOG = CmsLog.getLog(CmsDefaultXmlContentHandler.class);
        try {
            appinfoSchemaTypes = CmsFileUtil.readFile(APPINFO_SCHEMA_FILE_TYPES);
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_LOAD_SCHEMA_1", APPINFO_SCHEMA_FILE_TYPES), (Throwable)e);
        }
        CmsXmlEntityResolver.cacheSystemId(APPINFO_SCHEMA_TYPES_SYSTEM_ID, appinfoSchemaTypes);
        try {
            appinfoSchema = CmsFileUtil.readFile(APPINFO_SCHEMA_FILE);
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_LOAD_SCHEMA_1", APPINFO_SCHEMA_FILE), (Throwable)e);
        }
        CmsXmlEntityResolver.cacheSystemId(APPINFO_SCHEMA_SYSTEM_ID, appinfoSchema);
    }
}

