/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.I_CmsXmlContentValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsXmlContentErrorHandler {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentErrorHandler.class);
    private Map<Locale, Map<String, String>> m_errors;
    private boolean m_hasErrors;
    private boolean m_hasWarnings;
    private Map<Locale, Map<String, String>> m_warnings = new HashMap<Locale, Map<String, String>>();

    public CmsXmlContentErrorHandler() {
        this.m_errors = new HashMap<Locale, Map<String, String>>();
    }

    public void addError(I_CmsXmlContentValue value, String message) {
        this.m_hasErrors = true;
        Locale locale = value.getLocale();
        Map<String, String> localeErrors = this.getLocalIssueMap(this.m_errors, locale);
        localeErrors.put(value.getPath(), message);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_VALIDATION_ERR_2", value.getPath(), message));
        }
    }

    public void addWarning(I_CmsXmlContentValue value, String message) {
        this.m_hasWarnings = true;
        Locale locale = value.getLocale();
        Map<String, String> localeWarnings = this.getLocalIssueMap(this.m_warnings, locale);
        localeWarnings.put(value.getPath(), message);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_VALIDATION_WARN_2", value.getPath(), message));
        }
    }

    public Map<Locale, Map<String, String>> getErrors() {
        return this.m_errors;
    }

    public Map<String, String> getErrors(Locale locale) {
        return this.m_errors.get(locale);
    }

    public Map<Locale, Map<String, String>> getWarnings() {
        return this.m_warnings;
    }

    public Map<String, String> getWarnings(Locale locale) {
        return this.m_warnings.get(locale);
    }

    public boolean hasErrors() {
        return this.m_hasErrors;
    }

    public boolean hasErrors(Locale locale) {
        return null != this.getErrors(locale);
    }

    public boolean hasWarnings() {
        return this.m_hasWarnings;
    }

    public boolean hasWarnings(Locale locale) {
        return null != this.getWarnings(locale);
    }

    private Map<String, String> getLocalIssueMap(Map<Locale, Map<String, String>> base, Locale locale) {
        Map<String, String> result = base.get(locale);
        if (result == null) {
            result = new HashMap<String, String>();
            base.put(locale, result);
        }
        return result;
    }
}

