/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsFolderOrName;
import org.opencms.ade.configuration.I_CmsConfigurationObject;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsResourceTypeConfig
implements I_CmsConfigurationObject<CmsResourceTypeConfig> {
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeConfig.class);
    protected CmsObject m_cms;
    private boolean m_detailPagesDisabled;
    private boolean m_disabled;
    private CmsFolderOrName m_folderOrName;
    private CmsFormatterConfiguration m_formatterConfig;
    private String m_namePattern;
    private int m_order;
    private String m_typeName;

    public CmsResourceTypeConfig(String typeName, boolean disabled, CmsFolderOrName folder, String pattern, CmsFormatterConfiguration formatterConfig) {
        this(typeName, disabled, folder, pattern, formatterConfig, false, 10000);
    }

    public CmsResourceTypeConfig(String typeName, boolean disabled, CmsFolderOrName folder, String pattern, CmsFormatterConfiguration formatterConfig, boolean detailPagesDisabled, int order) {
        this.m_typeName = typeName;
        this.m_disabled = disabled;
        this.m_folderOrName = folder;
        this.m_namePattern = pattern;
        this.m_formatterConfig = formatterConfig;
        this.m_detailPagesDisabled = detailPagesDisabled;
        this.m_order = order;
    }

    public CmsResourceTypeConfig(String typeName, boolean disabled, CmsFolderOrName folder, String pattern, CmsFormatterConfiguration formatterConfig, int order) {
        this(typeName, disabled, folder, pattern, formatterConfig, false, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCreatable(CmsObject cms) throws CmsException {
        if (cms.getRequestContext().getCurrentProject().isOnlineProject() || "".equals(cms.getRequestContext().getSiteRoot())) {
            return false;
        }
        if ("function".equals(this.m_typeName)) {
            return OpenCms.getRoleManager().hasRole(cms, CmsRole.DEVELOPER);
        }
        this.checkInitialized();
        String folderPath = this.getFolderPath(cms);
        CmsObject createCms = OpenCms.initCmsObject(this.m_cms);
        createCms.getRequestContext().setCurrentProject(cms.getRequestContext().getCurrentProject());
        String oldSiteRoot = cms.getRequestContext().getSiteRoot();
        cms.getRequestContext().setSiteRoot("");
        this.tryToUnlock(cms, folderPath);
        this.createFolder(createCms, folderPath);
        try {
            CmsResource permissionCheckFolder = cms.readResource(folderPath);
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_typeName);
            boolean editable = settings.isEditable(cms, permissionCheckFolder);
            boolean controlPermission = settings.getAccess().getPermissions(cms, permissionCheckFolder).requiresControlPermission();
            boolean hasWritePermission = cms.hasPermissions(permissionCheckFolder, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            boolean bl = editable && controlPermission && hasWritePermission;
            return bl;
        }
        catch (CmsVfsResourceNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            cms.getRequestContext().setSiteRoot(oldSiteRoot);
        }
    }

    public boolean checkViewable(CmsObject cms, String referenceUri) {
        try {
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_typeName);
            CmsResource siteRoot = cms.readResource(referenceUri);
            return settings.getAccess().getPermissions(cms, siteRoot).requiresViewPermission();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void checkInitialized() {
        if (this.m_cms == null) {
            throw new IllegalStateException();
        }
    }

    public void checkOffline(CmsObject cms) {
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            throw new IllegalStateException();
        }
    }

    public void createFolder(CmsObject cms, String rootPath) throws CmsException {
        cms.getRequestContext().setSiteRoot("");
        List<String> parents = new ArrayList();
        String currentPath = rootPath;
        while (currentPath != null && !cms.existsResource(currentPath)) {
            parents.add(currentPath);
            currentPath = CmsResource.getParentFolder(currentPath);
        }
        parents = Lists.reverse(parents);
        for (String parent : parents) {
            try {
                cms.createResource(parent, CmsResourceTypeFolder.getStaticTypeId());
                try {
                    cms.unlockResource(parent);
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)e);
                }
            }
            catch (CmsVfsResourceAlreadyExistsException e) {}
        }
    }

    public CmsResource createNewElement(CmsObject userCms) throws CmsException {
        return this.createNewElement(userCms, null);
    }

    public CmsResource createNewElement(CmsObject userCms, CmsResource modelResource) throws CmsException {
        this.checkOffline(userCms);
        this.checkInitialized();
        CmsObject rootCms = this.rootCms(userCms);
        String folderPath = this.getFolderPath(userCms);
        this.createFolder(this.m_cms, folderPath);
        String destination = CmsStringUtil.joinPaths(folderPath, this.getNamePattern(true));
        String creationPath = OpenCms.getResourceManager().getNameGenerator().getNewFileName(rootCms, destination, 5);
        rootCms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_NEW_RESOURCE_LOCALE, userCms.getRequestContext().getLocale());
        if (modelResource != null) {
            rootCms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_MODEL, modelResource.getRootPath());
        }
        CmsResource createdResource = rootCms.createResource(creationPath, this.getType().getTypeId(), null, new ArrayList<CmsProperty>(0));
        return createdResource;
    }

    public String getFolderPath(CmsObject cms) {
        this.checkInitialized();
        if (this.m_folderOrName != null) {
            return this.m_folderOrName.getFolderPath(cms);
        }
        return CmsStringUtil.joinPaths(cms.getRequestContext().getSiteRoot(), ".content", this.m_typeName);
    }

    @Override
    public String getKey() {
        return this.m_typeName;
    }

    public String getNamePattern(boolean useDefaultIfEmpty) {
        if (this.m_namePattern != null) {
            return this.m_namePattern;
        }
        if (useDefaultIfEmpty) {
            return this.m_typeName + "-%(number).html";
        }
        return null;
    }

    public int getOrder() {
        return this.m_order;
    }

    public I_CmsResourceType getType() throws CmsException {
        return OpenCms.getResourceManager().getResourceType(this.m_typeName);
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void initialize(CmsObject cms) {
        this.m_cms = cms;
    }

    public boolean isDetailPagesDisabled() {
        return this.m_detailPagesDisabled;
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public CmsResourceTypeConfig merge(CmsResourceTypeConfig childConfig) {
        CmsFolderOrName folderOrName = childConfig.m_folderOrName != null ? childConfig.m_folderOrName : this.m_folderOrName;
        String namePattern = childConfig.m_namePattern != null ? childConfig.m_namePattern : this.m_namePattern;
        CmsFormatterConfiguration formatterConfig = childConfig.m_formatterConfig != null ? childConfig.m_formatterConfig : this.m_formatterConfig;
        return new CmsResourceTypeConfig(this.m_typeName, false, folderOrName, namePattern, formatterConfig, this.isDetailPagesDisabled() || childConfig.isDetailPagesDisabled(), this.m_order);
    }

    protected CmsResourceTypeConfig copy() {
        return new CmsResourceTypeConfig(this.m_typeName, this.m_disabled, this.getFolderOrName(), this.m_namePattern, this.m_formatterConfig, this.m_detailPagesDisabled, this.m_order);
    }

    protected CmsFolderOrName getFolderOrName() {
        return this.m_folderOrName;
    }

    protected CmsFormatterConfiguration getFormatterConfiguration() {
        return this.m_formatterConfig;
    }

    protected String getNamePattern() {
        return this.m_namePattern;
    }

    protected CmsObject rootCms(CmsObject cms) throws CmsException {
        CmsObject result = OpenCms.initCmsObject(cms);
        result.getRequestContext().setSiteRoot("");
        return result;
    }

    protected void tryToUnlock(CmsObject cms, String folderPath) throws CmsException {
        while (!cms.existsResource(folderPath)) {
            folderPath = CmsResource.getParentFolder(folderPath);
        }
        CmsResource resource = cms.readResource(folderPath);
        CmsLock lock = cms.getLock(resource);
        if (lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
            while (lock.isInherited()) {
                folderPath = CmsResource.getParentFolder(folderPath);
                resource = cms.readResource(folderPath);
                lock = cms.getLock(resource);
            }
            cms.unlockResource(folderPath);
        }
    }

    protected void updateBasePath(String basePath) {
        if (this.m_folderOrName != null) {
            if (this.m_folderOrName.isName()) {
                this.m_folderOrName = new CmsFolderOrName(basePath, this.m_folderOrName.getFolderName());
            }
        } else {
            this.m_folderOrName = new CmsFolderOrName(basePath, this.m_typeName);
        }
    }
}

