/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.CmsElementUtil;
import org.opencms.ade.containerpage.Messages;
import org.opencms.ade.containerpage.shared.CmsCntPageData;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsContainerElementData;
import org.opencms.ade.containerpage.shared.CmsCreateElementData;
import org.opencms.ade.containerpage.shared.CmsGroupContainer;
import org.opencms.ade.containerpage.shared.rpc.I_CmsContainerpageService;
import org.opencms.ade.detailpage.CmsDetailPageResourceHandler;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsNewResourceXmlContent;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsContainerpageService
extends CmsGwtService
implements I_CmsContainerpageService {
    private static final Log LOG = CmsLog.getLog(CmsContainerpageService.class);
    private static final long serialVersionUID = -6188370638303594280L;
    private CmsADESessionCache m_sessionCache;

    public static CmsContainerpageService newInstance(HttpServletRequest request) {
        CmsContainerpageService srv = new CmsContainerpageService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        return srv;
    }

    @Override
    public void addToFavoriteList(String clientId) throws CmsRpcException {
        try {
            this.ensureSession();
            List<CmsContainerElementBean> list = OpenCms.getADEManager().getFavoriteList(this.getCmsObject());
            this.updateFavoriteRecentList(clientId, list);
            OpenCms.getADEManager().saveFavoriteList(this.getCmsObject(), list);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void addToRecentList(String clientId) throws CmsRpcException {
        try {
            this.ensureSession();
            List<CmsContainerElementBean> list = OpenCms.getADEManager().getRecentList(this.getCmsObject());
            this.updateFavoriteRecentList(clientId, list);
            OpenCms.getADEManager().saveRecentList(this.getCmsObject(), list);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public CmsCreateElementData checkCreateNewElement(CmsUUID pageStructureId, String clientId, String resourceType, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCreateElementData result = new CmsCreateElementData();
        try {
            CmsResource currentPage = cms.readResource(pageStructureId);
            List<CmsResource> modelResources = CmsNewResourceXmlContent.getModelFiles(this.getCmsObject(), CmsResource.getFolderPath(cms.getSitePath(currentPage)), resourceType);
            if (modelResources.isEmpty()) {
                result.setCreatedElement(this.createNewElement(pageStructureId, clientId, resourceType, null, locale));
            } else {
                result.setModelResources(this.generateModelResourceList(resourceType, modelResources, CmsLocaleManager.getLocale(locale)));
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    public CmsUUID convertToServerId(String id) throws CmsIllegalArgumentException {
        if (id == null) {
            throw new CmsIllegalArgumentException(org.opencms.xml.containerpage.Messages.get().container("ERR_INVALID_ID_1", id));
        }
        String serverId = id;
        try {
            if (serverId.contains("#")) {
                serverId = serverId.substring(0, serverId.indexOf("#"));
            }
            return new CmsUUID(serverId);
        }
        catch (NumberFormatException e) {
            throw new CmsIllegalArgumentException(org.opencms.xml.containerpage.Messages.get().container("ERR_INVALID_ID_1", id));
        }
    }

    @Override
    public CmsContainerElement createNewElement(CmsUUID pageStructureId, String clientId, String resourceType, CmsUUID modelResourceStructureId, String locale) throws CmsRpcException {
        CmsContainerElement element = null;
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(pageStructureId);
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, pageResource.getRootPath());
            CmsResourceTypeConfig typeConfig = configData.getResourceType(resourceType);
            CmsObject cloneCms = OpenCms.initCmsObject(cms);
            cloneCms.getRequestContext().setLocale(CmsLocaleManager.getLocale(locale));
            CmsResource modelResource = null;
            if (modelResourceStructureId != null) {
                modelResource = cms.readResource(modelResourceStructureId);
            }
            CmsResource newResource = typeConfig.createNewElement(cloneCms, modelResource);
            CmsContainerElementBean bean = this.getCachedElement(clientId);
            CmsContainerElementBean newBean = new CmsContainerElementBean(newResource.getStructureId(), null, bean.getIndividualSettings(), false);
            String newClientId = newBean.editorHash();
            this.getSessionCache().setCacheContainerElement(newClientId, newBean);
            element = new CmsContainerElement();
            element.setClientId(newClientId);
            element.setSitePath(cms.getSitePath(newResource));
            element.setResourceType(resourceType);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return element;
    }

    @Override
    public Map<String, CmsContainerElementData> getElementsData(CmsUUID pageStructureId, String reqParams, Collection<String> clientIds, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        Map<String, CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource pageResource = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(pageResource);
            result = this.getElements(clientIds, containerpageUri, containers, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsContainerElementData getElementWithSettings(CmsUUID pageStructureId, String uriParams, String clientId, Map<String, String> settings, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsContainerElementData element = null;
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(pageStructureId);
            String containerpageUri = cms.getSitePath(pageResource);
            CmsElementUtil elemUtil = new CmsElementUtil(cms, containerpageUri, this.getRequest(), this.getResponse(), CmsLocaleManager.getLocale(locale));
            CmsContainerElementBean elementBean = this.getCachedElement(clientId);
            elementBean = CmsContainerElementBean.cloneWithSettings(elementBean, this.convertSettingValues(elementBean.getResource(), settings));
            this.getSessionCache().setCacheContainerElement(elementBean.editorHash(), elementBean);
            element = elemUtil.getElementData(elementBean, containers);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return element;
    }

    @Override
    public List<CmsContainerElementData> getFavoriteList(CmsUUID pageStructureId, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        List<CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource containerpage = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(containerpage);
            result = this.getListElementsData(OpenCms.getADEManager().getFavoriteList(this.getCmsObject()), containerpageUri, containers, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsContainerElementData getNewElementData(CmsUUID pageStructureId, String reqParams, String resourceType, Collection<CmsContainer> containers, String localeName) throws CmsRpcException {
        CmsContainerElementData result = null;
        try {
            this.ensureSession();
            CmsResource pageResource = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(pageResource);
            Locale locale = CmsLocaleManager.getLocale(localeName);
            result = this.getNewElement(resourceType, containerpageUri, containers, locale);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsContainerElementData> getRecentList(CmsUUID pageStructureId, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        List<CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource containerpage = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(containerpage);
            result = this.getListElementsData(OpenCms.getADEManager().getRecentList(this.getCmsObject()), containerpageUri, containers, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsCntPageData prefetch() throws CmsRpcException {
        CmsCntPageData data = null;
        CmsObject cms = this.getCmsObject();
        HttpServletRequest request = this.getRequest();
        try {
            CmsResource cntPage = this.getContainerpage(cms);
            long lastModified = cntPage.getDateLastModified();
            String cntPageUri = cms.getSitePath(cntPage);
            data = new CmsCntPageData(cms.getSitePath(cntPage), this.getNoEditReason(cms, cntPage), CmsRequestUtil.encodeParams(request), "/system/modules/org.opencms.ade.sitemap/pages/sitemap.jsp", cntPageUri, CmsDetailPageResourceHandler.getDetailId((ServletRequest)this.getRequest()), this.getNewTypes(cms, request), lastModified, cms.getRequestContext().getLocale().toString());
        }
        catch (Throwable e) {
            this.error(e);
        }
        return data;
    }

    @Override
    public void saveContainerpage(CmsUUID pageStructureId, List<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureSession();
            CmsResource containerpage = cms.readResource(pageStructureId);
            String containerpageUri = cms.getSitePath(containerpage);
            Locale contentLocale = CmsLocaleManager.getLocale(locale);
            ArrayList<CmsContainerBean> containerBeans = new ArrayList<CmsContainerBean>();
            for (CmsContainer container : containers) {
                CmsContainerBean containerBean = this.getContainerBean(container, containerpage, locale);
                containerBeans.add(containerBean);
            }
            CmsContainerPageBean page = new CmsContainerPageBean(contentLocale, containerBeans);
            cms.lockResourceTemporary(containerpageUri);
            CmsXmlContainerPage xmlCnt = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(containerpageUri));
            xmlCnt.save(cms, contentLocale, page);
            cms.unlockResource(containerpageUri);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void saveFavoriteList(List<String> clientIds) throws CmsRpcException {
        try {
            this.ensureSession();
            OpenCms.getADEManager().saveFavoriteList(this.getCmsObject(), this.getCachedElements(clientIds));
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public Map<String, CmsContainerElementData> saveGroupContainer(CmsUUID pageStructureId, String reqParams, CmsGroupContainer groupContainer, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.internalSaveGroupContainer(cms, pageStructureId, groupContainer, locale);
        }
        catch (Throwable e) {
            this.error(e);
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(groupContainer.getClientId());
        return this.getElementsData(pageStructureId, reqParams, ids, containers, locale);
    }

    @Override
    public void saveRecentList(List<String> clientIds) throws CmsRpcException {
        try {
            this.ensureSession();
            OpenCms.getADEManager().saveRecentList(this.getCmsObject(), this.getCachedElements(clientIds));
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void syncSaveContainerpage(CmsUUID pageStructureId, List<CmsContainer> containers, String locale) throws CmsRpcException {
        this.saveContainerpage(pageStructureId, containers, locale);
    }

    private Map<String, String> convertSettingValues(CmsResource resource, Map<String, String> settings) throws CmsException {
        CmsObject cms = this.getCmsObject();
        Map<String, CmsXmlContentProperty> settingsConf = OpenCms.getADEManager().getElementSettings(cms, resource);
        HashMap<String, String> changedSettings = new HashMap<String, String>();
        if (settings != null) {
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                String settingName = entry.getKey();
                String settingType = settingsConf.get(settingName).getType();
                changedSettings.put(settingName, CmsXmlContentPropertyHelper.getPropValueIds(this.getCmsObject(), settingType, entry.getValue()));
            }
        }
        return changedSettings;
    }

    private List<CmsModelResourceInfo> generateModelResourceList(String resourceType, List<CmsResource> modelResources, Locale contentLocale) throws CmsException {
        ArrayList<CmsModelResourceInfo> result = new ArrayList<CmsModelResourceInfo>();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        CmsModelResourceInfo defaultInfo = new CmsModelResourceInfo(Messages.get().getBundle(wpLocale).key("GUI_TITLE_DEFAULT_RESOURCE_CONTENT_0"), Messages.get().getBundle(wpLocale).key("GUI_DESCRIPTION_DEFAULT_RESOURCE_CONTENT_0"), null);
        defaultInfo.setResourceType(resourceType);
        result.add(defaultInfo);
        for (CmsResource model : modelResources) {
            CmsGallerySearchResult searchInfo = CmsGallerySearch.searchById(this.getCmsObject(), model.getStructureId(), contentLocale);
            CmsModelResourceInfo modelInfo = new CmsModelResourceInfo(searchInfo.getTitle(), searchInfo.getDescription(), null);
            modelInfo.addAdditionalInfo(Messages.get().getBundle(wpLocale).key("GUI_LABEL_PATH_0"), this.getCmsObject().getSitePath(model));
            modelInfo.setResourceType(resourceType);
            modelInfo.setStructureId(model.getStructureId());
            result.add(modelInfo);
        }
        return result;
    }

    private CmsContainerElementBean getCachedElement(String clientId) {
        String id = clientId;
        CmsContainerElementBean element = null;
        element = this.getSessionCache().getCacheContainerElement(id);
        if (element != null) {
            return element;
        }
        if (id.contains("#")) {
            id = id.substring(0, id.indexOf("#"));
            element = this.getSessionCache().getCacheContainerElement(id);
            if (element != null) {
                return element;
            }
        }
        element = new CmsContainerElementBean(this.convertToServerId(id), null, null, false);
        this.getSessionCache().setCacheContainerElement(id, element);
        return element;
    }

    private List<CmsContainerElementBean> getCachedElements(List<String> clientIds) {
        ArrayList<CmsContainerElementBean> result = new ArrayList<CmsContainerElementBean>();
        for (String id : clientIds) {
            try {
                result.add(this.getCachedElement(id));
            }
            catch (CmsIllegalArgumentException e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    private CmsContainerBean getContainerBean(CmsContainer container, CmsResource containerpage, String locale) {
        CmsObject cms = this.getCmsObject();
        ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElement elementData : container.getElements()) {
            try {
                if (elementData.isNew()) {
                    if ("groupcontainer".equals(elementData.getResourceType())) {
                        CmsGroupContainer groupContainer = new CmsGroupContainer();
                        groupContainer.setNew(true);
                        groupContainer.setElements(new ArrayList<CmsContainerElement>());
                        HashSet<String> types = new HashSet<String>();
                        types.add(container.getType());
                        groupContainer.setTypes(types);
                        elementData = this.internalSaveGroupContainer(cms, containerpage.getStructureId(), groupContainer, locale);
                    } else {
                        elementData = this.createNewElement(containerpage.getStructureId(), elementData.getClientId(), elementData.getResourceType(), null, locale);
                    }
                }
                CmsContainerElementBean element = this.getCachedElement(elementData.getClientId());
                CmsResource resource = cms.readResource(element.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
                int containerWidth = container.getWidth();
                CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, containerpage.getRootPath());
                CmsFormatterConfiguration formatters = config.getFormatters(cms, resource);
                String containerType = null;
                containerType = "groupcontainer".equals(OpenCms.getResourceManager().getResourceType(resource).getTypeName()) ? "_PREVIEW_" : container.getType();
                CmsFormatterBean formatter = formatters.getFormatter(containerType, containerWidth);
                if (formatter == null) continue;
                elements.add(new CmsContainerElementBean(element.getId(), formatter.getJspStructureId(), element.getIndividualSettings(), false));
            }
            catch (Exception e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        CmsContainerBean result = new CmsContainerBean(container.getName(), container.getType(), elements);
        return result;
    }

    private CmsResource getContainerpage(CmsObject cms) throws CmsException {
        String currentUri = cms.getRequestContext().getUri();
        CmsResource containerPage = cms.readResource(currentUri);
        if (!CmsResourceTypeXmlContainerPage.isContainerPage(containerPage)) {
            String cntPagePath = cms.readPropertyObject(containerPage, "template-elements", true).getValue("");
            try {
                containerPage = cms.readResource(cntPagePath);
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) {
                    LOG.warn((Object)e.getLocalizedMessage());
                }
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return containerPage;
    }

    private Map<String, CmsContainerElementData> getElements(Collection<String> clientIds, String uriParam, Collection<CmsContainer> containers, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, uriParam, this.getRequest(), this.getResponse(), locale);
        HashMap<String, CmsContainerElementData> result = new HashMap<String, CmsContainerElementData>();
        HashSet<String> ids = new HashSet<String>();
        for (String elemId : clientIds) {
            if (ids.contains(elemId)) continue;
            CmsContainerElementBean element = this.getCachedElement(elemId);
            CmsContainerElementData elementData = elemUtil.getElementData(element, containers);
            result.put(element.editorHash(), elementData);
            if (elementData.isGroupContainer()) {
                CmsResource elementRes = cms.readResource(element.getId());
                CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, elementRes, (ServletRequest)this.getRequest());
                CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(cms, locale);
                for (CmsContainerElementBean subElement : groupContainer.getElements()) {
                    String subId;
                    if (ids.contains(subElement.getId()) || ids.contains(subId = subElement.editorHash())) continue;
                    CmsContainerElementData subItemData = elemUtil.getElementData(subElement, containers);
                    ids.add(subId);
                    result.put(subId, subItemData);
                }
            }
            ids.add(elemId);
        }
        return result;
    }

    private CmsGroupContainerBean getGroupContainerBean(CmsGroupContainer groupContainer, CmsUUID pageStructureId, String locale) {
        CmsObject cms = this.getCmsObject();
        ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElement elementData : groupContainer.getElements()) {
            try {
                CmsContainerElementBean element;
                if (elementData.isNew()) {
                    elementData = this.createNewElement(pageStructureId, elementData.getClientId(), elementData.getResourceType(), null, locale);
                }
                if (!cms.existsResource((element = this.getCachedElement(elementData.getClientId())).getId(), CmsResourceFilter.IGNORE_EXPIRATION)) continue;
                elements.add(element);
            }
            catch (Exception e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        return new CmsGroupContainerBean(groupContainer.getTitle(), groupContainer.getDescription(), elements, groupContainer.getTypes());
    }

    private List<CmsContainerElementData> getListElementsData(List<CmsContainerElementBean> listElements, String containerpageUri, Collection<CmsContainer> containers, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, containerpageUri, this.getRequest(), this.getResponse(), locale);
        CmsADESessionCache cache = this.getSessionCache();
        ArrayList<CmsContainerElementData> result = new ArrayList<CmsContainerElementData>();
        for (CmsContainerElementBean element : listElements) {
            if (!cms.existsResource(element.getId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) continue;
            cache.setCacheContainerElement(element.editorHash(), element);
            CmsContainerElementData elementData = elemUtil.getElementData(element, containers);
            result.add(elementData);
        }
        return result;
    }

    private CmsContainerElementData getNewElement(String resourceTypeName, String uriParam, Collection<CmsContainer> containers, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, uriParam, this.getRequest(), this.getResponse(), locale);
        CmsContainerElementBean elementBean = this.getSessionCache().getCacheContainerElement(resourceTypeName);
        if (elementBean == null) {
            elementBean = CmsContainerElementBean.createElementForResourceType(cms, OpenCms.getResourceManager().getResourceType(resourceTypeName), "/", Collections.<String, String>emptyMap(), locale);
            this.getSessionCache().setCacheContainerElement(elementBean.editorHash(), elementBean);
        }
        return elemUtil.getElementData(elementBean, containers);
    }

    private Map<String, String> getNewTypes(CmsObject cms, HttpServletRequest request) throws CmsRpcException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        try {
            List<CmsResourceTypeConfig> types = configData.getCreatableTypes(cms);
            for (CmsResourceTypeConfig type : types) {
                result.put(type.getTypeName(), CmsUUID.getNullUUID().toString());
            }
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    private String getNoEditReason(CmsObject cms, CmsResource containerPage) throws CmsException {
        return new CmsResourceUtil(cms, containerPage).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    private CmsADESessionCache getSessionCache() {
        if (this.m_sessionCache == null) {
            this.m_sessionCache = (CmsADESessionCache)this.getRequest().getSession().getAttribute("__OCMS_ADE_CACHE__");
            if (this.m_sessionCache == null) {
                this.m_sessionCache = new CmsADESessionCache(this.getCmsObject());
                this.getRequest().getSession().setAttribute("__OCMS_ADE_CACHE__", (Object)this.m_sessionCache);
            }
        }
        return this.m_sessionCache;
    }

    private CmsContainerElement internalSaveGroupContainer(CmsObject cms, CmsUUID pageStructureId, CmsGroupContainer groupContainer, String locale) throws CmsException, CmsXmlException {
        this.ensureSession();
        CmsResource pageResource = this.getCmsObject().readResource(pageStructureId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsResource groupContainerResource = null;
        if (groupContainer.isNew()) {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), pageResource.getRootPath());
            CmsResourceTypeConfig typeConfig = config.getResourceType("groupcontainer");
            groupContainerResource = typeConfig.createNewElement(this.getCmsObject());
            String resourceName = cms.getSitePath(groupContainerResource);
            groupContainer.setSitePath(resourceName);
            groupContainer.setClientId(groupContainerResource.getStructureId().toString());
        }
        if (groupContainerResource == null) {
            CmsUUID id = this.convertToServerId(groupContainer.getClientId());
            groupContainerResource = cms.readResource(id, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        CmsGroupContainerBean groupContainerBean = this.getGroupContainerBean(groupContainer, pageResource.getStructureId(), locale);
        cms.lockResourceTemporary(groupContainerResource);
        CmsFile groupContainerFile = cms.readFile(groupContainerResource);
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, groupContainerFile);
        xmlGroupContainer.save(cms, groupContainerBean, CmsLocaleManager.getLocale(locale));
        cms.unlockResource(groupContainerResource);
        CmsContainerElement element = new CmsContainerElement();
        element.setClientId(groupContainerFile.getStructureId().toString());
        element.setSitePath(cms.getSitePath(groupContainerFile));
        element.setResourceType("groupcontainer");
        return element;
    }

    private List<CmsContainerElementBean> updateFavoriteRecentList(String clientId, List<CmsContainerElementBean> list) {
        CmsContainerElementBean element = this.getCachedElement(clientId);
        Iterator<CmsContainerElementBean> listIt = list.iterator();
        while (listIt.hasNext()) {
            CmsContainerElementBean listElem = listIt.next();
            if (!listElem.getId().equals(element.getId())) continue;
            listIt.remove();
        }
        list.add(0, element);
        return list;
    }
}

