/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.detailpage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmsDetailPageUtil {
    private CmsDetailPageUtil() {
    }

    public static List<String> getAllDetailPagesWithUrlName(CmsObject cms, CmsResource res) throws CmsException {
        ArrayList<String> result = new ArrayList<String>();
        Collection<String> detailPages = OpenCms.getADEManager().getDetailPageFinder().getAllDetailPages(cms, res.getTypeId());
        if (detailPages.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> detailNames = cms.readUrlNamesForAllLocales(res.getStructureId());
        for (String urlName : detailNames) {
            for (String detailPage : detailPages) {
                String rootPath = CmsStringUtil.joinPaths(detailPage, urlName, "/");
                result.add(rootPath);
            }
        }
        return result;
    }

    public static String getBestUrlName(CmsObject cms, CmsUUID id) throws CmsException {
        List<Locale> defaultLocales;
        Locale locale = cms.getRequestContext().getLocale();
        String urlName = cms.readBestUrlName(id, locale, defaultLocales = OpenCms.getLocaleManager().getDefaultLocales());
        if (urlName != null) {
            return urlName;
        }
        return id.toString();
    }

    public static CmsResource lookupPage(CmsObject cms, String uri) throws CmsException {
        try {
            CmsResource res = cms.readResource(uri);
            return res;
        }
        catch (CmsVfsResourceNotFoundException e) {
            String detailName = CmsResource.getName(uri).replaceAll("/$", "");
            CmsUUID detailId = cms.readIdForUrlName(detailName);
            if (detailId != null) {
                return cms.readResource(detailId);
            }
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_READ_RESOURCE_1", uri));
        }
    }
}

