/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;

public class CmsOpenGallery
extends CmsDialog {
    public CmsOpenGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public void openGallery() throws Exception {
        String galleryPath = this.getParamResource();
        if (galleryPath != null && !galleryPath.endsWith("/")) {
            galleryPath = galleryPath + "/";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        Locale locale = OpenCms.getLocaleManager().getDefaultLocale(this.getCms(), galleryPath);
        params.put("__locale", locale.toString());
        params.put(I_CmsGalleryProviderConstants.ReqParam.dialogmode.name(), I_CmsGalleryProviderConstants.GalleryMode.view.name());
        try {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(galleryPath)) {
                CmsResource galleryFolder = this.getCms().readResource(galleryPath);
                galleryPath = this.getCms().getSitePath(galleryFolder);
            }
        }
        catch (CmsException e) {
            // empty catch block
        }
        params.put(I_CmsGalleryProviderConstants.ReqParam.gallerypath.name(), galleryPath);
        params.put(I_CmsGalleryProviderConstants.ReqParam.types.name(), "");
        this.sendForward("/system/modules/org.opencms.ade.galleries/gallery.jsp", params);
    }
}

