/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import java.util.ArrayList;
import java.util.List;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishData;
import org.opencms.ade.publish.shared.CmsPublishGroup;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.rpc.I_CmsPublishService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsPublishService
extends CmsGwtService
implements I_CmsPublishService {
    private static final long serialVersionUID = 3852074177607037076L;
    private static final String SESSION_ATTR_ADE_PUB_OPTS_CACHE = "__OCMS_ADE_PUB_OPTS_CACHE__";

    @Override
    public CmsPublishData getInitData() throws CmsRpcException {
        CmsPublishData result = null;
        try {
            CmsPublishOptions options = this.getCachedOptions();
            result = new CmsPublishData(options, this.getProjects(), this.getPublishGroups(options), this.canPublishBrokenRelations(this.getCmsObject()));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsProjectBean> getProjects() throws CmsRpcException {
        List<CmsProjectBean> result = null;
        try {
            result = new CmsPublish(this.getCmsObject()).getManageableProjects();
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsPublishGroup> getPublishGroups(CmsPublishOptions options) throws CmsRpcException {
        List<CmsPublishGroup> results = null;
        try {
            CmsPublish pub = new CmsPublish(this.getCmsObject(), options);
            this.setCachedOptions(options);
            results = pub.getPublishGroups();
        }
        catch (Throwable e) {
            this.error(e);
        }
        return results;
    }

    @Override
    public CmsPublishOptions getPublishOptions() throws CmsRpcException {
        CmsPublishOptions result = null;
        try {
            result = this.getCachedOptions();
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsPublishResource> publishResources(List<CmsUUID> toPublish, List<CmsUUID> toRemove, boolean force) throws CmsRpcException {
        List<Object> brokenLinkBeans = null;
        try {
            CmsObject cms = this.getCmsObject();
            CmsPublish pub = new CmsPublish(cms, this.getCachedOptions());
            List<CmsResource> publishResources = this.idsToResources(cms, toPublish);
            List<Object> list = brokenLinkBeans = force ? new ArrayList() : pub.getBrokenResources(publishResources);
            if (brokenLinkBeans.size() == 0) {
                pub.publishResources(publishResources);
                pub.removeResourcesFromPublishList(toRemove);
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return brokenLinkBeans;
    }

    private boolean canPublishBrokenRelations(CmsObject cms) {
        return OpenCms.getWorkplaceManager().getDefaultUserSettings().isAllowBrokenRelations() || OpenCms.getRoleManager().hasRole(cms, CmsRole.VFS_MANAGER);
    }

    private CmsPublishOptions getCachedOptions() {
        CmsPublishOptions cache = (CmsPublishOptions)this.getRequest().getSession().getAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE);
        if (cache == null) {
            cache = new CmsPublishOptions();
            this.getRequest().getSession().setAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE, (Object)cache);
        }
        return cache;
    }

    private List<CmsResource> idsToResources(CmsObject cms, List<CmsUUID> ids) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsUUID id : ids) {
            try {
                CmsResource resource = cms.readResource(id, CmsResourceFilter.ALL);
                result.add(resource);
            }
            catch (CmsException e) {
                this.logError(e);
            }
        }
        return result;
    }

    private void setCachedOptions(CmsPublishOptions options) {
        this.getRequest().getSession().setAttribute(SESSION_ATTR_ADE_PUB_OPTS_CACHE, (Object)options);
    }
}

