/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.publish.CmsPublishActionElement;
import org.opencms.ade.sitemap.ClientMessages;
import org.opencms.ade.sitemap.CmsVfsSitemapService;
import org.opencms.ade.sitemap.Messages;
import org.opencms.ade.sitemap.shared.CmsSitemapData;
import org.opencms.ade.sitemap.shared.rpc.I_CmsSitemapService;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.CmsRpcException;

public class CmsSitemapActionElement
extends CmsGwtActionElement {
    public static final String MODULE_NAME = "sitemap";
    private CmsSitemapData m_sitemapData;

    public CmsSitemapActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public String export() throws Exception {
        StringBuffer sb = new StringBuffer();
        String prefetchedData = this.serialize(I_CmsSitemapService.class.getMethod("prefetch", String.class), this.getSitemapData());
        sb.append("org_opencms_ade_sitemap").append("='").append(prefetchedData).append("';");
        sb.append(ClientMessages.get().export(this.getRequest()));
        return this.wrapScript(sb).toString();
    }

    public String exportAll() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.export(".vfsMode"));
        sb.append(this.export());
        sb.append(new CmsPublishActionElement(this.getJspContext(), this.getRequest(), this.getResponse()).export());
        sb.append(this.createNoCacheScript(MODULE_NAME));
        return sb.toString();
    }

    public CmsSitemapData getSitemapData() {
        if (this.m_sitemapData == null) {
            try {
                this.m_sitemapData = CmsVfsSitemapService.newInstance(this.getRequest()).prefetch(this.getCoreData().getUri());
            }
            catch (CmsRpcException cmsRpcException) {
                // empty catch block
            }
        }
        return this.m_sitemapData;
    }

    public String getTitle() {
        return Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_EDITOR_TITLE_1", this.getCoreData().getUri());
    }
}

