/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.sitemap.shared.CmsClientSitemapEntry;
import org.opencms.ade.sitemap.shared.CmsSitemapClipboardData;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.gwt.shared.property.CmsPropertyModification;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsSitemapChange
implements IsSerializable,
Comparable<CmsSitemapChange> {
    private ChangeType m_changeType;
    private CmsSitemapClipboardData m_clipBoardData;
    private CmsUUID m_defaultFileId;
    private Map<String, CmsClientProperty> m_defaultFileInternalProperties = new HashMap<String, CmsClientProperty>();
    private List<CmsDetailPageInfo> m_detailPageInfos;
    private CmsUUID m_entryId;
    private boolean m_isLeafType;
    private String m_name;
    private CmsUUID m_newCopyResourceId;
    private int m_newResourceTypeId;
    private Map<String, CmsClientProperty> m_ownInternalProperties = new HashMap<String, CmsClientProperty>();
    private String m_parameter;
    private CmsUUID m_parentId;
    private int m_position = -1;
    private List<CmsPropertyModification> m_propertyModifications = new ArrayList<CmsPropertyModification>();
    private String m_sitePath;
    private CmsClientSitemapEntry m_updatedEntry;

    public CmsSitemapChange() {
    }

    public CmsSitemapChange(CmsUUID entryId, String sitePath, ChangeType changeType) {
        this.m_entryId = entryId;
        this.m_sitePath = sitePath;
        this.m_changeType = changeType;
    }

    public void addChangeData(CmsSitemapChange data) {
        if (data == null) {
            return;
        }
        if (!this.m_entryId.equals(data.m_entryId)) {
            throw new UnsupportedOperationException("Can't add data for a different entry id.");
        }
        this.m_sitePath = data.m_sitePath;
        if (data.hasChangedName()) {
            this.m_name = data.m_name;
        }
        if (data.hasChangedPosition()) {
            this.m_position = data.m_position;
        }
        if (data.hasChangedProperties()) {
            this.m_propertyModifications.addAll(data.m_propertyModifications);
        }
        if (data.hasNewParent()) {
            this.m_parentId = data.m_parentId;
        }
        if (data.getClipBoardData() != null) {
            this.m_clipBoardData = data.getClipBoardData();
        }
        if (data.m_changeType == ChangeType.delete || data.m_changeType == ChangeType.remove && this.m_changeType != ChangeType.delete || this.m_changeType == ChangeType.clipboardOnly) {
            this.m_changeType = data.m_changeType;
        }
    }

    public void addChangeTitle(String title) {
        CmsPropertyModification propChange = new CmsPropertyModification(this.m_entryId, "NavText", title, true);
        this.m_propertyModifications.add(propChange);
        this.m_ownInternalProperties.put("NavText", new CmsClientProperty("NavText", title, null));
    }

    @Override
    public int compareTo(CmsSitemapChange arg0) {
        if (this.m_entryId.equals(arg0.m_entryId)) {
            return 0;
        }
        int result = CmsResource.getParentFolder(this.m_sitePath).compareTo(CmsResource.getParentFolder(arg0.m_sitePath));
        if (result == 0 && (result = this.m_position - arg0.m_position) == 0) {
            result = this.m_name.compareTo(arg0.m_name);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CmsSitemapChange) {
            return this.m_entryId.equals(((CmsSitemapChange)obj).m_entryId);
        }
        return false;
    }

    public ChangeType getChangeType() {
        return this.m_changeType;
    }

    public CmsSitemapClipboardData getClipBoardData() {
        return this.m_clipBoardData;
    }

    public String getCreateParameter() {
        return this.m_parameter;
    }

    public CmsUUID getDefaultFileId() {
        return this.m_defaultFileId;
    }

    public Map<String, CmsClientProperty> getDefaultFileProperties() {
        return this.m_defaultFileInternalProperties;
    }

    public List<CmsDetailPageInfo> getDetailPageInfos() {
        return this.m_detailPageInfos;
    }

    public CmsUUID getEntryId() {
        return this.m_entryId;
    }

    public String getName() {
        return this.m_name;
    }

    public CmsUUID getNewCopyResourceId() {
        return this.m_newCopyResourceId;
    }

    public int getNewResourceTypeId() {
        return this.m_newResourceTypeId;
    }

    public Map<String, CmsClientProperty> getOwnInternalProperties() {
        return this.m_ownInternalProperties;
    }

    public Map<String, CmsClientProperty> getOwnProperties() {
        return this.m_ownInternalProperties;
    }

    public CmsUUID getParentId() {
        return this.m_parentId;
    }

    public int getPosition() {
        return this.m_position;
    }

    public List<CmsPropertyModification> getPropertyChanges() {
        return this.m_propertyModifications;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public CmsClientSitemapEntry getUpdatedEntry() {
        return this.m_updatedEntry;
    }

    public boolean hasChangedName() {
        return this.m_name != null;
    }

    public boolean hasChangedPosition() {
        return this.m_position >= 0;
    }

    public boolean hasChangedProperties() {
        return this.m_propertyModifications != null && this.m_propertyModifications.size() > 0;
    }

    public boolean hasDetailPageInfos() {
        return this.m_detailPageInfos != null;
    }

    public int hashCode() {
        return this.m_entryId.hashCode();
    }

    public boolean hasNewParent() {
        return this.m_parentId != null;
    }

    public boolean isDelete() {
        return ChangeType.delete == this.m_changeType;
    }

    public boolean isLeafType() {
        return this.m_isLeafType;
    }

    public boolean isNew() {
        return ChangeType.create == this.m_changeType;
    }

    public boolean isRemove() {
        return ChangeType.remove == this.m_changeType;
    }

    public void setClipBoardData(CmsSitemapClipboardData clipBoardData) {
        this.m_clipBoardData = clipBoardData;
    }

    public void setCreateParameter(String parameter) {
        this.m_parameter = parameter;
    }

    public void setDefaultFileId(CmsUUID id) {
        this.m_defaultFileId = id;
    }

    public void setDefaultFileInternalProperties(Map<String, CmsClientProperty> props) {
        this.m_defaultFileInternalProperties = props;
    }

    public void setDetailPageInfos(List<CmsDetailPageInfo> detailPageInfos) {
        this.m_detailPageInfos = detailPageInfos;
    }

    public void setEntryId(CmsUUID entryId) {
        this.m_entryId = entryId;
    }

    public void setLeafType(boolean isLeafEntry) {
        this.m_isLeafType = isLeafEntry;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNewCopyResourceId(CmsUUID newCopyResourceId) {
        this.m_newCopyResourceId = newCopyResourceId;
    }

    public void setNewResourceTypeId(int newResourceTypeId) {
        this.m_newResourceTypeId = newResourceTypeId;
    }

    public void setOwnInternalProperties(Map<String, CmsClientProperty> props) {
        this.m_ownInternalProperties = props;
    }

    public void setParentId(CmsUUID parentId) {
        this.m_parentId = parentId;
    }

    public void setPosition(int position) {
        this.m_position = position;
    }

    public void setPropertyChanges(List<CmsPropertyModification> propertyChanges) {
        this.m_propertyModifications = propertyChanges;
    }

    public void setSitePath(String sitePath) {
        this.m_sitePath = sitePath;
    }

    public void setTitle(String title) {
        this.addChangeTitle(title);
    }

    public void setUpdatedEntry(CmsClientSitemapEntry updatedEntry) {
        this.m_updatedEntry = updatedEntry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        bumpDetailPage,
        clipboardOnly,
        create,
        delete,
        modify,
        remove,
        undelete;

    }
}

