/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.log4j.spi.ThrowableInformation;
import org.opencms.ade.upload.CmsUploadException;
import org.opencms.ade.upload.CmsUploadListener;
import org.opencms.ade.upload.Messages;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsImportFolder;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsUploadBean
extends CmsJspBean {
    public static final int DEFAULT_UPLOAD_TIMEOUT = 20000;
    public static final String SESSION_ATTRIBUTE_LISTENER_ID = "__CmsUploadBean.LISTENER";
    private static final Log LOG = CmsLog.getLog(CmsUploadBean.class);
    private static Map<CmsUUID, CmsUploadListener> m_listeners = new HashMap<CmsUUID, CmsUploadListener>();
    private CmsMessages m_bundle = Messages.get().getBundle();
    private boolean m_called;
    private List<FileItem> m_multiPartFileItems;
    private Map<String, String[]> m_parameterMap;
    private Set<String> m_resourcesCreated = new HashSet<String>();
    private int m_uploadDelay;

    public CmsUploadBean(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public static CmsUploadListener getCurrentListener(CmsUUID listenerId) {
        return m_listeners.get(listenerId);
    }

    public static String getNewResourceName(CmsObject cms, String fileName, String folder) {
        String newResname = CmsResource.getName(fileName.replace('\\', '/'));
        newResname = cms.getRequestContext().getFileTranslator().translateResource(newResname);
        newResname = folder + newResname;
        return newResname;
    }

    public void setUploadDelay(int uploadDelay) {
        this.m_uploadDelay = uploadDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String start() {
        if (this.m_called) {
            throw new UnsupportedOperationException();
        }
        this.m_called = true;
        CmsUploadListener listener = this.createListener();
        try {
            this.parseRequest(listener);
            this.createResources(listener);
            OpenCms.getSearchManager().updateOfflineIndexes(2500L);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            String string = this.generateResponse(Boolean.FALSE, this.getCreationErrorMessage(), this.formatStackTrace(e));
            return string;
        }
        catch (CmsUploadException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            String string = this.generateResponse(Boolean.FALSE, e.getMessage(), this.formatStackTrace(e));
            return string;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            String message = this.m_bundle.key("ERR_UPLOAD_UNEXPECTED_0");
            String string = this.generateResponse(Boolean.FALSE, message, this.formatStackTrace(e));
            return string;
        }
        finally {
            this.removeListener(listener.getId());
        }
        return this.generateResponse(Boolean.TRUE, this.m_bundle.key("LOG_UPLOAD_SUCCESS_0"), "");
    }

    private CmsUploadListener createListener() {
        CmsUploadListener listener = new CmsUploadListener(this.getRequest().getContentLength());
        listener.setDelay(this.m_uploadDelay);
        m_listeners.put(listener.getId(), listener);
        this.getRequest().getSession().setAttribute(SESSION_ATTRIBUTE_LISTENER_ID, (Object)listener.getId());
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResources(CmsUploadListener listener) throws CmsException, UnsupportedEncodingException {
        String targetFolder = this.getTargetFolder();
        List<String> filesToUnzip = this.getFilesToUnzip();
        for (FileItem fileItem : this.m_multiPartFileItems) {
            if (fileItem == null || fileItem.isFormField()) continue;
            byte[] content = fileItem.get();
            fileItem.delete();
            String fileName = this.m_parameterMap.get(fileItem.getFieldName() + "_filename_encoded")[0];
            fileName = URLDecoder.decode(fileName, "UTF-8");
            if (filesToUnzip.contains(CmsResource.getName(fileName.replace('\\', '/')))) {
                CmsImportFolder importZip = new CmsImportFolder();
                try {
                    importZip.importZip(content, targetFolder, this.getCmsObject(), false);
                }
                finally {
                    this.m_resourcesCreated.addAll(importZip.getCreatedResourceNames());
                }
            } else {
                String newResname = this.createSingleResource(fileName, targetFolder, content);
                this.m_resourcesCreated.add(newResname);
            }
            if (!listener.isCanceled()) continue;
            throw listener.getException();
        }
    }

    private String createSingleResource(String fileName, String targetFolder, byte[] content) throws CmsException, CmsLoaderException, CmsDbSqlException {
        int slashIndex;
        int backslashIndex;
        String newResname = CmsUploadBean.getNewResourceName(this.getCmsObject(), fileName, targetFolder);
        String title = fileName;
        if (title.lastIndexOf(46) != -1) {
            title = title.substring(0, title.lastIndexOf(46));
        }
        if ((backslashIndex = title.lastIndexOf(92)) != -1) {
            title = title.substring(backslashIndex + 1);
        }
        if ((slashIndex = title.lastIndexOf(47)) != -1) {
            title = title.substring(slashIndex + 1);
        }
        ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(1);
        CmsProperty titleProp = new CmsProperty();
        titleProp.setName("Title");
        if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
            titleProp.setStructureValue(title);
        } else {
            titleProp.setResourceValue(title);
        }
        properties.add(titleProp);
        int plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
        if (!this.getCmsObject().existsResource(newResname, CmsResourceFilter.IGNORE_EXPIRATION)) {
            try {
                int resTypeId = OpenCms.getResourceManager().getDefaultTypeForName(newResname).getTypeId();
                this.getCmsObject().createResource(newResname, resTypeId, content, properties);
            }
            catch (CmsSecurityException e) {
                this.getCmsObject().createResource(newResname, plainId, content, properties);
            }
            catch (CmsDbSqlException sqlExc) {
                this.getCmsObject().lockResource(newResname);
                this.getCmsObject().deleteResource(newResname, CmsResource.DELETE_PRESERVE_SIBLINGS);
                throw sqlExc;
            }
        } else {
            CmsResource res = this.getCmsObject().readResource(newResname, CmsResourceFilter.ALL);
            if (!this.getCmsObject().getLock(res).isOwnedBy(this.getCmsObject().getRequestContext().getCurrentUser())) {
                this.getCmsObject().lockResource(res);
            }
            CmsFile file = this.getCmsObject().readFile(res);
            byte[] contents = file.getContents();
            try {
                this.getCmsObject().replaceResource(newResname, res.getTypeId(), content, null);
            }
            catch (CmsDbSqlException sqlExc) {
                file.setContents(contents);
                this.getCmsObject().writeFile(file);
                throw sqlExc;
            }
        }
        return newResname;
    }

    private String formatStackTrace(Exception e) {
        StringBuffer result = new StringBuffer(64);
        for (String s : new ThrowableInformation((Throwable)e).getThrowableStrRep()) {
            result.append(s + "<br />\n");
        }
        return result.toString();
    }

    private String generateResponse(Boolean success, String message, String stacktrace) {
        JSONObject result = new JSONObject();
        try {
            result.put("success", success);
            result.put("message", message);
            result.put("stacktrace", stacktrace);
            result.put("requestsize", this.getRequest().getContentLength());
        }
        catch (JSONException e) {
            LOG.error((Object)this.m_bundle.key("ERR_UPLOAD_JSON_0"), (Throwable)e);
        }
        return result.toString();
    }

    private String getCreationErrorMessage() {
        String message = new String();
        if (!this.m_resourcesCreated.isEmpty()) {
            StringBuffer buf = new StringBuffer(64);
            for (String name : this.m_resourcesCreated) {
                buf.append("<br />");
                buf.append(name);
            }
            message = this.m_bundle.key("ERR_UPLOAD_CREATING_1", buf.toString());
        } else {
            message = this.m_bundle.key("ERR_UPLOAD_CREATING_0");
        }
        return message;
    }

    private List<String> getFilesToUnzip() throws UnsupportedEncodingException {
        String[] filesToUnzip;
        if (this.m_parameterMap.get("upload_unzip_files") != null && (filesToUnzip = this.m_parameterMap.get("upload_unzip_files")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String filename : filesToUnzip) {
                result.add(URLDecoder.decode(filename, "UTF-8"));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private String getTargetFolder() throws CmsException {
        CmsResource tmpTarget;
        String targetFolder;
        CmsResource target = this.getCmsObject().readResource("/", CmsResourceFilter.IGNORE_EXPIRATION);
        if (this.m_parameterMap.get("upload_target_folder") != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(targetFolder = this.m_parameterMap.get("upload_target_folder")[0]) && this.getCmsObject().existsResource(targetFolder) && (tmpTarget = this.getCmsObject().readResource(targetFolder, CmsResourceFilter.IGNORE_EXPIRATION)).isFolder()) {
            target = tmpTarget;
        }
        if (!(targetFolder = this.getCmsObject().getRequestContext().removeSiteRoot(target.getRootPath())).endsWith("/")) {
            targetFolder = targetFolder + "/";
        }
        return targetFolder;
    }

    private void parseRequest(CmsUploadListener listener) throws Exception {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this.getRequest())) {
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_NO_MULTIPART_0"));
        }
        this.m_multiPartFileItems = this.readMultipartFileItems(listener);
        if (this.m_multiPartFileItems == null || this.m_multiPartFileItems.isEmpty()) {
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_NO_FILEITEMS_0"));
        }
        this.m_parameterMap = CmsRequestUtil.readParameterMapFromMultiPart(this.getCmsObject().getRequestContext().getEncoding(), this.m_multiPartFileItems);
        listener.setFinished(true);
    }

    private List<FileItem> readMultipartFileItems(CmsUploadListener listener) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        factory.setRepository(new File(OpenCms.getSystemInfo().getPackagesRfsPath()));
        ServletFileUpload fu = new ServletFileUpload((FileItemFactory)factory);
        fu.setProgressListener((ProgressListener)listener);
        fu.setHeaderEncoding(this.getRequest().getCharacterEncoding());
        long maxFileSizeBytes = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCmsObject());
        if (maxFileSizeBytes > 0L) {
            fu.setFileSizeMax(maxFileSizeBytes);
        }
        try {
            return CmsCollectionsGenericWrapper.list(fu.parseRequest(this.getRequest()));
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            Integer actualSize = new Integer((int)(e.getActualSize() / 1024L));
            Integer maxSize = new Integer((int)(e.getPermittedSize() / 1024L));
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_REQUEST_SIZE_LIMIT_2", actualSize, maxSize), e);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            Integer actualSize = new Integer((int)(e.getActualSize() / 1024L));
            Integer maxSize = new Integer((int)(e.getPermittedSize() / 1024L));
            throw new CmsUploadException(this.m_bundle.key("ERR_UPLOAD_FILE_SIZE_LIMIT_3", actualSize, e.getFileName(), maxSize), e);
        }
    }

    private void removeListener(CmsUUID listenerId) {
        this.getRequest().getSession().removeAttribute(SESSION_ATTRIBUTE_LISTENER_ID);
        m_listeners.remove(listenerId);
    }
}

