/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.fileupload.util.Streams;
import org.opencms.ade.upload.CmsUploadBean;
import org.opencms.ade.upload.CmsUploadException;
import org.opencms.ade.upload.CmsUploadListener;
import org.opencms.ade.upload.Messages;
import org.opencms.ade.upload.shared.CmsUploadData;
import org.opencms.ade.upload.shared.CmsUploadFileBean;
import org.opencms.ade.upload.shared.CmsUploadProgessInfo;
import org.opencms.ade.upload.shared.rpc.I_CmsUploadService;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsUploadService
extends CmsGwtService
implements I_CmsUploadService {
    private static final long serialVersionUID = -2235662141861687012L;

    public static CmsUploadService newInstance(HttpServletRequest request) {
        CmsUploadService srv = new CmsUploadService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        return srv;
    }

    @Override
    public Boolean cancelUpload() {
        CmsUUID listenerId;
        CmsUploadListener listener;
        if (this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER") != null && (listener = CmsUploadBean.getCurrentListener(listenerId = (CmsUUID)this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER"))) != null && !listener.isCanceled()) {
            listener.cancelUpload(new CmsUploadException(Messages.get().getBundle().key("ERR_UPLOAD_USER_CANCELED_0")));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public CmsUploadFileBean checkUploadFiles(List<String> fileNames, String targetFolder) {
        ArrayList<String> existingResourceNames = new ArrayList<String>();
        ArrayList<String> invalidFileNames = new ArrayList<String>();
        boolean isActive = false;
        if (this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER") == null) {
            for (String fileName : fileNames) {
                try {
                    Streams.checkFileName((String)fileName);
                    String newResName = CmsUploadBean.getNewResourceName(this.getCmsObject(), fileName, targetFolder);
                    if (!this.getCmsObject().existsResource(newResName, CmsResourceFilter.ALL)) continue;
                    existingResourceNames.add(fileName);
                }
                catch (InvalidFileNameException e) {
                    invalidFileNames.add(fileName);
                }
            }
        } else {
            isActive = true;
        }
        return new CmsUploadFileBean(existingResourceNames, invalidFileNames, isActive);
    }

    @Override
    public CmsUploadProgessInfo getUploadProgressInfo() {
        CmsUUID listenerId;
        CmsUploadListener listener;
        CmsUploadProgessInfo info = new CmsUploadProgessInfo(0, 0, CmsUploadProgessInfo.UPLOAD_STATE.notStarted, 0L, 0L);
        if (this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER") != null && (listener = CmsUploadBean.getCurrentListener(listenerId = (CmsUUID)this.getRequest().getSession().getAttribute("__CmsUploadBean.LISTENER"))) != null) {
            info = listener.getInfo();
        }
        return info;
    }

    @Override
    public CmsUploadData prefetch() {
        long uploadFileSizeLimit = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCmsObject());
        CmsUploadData data = new CmsUploadData(uploadFileSizeLimit);
        return data;
    }
}

