/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.digester.Digester;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.db.CmsUserExportSettings;
import org.opencms.importexport.CmsExtendedHtmlImportDefault;
import org.opencms.importexport.CmsImportExportManager;
import org.opencms.importexport.I_CmsImport;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.main.CmsLog;
import org.opencms.repository.A_CmsRepository;
import org.opencms.repository.CmsRepositoryFilter;
import org.opencms.repository.CmsRepositoryManager;
import org.opencms.staticexport.CmsStaticExportExportRule;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.CmsStaticExportRfsRule;
import org.opencms.util.CmsStringUtil;

public class CmsImportExportConfiguration
extends A_CmsXmlConfiguration {
    public static final String CONFIGURATION_DTD_NAME = "opencms-importexport.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-importexport.xml";
    public static final String N_COLUMN = "column";
    public static final String N_COLUMNS = "columns";
    public static final String N_CONVERT = "convert";
    public static final String N_EXTHTMLIMPORT = "extendedhtmlimport";
    public static final String N_EXTHTMLIMPORT_DESTINATION = "destination";
    public static final String N_EXTHTMLIMPORT_DOWNLOAD = "download";
    public static final String N_EXTHTMLIMPORT_ELEMENT = "element";
    public static final String N_EXTHTMLIMPORT_ENCODING = "encoding";
    public static final String N_EXTHTMLIMPORT_EXTERNALLINK = "externallink";
    public static final String N_EXTHTMLIMPORT_GALLERIES = "galleries";
    public static final String N_EXTHTMLIMPORT_IMAGE = "image";
    public static final String N_EXTHTMLIMPORT_INPUT = "input";
    public static final String N_EXTHTMLIMPORT_KEEPBROKENLINKS = "keepbrokenlinks";
    public static final String N_EXTHTMLIMPORT_LOCALE = "locale";
    public static final String N_EXTHTMLIMPORT_OVERWRITE = "overwritefiles";
    public static final String N_EXTHTMLIMPORT_PATTERN = "pattern";
    public static final String N_EXTHTMLIMPORT_PATTERN_END = "end";
    public static final String N_EXTHTMLIMPORT_PATTERN_START = "start";
    public static final String N_EXTHTMLIMPORT_SETTINGS = "settings";
    public static final String N_EXTHTMLIMPORT_TEMPLATE = "template";
    public static final String N_FILTER = "filter";
    public static final String N_IGNOREDPROPERTIES = "ignoredproperties";
    public static final String N_IMMUTABLES = "immutables";
    public static final String N_IMPORT = "import";
    public static final String N_IMPORTEXPORT = "importexport";
    public static final String N_IMPORTEXPORTHANDLER = "importexporthandler";
    public static final String N_IMPORTEXPORTHANDLERS = "importexporthandlers";
    public static final String N_IMPORTVERSION = "importversion";
    public static final String N_IMPORTVERSIONS = "importversions";
    public static final String N_LINKSUBSTITUTION_HANDLER = "linksubstitutionhandler";
    public static final String N_OLDWEBAPPURL = "oldwebappurl";
    public static final String N_OVERWRITE = "overwrite";
    public static final String N_PARAMS = "params";
    public static final String N_PRINCIPALTRANSLATION = "principaltranslation";
    public static final String N_PRINCIPALTRANSLATIONS = "principaltranslations";
    public static final String N_REGEX = "regex";
    public static final String N_REPOSITORIES = "repositories";
    public static final String N_REPOSITORY = "repository";
    public static final String N_SEPARATOR = "separator";
    public static final String N_STATICEXPORT = "staticexport";
    public static final String N_STATICEXPORT_ACCEPTCHARSET = "acceptcharset";
    public static final String N_STATICEXPORT_ACCEPTLANGUAGE = "acceptlanguage";
    public static final String N_STATICEXPORT_DEFAULT = "defaultpropertyvalue";
    public static final String N_STATICEXPORT_DEFAULTSUFFIXES = "defaultsuffixes";
    public static final String N_STATICEXPORT_DESCRIPTION = "description";
    public static final String N_STATICEXPORT_EXPORT = "export-resources";
    public static final String N_STATICEXPORT_EXPORTBACKUPS = "exportbackups";
    public static final String N_STATICEXPORT_EXPORTHEADERS = "exportheaders";
    public static final String N_STATICEXPORT_EXPORTPATH = "exportpath";
    public static final String N_STATICEXPORT_EXPORTRULE = "export-rule";
    public static final String N_STATICEXPORT_EXPORTRULES = "export-rules";
    public static final String N_STATICEXPORT_EXPORTURL = "exporturl";
    public static final String N_STATICEXPORT_EXPORTWORKPATH = "exportworkpath";
    public static final String N_STATICEXPORT_HANDLER = "staticexporthandler";
    public static final String N_STATICEXPORT_HEADER = "header";
    public static final String N_STATICEXPORT_MODIFIED = "modified-resources";
    public static final String N_STATICEXPORT_NAME = "name";
    public static final String N_STATICEXPORT_PLAINOPTIMIZATION = "plainoptimization";
    public static final String N_STATICEXPORT_REGEX = "regex";
    public static final String N_STATICEXPORT_RELATED_SYSTEM_RES = "related-system-res";
    public static final String N_STATICEXPORT_RELATIVELINKS = "userelativelinks";
    public static final String N_STATICEXPORT_REMOTEADDR = "remoteaddr";
    public static final String N_STATICEXPORT_RENDERSETTINGS = "rendersettings";
    public static final String N_STATICEXPORT_REQUESTHEADERS = "requestheaders";
    public static final String N_STATICEXPORT_RESOURCESTORENDER = "resourcestorender";
    public static final String N_STATICEXPORT_RFS_PREFIX = "rfs-prefix";
    public static final String N_STATICEXPORT_RFS_RULE = "rfs-rule";
    public static final String N_STATICEXPORT_RFS_RULES = "rfs-rules";
    public static final String N_STATICEXPORT_SOURCE = "source";
    public static final String N_STATICEXPORT_SUFFIX = "suffix";
    public static final String N_STATICEXPORT_TESTRESOURCE = "testresource";
    public static final String N_STATICEXPORT_URI = "uri";
    public static final String N_STATICEXPORT_VFS_PREFIX = "vfs-prefix";
    public static final String N_USERCSVEXPORT = "usercsvexport";
    private CmsImportExportManager m_importExportManager;
    private CmsRepositoryManager m_repositoryManager;
    private CmsStaticExportManager m_staticExportManager;

    public void addXmlDigesterRules(Digester digester) {
        digester.addCallMethod("*/importexport", "initializeFinished");
        digester.addObjectCreate("*/importexport", CmsImportExportManager.class);
        digester.addSetNext("*/importexport", "setImportExportManager");
        digester.addObjectCreate("*/importexport/importexporthandlers/importexporthandler", "class", CmsConfigurationException.class);
        digester.addSetNext("*/importexport/importexporthandlers/importexporthandler", "addImportExportHandler");
        digester.addCallMethod("*/importexport/import/overwrite", "setOverwriteCollidingResources", 0);
        digester.addCallMethod("*/importexport/import/convert", "setConvertToXmlPage", 0);
        digester.addCallMethod("*/importexport/import/oldwebappurl", "setOldWebAppUrl", 0);
        digester.addObjectCreate("*/importexport/import/importversions/importversion", "class", CmsConfigurationException.class);
        digester.addSetNext("*/importexport/import/importversions/importversion", "addImportVersionClass");
        digester.addCallMethod("*/importexport/import/immutables/resource", "addImmutableResource", 1);
        digester.addCallParam("*/importexport/import/immutables/resource", 0, N_STATICEXPORT_URI);
        digester.addCallMethod("*/importexport/import/principaltranslations/principaltranslation", "addImportPrincipalTranslation", 3);
        digester.addCallParam("*/importexport/import/principaltranslations/principaltranslation", 0, "type");
        digester.addCallParam("*/importexport/import/principaltranslations/principaltranslation", 1, "from");
        digester.addCallParam("*/importexport/import/principaltranslations/principaltranslation", 2, "to");
        digester.addCallMethod("*/importexport/import/ignoredproperties/property", "addIgnoredProperty", 1);
        digester.addCallParam("*/importexport/import/ignoredproperties/property", 0, N_STATICEXPORT_NAME);
        digester.addObjectCreate("*/staticexport", CmsStaticExportManager.class);
        digester.addSetNext("*/staticexport", "setStaticExportManager");
        digester.addCallMethod("*/staticexport", "setExportEnabled", 1);
        digester.addCallParam("*/staticexport", 0, "enabled");
        digester.addCallMethod("*/staticexport/staticexporthandler", "setHandler", 0);
        digester.addCallMethod("*/staticexport/linksubstitutionhandler", "setLinkSubstitutionHandler", 0);
        digester.addCallMethod("*/staticexport/exportpath", "setExportPath", 0);
        digester.addCallMethod("*/staticexport/exportworkpath", "setExportWorkPath", 0);
        digester.addCallMethod("*/staticexport/exportbackups", "setExportBackups", 0);
        digester.addCallMethod("*/staticexport/defaultpropertyvalue", "setDefault", 0);
        digester.addCallMethod("*/staticexport/defaultsuffixes/suffix", "setExportSuffix", 1);
        digester.addCallParam("*/staticexport/defaultsuffixes/suffix", 0, "key");
        digester.addCallMethod("*/staticexport/exportheaders/header", "setExportHeader", 0);
        digester.addCallMethod("*/staticexport/requestheaders/acceptlanguage", "setAcceptLanguageHeader", 0);
        digester.addCallMethod("*/staticexport/requestheaders/acceptcharset", "setAcceptCharsetHeader", 0);
        digester.addCallMethod("*/staticexport/requestheaders/remoteaddr", "setRemoteAddr", 0);
        digester.addCallMethod("*/staticexport/rendersettings/rfs-prefix", "setRfsPrefix", 0);
        digester.addCallMethod("*/staticexport/rendersettings/vfs-prefix", "setVfsPrefix", 0);
        digester.addCallMethod("*/staticexport/rendersettings/userelativelinks", "setRelativeLinks", 0);
        digester.addCallMethod("*/staticexport/rendersettings/exporturl", "setExportUrl", 0);
        digester.addCallMethod("*/staticexport/rendersettings/plainoptimization", "setPlainExportOptimization", 0);
        digester.addCallMethod("*/staticexport/rendersettings/testresource", "setTestResource", 1);
        digester.addCallParam("*/staticexport/rendersettings/testresource", 0, N_STATICEXPORT_URI);
        digester.addCallMethod("*/staticexport/rendersettings/resourcestorender/regex", "setExportFolderPattern", 0);
        String exportRulePath = "*/staticexport/rendersettings/resourcestorender/export-rules/export-rule";
        digester.addCallMethod(exportRulePath, "addExportRule", 2);
        digester.addCallParam(exportRulePath + "/" + N_STATICEXPORT_NAME, 0);
        digester.addCallParam(exportRulePath + "/" + N_STATICEXPORT_DESCRIPTION, 1);
        digester.addCallMethod(exportRulePath + "/" + N_STATICEXPORT_MODIFIED + "/" + "regex", "addExportRuleRegex", 1);
        digester.addCallParam(exportRulePath + "/" + N_STATICEXPORT_MODIFIED + "/" + "regex", 0);
        digester.addCallMethod(exportRulePath + "/" + N_STATICEXPORT_EXPORT + "/" + N_STATICEXPORT_URI, "addExportRuleUri", 1);
        digester.addCallParam(exportRulePath + "/" + N_STATICEXPORT_EXPORT + "/" + N_STATICEXPORT_URI, 0);
        String rfsRulePath = "*/staticexport/rendersettings/rfs-rules/rfs-rule";
        digester.addCallMethod(rfsRulePath, "addRfsRule", 8);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_NAME, 0);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_DESCRIPTION, 1);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_SOURCE, 2);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_RFS_PREFIX, 3);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_EXPORTPATH, 4);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_EXPORTWORKPATH, 5);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_EXPORTBACKUPS, 6);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_RELATIVELINKS, 7);
        digester.addCallMethod(rfsRulePath + "/" + N_STATICEXPORT_RELATED_SYSTEM_RES + "/" + "regex", "addRfsRuleSystemRes", 1);
        digester.addCallParam(rfsRulePath + "/" + N_STATICEXPORT_RELATED_SYSTEM_RES + "/" + "regex", 0);
        digester.addObjectCreate("*/usercsvexport", CmsUserExportSettings.class);
        digester.addCallMethod("*/usercsvexport/separator", "setSeparator", 0);
        digester.addCallMethod("*/usercsvexport/columns/column", "addColumn", 0);
        digester.addSetNext("*/usercsvexport", "setUserExportSettings");
        digester.addObjectCreate("*/repositories", CmsRepositoryManager.class);
        digester.addCallMethod("*/repositories", "initConfiguration");
        digester.addSetNext("*/repositories", "setRepositoryManager");
        digester.addObjectCreate("*/repositories/repository", "class", CmsConfigurationException.class);
        digester.addCallMethod("*/repositories/repository", "setName", 1);
        digester.addCallParam("*/repositories/repository", 0, N_STATICEXPORT_NAME);
        digester.addCallMethod("*/repositories/repository/params/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/repositories/repository/params/param", 0, N_STATICEXPORT_NAME);
        digester.addCallParam("*/repositories/repository/params/param", 1);
        digester.addObjectCreate("*/repositories/repository/filter", CmsRepositoryFilter.class);
        digester.addCallMethod("*/repositories/repository/filter", "setType", 1);
        digester.addCallParam("*/repositories/repository/filter", 0, "type");
        digester.addCallMethod("*/repositories/repository/filter/regex", "addFilterRule", 1);
        digester.addCallParam("*/repositories/repository/filter/regex", 0);
        digester.addSetNext("*/repositories/repository/filter", "setFilter");
        digester.addSetNext("*/repositories/repository", "addRepositoryClass");
        if (this.m_repositoryManager == null) {
            this.m_repositoryManager = new CmsRepositoryManager(false);
        }
        digester.addObjectCreate("*/extendedhtmlimport", CmsExtendedHtmlImportDefault.class);
        digester.addSetNext("*/extendedhtmlimport", "setExtendedHtmlImportManager");
        digester.addCallMethod("*/extendedhtmlimport/destination", "setDestinationDir", 0);
        digester.addCallMethod("*/extendedhtmlimport/input", "setInputDir", 0);
        digester.addCallMethod("*/extendedhtmlimport/galleries/download", "setDownloadGallery", 0);
        digester.addCallMethod("*/extendedhtmlimport/galleries/image", "setImageGallery", 0);
        digester.addCallMethod("*/extendedhtmlimport/galleries/externallink", "setLinkGallery", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/template", "setTemplate", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/element", "setElement", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/locale", "setLocale", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/encoding", "setEncoding", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/pattern/start", "setStartPattern", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/pattern/end", "setEndPattern", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/overwritefiles", "setOverwrite", 0);
        digester.addCallMethod("*/extendedhtmlimport/settings/keepbrokenlinks", "setKeepBrokenLinks", 0);
    }

    public Element generateXml(Element parent) {
        CmsExtendedHtmlImportDefault htmlimport;
        List<A_CmsRepository> repositories;
        Element importexportElement = parent.addElement(N_IMPORTEXPORT);
        Element resourceloadersElement = importexportElement.addElement(N_IMPORTEXPORTHANDLERS);
        List<I_CmsImportExportHandler> handlers = this.m_importExportManager.getImportExportHandlers();
        for (I_CmsImportExportHandler handler : handlers) {
            Element loaderNode = resourceloadersElement.addElement(N_IMPORTEXPORTHANDLER);
            loaderNode.addAttribute("class", handler.getClass().getName());
        }
        Element importElement = importexportElement.addElement(N_IMPORT);
        importElement.addElement(N_OVERWRITE).setText(String.valueOf(this.m_importExportManager.overwriteCollidingResources()));
        importElement.addElement(N_CONVERT).setText(String.valueOf(this.m_importExportManager.convertToXmlPage()));
        if (this.m_importExportManager.getOldWebAppUrl() != null) {
            importElement.addElement(N_OLDWEBAPPURL).setText(this.m_importExportManager.getOldWebAppUrl());
        }
        Element resourcetypesElement = importElement.addElement(N_IMPORTVERSIONS);
        Iterator<I_CmsImport> importVersions = this.m_importExportManager.getImportVersionClasses().iterator();
        while (importVersions.hasNext()) {
            resourcetypesElement.addElement(N_IMPORTVERSION).addAttribute("class", importVersions.next().getClass().getName());
        }
        Element immutablesElement = importElement.addElement(N_IMMUTABLES);
        for (String uri : this.m_importExportManager.getImmutableResources()) {
            immutablesElement.addElement("resource").addAttribute(N_STATICEXPORT_URI, uri);
        }
        Element principalsElement = importElement.addElement(N_PRINCIPALTRANSLATIONS);
        for (String from : this.m_importExportManager.getImportUserTranslations().keySet()) {
            String to = this.m_importExportManager.getImportUserTranslations().get(from);
            principalsElement.addElement(N_PRINCIPALTRANSLATION).addAttribute("type", "USER").addAttribute("from", from).addAttribute("to", to);
        }
        for (String from : this.m_importExportManager.getImportGroupTranslations().keySet()) {
            String to = this.m_importExportManager.getImportGroupTranslations().get(from);
            principalsElement.addElement(N_PRINCIPALTRANSLATION).addAttribute("type", "GROUP").addAttribute("from", from).addAttribute("to", to);
        }
        Element propertiesElement = importElement.addElement(N_IGNOREDPROPERTIES);
        for (String property : this.m_importExportManager.getIgnoredProperties()) {
            propertiesElement.addElement("property").addAttribute(N_STATICEXPORT_NAME, property);
        }
        Element staticexportElement = parent.addElement(N_STATICEXPORT);
        staticexportElement.addAttribute("enabled", this.m_staticExportManager.getExportEnabled());
        staticexportElement.addElement(N_STATICEXPORT_HANDLER).addText(this.m_staticExportManager.getHandler().getClass().getName());
        staticexportElement.addElement(N_LINKSUBSTITUTION_HANDLER).addText(this.m_staticExportManager.getLinkSubstitutionHandler().getClass().getName());
        String exportPathUnmodified = this.m_staticExportManager.getExportPathForConfiguration();
        if (exportPathUnmodified.endsWith(File.separator)) {
            exportPathUnmodified = exportPathUnmodified.substring(0, exportPathUnmodified.length() - 1);
        }
        staticexportElement.addElement(N_STATICEXPORT_EXPORTPATH).addText(exportPathUnmodified);
        String exportWorkPathUnmodified = this.m_staticExportManager.getExportWorkPathForConfiguration();
        if (exportWorkPathUnmodified != null) {
            if (exportWorkPathUnmodified.endsWith(File.separator)) {
                exportWorkPathUnmodified = exportWorkPathUnmodified.substring(0, exportWorkPathUnmodified.length() - 1);
            }
            staticexportElement.addElement(N_STATICEXPORT_EXPORTWORKPATH).addText(exportWorkPathUnmodified);
        }
        if (this.m_staticExportManager.getExportBackups() != null) {
            String exportBackupsUnmodified = String.valueOf(this.m_staticExportManager.getExportBackups());
            staticexportElement.addElement(N_STATICEXPORT_EXPORTBACKUPS).addText(exportBackupsUnmodified);
        }
        staticexportElement.addElement(N_STATICEXPORT_DEFAULT).addText(this.m_staticExportManager.getDefault());
        Element defaultsuffixesElement = staticexportElement.addElement(N_STATICEXPORT_DEFAULTSUFFIXES);
        for (String suffix : this.m_staticExportManager.getExportSuffixes()) {
            Element suffixElement = defaultsuffixesElement.addElement(N_STATICEXPORT_SUFFIX);
            suffixElement.addAttribute("key", suffix);
        }
        Iterator<String> exportHandlers = this.m_staticExportManager.getExportHeaders().iterator();
        if (exportHandlers.hasNext()) {
            Element exportheadersElement = staticexportElement.addElement(N_STATICEXPORT_EXPORTHEADERS);
            while (exportHandlers.hasNext()) {
                String header = exportHandlers.next();
                exportheadersElement.addElement(N_STATICEXPORT_HEADER).addText(header);
            }
        }
        String acceptlanguage = this.m_staticExportManager.getAcceptLanguageHeader();
        String acceptcharset = this.m_staticExportManager.getAcceptCharsetHeader();
        String remoteaddr = this.m_staticExportManager.getRemoteAddr();
        if (acceptlanguage != null || acceptcharset != null || remoteaddr != null) {
            Element requestheadersElement = staticexportElement.addElement(N_STATICEXPORT_REQUESTHEADERS);
            if (acceptlanguage != null) {
                requestheadersElement.addElement(N_STATICEXPORT_ACCEPTLANGUAGE).addText(acceptlanguage);
            }
            if (acceptcharset != null) {
                requestheadersElement.addElement(N_STATICEXPORT_ACCEPTCHARSET).addText(acceptcharset);
            }
            if (remoteaddr != null) {
                requestheadersElement.addElement(N_STATICEXPORT_REMOTEADDR).addText(remoteaddr);
            }
        }
        Element rendersettingsElement = staticexportElement.addElement(N_STATICEXPORT_RENDERSETTINGS);
        rendersettingsElement.addElement(N_STATICEXPORT_RFS_PREFIX).addText(this.m_staticExportManager.getRfsPrefixForConfiguration());
        rendersettingsElement.addElement(N_STATICEXPORT_VFS_PREFIX).addText(this.m_staticExportManager.getVfsPrefixForConfiguration());
        rendersettingsElement.addElement(N_STATICEXPORT_RELATIVELINKS).addText(this.m_staticExportManager.getRelativeLinks());
        rendersettingsElement.addElement(N_STATICEXPORT_EXPORTURL).addText(this.m_staticExportManager.getExportUrlForConfiguration());
        rendersettingsElement.addElement(N_STATICEXPORT_PLAINOPTIMIZATION).addText(this.m_staticExportManager.getPlainExportOptimization());
        Element testresourceElement = rendersettingsElement.addElement(N_STATICEXPORT_TESTRESOURCE);
        testresourceElement.addAttribute(N_STATICEXPORT_URI, this.m_staticExportManager.getTestResource());
        Element resourcetorenderElement = rendersettingsElement.addElement(N_STATICEXPORT_RESOURCESTORENDER);
        for (String pattern : this.m_staticExportManager.getExportFolderPatterns()) {
            resourcetorenderElement.addElement("regex").addText(pattern);
        }
        if (!this.m_staticExportManager.getExportRules().isEmpty()) {
            Element exportRulesElement = resourcetorenderElement.addElement(N_STATICEXPORT_EXPORTRULES);
            for (CmsStaticExportExportRule cmsStaticExportExportRule : this.m_staticExportManager.getExportRules()) {
                Element exportRuleElement = exportRulesElement.addElement(N_STATICEXPORT_EXPORTRULE);
                exportRuleElement.addElement(N_STATICEXPORT_NAME).addText(cmsStaticExportExportRule.getName());
                exportRuleElement.addElement(N_STATICEXPORT_DESCRIPTION).addText(cmsStaticExportExportRule.getDescription());
                Element modifiedElement = exportRuleElement.addElement(N_STATICEXPORT_MODIFIED);
                for (Pattern regex : cmsStaticExportExportRule.getModifiedResources()) {
                    modifiedElement.addElement("regex").addText(regex.pattern());
                }
                Element exportElement = exportRuleElement.addElement(N_STATICEXPORT_EXPORT);
                for (String uri : cmsStaticExportExportRule.getExportResourcePatterns()) {
                    exportElement.addElement(N_STATICEXPORT_URI).addText(uri);
                }
            }
        }
        if (!this.m_staticExportManager.getRfsRules().isEmpty()) {
            Element rfsRulesElement = rendersettingsElement.addElement(N_STATICEXPORT_RFS_RULES);
            for (CmsStaticExportRfsRule cmsStaticExportRfsRule : this.m_staticExportManager.getRfsRules()) {
                Element rfsRuleElement = rfsRulesElement.addElement(N_STATICEXPORT_RFS_RULE);
                rfsRuleElement.addElement(N_STATICEXPORT_NAME).addText(cmsStaticExportRfsRule.getName());
                rfsRuleElement.addElement(N_STATICEXPORT_DESCRIPTION).addText(cmsStaticExportRfsRule.getDescription());
                rfsRuleElement.addElement(N_STATICEXPORT_SOURCE).addText(cmsStaticExportRfsRule.getSource().pattern());
                rfsRuleElement.addElement(N_STATICEXPORT_RFS_PREFIX).addText(cmsStaticExportRfsRule.getRfsPrefixConfigured());
                rfsRuleElement.addElement(N_STATICEXPORT_EXPORTPATH).addText(cmsStaticExportRfsRule.getExportPathConfigured());
                if (cmsStaticExportRfsRule.getExportWorkPathConfigured() != null) {
                    rfsRuleElement.addElement(N_STATICEXPORT_EXPORTWORKPATH).addText(cmsStaticExportRfsRule.getExportWorkPathConfigured());
                }
                if (cmsStaticExportRfsRule.getExportBackups() != null) {
                    rfsRuleElement.addElement(N_STATICEXPORT_EXPORTBACKUPS).addText(String.valueOf(cmsStaticExportRfsRule.getExportBackups()));
                }
                if (cmsStaticExportRfsRule.getUseRelativeLinks() != null) {
                    rfsRuleElement.addElement(N_STATICEXPORT_RELATIVELINKS).addText(cmsStaticExportRfsRule.getUseRelativeLinks().toString());
                }
                Element relatedSystemRes = rfsRuleElement.addElement(N_STATICEXPORT_RELATED_SYSTEM_RES);
                for (Pattern sysRes : cmsStaticExportRfsRule.getRelatedSystemResources()) {
                    relatedSystemRes.addElement("regex").addText(sysRes.pattern());
                }
            }
        }
        if (this.m_importExportManager.getUserExportSettings() != null) {
            Element userExportElement = parent.addElement(N_USERCSVEXPORT);
            userExportElement.addElement(N_SEPARATOR).setText(this.m_importExportManager.getUserExportSettings().getSeparator());
            Element exportColumns = userExportElement.addElement(N_COLUMNS);
            List<String> list = this.m_importExportManager.getUserExportSettings().getColumns();
            Iterator<String> itExportColumnList = list.iterator();
            while (itExportColumnList.hasNext()) {
                exportColumns.addElement(N_COLUMN).setText(itExportColumnList.next());
            }
        }
        if (this.m_repositoryManager.isConfigured() && (repositories = this.m_repositoryManager.getRepositories()) != null) {
            Element repositoriesElement = parent.addElement(N_REPOSITORIES);
            for (A_CmsRepository repository : repositories) {
                List<Pattern> rules;
                CmsRepositoryFilter filter;
                Element repositoryElement = repositoriesElement.addElement(N_REPOSITORY);
                repositoryElement.addAttribute(N_STATICEXPORT_NAME, repository.getName());
                repositoryElement.addAttribute("class", repository.getClass().getName());
                CmsParameterConfiguration config = repository.getConfiguration();
                if (config != null && config.size() > 0) {
                    Element paramsElement = repositoryElement.addElement(N_PARAMS);
                    config.appendToXml(paramsElement);
                }
                if ((filter = repository.getFilter()) == null || (rules = filter.getFilterRules()).size() <= 0) continue;
                Element filterElement = repositoryElement.addElement(N_FILTER);
                filterElement.addAttribute("type", filter.getType());
                for (Pattern rule : rules) {
                    filterElement.addElement("regex").addText(rule.pattern());
                }
            }
        }
        if ((htmlimport = this.m_importExportManager.getExtendedHtmlImportDefault(true)) != null) {
            Element htmlImportElement = parent.addElement(N_EXTHTMLIMPORT);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(htmlimport.getDestinationDir())) {
                htmlImportElement.addElement(N_EXTHTMLIMPORT_DESTINATION).setText(htmlimport.getDestinationDir());
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(htmlimport.getInputDir())) {
                htmlImportElement.addElement(N_EXTHTMLIMPORT_INPUT).setText(htmlimport.getInputDir());
            }
            Element element = htmlImportElement.addElement(N_EXTHTMLIMPORT_GALLERIES);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(htmlimport.getDownloadGallery())) {
                element.addElement(N_EXTHTMLIMPORT_DOWNLOAD).setText(htmlimport.getDownloadGallery());
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(htmlimport.getImageGallery())) {
                element.addElement(N_EXTHTMLIMPORT_IMAGE).setText(htmlimport.getImageGallery());
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(htmlimport.getLinkGallery())) {
                element.addElement(N_EXTHTMLIMPORT_EXTERNALLINK).setText(htmlimport.getLinkGallery());
            }
            Element settingElement = htmlImportElement.addElement(N_EXTHTMLIMPORT_SETTINGS);
            settingElement.addElement(N_EXTHTMLIMPORT_TEMPLATE).setText(htmlimport.getTemplate());
            settingElement.addElement(N_EXTHTMLIMPORT_ELEMENT).setText(htmlimport.getElement());
            settingElement.addElement(N_EXTHTMLIMPORT_LOCALE).setText(htmlimport.getLocale());
            settingElement.addElement(N_EXTHTMLIMPORT_ENCODING).setText(htmlimport.getEncoding());
            Element patternElement = settingElement.addElement(N_EXTHTMLIMPORT_PATTERN);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(htmlimport.getStartPattern())) {
                patternElement.addElement(N_EXTHTMLIMPORT_PATTERN_START).setText(htmlimport.getStartPattern());
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(htmlimport.getEndPattern())) {
                patternElement.addElement(N_EXTHTMLIMPORT_PATTERN_END).setText(htmlimport.getEndPattern());
            }
            settingElement.addElement(N_EXTHTMLIMPORT_OVERWRITE).setText(htmlimport.getOverwrite());
            settingElement.addElement(N_EXTHTMLIMPORT_KEEPBROKENLINKS).setText(htmlimport.getKeepBrokenLinks());
        }
        return importexportElement;
    }

    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsImportExportManager getImportExportManager() {
        return this.m_importExportManager;
    }

    public CmsRepositoryManager getRepositoryManager() {
        return this.m_repositoryManager;
    }

    public CmsStaticExportManager getStaticExportManager() {
        return this.m_staticExportManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_IMPORT_CONFIG_FINISHED_0"));
        }
    }

    public void setExtendedHtmlImportManager(CmsExtendedHtmlImportDefault extendedHtmlImportManager) {
        this.m_importExportManager.setExtendedHtmlImportDefault(extendedHtmlImportManager);
    }

    public void setImportExportManager(CmsImportExportManager manager) {
        this.m_importExportManager = manager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_IMPORT_MANAGER_0"));
        }
    }

    public void setRepositoryManager(CmsRepositoryManager manager) {
        this.m_repositoryManager = manager;
    }

    public void setStaticExportManager(CmsStaticExportManager manager) {
        this.m_staticExportManager = manager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STATEXP_MANAGER_0"));
        }
    }

    public void setUserExportSettings(CmsUserExportSettings userExportSettings) {
        this.m_importExportManager.setUserExportSettings(userExportSettings);
    }

    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_IMPORT_CONFIG_INIT_0"));
        }
    }
}

