/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.opencms.db.CmsLoginMessage;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAuthentificationException;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsUserDisabledException;
import org.opencms.security.Messages;

public class CmsLoginManager {
    public static final int DISABLE_MINUTES_DEFAULT = 15;
    public static final boolean ENABLE_SECURITY_DEFAULT = false;
    public static final int MAX_BAD_ATTEMPTS_DEFAULT = 3;
    protected int m_disableMillis;
    protected int m_disableMinutes;
    protected boolean m_enableSecurity;
    protected int m_maxBadAttempts;
    protected Map<String, CmsUserData> m_storage;
    private CmsLoginMessage m_loginMessage;

    public CmsLoginManager(int disableMinutes, int maxBadAttempts, boolean enableSecurity) {
        this.m_maxBadAttempts = maxBadAttempts;
        if (this.m_maxBadAttempts >= 0) {
            this.m_disableMinutes = disableMinutes;
            this.m_disableMillis = disableMinutes * 60 * 1000;
            this.m_storage = new Hashtable<String, CmsUserData>();
        }
        this.m_enableSecurity = enableSecurity;
    }

    private static String createStorageKey(String userName, String remoteAddress) {
        StringBuffer result = new StringBuffer();
        result.append(userName);
        result.append('_');
        result.append(remoteAddress);
        return result.toString();
    }

    public void checkInvalidLogins(String userName, String remoteAddress) throws CmsAuthentificationException {
        if (this.m_maxBadAttempts < 0) {
            return;
        }
        String key = CmsLoginManager.createStorageKey(userName, remoteAddress);
        CmsUserData userData = this.m_storage.get(key);
        if (userData != null && userData.isDisabled()) {
            throw new CmsUserDisabledException(Messages.get().container("ERR_LOGIN_FAILED_TEMP_DISABLED_4", new Object[]{userName, remoteAddress, userData.getReleaseDate(), userData.getInvalidLoginCount()}));
        }
    }

    public void checkLoginAllowed() throws CmsAuthentificationException {
        if (this.m_loginMessage != null && this.m_loginMessage.isLoginCurrentlyForbidden()) {
            throw new CmsAuthentificationException(Messages.get().container("ERR_LOGIN_FAILED_WITH_MESSAGE_1", this.m_loginMessage.getMessage()));
        }
    }

    public int getDisableMinutes() {
        return this.m_disableMinutes;
    }

    public boolean isEnableSecurity() {
        return this.m_enableSecurity;
    }

    public CmsLoginMessage getLoginMessage() {
        return this.m_loginMessage;
    }

    public int getMaxBadAttempts() {
        return this.m_maxBadAttempts;
    }

    public void removeLoginMessage(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        this.m_loginMessage = null;
    }

    public void setLoginMessage(CmsObject cms, CmsLoginMessage message) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() >= 3) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        }
        this.m_loginMessage = message;
        if (this.m_loginMessage != null) {
            this.m_loginMessage.setFrozen();
        }
    }

    protected void addInvalidLogin(String userName, String remoteAddress) {
        if (this.m_maxBadAttempts < 0) {
            return;
        }
        String key = CmsLoginManager.createStorageKey(userName, remoteAddress);
        CmsUserData userData = this.m_storage.get(key);
        if (userData != null) {
            userData.increaseInvalidLoginCount();
        } else {
            userData = new CmsUserData();
            this.m_storage.put(key, userData);
        }
    }

    protected void removeInvalidLogins(String userName, String remoteAddress) {
        if (this.m_maxBadAttempts < 0) {
            return;
        }
        String key = CmsLoginManager.createStorageKey(userName, remoteAddress);
        this.m_storage.remove(key);
    }

    private class CmsUserData {
        private long m_disableTimeStart;
        private int m_invalidLoginCount = 1;

        protected CmsUserData() {
        }

        protected Integer getInvalidLoginCount() {
            return new Integer(this.m_invalidLoginCount);
        }

        protected Date getReleaseDate() {
            return new Date(this.m_disableTimeStart + (long)CmsLoginManager.this.m_disableMillis + 1L);
        }

        protected void increaseInvalidLoginCount() {
            ++this.m_invalidLoginCount;
            if (this.m_invalidLoginCount >= CmsLoginManager.this.m_maxBadAttempts && this.m_disableTimeStart == 0L) {
                this.m_disableTimeStart = System.currentTimeMillis();
            }
        }

        protected boolean isDisabled() {
            long currentTime;
            if (this.m_disableTimeStart > 0L && (currentTime = System.currentTimeMillis()) - this.m_disableTimeStart > (long)CmsLoginManager.this.m_disableMillis) {
                this.m_disableTimeStart = 0L;
            }
            return this.m_disableTimeStart > 0L;
        }
    }
}

