/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.Date;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.util.CmsStringUtil;

public class CmsVisitedByFilter {
    private long m_fromDate = 0L;
    private boolean m_includeSubFolders;
    private String m_parentPath;
    private long m_toDate = Long.MAX_VALUE;
    private CmsUser m_user;

    public CmsVisitedByFilter() {
    }

    public CmsVisitedByFilter(CmsObject cms) {
        this();
        this.m_user = cms.getRequestContext().getCurrentUser();
    }

    public Object clone() {
        CmsVisitedByFilter filter = new CmsVisitedByFilter();
        filter.m_fromDate = this.m_fromDate;
        filter.m_includeSubFolders = this.m_includeSubFolders;
        filter.m_parentPath = this.m_parentPath;
        filter.m_toDate = this.m_toDate;
        filter.m_user = this.m_user;
        return filter;
    }

    public long getFromDate() {
        return this.m_fromDate;
    }

    public String getParentPath() {
        return this.m_parentPath;
    }

    public long getToDate() {
        return this.m_toDate;
    }

    public CmsUser getUser() {
        return this.m_user;
    }

    public boolean isIncludeSubFolders() {
        return this.m_includeSubFolders;
    }

    public void setFromDate(long fromDate) {
        this.m_fromDate = fromDate;
    }

    public void setIncludeSubfolders(boolean includeSubFolders) {
        this.m_includeSubFolders = includeSubFolders;
    }

    public void setParentPath(String parentPath) {
        this.m_parentPath = parentPath;
    }

    public void setParentResource(CmsResource parentResource) {
        this.m_parentPath = parentResource.isFile() ? CmsResource.getFolderPath(parentResource.getRootPath()) : parentResource.getRootPath();
    }

    public void setToDate(long toDate) {
        this.m_toDate = toDate;
    }

    public void setUser(CmsUser user) {
        this.m_user = user;
    }

    public void setVisitedDates(long fromDate, long toDate) {
        this.setFromDate(fromDate);
        this.setToDate(toDate);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("From: ").append(new Date(this.getFromDate()).toString());
        result.append(", To: ").append(new Date(this.getToDate()).toString());
        if (this.getUser() != null) {
            result.append(", User: ").append(this.getUser().getName());
        }
        if (CmsStringUtil.isNotEmpty(this.getParentPath())) {
            result.append(", Parent path: ").append(this.getParentPath());
            result.append(", Subfolders: ").append(this.isIncludeSubFolders());
        }
        return result.toString();
    }
}

