/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsResourceState;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsHistoryDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.jpa.CmsSqlManager;
import org.opencms.db.jpa.CmsVfsDriver;
import org.opencms.db.jpa.Messages;
import org.opencms.db.jpa.persistence.CmsDAOContents;
import org.opencms.db.jpa.persistence.CmsDAOHistoryPrincipals;
import org.opencms.db.jpa.persistence.CmsDAOHistoryProjectResources;
import org.opencms.db.jpa.persistence.CmsDAOHistoryProjects;
import org.opencms.db.jpa.persistence.CmsDAOHistoryProperties;
import org.opencms.db.jpa.persistence.CmsDAOHistoryPropertyDef;
import org.opencms.db.jpa.persistence.CmsDAOHistoryResources;
import org.opencms.db.jpa.persistence.CmsDAOHistoryStructure;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.history.CmsHistoryFolder;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsHistoryDriver
implements I_CmsDriver,
I_CmsHistoryDriver {
    private static final String C_CONTENT_HISTORY_DELETE = "C_CONTENT_HISTORY_DELETE";
    private static final String C_CONTENT_PUBLISH_MAXTAG = "C_CONTENT_PUBLISH_MAXTAG";
    private static final String C_FILES_READ_HISTORY_BYID = "C_FILES_READ_HISTORY_BYID";
    private static final String C_HISTORY_EXISTS_RESOURCE = "C_HISTORY_EXISTS_RESOURCE";
    private static final String C_HISTORY_PRINCIPAL_READ = "C_HISTORY_PRINCIPAL_READ";
    private static final String C_HISTORY_READ_CONTENT = "C_HISTORY_READ_CONTENT";
    private static final String C_HISTORY_READ_MAXTAG_FOR_VERSION = "C_HISTORY_READ_MAXTAG_FOR_VERSION";
    private static final String C_HISTORY_READ_MIN_USED_TAG = "C_HISTORY_READ_MIN_USED_TAG";
    private static final String C_PROJECTRESOURCES_HISTORY_READ = "C_PROJECTRESOURCES_HISTORY_READ";
    private static final String C_PROJECTS_HISTORY_MAXTAG = "C_PROJECTS_HISTORY_MAXTAG";
    private static final String C_PROJECTS_HISTORY_READ = "C_PROJECTS_HISTORY_READ";
    private static final String C_PROJECTS_HISTORY_READ_ALL = "C_PROJECTS_HISTORY_READ_ALL";
    private static final String C_PROJECTS_HISTORY_READ_BYID = "C_PROJECTS_HISTORY_READ_BYID";
    private static final String C_PROJECTS_HISTORY_READ_TAG_FOR_DATE = "C_PROJECTS_HISTORY_READ_TAG_FOR_DATE";
    private static final String C_PROPERTIES_HISTORY_DELETE = "C_PROPERTIES_HISTORY_DELETE";
    private static final String C_PROPERTIES_HISTORY_READ_PUBTAG = "C_PROPERTIES_HISTORY_READ_PUBTAG";
    private static final String C_PROPERTIES_HISTORY_READALL_RES = "C_PROPERTIES_HISTORY_READALL_RES";
    private static final String C_PROPERTIES_HISTORY_READALL_STR = "C_PROPERTIES_HISTORY_READALL_STR";
    private static final String C_PROPERTIES_READALL_COUNT = "C_PROPERTIES_READALL_COUNT";
    private static final String C_PROPERTYDEF_DELETE_HISTORY = "C_PROPERTYDEF_DELETE_HISTORY";
    private static final String C_PROPERTYDEF_READ_HISTORY = "C_PROPERTYDEF_READ_HISTORY";
    private static final String C_RESOURCES_HISTORY_DELETE = "C_RESOURCES_HISTORY_DELETE";
    private static final String C_RESOURCES_HISTORY_MAXTAG = "C_RESOURCES_HISTORY_MAXTAG";
    private static final String C_RESOURCES_HISTORY_READ_ALL_VERSIONS = "C_RESOURCES_HISTORY_READ_ALL_VERSIONS";
    private static final String C_RESOURCES_HISTORY_READ_BTW_VERSIONS = "C_RESOURCES_HISTORY_READ_BTW_VERSIONS";
    private static final String C_RESOURCES_HISTORY_READ_DELETED = "C_RESOURCES_HISTORY_READ_DELETED";
    private static final String C_RESOURCES_HISTORY_READ_DELETED_NAME = "C_RESOURCES_HISTORY_READ_DELETED_NAME";
    private static final String C_RESOURCES_HISTORY_READ_DELETED_NAME_RESTRICTED = "C_RESOURCES_HISTORY_READ_DELETED_NAME_RESTRICTED";
    private static final String C_RESOURCES_HISTORY_READ_DELETED_RESTRICTED = "C_RESOURCES_HISTORY_READ_DELETED_RESTRICTED";
    private static final String C_RESOURCES_HISTORY_READ_NEW_VERSIONS = "C_RESOURCES_HISTORY_READ_NEW_VERSIONS";
    private static final String C_RESOURCES_HISTORY_READ_OLD_VERSIONS = "C_RESOURCES_HISTORY_READ_OLD_VERSIONS";
    private static final String C_RESOURCES_HISTORY_READ_VERSION = "C_RESOURCES_HISTORY_READ_VERSION";
    private static final String C_RESOURCES_READ_MAX_PUBLISH_TAG = "C_RESOURCES_READ_MAX_PUBLISH_TAG";
    private static final String C_STRUCTURE_HISTORY_DELETE = "C_STRUCTURE_HISTORY_DELETE";
    private static final String C_STRUCTURE_HISTORY_MAXVER = "C_STRUCTURE_HISTORY_MAXVER";
    private static final String C_STRUCTURE_HISTORY_MAXVER_BYTIME = "C_STRUCTURE_HISTORY_MAXVER_BYTIME";
    private static final String C_STRUCTURE_HISTORY_READ_DELETED = "C_STRUCTURE_HISTORY_READ_DELETED";
    private static final String C_STRUCTURE_HISTORY_READ_NOTDELETED = "C_STRUCTURE_HISTORY_READ_NOTDELETED";
    private static final String C_STRUCTURE_HISTORY_READ_SUBRESOURCES = "C_STRUCTURE_HISTORY_READ_SUBRESOURCES";
    private static final Log LOG = CmsLog.getLog(CmsHistoryDriver.class);
    protected CmsDriverManager m_driverManager;
    protected CmsSqlManager m_sqlManager;

    @Override
    public CmsPropertyDefinition createPropertyDefinition(CmsDbContext dbc, String name, CmsPropertyDefinition.CmsPropertyType type) throws CmsDataAccessException {
        try {
            CmsDAOHistoryPropertyDef chpd = new CmsDAOHistoryPropertyDef();
            chpd.setPropertyDefId(new CmsUUID().toString());
            chpd.setPropertyDefName(name);
            chpd.setPropertyDefType(type.getMode());
            this.m_sqlManager.persist(dbc, chpd);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1"), (Throwable)e);
        }
        return this.readPropertyDefinition(dbc, name);
    }

    @Override
    public int deleteEntries(CmsDbContext dbc, I_CmsHistoryResource resource, int versionsToKeep, long time) throws CmsDataAccessException {
        try {
            int maxVersion = -1;
            Query q = this.m_sqlManager.createQuery(dbc, C_STRUCTURE_HISTORY_MAXVER);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            try {
                maxVersion = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {
                this.internalCleanup(dbc, resource);
                return 0;
            }
            if (time >= 0L) {
                int maxVersionByTime = -1;
                q = this.m_sqlManager.createQuery(dbc, C_STRUCTURE_HISTORY_MAXVER_BYTIME);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                q.setParameter(2, (Object)time);
                try {
                    maxVersionByTime = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
                }
                catch (NoResultException e) {
                    // empty catch block
                }
                if (maxVersionByTime > 0) {
                    versionsToKeep = versionsToKeep < 0 ? maxVersion - maxVersionByTime : Math.min(versionsToKeep, maxVersion - maxVersionByTime);
                }
            }
            if (maxVersion - versionsToKeep <= 0) {
                this.internalCleanup(dbc, resource);
                return 0;
            }
            int minStrPublishTagToKeep = -1;
            q = this.m_sqlManager.createQuery(dbc, C_HISTORY_READ_MAXTAG_FOR_VERSION);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            q.setParameter(2, (Object)(1 + maxVersion - versionsToKeep));
            try {
                minStrPublishTagToKeep = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {
                this.internalCleanup(dbc, resource);
                return 0;
            }
            if (minStrPublishTagToKeep < 1) {
                this.internalCleanup(dbc, resource);
                return 0;
            }
            q = this.m_sqlManager.createQuery(dbc, C_PROPERTIES_HISTORY_DELETE);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            q.setParameter(2, (Object)(++minStrPublishTagToKeep));
            List hisProps = q.getResultList();
            for (CmsDAOHistoryProperties hp : hisProps) {
                this.m_sqlManager.remove(dbc, hp);
            }
            q = this.m_sqlManager.createQuery(dbc, C_STRUCTURE_HISTORY_DELETE);
            q.setParameter(1, (Object)resource.getStructureId().toString());
            q.setParameter(2, (Object)minStrPublishTagToKeep);
            List structureEntries = q.getResultList();
            int structureVersions = 0;
            for (CmsDAOHistoryStructure hs : structureEntries) {
                this.m_sqlManager.remove(dbc, hs);
                ++structureVersions;
            }
            int minResPublishTagToKeep = -1;
            q = this.m_sqlManager.createQuery(dbc, C_HISTORY_READ_MIN_USED_TAG);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            try {
                Object numObj = q.getSingleResult();
                minResPublishTagToKeep = numObj == null ? Integer.MAX_VALUE : CmsDataTypeUtil.numberToInt((Number)numObj);
            }
            catch (NoResultException e) {
                this.internalCleanup(dbc, resource);
                return structureVersions;
            }
            q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_DELETE);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            q.setParameter(2, (Object)minResPublishTagToKeep);
            int resourceVersions = 0;
            List resourceEntries = q.getResultList();
            for (CmsDAOHistoryResources hr : resourceEntries) {
                this.m_sqlManager.remove(dbc, hr);
                ++resourceVersions;
            }
            q = this.m_sqlManager.createQuery(dbc, C_CONTENT_HISTORY_DELETE);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            q.setParameter(2, (Object)minResPublishTagToKeep);
            List contentEntries = q.getResultList();
            for (CmsDAOContents c : contentEntries) {
                this.m_sqlManager.remove(dbc, c);
            }
            this.internalCleanup(dbc, resource);
            return Math.max(structureVersions, resourceVersions);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1"), (Throwable)e);
        }
    }

    @Override
    public void deletePropertyDefinition(CmsDbContext dbc, CmsPropertyDefinition metadef) throws CmsDataAccessException {
        try {
            if (this.internalCountProperties(dbc, metadef, CmsProject.ONLINE_PROJECT_ID) != 0 || this.internalCountProperties(dbc, metadef, CmsUUID.getOpenCmsUUID()) != 0) {
                throw new CmsDbConsistencyException(Messages.get().container("ERR_ERROR_DELETING_PROPERTYDEF_1", metadef.getName()));
            }
            Query q = this.m_sqlManager.createQuery(dbc, C_PROPERTYDEF_DELETE_HISTORY);
            q.setParameter(1, (Object)metadef.getId().toString());
            List res = q.getResultList();
            for (CmsDAOHistoryPropertyDef hpd : res) {
                this.m_sqlManager.remove(dbc, hpd);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_GENERIC_SQL_1", "ERR_COUNTING_PROPERTIES_1"), (Throwable)e);
        }
    }

    @Override
    public void destroy() throws Throwable {
        this.m_sqlManager = null;
        this.m_driverManager = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_DRIVER_1", this.getClass().getName()));
        }
    }

    @Override
    public List<I_CmsHistoryResource> getAllDeletedEntries(CmsDbContext dbc) throws CmsDataAccessException {
        Query q = null;
        ArrayList<I_CmsHistoryResource> entries = new ArrayList<I_CmsHistoryResource>();
        try {
            q = this.m_sqlManager.createQuery(dbc, C_STRUCTURE_HISTORY_READ_DELETED);
            List res = q.getResultList();
            for (Object[] obj : res) {
                CmsUUID structureId = new CmsUUID((String)obj[0]);
                int version = CmsDataTypeUtil.numberToInt((Integer)obj[1]);
                entries.add(this.readResource(dbc, structureId, version));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return entries;
    }

    @Override
    public List<I_CmsHistoryResource> getAllNotDeletedEntries(CmsDbContext dbc) throws CmsDataAccessException {
        ArrayList<I_CmsHistoryResource> entries = new ArrayList<I_CmsHistoryResource>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_STRUCTURE_HISTORY_READ_NOTDELETED);
            List res = q.getResultList();
            for (Object[] o : res) {
                CmsUUID structureId = new CmsUUID((String)o[0]);
                int version = CmsDataTypeUtil.numberToInt((Number)o[1]);
                entries.add(this.readResource(dbc, structureId, version));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return entries;
    }

    @Override
    public org.opencms.db.CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    @Override
    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List<String> successiveDrivers, CmsDriverManager driverManager) {
        CmsParameterConfiguration config = configurationManager.getConfiguration();
        String poolUrl = config.get("db.history.pool");
        String classname = config.get("db.history.sqlmanager");
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    @Override
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    @Override
    public List<I_CmsHistoryResource> readAllAvailableVersions(CmsDbContext dbc, CmsUUID structureId) throws CmsDataAccessException {
        ArrayList<I_CmsHistoryResource> result = new ArrayList<I_CmsHistoryResource>();
        Query q = null;
        try {
            I_CmsHistoryResource histRes;
            I_CmsHistoryResource newHistRes;
            List lResources;
            ArrayList<I_CmsHistoryResource> historyResources = new ArrayList<I_CmsHistoryResource>();
            q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_ALL_VERSIONS);
            q.setParameter(1, (Object)structureId.toString());
            List res = q.getResultList();
            for (Object[] o : res) {
                historyResources.add(this.internalCreateResource(o));
            }
            res = null;
            if (!historyResources.isEmpty()) {
                I_CmsHistoryResource histRes2 = (I_CmsHistoryResource)historyResources.get(0);
                q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_NEW_VERSIONS);
                q.setParameter(1, (Object)histRes2.getResourceId().toString());
                q.setParameter(2, (Object)histRes2.getPublishTag());
                lResources = q.getResultList();
                I_CmsHistoryResource lastHistRes = histRes2;
                for (CmsDAOHistoryResources hr : lResources) {
                    int resVersion = hr.getResourceVersion();
                    if (resVersion == lastHistRes.getResourceVersion()) continue;
                    newHistRes = this.internalMergeResource(histRes2, hr, 0);
                    result.add(0, newHistRes);
                    lastHistRes = newHistRes;
                }
            }
            for (int i = 0; i < historyResources.size(); ++i) {
                I_CmsHistoryResource histRes3 = (I_CmsHistoryResource)historyResources.get(i);
                result.add(histRes3);
                if (i >= historyResources.size() - 1) continue;
                I_CmsHistoryResource histRes2 = (I_CmsHistoryResource)historyResources.get(i + 1);
                q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_BTW_VERSIONS);
                q.setParameter(1, (Object)histRes3.getResourceId().toString());
                q.setParameter(2, (Object)histRes2.getPublishTag());
                q.setParameter(3, (Object)histRes3.getPublishTag());
                List lResources2 = q.getResultList();
                int pos = result.size();
                I_CmsHistoryResource lastHistRes = histRes2;
                for (CmsDAOHistoryResources hr : lResources2) {
                    int resVersion = hr.getResourceVersion();
                    if (resVersion == lastHistRes.getResourceVersion()) continue;
                    I_CmsHistoryResource newHistRes2 = this.internalMergeResource(histRes2, hr, 0);
                    result.add(pos, newHistRes2);
                    lastHistRes = newHistRes2;
                }
                lResources2 = null;
            }
            if (!result.isEmpty() && (histRes = (I_CmsHistoryResource)result.get(result.size() - 1)).getVersion() > 1) {
                q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_OLD_VERSIONS);
                q.setParameter(1, (Object)String.valueOf(histRes.getResourceId()));
                q.setParameter(2, (Object)histRes.getPublishTag());
                lResources = q.getResultList();
                int offset = histRes.getStructureVersion() > 0 ? 1 : 0;
                I_CmsHistoryResource lastHistRes = histRes;
                for (CmsDAOHistoryResources hr : lResources) {
                    newHistRes = this.internalMergeResource(histRes, hr, offset);
                    if (newHistRes.getResourceVersion() != lastHistRes.getResourceVersion()) {
                        if (offset == 1) {
                            if (histRes != lastHistRes) {
                                result.add(lastHistRes);
                            }
                        } else {
                            result.add(newHistRes);
                        }
                    }
                    lastHistRes = newHistRes;
                }
                if (offset == 1 && lastHistRes != histRes) {
                    result.add(lastHistRes);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public byte[] readContent(CmsDbContext dbc, CmsUUID resourceId, int publishTag) throws CmsDataAccessException {
        byte[] content = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_HISTORY_READ_CONTENT);
            q.setParameter(1, (Object)resourceId.toString());
            q.setParameter(2, (Object)publishTag);
            q.setParameter(3, (Object)publishTag);
            try {
                content = ((CmsDAOContents)q.getSingleResult()).getFileContent();
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return content;
    }

    @Override
    public List<I_CmsHistoryResource> readDeletedResources(CmsDbContext dbc, CmsUUID structureId, CmsUUID userId) throws CmsDataAccessException {
        ArrayList<I_CmsHistoryResource> result = new ArrayList<I_CmsHistoryResource>();
        Query q = null;
        I_CmsVfsDriver vfsDriver = this.m_driverManager.getVfsDriver(dbc);
        try {
            q = userId == null ? this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_DELETED) : this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_DELETED_RESTRICTED);
            q.setParameter(1, (Object)structureId.toString());
            if (userId != null) {
                q.setParameter(2, (Object)userId.toString());
            }
            List res = q.getResultList();
            for (Object[] o : res) {
                I_CmsHistoryResource histRes = this.internalCreateResource(o);
                if (vfsDriver.validateStructureIdExists(dbc, dbc.currentProject().getUuid(), histRes.getStructureId())) continue;
                result.add(histRes);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        if (!result.isEmpty() || dbc.getRequestContext() == null || dbc.getRequestContext().getAttribute("ATTR_RESOURCE_NAME") == null) {
            return result;
        }
        try {
            q = userId == null ? this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_DELETED_NAME) : this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_DELETED_NAME_RESTRICTED);
            String path = dbc.getRequestContext().getAttribute("ATTR_RESOURCE_NAME").toString();
            q.setParameter(1, (Object)CmsVfsDriver.escapeDbWildcard(path + '%'));
            q.setParameter(2, (Object)path);
            if (userId != null) {
                q.setParameter(3, (Object)userId.toString());
            }
            List res = q.getResultList();
            for (Object[] o : res) {
                I_CmsHistoryResource histRes = this.internalCreateResource(o);
                if (vfsDriver.validateStructureIdExists(dbc, dbc.currentProject().getUuid(), histRes.getStructureId())) continue;
                result.add(histRes);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Deprecated
    public I_CmsHistoryResource readFile(CmsDbContext dbc, CmsUUID structureId, int tagId) throws CmsDataAccessException {
        I_CmsHistoryResource file = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_FILES_READ_HISTORY_BYID);
            q.setParameter(1, (Object)structureId.toString());
            q.setParameter(2, (Object)tagId);
            Object[] res = (Object[])q.getSingleResult();
            file = this.internalCreateResource(res);
        }
        catch (NoResultException e) {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_HISTORY_FILE_NOT_FOUND_1", structureId));
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        ((CmsFile)((Object)file)).setContents(this.readContent(dbc, file.getResourceId(), file.getPublishTag()));
        return file;
    }

    @Override
    public int readLastVersion(CmsDbContext dbc, CmsUUID structureId) throws CmsDataAccessException {
        int lastVersion = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_STRUCTURE_HISTORY_MAXVER);
            q.setParameter(1, (Object)structureId.toString());
            try {
                lastVersion = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {
            }
            catch (NullPointerException e) {
                lastVersion = 0;
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return lastVersion;
    }

    @Override
    public int readMaxPublishTag(CmsDbContext dbc, CmsUUID resourceId) throws CmsDataAccessException {
        int result = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_READ_MAX_PUBLISH_TAG);
            q.setParameter(1, (Object)resourceId.toString());
            try {
                result = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return result;
    }

    @Override
    public int readNextPublishTag(CmsDbContext dbc) {
        Query q;
        int projectPublishTag = 1;
        int resourcePublishTag = 1;
        try {
            q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_HISTORY_MAXTAG);
            try {
                projectPublishTag = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult()) + 1;
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            LOG.error((Object)Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        try {
            q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_MAXTAG);
            try {
                resourcePublishTag = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult()) + 1;
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            LOG.error((Object)Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        if (resourcePublishTag > projectPublishTag) {
            projectPublishTag = resourcePublishTag;
        }
        try {
            q = this.m_sqlManager.createQuery(dbc, C_CONTENT_PUBLISH_MAXTAG);
            try {
                resourcePublishTag = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult()) + 1;
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            // empty catch block
        }
        if (resourcePublishTag > projectPublishTag) {
            projectPublishTag = resourcePublishTag;
        }
        return projectPublishTag;
    }

    @Override
    public CmsHistoryPrincipal readPrincipal(CmsDbContext dbc, CmsUUID principalId) throws CmsDataAccessException {
        CmsHistoryPrincipal historyPrincipal = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_HISTORY_PRINCIPAL_READ);
            q.setParameter(1, (Object)principalId.toString());
            try {
                CmsDAOHistoryPrincipals hp = (CmsDAOHistoryPrincipals)q.getSingleResult();
                String userName = hp.getPrincipalName();
                String ou = CmsOrganizationalUnit.removeLeadingSeparator(hp.getPrincipalOu());
                historyPrincipal = new CmsHistoryPrincipal(principalId, ou + userName, hp.getPrincipalDescription(), hp.getPrincipalEmail(), hp.getPrincipalType(), new CmsUUID(hp.getPrincipalUserDeleted()), hp.getPrincipalDateDeleted());
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_HISTORY_PRINCIPAL_NOT_FOUND_1", principalId));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return historyPrincipal;
    }

    @Override
    public CmsHistoryProject readProject(CmsDbContext dbc, CmsUUID projectId) throws CmsDataAccessException {
        CmsHistoryProject project = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_HISTORY_READ_BYID);
            q.setParameter(1, (Object)projectId.toString());
            try {
                CmsDAOHistoryProjects hp = (CmsDAOHistoryProjects)q.getSingleResult();
                int tag = hp.getPublishTag();
                List<String> projectresources = this.readProjectResources(dbc, tag);
                project = this.internalCreateProject(hp, projectresources);
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_HISTORY_PROJECT_WITH_ID_1", projectId));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return project;
    }

    @Override
    public CmsHistoryProject readProject(CmsDbContext dbc, int publishTag) throws CmsDataAccessException {
        CmsHistoryProject project = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_HISTORY_READ);
            q.setParameter(1, (Object)publishTag);
            try {
                CmsDAOHistoryProjects hp = (CmsDAOHistoryProjects)q.getSingleResult();
                List<String> projectresources = this.readProjectResources(dbc, publishTag);
                project = this.internalCreateProject(hp, projectresources);
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_HISTORY_PROJECT_WITH_TAG_ID_1", new Integer(publishTag)));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return project;
    }

    @Override
    public List<String> readProjectResources(CmsDbContext dbc, int publishTag) throws CmsDataAccessException {
        ArrayList<String> projectResources = new ArrayList<String>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTRESOURCES_HISTORY_READ);
            q.setParameter(1, (Object)publishTag);
            List res = q.getResultList();
            for (String s : res) {
                projectResources.add(s);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return projectResources;
    }

    @Override
    public List<CmsHistoryProject> readProjects(CmsDbContext dbc) throws CmsDataAccessException {
        ArrayList<CmsHistoryProject> projects = new ArrayList<CmsHistoryProject>();
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_HISTORY_READ_ALL);
            q.setMaxResults(300);
            List res = q.getResultList();
            for (CmsDAOHistoryProjects hp : res) {
                List<String> resources = this.readProjectResources(dbc, hp.getPublishTag());
                projects.add(this.internalCreateProject(hp, resources));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return projects;
    }

    @Override
    public List<CmsProperty> readProperties(CmsDbContext dbc, I_CmsHistoryResource resource) throws CmsDataAccessException {
        HashMap<String, CmsProperty> propertyMap = new HashMap<String, CmsProperty>();
        try {
            int mappingType;
            String propertyValue;
            String propertyKey;
            List res;
            int pubTag = -1;
            Query q = this.m_sqlManager.createQuery(dbc, C_PROPERTIES_HISTORY_READ_PUBTAG);
            q.setParameter(1, (Object)String.valueOf(resource.getStructureId()));
            q.setParameter(2, (Object)resource.getPublishTag());
            try {
                pubTag = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {
                // empty catch block
            }
            if (pubTag > 0) {
                q = this.m_sqlManager.createQuery(dbc, C_PROPERTIES_HISTORY_READALL_STR);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                q.setParameter(2, (Object)pubTag);
                res = q.getResultList();
                for (Object[] o : res) {
                    propertyKey = (String)o[0];
                    propertyValue = (String)o[1];
                    mappingType = CmsDataTypeUtil.numberToInt((Number)o[2]);
                    this.internalAddToPropMap(propertyMap, resource, propertyKey, propertyValue, mappingType);
                }
            }
            if (pubTag != resource.getPublishTag()) {
                q = this.m_sqlManager.createQuery(dbc, C_PROPERTIES_HISTORY_READALL_RES);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                q.setParameter(2, (Object)resource.getPublishTag());
                res = q.getResultList();
                for (Object[] o : res) {
                    propertyKey = (String)o[0];
                    propertyValue = (String)o[1];
                    mappingType = CmsDataTypeUtil.numberToInt((Number)o[2]);
                    this.internalAddToPropMap(propertyMap, resource, propertyKey, propertyValue, mappingType);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return new ArrayList<CmsProperty>(propertyMap.values());
    }

    @Override
    public CmsPropertyDefinition readPropertyDefinition(CmsDbContext dbc, String name) throws CmsDataAccessException {
        CmsPropertyDefinition propDef = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROPERTYDEF_READ_HISTORY);
            q.setParameter(1, (Object)name);
            try {
                CmsDAOHistoryPropertyDef hpd = (CmsDAOHistoryPropertyDef)q.getSingleResult();
                propDef = new CmsPropertyDefinition(new CmsUUID(hpd.getPropertyDefId()), hpd.getPropertyDefName(), CmsPropertyDefinition.CmsPropertyType.valueOf(hpd.getPropertyDefType()));
            }
            catch (NoResultException e) {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROPERTYDEF_WITH_NAME_1", name));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return propDef;
    }

    @Override
    public int readPublishTag(CmsDbContext dbc, long maxdate) throws CmsDataAccessException {
        int maxVersion = 0;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_PROJECTS_HISTORY_READ_TAG_FOR_DATE);
            q.setParameter(1, (Object)maxdate);
            try {
                maxVersion = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return maxVersion;
    }

    @Override
    public I_CmsHistoryResource readResource(CmsDbContext dbc, CmsUUID structureId, int version) throws CmsDataAccessException {
        I_CmsHistoryResource resource = null;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_RESOURCES_HISTORY_READ_VERSION);
            q.setParameter(1, (Object)structureId.toString());
            q.setParameter(2, (Object)version);
            try {
                resource = this.internalCreateResource((Object[])q.getSingleResult());
            }
            catch (NoResultException e) {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_HISTORY_FILE_NOT_FOUND_1", structureId));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return resource;
    }

    @Override
    public void setDriverManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    @Override
    public void setSqlManager(org.opencms.db.CmsSqlManager sqlManager) {
        this.m_sqlManager = (CmsSqlManager)sqlManager;
    }

    @Override
    public void writePrincipal(CmsDbContext dbc, I_CmsPrincipal principal) throws CmsDataAccessException {
        try {
            this.readPrincipal(dbc, principal.getId());
            return;
        }
        catch (CmsDbEntryNotFoundException e) {
            try {
                CmsDAOHistoryPrincipals hp = new CmsDAOHistoryPrincipals();
                hp.setPrincipalId(principal.getId().toString());
                hp.setPrincipalName(principal.getSimpleName());
                String desc = principal.getDescription();
                desc = CmsStringUtil.isEmptyOrWhitespaceOnly(desc) ? "-" : desc;
                hp.setPrincipalDescription(desc);
                hp.setPrincipalOu("/" + principal.getOuFqn());
                if (principal instanceof CmsUser) {
                    String email = ((CmsUser)principal).getEmail();
                    email = CmsStringUtil.isEmptyOrWhitespaceOnly(email) ? "-" : email;
                    hp.setPrincipalEmail(email);
                    hp.setPrincipalType("USER");
                } else {
                    hp.setPrincipalEmail("-");
                    hp.setPrincipalType("GROUP");
                }
                hp.setPrincipalUserDeleted(dbc.currentUser().getId().toString());
                hp.setPrincipalDateDeleted(System.currentTimeMillis());
                this.m_sqlManager.persist(dbc, hp);
            }
            catch (PersistenceException e2) {
                throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e2), (Throwable)e2);
            }
            return;
        }
    }

    @Override
    public void writeProject(CmsDbContext dbc, int publishTag, long publishDate) throws CmsDataAccessException {
        CmsProject currentProject = dbc.currentProject();
        CmsUser currentUser = dbc.currentUser();
        List<String> projectresources = this.m_driverManager.getProjectDriver(dbc).readProjectResources(dbc, currentProject);
        try {
            CmsDAOHistoryProjects hp = new CmsDAOHistoryProjects();
            hp.setPublishTag(publishTag);
            hp.setProjectId(currentProject.getUuid().toString());
            hp.setProjectName(currentProject.getSimpleName());
            hp.setProjectPublishDate(publishDate);
            hp.setProjectPublishedBy(currentUser.getId().toString());
            hp.setUserId(currentProject.getOwnerId().toString());
            hp.setGroupId(currentProject.getGroupId().toString());
            hp.setManagerGroupId(currentProject.getManagerGroupId().toString());
            hp.setProjectDescription(currentProject.getDescription());
            hp.setDateCreated(currentProject.getDateCreated());
            hp.setProjectType(currentProject.getType().getMode());
            hp.setProjectOu("/" + currentProject.getOuFqn());
            this.m_sqlManager.persist(dbc, hp);
            for (String projectResource : projectresources) {
                CmsDAOHistoryProjectResources hpr = new CmsDAOHistoryProjectResources();
                hpr.setPublishTag(publishTag);
                hpr.setProjectId(currentProject.getUuid().toString());
                hpr.setResourcePath(projectResource);
                this.m_sqlManager.persist(dbc, hpr);
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeProperties(CmsDbContext dbc, CmsResource resource, List<CmsProperty> properties, int publishTag) throws CmsDataAccessException {
        try {
            block4: for (CmsProperty property : properties) {
                CmsPropertyDefinition propDef = null;
                try {
                    propDef = this.readPropertyDefinition(dbc, property.getName());
                }
                catch (CmsDbEntryNotFoundException e) {
                    propDef = this.createPropertyDefinition(dbc, property.getName(), CmsPropertyDefinition.TYPE_NORMAL);
                }
                for (int i = 0; i < 2; ++i) {
                    CmsUUID id;
                    int mappingType;
                    String value;
                    if (i == 0) {
                        value = property.getStructureValue();
                        mappingType = 1;
                        id = resource.getStructureId();
                        if (CmsStringUtil.isEmpty(value)) {
                            continue;
                        }
                    } else {
                        value = property.getResourceValue();
                        mappingType = 2;
                        id = resource.getResourceId();
                        if (CmsStringUtil.isEmpty(value)) continue block4;
                    }
                    CmsDAOHistoryProperties hp = new CmsDAOHistoryProperties();
                    hp.setStructureId(resource.getStructureId().toString());
                    hp.setPropertyDefId(propDef.getId().toString());
                    hp.setPropertyMappingId(id.toString());
                    hp.setPropertyMappingType(mappingType);
                    hp.setPropertyValue(this.m_sqlManager.validateEmpty(value));
                    hp.setPublishTag(publishTag);
                    this.m_sqlManager.persist(dbc, hp);
                }
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
    }

    @Override
    public void writeResource(CmsDbContext dbc, CmsResource resource, List<CmsProperty> properties, int publishTag) throws CmsDataAccessException {
        try {
            int sibCount = resource.getSiblingCount();
            boolean valResource = this.internalValidateResource(dbc, resource, publishTag);
            if (resource.getState().isDeleted()) {
                if (resource instanceof CmsFile && !valResource) {
                    if (sibCount < 2) {
                        this.m_driverManager.getVfsDriver(dbc).createOnlineContent(dbc, resource.getResourceId(), ((CmsFile)resource).getContents(), publishTag, false, true);
                    } else {
                        Set changedAndDeleted = (Set)dbc.getAttribute("changedAndDeleted");
                        if (changedAndDeleted == null || !changedAndDeleted.contains(resource.getResourceId())) {
                            this.m_driverManager.getVfsDriver(dbc).createOnlineContent(dbc, resource.getResourceId(), ((CmsFile)resource).getContents(), publishTag, true, false);
                        }
                    }
                }
                this.m_driverManager.getVfsDriver(dbc).publishVersions(dbc, resource, !valResource);
            }
            Map<String, Integer> versions = this.m_driverManager.getVfsDriver(dbc).readVersions(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getResourceId(), resource.getStructureId());
            int structureVersion = CmsDataTypeUtil.numberToInt(versions.get("structure"));
            int resourceVersion = CmsDataTypeUtil.numberToInt(versions.get("resource"));
            if (!valResource) {
                CmsDAOHistoryResources hs = new CmsDAOHistoryResources();
                hs.setResourceId(resource.getResourceId().toString());
                hs.setResourceType(resource.getTypeId());
                hs.setResourceFlags(resource.getFlags());
                hs.setDateCreated(resource.getDateCreated());
                hs.setUserCreated(resource.getUserCreated().toString());
                hs.setDateLastModified(resource.getDateLastModified());
                hs.setUserLastModified(resource.getUserLastModified().toString());
                hs.setResourceState(resource.getState().getState());
                hs.setResourceSize(resource.getLength());
                hs.setDateContent(resource.getDateContent());
                hs.setProjectLastModified(dbc.currentProject().getUuid().toString());
                hs.setSiblingCount(resource.getSiblingCount());
                hs.setResourceVersion(resourceVersion);
                hs.setPublishTag(publishTag);
                this.m_sqlManager.persist(dbc, hs);
            }
            CmsUUID parentId = CmsUUID.getNullUUID();
            CmsFolder parent = this.m_driverManager.getVfsDriver(dbc).readParentFolder(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getStructureId());
            if (parent != null) {
                parentId = parent.getStructureId();
            }
            CmsDAOHistoryStructure hstr = new CmsDAOHistoryStructure();
            hstr.setStructureId(resource.getStructureId().toString());
            hstr.setResourceId(resource.getResourceId().toString());
            hstr.setResourcePath(resource.getRootPath());
            hstr.setStructureState(resource.getState().getState());
            hstr.setDateReleased(resource.getDateReleased());
            hstr.setDateExpired(resource.getDateExpired());
            hstr.setStructureVersion(structureVersion);
            hstr.setParentId(parentId.toString());
            hstr.setPublishTag(publishTag);
            hstr.setVersion(resource.getVersion());
            this.m_sqlManager.persist(dbc, hstr);
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        this.writeProperties(dbc, resource, properties, publishTag);
    }

    protected void internalAddToPropMap(Map<String, CmsProperty> propertyMap, I_CmsHistoryResource resource, String propertyKey, String propertyValue, int mappingType) throws CmsDbConsistencyException {
        block9: {
            CmsProperty property;
            block8: {
                property = propertyMap.get(propertyKey);
                if (property == null) break block8;
                switch (mappingType) {
                    case 1: {
                        property.setStructureValue(propertyValue);
                        break block9;
                    }
                    case 2: {
                        property.setResourceValue(propertyValue);
                        break block9;
                    }
                    default: {
                        throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), new Integer(mappingType), propertyKey));
                    }
                }
            }
            property = new CmsProperty();
            property.setName(propertyKey);
            switch (mappingType) {
                case 1: {
                    property.setStructureValue(propertyValue);
                    property.setResourceValue(null);
                    break;
                }
                case 2: {
                    property.setStructureValue(null);
                    property.setResourceValue(propertyValue);
                    break;
                }
                default: {
                    throw new CmsDbConsistencyException(Messages.get().container("ERR_UNKNOWN_PROPERTY_VALUE_MAPPING_3", resource.getRootPath(), new Integer(mappingType), propertyKey));
                }
            }
            propertyMap.put(propertyKey, property);
        }
    }

    protected void internalCleanup(CmsDbContext dbc, I_CmsHistoryResource resource) throws CmsDataAccessException {
        boolean isFolder = resource.getRootPath().endsWith("/");
        ArrayList<I_CmsHistoryResource> subResources = new ArrayList<I_CmsHistoryResource>();
        if (isFolder && this.readLastVersion(dbc, resource.getStructureId()) == 0) {
            try {
                Query q = this.m_sqlManager.createQuery(dbc, C_STRUCTURE_HISTORY_READ_SUBRESOURCES);
                q.setParameter(1, (Object)resource.getStructureId().toString());
                List res = q.getResultList();
                for (Object[] obj : res) {
                    CmsUUID structureId = new CmsUUID((String)obj[0]);
                    int version = CmsDataTypeUtil.numberToInt((Integer)obj[1]);
                    subResources.add(this.readResource(dbc, structureId, version));
                }
            }
            catch (PersistenceException e) {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", "ERR_COUNTING_PROPERTIES_1"), (Throwable)e);
            }
        }
        for (I_CmsHistoryResource histResource : subResources) {
            this.deleteEntries(dbc, histResource, 0, -1L);
        }
    }

    protected int internalCountProperties(CmsDbContext dbc, CmsPropertyDefinition metadef, CmsUUID projectId) throws CmsDataAccessException {
        int returnValue;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, projectId, C_PROPERTIES_READALL_COUNT);
            q.setParameter(1, (Object)metadef.getId().toString());
            try {
                returnValue = CmsDataTypeUtil.numberToInt((Number)q.getSingleResult());
            }
            catch (NoResultException e) {
                throw new CmsDbConsistencyException(Messages.get().container("ERR_NO_PROPERTIES_FOR_PROPERTYDEF_1", metadef.getName()));
            }
        }
        catch (PersistenceException e) {
            throw new CmsDataAccessException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return returnValue;
    }

    protected CmsHistoryProject internalCreateProject(CmsDAOHistoryProjects hp, List<String> resources) throws PersistenceException {
        String ou = CmsOrganizationalUnit.removeLeadingSeparator(hp.getProjectOu());
        CmsUUID publishedById = new CmsUUID(hp.getProjectPublishedBy());
        CmsUUID userId = new CmsUUID(hp.getUserId());
        return new CmsHistoryProject(hp.getPublishTag(), new CmsUUID(hp.getProjectId()), ou + hp.getProjectName(), hp.getProjectDescription(), userId, new CmsUUID(hp.getGroupId()), new CmsUUID(hp.getManagerGroupId()), hp.getDateCreated(), CmsProject.CmsProjectType.valueOf(hp.getProjectType()), hp.getProjectPublishDate(), publishedById, resources);
    }

    protected I_CmsHistoryResource internalCreateResource(Object[] res) {
        CmsDAOHistoryStructure hs = (CmsDAOHistoryStructure)res[0];
        CmsDAOHistoryResources hr = (CmsDAOHistoryResources)res[1];
        int resourceVersion = hr.getResourceVersion();
        int structureVersion = hs.getStructureVersion();
        int tagId = hr.getPublishTag();
        CmsUUID structureId = new CmsUUID(hs.getStructureId());
        CmsUUID resourceId = new CmsUUID(hr.getResourceId());
        String resourcePath = hs.getResourcePath();
        int resourceType = hr.getResourceType();
        int resourceFlags = hr.getResourceFlags();
        CmsUUID projectLastModified = new CmsUUID(hr.getProjectLastModified());
        int state = Math.max(hr.getResourceState(), hs.getStructureState());
        long dateCreated = hr.getDateCreated();
        long dateLastModified = hr.getDateLastModified();
        long dateReleased = hs.getDateReleased();
        long dateExpired = hs.getDateExpired();
        int resourceSize = hr.getResourceSize();
        CmsUUID userLastModified = new CmsUUID(hr.getUserLastModified());
        CmsUUID userCreated = new CmsUUID(hr.getUserCreated());
        CmsUUID parentId = new CmsUUID(hs.getParentId());
        long dateContent = hr.getDateContent();
        boolean isFolder = resourcePath.endsWith("/");
        if (isFolder) {
            return new CmsHistoryFolder(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceVersion + structureVersion, parentId, resourceVersion, structureVersion);
        }
        return new CmsHistoryFile(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceSize, dateContent, resourceVersion + structureVersion, parentId, null, resourceVersion, structureVersion);
    }

    protected I_CmsHistoryResource internalMergeResource(I_CmsHistoryResource histRes, CmsDAOHistoryResources hr, int versionOffset) {
        int resourceVersion = hr.getResourceVersion();
        int structureVersion = histRes.getStructureVersion() - versionOffset;
        int tagId = hr.getPublishTag();
        CmsUUID structureId = histRes.getStructureId();
        CmsUUID resourceId = new CmsUUID(hr.getResourceId());
        int resourceType = hr.getResourceType();
        int resourceFlags = hr.getResourceFlags();
        CmsUUID projectLastModified = new CmsUUID(hr.getProjectLastModified());
        int state = histRes.getState().getState();
        long dateCreated = hr.getDateCreated();
        long dateLastModified = hr.getDateLastModified();
        long dateReleased = histRes.getDateReleased();
        long dateExpired = histRes.getDateExpired();
        int resourceSize = hr.getResourceSize();
        CmsUUID userLastModified = new CmsUUID(hr.getUserLastModified());
        CmsUUID userCreated = new CmsUUID(hr.getUserCreated());
        String resourcePath = histRes.getRootPath();
        CmsUUID parentId = histRes.getParentId();
        long dateContent = hr.getDateContent();
        if (histRes.isFolder()) {
            return new CmsHistoryFolder(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceVersion + structureVersion, parentId, resourceVersion, structureVersion);
        }
        return new CmsHistoryFile(tagId, structureId, resourceId, resourcePath, resourceType, resourceFlags, projectLastModified, CmsResourceState.valueOf(state), dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, resourceSize, dateContent, resourceVersion + structureVersion, parentId, null, resourceVersion, structureVersion);
    }

    protected boolean internalValidateResource(CmsDbContext dbc, CmsResource resource, int publishTag) throws CmsDataAccessException {
        boolean exists = false;
        try {
            Query q = this.m_sqlManager.createQuery(dbc, C_HISTORY_EXISTS_RESOURCE);
            q.setParameter(1, (Object)resource.getResourceId().toString());
            q.setParameter(2, (Object)publishTag);
            try {
                q.getSingleResult();
                exists = true;
            }
            catch (NoResultException e) {}
        }
        catch (PersistenceException e) {
            throw new CmsDbSqlException(Messages.get().container("ERR_COUNTING_PROPERTIES_1", (Object)e), (Throwable)e);
        }
        return exists;
    }
}

