/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.file.types.Messages;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONObject;
import org.opencms.jsp.util.CmsJspLinkMacroResolver;
import org.opencms.loader.CmsJspLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsResourceTypeJsp
extends A_CmsResourceTypeLinkParseable {
    public static final String FORMATTER_SETTING_MAX_WIDTH = "maxwidth";
    public static final String FORMATTER_SETTING_MIN_WIDTH = "minwidth";
    public static final String FORMATTER_SETTING_TYPE = "type";
    private static final int CONTAINERPAGE_TEMPLATE_TYPE_ID = 21;
    private static final String CONTAINERPAGE_TEMPLATE_TYPE_NAME = "containerpage_template";
    private static final int JSP_RESOURCE_TYPE_ID = 4;
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeJsp.class);
    private static List<Integer> m_jspResourceTypeIds = new ArrayList<Integer>();
    private static final String RESOURCE_TYPE_NAME = "jsp";
    protected CmsJspLoader m_jspLoader;

    public static int getContainerPageTemplateTypeId() {
        return 21;
    }

    public static String getContainerPageTemplateTypeName() {
        return CONTAINERPAGE_TEMPLATE_TYPE_NAME;
    }

    public static List<Integer> getJspResourceTypeIds() {
        return m_jspResourceTypeIds;
    }

    public static int getJSPTypeId() {
        return 4;
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public static boolean isJsp(CmsResource resource) {
        return resource == null ? false : CmsResourceTypeJsp.isJspTypeId(resource.getTypeId());
    }

    public static boolean isJspTypeId(int typeId) {
        return m_jspResourceTypeIds.contains(typeId);
    }

    @Override
    public void chtype(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.chtype(cms, securityManager, resource, type);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void deleteResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.deleteResource(cms, securityManager, resource, siblingMode);
        this.removeReferencingFromCache(references);
    }

    @Override
    public CmsFormatterConfiguration getFormattersForResource(CmsObject cms, CmsResource res) {
        String containerType = "*";
        int minWidth = 1;
        int maxWidth = Integer.MAX_VALUE;
        try {
            String formatterSetting = cms.readPropertyObject(res, "template", false).getValue();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatterSetting)) {
                JSONObject setting = new JSONObject(formatterSetting);
                if (setting.has(FORMATTER_SETTING_TYPE)) {
                    containerType = setting.getString(FORMATTER_SETTING_TYPE);
                }
                if (setting.has(FORMATTER_SETTING_MIN_WIDTH)) {
                    minWidth = setting.getInt(FORMATTER_SETTING_MIN_WIDTH);
                }
                if (setting.has(FORMATTER_SETTING_MAX_WIDTH)) {
                    maxWidth = setting.getInt(FORMATTER_SETTING_MAX_WIDTH);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_PARSING_FORMATTER_SETTINGS_FROM_PROPERTY_2", res.getName(), "template"), (Throwable)e);
        }
        CmsFormatterBean selfFormatter = new CmsFormatterBean(containerType, res.getRootPath(), res.getStructureId(), minWidth, maxWidth, true, false, res.getRootPath());
        return CmsFormatterConfiguration.create(cms, Collections.singletonList(selfFormatter));
    }

    @Override
    public int getLoaderId() {
        return 6;
    }

    @Override
    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        super.initConfiguration(name, id, className);
        this.addTypeId(this.m_typeId);
    }

    @Override
    public void initialize(CmsObject cms) {
        super.initialize(cms);
        try {
            this.m_jspLoader = (CmsJspLoader)OpenCms.getResourceManager().getLoader(6);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void moveResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, String destination) throws CmsException, CmsIllegalArgumentException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.moveResource(cms, securityManager, resource, destination);
        this.removeReferencingFromCache(references);
    }

    @Override
    public List<CmsLink> parseLinks(CmsObject cms, CmsFile file) {
        CmsJspLinkMacroResolver macroResolver = new CmsJspLinkMacroResolver(cms, file.getRootPath(), false);
        String encoding = CmsLocaleManager.getResourceEncoding(cms, file);
        String content = CmsEncoder.createString(file.getContents(), encoding);
        macroResolver.resolveMacros(content);
        return macroResolver.getLinks();
    }

    @Override
    public void replaceResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type, byte[] content, List<CmsProperty> properties) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.replaceResource(cms, securityManager, resource, type, content, properties);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void restoreResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int version) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.restoreResource(cms, securityManager, resource, version);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void setDateExpired(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateExpired, boolean recursive) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.setDateExpired(cms, securityManager, resource, dateExpired, recursive);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void setDateLastModified(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateLastModified, boolean recursive) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.setDateLastModified(cms, securityManager, resource, dateLastModified, recursive);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void setDateReleased(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateReleased, boolean recursive) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.setDateReleased(cms, securityManager, resource, dateReleased, recursive);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void undoChanges(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.undoChanges(cms, securityManager, resource, mode);
        this.removeReferencingFromCache(references);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        CmsJspLinkMacroResolver macroResolver = new CmsJspLinkMacroResolver(cms, resource.getRootPath(), false);
        String encoding = CmsLocaleManager.getResourceEncoding(cms, resource);
        String content = CmsEncoder.createString(resource.getContents(), encoding);
        content = macroResolver.resolveMacros(content);
        try {
            resource.setContents(content.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            resource.setContents(content.getBytes());
        }
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        CmsFile file = super.writeFile(cms, securityManager, resource);
        this.removeReferencingFromCache(references);
        return file;
    }

    protected Set<String> getReferencingStrongLinks(CmsObject cms, CmsResource resource) throws CmsException {
        HashSet<String> references = new HashSet<String>();
        if (this.m_jspLoader == null) {
            return references;
        }
        this.m_jspLoader.getReferencingStrongLinks(cms, resource, references);
        return references;
    }

    protected void removeReferencingFromCache(Set<String> references) {
        if (this.m_jspLoader != null) {
            this.m_jspLoader.removeFromCache(references, false);
        }
    }

    private void addTypeId(int typeId) {
        m_jspResourceTypeIds.add(typeId);
    }
}

